/***
* four.prg
* Same as one.prg except with "scoping" of browse
*
*/                 

#include "inkey.ch"
#include "set.ch"

FUNCTION Four( cName1, cName2 )
   IF PCOUNT() < 2
      ?
      ? "Syntax:  Four Name1 Name2"
      ?
      ERRORLEVEL(1)

      RETURN(NIL)
   ENDIF
   CLEAR SCREEN

   @ 3, 10 TO 21, 70

   BrowseRolo( 4, 11, 20, 69, cName1, cName2 )  // NOTE!

   RETURN NIL

FUNCTION BrowseRolo( nTop, nLeft, nBottom, nRight, cFirst, cLast )
   LOCAL oBrowse, oColumn
   LOCAL lCont
   LOCAL nKey
   LOCAL cString
   LOCAL nCursSave

   USE ROLO INDEX ROLONAME                      // NOTE! (index added)
   @ nBottom+2, nLeft SAY 'Alt-B: Beginning, Alt-E: End'

   /* Set cursor off */
   nCursSave := SETCURSOR(0)

	/* make new browse object */
   oBrowse := TBrowseDB(nTop, nLeft, nBottom, nRight)

   /* add columns            */
   oColumn := TBColumnNew("Name", {|| Rolo->Name})
   oColumn:footing := oColumn:heading
   oBrowse:addColumn(oColumn)

   oColumn := TBColumnNew("Age", {|| CalcAge(Rolo->BirthDate)})
   oColumn:footing := oColumn:heading
   oBrowse:addColumn(oColumn)

   oColumn := TBColumnNew("Phone #", ;
                          {|| TRANSFORM(Rolo->PhoneNum,'@R 999-9999')})
   oColumn:footing := oColumn:heading
   oBrowse:addColumn(oColumn)  

   /* "customize" browse    */                 // NOTE!
   oBrowse:skipBlock := {|n| SkipFor( n, UPPER(cFirst), UPPER(cLast) )}
   oBrowse:goTopBlock := {|| FindFirst( UPPER(cFirst) )}
   oBrowse:goBottomBlock := {|| FindLast( UPPER(cLast) )}

   oBrowse:headSep := ''
   oBrowse:colSep  := '  '
   oBrowse:footSep := ''

   // start at top of "range"
   oBrowse:goTop()

   // enter main browse loop
   lCont := .T.
   DO WHILE lCont
      /* stabilization
      * 
      * Stabilization causes all pending actions to be resolved.  No 
      * movement actually takes place until stabilization is done.  One
      * row is updated at a time, headings are not affected.
      */
      DO WHILE .NOT. oBrowse:stabilize()
      ENDDO

      IF oBrowse:hitBottom
         TONE( 523.3, 9 )
      ENDIF
      IF oBrowse:hitTop
         TONE( 523.3, 9 )
      ENDIF

      /* Idle event area */
      cString := STR(RECNO(),3) + '/' + STR(LASTREC(),3)
      @ nBottom+2, nRight-LEN(cString) SAY cString   

      nKey := INKEY(0)

      /* keystroke exception area */
      DO CASE
      CASE nKey == K_UP
         oBrowse:up()
      CASE nKey == K_DOWN
         oBrowse:down()
      CASE nKey == K_LEFT
         oBrowse:left()
      CASE nKey == K_RIGHT
         oBrowse:right()
      CASE nKey == K_PGUP
         oBrowse:pageUp()
      CASE nKey == K_PGDN
         oBrowse:pageDown()
      CASE nKey == K_HOME
         oBrowse:home()
      CASE nKey == K_END
         oBrowse:end()
      CASE nKey == K_CTRL_PGUP
         oBrowse:goTop()
      CASE nKey == K_CTRL_PGDN
         oBrowse:goBottom()
      CASE nKey == K_CTRL_LEFT
         oBrowse:panLeft()
      CASE nKey == K_CTRL_RIGHT
         oBrowse:panRight()
      CASE nKey == K_CTRL_HOME
         oBrowse:panHome()
      CASE nKey == K_CTRL_END
         oBrowse:panEnd()
      /***
      * Add your keys here
      */
      CASE nKey == K_ESC
         lCont := .F.
      CASE nKey == K_ALT_E
         oBrowse:goBottom()
      CASE nKey == K_ALT_B
         oBrowse:goTop()
      ENDCASE
   ENDDO

   /* Restore cursor */
   SETCURSOR(nCursSave)
   RETURN (NIL)


FUNCTION CalcAge(dBirth)
   LOCAL lPast := .F.

   IF (MONTH(DATE()) > MONTH(dBirth)) .AND. (DAY(DATE()) >= DAY(dBirth))
      lPast := .T.
   ENDIF
   
   RETURN( YEAR(DATE())-YEAR(dBirth) - IIF(lPast, 0, 1) )


/***
* SkipFor()
*/
FUNCTION SkipFor(n, xStart, xEnd)    // NOTE!
   LOCAL nMoved

   nMoved := 0
   IF ( LASTREC() == 0 )
      RETURN (nMoved)
   ENDIF

   DO CASE
   CASE ( n == 0 )
      SKIP 0

   CASE ( n > 0 )
      // Because of non-unique index keys, must actually move past end
      // and come back to make sure I am on last record.
      DO WHILE ( nMoved < n .AND. &(INDEXKEY()) < xEnd )
         SKIP 1
         nMoved++
      ENDDO

      DO WHILE (&(INDEXKEY()) > xEnd)
         SKIP -1
         nMoved--
      ENDDO

   CASE ( n < 0 )
      // Because of non-unique index keys, must actually move past start
      // and come back to make sure I am on first record
      DO WHILE ( nMoved > n .AND. &(INDEXKEY()) >= xStart )
         SKIP -1
         IF BOF()
            EXIT
         ENDIF
         nMoved--
      ENDDO

      DO WHILE (&(INDEXKEY()) < xStart)
         SKIP
         nMoved++
      ENDDO

   ENDCASE

   RETURN (nMoved)

FUNCTION FindFirst( xValue )           // NOTE!
   LOCAL lSeek
   lSeek := SET(_SET_SOFTSEEK,.T.)

   SEEK xValue                 

   SET(_SET_SOFTSEEK, lSeek)

   RETURN(NIL)

FUNCTION FindLast( xValue )           // NOTE!
   LOCAL lSeek
   lSeek := SET(_SET_SOFTSEEK,.T.)

   SEEK xValue
   // Move through all matching index keys
   DO WHILE &(INDEXKEY()) <= xValue  .AND. ! (EOF())
      SKIP
   ENDDO

   // and come back to last record in range
   DO WHILE &(INDEXKEY()) > xValue  .AND. ! (BOF())
      SKIP -1
   ENDDO

   IF EOF()
      SKIP -1
   ENDIF
   SET(_SET_SOFTSEEK, lSeek)

   RETURN (NIL)


