*****
*
*	tbldemo.prg
*

#include "\s89\edit\tbrowse.ch"
#include "\s89\exp\inkey.ch"
#include "\s89\exp\gset.ch"


****
*	tbldemo <dbf> [<index>]
*

func tbldemo(datafile, indexfile)

	if Valtype(datafile) == "U"
		?
		? "Must enter name of data file on command line."
		?
		quit

	end

	if .not. (File(datafile) .or. File(datafile + ".dbf"))
		?
		? "File not found."
		?
		quit

	end

	SetColor("n/bg")
	clear screen

	* file exists
	if Valtype(indexfile) == "C" .and.;
	   (File(indexfile) .or. File(indexfile + IndexExt()))
		use (datafile) index (indexfile)

	else
		use (datafile)

	end

	Browse(3, 6, 22, 73)

	SetColor("w/n")
	clear screen

return (NIL)



***
*	browse()
*

func browse(t, l, b, r)
local tb, n, aCol, cColorSave, nCursSave, lMore, nKey, lAppend


	/* make new browse object */
	tb := TBrowseNew(t, l, b, r)

	/* add custom 'skipper' for append mode */
	tb:SetSkip( {|x| Skipped(x, lAppend)} )

	/* color table */
	tb:SetColorTable("B/W, B/BG, B/W, B/BG, R/W, B/R")

	* draw box to illustrate window
*	@ t-1, l-1, b, r+1 BOX "͸Գ"
*	@ t+1, l-1  SAY ""
*	@ t+1, r+1 SAY ""

	cColorSave := SetColor("n/n")
	@ t+1, l+1 CLEAR TO b+1, r+1
	SetColor(cColorSave)



	/* add column for recno() */
	aCol := Array(TBC_LEN)
	aCol[TBC_BDATA]	:= {|| Recno()}
	aCol[TBC_HEAD]	:= "Rec #"

*	aCol[TBC_HSEP]	:= ""
*	aCol[TBC_CSEP]	:= "  "
*	aCol[TBC_FSEP]	:= ""

	aCol[TBC_HSEP]	:= ""
	aCol[TBC_CSEP]	:= "  "
	tb:AddColumn(aCol)


	/* add field columns */
	for n = 1 to FCount()

		aCol := Array(TBC_LEN)
		aCol[TBC_BDATA] := &( "{||" + FieldName(n) + "}" )

		if ( Type(FieldName(n)) == "N" )
			aCol[TBC_BCOLOR] := { |x| if(x < 0, {5, 6}, {3, 4}) }
		end

		aCol[TBC_HEAD] := FieldName(n)
*		aCol[TBC_HSEP] := ""
*		aCol[TBC_CSEP] := "  "
*		aCol[TBC_FSEP] := ""

		aCol[TBC_HSEP]	:= ""
		aCol[TBC_CSEP]	:= "  "

		tb:AddColumn(aCol)
	next


	/* freeze record number on left */
	tb:setFreeze(1)


	nCursSave := SetCursor(0)
	nKey := 0
	lAppend := .f.


	lMore := .t.
	while (lMore)

		if ( tb:CursCol() < 2 )
			/* keep cursor out of recno field */
			tb:setCursCol(2)
		end


		nKey := 0


		/* try to stabilize the display */
		while ( !tb:Stabilize() )
			nKey := InKey()
			if ( nKey != 0 )
				exit 			/* (don't bother if a key is waiting) */
			end
		end


		if (nKey == 0)
			/* display is stable */
			if ( tb:eBang() .and. !lAppend )
				/* banged against EOF; go into append mode */
				lAppend := .t.
				nKey := K_DN

			else
				if ( tb:eBang() .or. tb:bBang() )
					tone(125, 0)
				end

				nKey := InKey(0)

			end
		end


		do case
		case ( nKey == K_DN )
			tb:Down()

		case ( nKey == K_UP )
			tb:Up()

			if ( lAppend )
				/* force stabilization here or keyboard gets out of synch */
				lAppend := .f.
				tb:Refresh()
				while ( !tb:stabilize() ) ; end
			end

		case ( nKey == K_PGDN )
			tb:PgDn()

		case ( nKey == K_PGUP )
			tb:PgUp()

			if ( lAppend )
				/* force stabilization here or keyboard gets out of synch */
				lAppend := .f.
				tb:Refresh()
				while ( !tb:stabilize() ) ; end
			end

		case ( nKey == K_CTRLPGUP )
			tb:GoTop()
			lAppend := .f.

		case ( nKey == K_CTRLPGDN )
			tb:GoBottom()
			lAppend := .f.

		case ( nKey == K_RIGHT )
			tb:Right()

		case ( nKey == K_LEFT )
			tb:Left()

		case ( nKey == K_HOME )
			tb:Home()

		case ( nKey == K_END )
			tb:End()

		case ( nKey == K_CTRLLEFT )
			tb:PanLeft()

		case ( nKey == K_CTRLRIGHT )
			tb:PanRight()

		case ( nKey == K_CTRLHOME )
			tb:PanHome()

		case ( nKey == K_CTRLEND )
			tb:PanEnd()

		case ( nKey == K_ESC )
			lMore := .f.

		case ( nKey == K_RETURN )
			DoGet(tb, lAppend)

		otherwise
			KEYBOARD( Chr(nKey) )
			DoGet(tb, lAppend)

		end

	end

	SetCursor(nCursSave)

return(.t.)


****
*	Skipped()
*

func Skipped(n, lAppend)
local i

	i := 0
	if ( lastrec() != 0 )
		if ( n == 0 )
			skip 0

		elseif ( n > 0 .and. recno() != lastrec() + 1 )
			while ( i < n )
				skip 1
				if ( eof() )
					if ( lAppend )
						i++
					else
						skip -1
					end

					exit
				end

				i++
			end

		elseif ( n < 0 )
			while ( i > n )
				skip -1
				if ( bof() )
					exit
				end

				i--
			end
		end
	end

return (i)


****
*	DoGet()
*

func DoGet(tb, lAppend)
local GetList := {}, cColorSave, bInsSave, lScoreSave
local nKey
private cField

	/* make sure browse is stable */
	while ( !tb:stabilize() ) ; end

	/* if confirming new record, append blank */
	if ( lAppend .and. Recno() == Lastrec() + 1 )
		append blank
	end

	lScoreSave := GSet(GS_SCOREBOARD, .f.)
	cColorSave := SetColor(",w+/bg")
	bInsSave := SetKey(K_INS, ;
				{|| SetCursor(if(ReadInsert(!ReadInsert()), 1, 2))} )

	cField := tb:Column(tb:CursCol())[TBC_HEAD]
	@ Row(), Col()  GET &cField  PICT "@K"

	SetCursor( if(ReadInsert(), 2, 1) )
	Read
	SetCursor(0)

	GSet(GS_SCOREBOARD, lScoreSave)
	SetColor(cColorSave)
	SetKey(K_INS, bInsSave)

*	if ( change in index key eval )
*		tb:refresh()
*	else

	tb:linefresh()

	nKey := LastKey()
	if ( nKey == K_UP .or. nKey == K_DN .or. ;
		nKey == K_PGUP .or. nKey == K_PGDN )

		KEYBOARD( Chr(nKey) )
	end

return (NIL)

