*** 
* Auteur : Philippe Bonnardel
* Langage: Clipper 5.0 VF
* Date   : 1994
* Compil.: /M/L/N/W
*
*  Make the memo
***

#include "inkey.ch"
#include "box.ch"
#include "memoedit.ch"

// Touches de formatage du paragraphe
#define GAUCHE  K_ALT_G
#define DROITE  K_ALT_L
#define CENTRE  K_ALT_C
#define JUSTIF  K_ALT_J

// Coordonnes de la fentre du MemoEdit()
#define F_TOP   3
#define F_LEFT  3
#define F_BAS   20
#define F_RIGHT 76
#define NLARG   F_RIGHT - F_LEFT

// Coordonnes du curseur qd appel de la fonction de formatage du paragraphe
STATIC nEcrRow := F_TOP, nRelRow := 1, nRelCol := 0

STATIC MemoLastKey              // Contient la dernire touche presse


// Pseudo-fonction qui sauve les coordonnes relles et relatives du curseur
// dans le Memoedit (). 
// Les pseudo-fonctions sont  consommer avec modration...
#Translate SavePos() => nEcrRow := ROW(); nRelRow := nLine ; nRelCol := nCol

//Pseudo-fonction qui restore les coordonnes relles et relatives du curseur
//de la version prcdente si retour  cette version.
#Translate SavPos2() => nEcrRow:= nEcrRow2; nRelRow := nRelRow2 ; nRelCol := nRelCol2

***
* Lance l'dition du champ mmo
***
FUNCTION APPMEMO (cMemo)
LOCAL lOk := .F.
LOCAL lOldScore := SET(_SET_SCOREBOARD, .F.)
LOCAL lOldCancel := SET(_SET_CANCEL, .F.)

// Trace l'interface
SETCOLOR ("GR+/B")
@ F_TOP - 1, F_LEFT - 1, F_BAS + 1, F_RIGHT + 1 BOX B_DOUBLE + CHR(32)
SETCOLOR ("G+/B")
@ MAXROW()-1, 0 SAY PADC(;
"Alt-G:aligner  Gauche  Alt-L:aLigner  droite  Alt-C:Centrer  Alt-J:Justifier",;
MAXCOL()+1)

SETCOLOR ("GR+/B")
@ MAXROW(), 0 SAY PADC("Esc : Quitter     F5 : Sauver    F1 : Help", MAXCOL()+1)

SETCOLOR("W+/B")

DO WHILE .T.
	// Les coordonnes du curseur permettent de le replacer la o il se
	// situait lors de l'appel de la fonction de formatage
	cMemo := MEMOEDIT (cMemo, F_TOP, F_LEFT, F_BAS, F_RIGHT, .T.,;
										 "CTRLMEMOED", NLARG,, nRelRow, nRelCol,;
										 IF(nEcrRow != NIL, nEcrRow - F_TOP, NIL), nRelCol)
	// Si appel de la fonction de formatage
	IF LASTKEY() == K_ESC  // Abandon
			EXIT
	ELSEIF MemoLastKey == GAUCHE .OR. MemoLastKey == DROITE .OR. ;
				 MemoLastKey == CENTRE .OR. MemoLastKey == JUSTIF
			 cMemo := Make_Paragrf (cMemo, nRelRow, NLARG, MemoLastKey)
	ELSEIF LASTKEY() == K_CTRL_W   // retourne OK
			lOk := .T.
			EXIT
	ENDIF
ENDDO
nEcrRow := nRelRow := nRelCol := MemoLastKey :=  NIL                         
SET(_SET_CANCEL, lOldCancel) 
SET(_SET_SCOREBOARD, lOldScore)
RETURN (lOk)

/* * *
*
*    Fonction CTRLMEMOED (nMode, nLine, nCol)
*
*         - Fonction de contrle de la fonction Memoedit ()
*
*/
FUNCTION CTRLMEMOED (nMode, nLine, nCol)
LOCAL nKey
LOCAL nRetval := ME_DEFAULT
nKey := LASTKEY ()
// appui sur touche de justification
IF nKey == GAUCHE .OR. nKey == DROITE .OR. ;
	 nKey == CENTRE .OR. nKey == JUSTIF
				SavePos()               // Sauve les coordonnes du curseur
				MemoLastKey := nKey     // Sauve la touche presse
				KEYBOARD CHR(K_CTRL_W)  // Sauve le texte et sortie de MemoEdit()
ELSEIF nKey == K_F5
		 KEYBOARD CHR(K_CTRL_W) // sauver
ENDIF
RETURN (nRetVal)          

