/*
**  S W T A L K . P R G -	SilverClip Communications Library
**	Version 3.02		demo terminal example program.
**
**				Copyright (c) 1991 SilverWare Inc.
**
**				Author: John P. Halovanic
**
**				Compile: clipper swtalk /W/N
**
**				.DBF Environment -> set swtalk=\path
**
**
**
**	The SilverTalk III demo requires Clipper 5.01 or above and the
**	SilverClip Library SPCS version 3.01 or above.
**
**
**
**
******************************************************************************
**
**
**
** Database FIELD declarations for SWDefalt
**
** 	fnTerm			= Terminal mode
** 	fnBoard			= COM adapter
** 	fcModem			= Modem setup string
** 	fnMaxRow		= Terminal maximum row
** 	fnPort			= COM port
**
**
** Database FIELD declarations for SWDial
**
** 	fcTag			= Dialing directory tag
** 	fnBaud			= Baud rate
** 	fnParity		= Parity
** 	fnWord			= Word length (data bits)
** 	fnStop			= Stop bits
** 	fcName			= Dialing directory name
** 	fcPhone			= Dialing directory phone
** 	fcMacros		= Dialing directory Alt-0 through Alt-9 attach
**
**
**
** STATIC variable declarations
**
** 	nTerm			= Terminal mode
** 	nBaud			= Baud rate
** 	nParity			= Paritiy setting
** 	nWord			= Word length (data bits)
** 	nStop			= Stop bits
** 	nMaxRow			= Terminal maximum row
** 	cModem			= Modem setup string
** 	cDoubleBar		= Box display character
** 	cLastPhone		= Redial last phone number variable
** 	cLastName		= Redial last phone number, name variable
** 	cOpenScreen		= Saved open screen
** 	lnPortActive		= Is port active
** 	cText1Color		= Clipper text color value 1
** 	cText2Color		= Clipper text color value 2
** 	cPromptColor		= Clipper prompt color value
** 	cTBColor		= Clipper COM bar color
** 	nTermColor		= SilverClip terminal mode color
** 	nBarColor		= SilverClip COM bar color
** 	nWait			= Wait time for autodialer
** 	nCallCount		= Call count for auto dialer
** 	nCursorType		= CGA, EGA, VGA cursor
** 	lXONXOFFlowControl	= Is XON/XOFF flow control on
** 	lRTSCTSFlowControl	= Is RTS/CTS flow control on
** 	lDTRDSRFlowControl	= Is DTR/DSR flow control on
** 	lCDFlowControl		= Is CD flow control on
** 	cFileName		= Global file name get variable
** 	nTransStatusType	= Transfer display type
** 	nBoard			= COM adapter
** 	nOldBoard		= Temp board holder variable
** 	cAutoScreen		= Dialing directory save screen variable
**
**
**
** STATIC array declarations
**
** 	acCOMPortOption[16]	= Ascii COM ports options for menus displays
** 	acBaudOption[18]	= Ascii baud rate options for menus displays
** 	acParityOption[5]	= Ascii parity setting options for menus displays
** 	acTermOption[4]		= Ascii terminal options for menus displays
** 	acComBoardOption[3]	= Ascii COM adapter options for menus displays
** 	acWordOption[3]		= Ascii word length options for menus displays
** 	acStopBitsOption[2]	= Ascii stop bits options for menus displays
** 	anParity[5]		= Ascii parity options for menus displays
** 	anComBoardOption[3]	= Numeric COM board index
** 	acSWOpenCom[3]		= Open COM macro array
** 	acSWCloseCom[3]		= Close COM macro array
**
******************************************************************************
*/
	

/* 
** Declare external COM functions that will be used in open and close COM 
** macros.
*/

EXTERNAL SWOpenCom		/* Standard open of COM port */
EXTERNAL SWOpenAST		/* AST open of COM port */
EXTERNAL SWOpenDig		/* DIGI open of COM port */

EXTERNAL SWCloseCom		/* Standard close of COM port */
EXTERNAL SWCloseAST		/* AST close of COM port */
EXTERNAL SWCloseDig		/* DIGI close of COM port */


/* Header Files */

#include "inkey.ch"
#include "box.ch"
#include "error.ch"
#include "slvrclip.ch"

/* Define Program Constants */

#define COMBAR		1
#define ESCBAR		2
#define VIEWBAR		3
#define ESC     	283
#define FILELEN 	46
#define STANDARD	8	/* Max ports for standard and MC adapters */
#define AST4    	8	/* Max ports for AST adapter */
#define DIGI    	16	/* Max ports for Digiboard adapter */
#define MACROCR    	"^M"	/* Macro definition for <CR> in hot keys memu */
#define SWTALKIII    	"3.01"  /* SilverTalk III version number */


/* Define Hot-Key Constants */

#define SW_FUTURE		1		/* Reserved for future use */

#define SW_ALT_C		11776		/* Alt-C		*/
#define SW_PGUP			18688		/* PgUp			*/
#define SW_PGDN			20736		/* PgDn			*/
#define SW_ALT_P		6400		/* Alt-P		*/
#define SW_ALT_D		8192		/* Alt-D		*/
#define SW_ALT_M		12800		/* Alt-M		*/
#define SW_ALT_0		33024		/* Alt-0		*/
#define SW_ALT_1		30720		/* Alt-1		*/
#define SW_ALT_2		30976		/* Alt-2		*/
#define SW_ALT_3		31232		/* Alt-3		*/
#define SW_ALT_4		31488		/* Alt-4		*/
#define SW_ALT_5		31744		/* Alt-5		*/
#define SW_ALT_6		32000		/* Alt-6		*/
#define SW_ALT_7		32256		/* Alt-7		*/
#define SW_ALT_8		32512		/* Alt-8		*/
#define SW_ALT_9		32768		/* Alt-9		*/
#define SW_ALT_S		7936		/* Alt-S		*/
#define SW_ALT_H		8960		/* Alt-H		*/
#define SW_ALT_Y		5376		/* Alt-Y		*/
#define SW_TILDY		10592		/* `   Video menu	*/
#define SW_ALT_Z		11264		/* Alt-Z		*/
#define SW_ALT_R		4864		/* Alt-R		*/
#define SW_ALT_B		12288		/* Alt-B		*/
#define SW_ALT_F10		28928		/* Alt-F10		*/
#define SW_ALT_F		8448		/* Alt-F		*/
#define SW_ALT_F4		27392		/* Alt-F4               */
#define SW_ALT_V		12032		/* Alt-V                */
#define SW_ALT_E		4608		/* Alt-E		*/
#define SW_ALT_X		11520		/* Alt-X		*/
#define SW_ALT_I		5888		/* Alt-I		*/


/* Declare Program STATIC Variables And Fields */

FIELD fnTerm, fnBoard, fcModem, fnMaxRow, fcTag, fnPort, fnBaud, fnParity, fnWord, fnStop, fcName, fcPhone, fcMacros
STATIC nTerm, nBaud, nParity, nWord, nStop, nMaxRow, cModem, cDoubleBar, cLastPhone, cLastName, cOpenScreen, lnPortActive, cText1Color, cText2Color, cPromptColor, cTBColor, nTermColor, nBarColor, nWait, nCallCount, nCursorType, lXONXOFFlowControl, lRTSCTSFlowControl, lDTRDSRFlowControl, lCDFlowControl, cFileName, nTransStatusType, nBoard, nOldBoard, cAutoScreen
STATIC acCOMPortOption[32], acBaudOption[18], acParityOption[5], acTermOption[4], acComBoardOption[3], anComBoardOption[3], acSWOpenCom[3], acSWCloseCom[3]
STATIC acWordOption[3], acStopBitsOption[2], anParity[5]

/* Declare Program MEMVAR Variables That Will Be Used In Macros */

MEMVAR getlist, cSWOpenCom, cSWCloseCom, nPort, cHolder, nHolder, nComOption


/*
**
** Function Name: Main() -> NIL
**
** Description:
**
**	Main entry into program.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION Main()

FIELD fnAlt0, fnAlt1, fnAlt2, fnAlt3, fnAlt4, fnAlt5, fnAlt6, fnAlt7, fnAlt8, fnAlt9

LOCAL nOption, cTermScreen, nTermRow, nTermCol, nReturnCode, nExitKey, cDBFPath, cCOMSPEC, nStartVideoMode
LOCAL anExitKeys[32]


SET SCOREBOARD OFF
SET WRAP ON
SET KEY K_ALT_F to SWFileDir()  /* File Directory Box */

setcancel(SWFALSE)		/* Set Alt-C OFF */

cOpenScreen := savescreen(0,0,24,79)

/* Define ROM BIOS Scan Code Exit Keys For Terminal Modes */

anExitKeys[1]  := SW_ALT_C	/* Alt-C		*/
anExitKeys[2]  := SW_PGUP	/* PgUp			*/
anExitKeys[3]  := SW_PGDN	/* PgDn			*/
anExitKeys[4]  := SW_ALT_P	/* Alt-P		*/
anExitKeys[5]  := SW_ALT_D	/* Alt-D		*/
anExitKeys[6]  := SW_ALT_M	/* Alt-M		*/
anExitKeys[7]  := SW_ALT_0	/* Alt-0		*/
anExitKeys[8]  := SW_ALT_1	/* Alt-1		*/
anExitKeys[9]  := SW_ALT_2	/* Alt-2		*/
anExitKeys[10] := SW_ALT_3	/* Alt-3		*/
anExitKeys[11] := SW_ALT_4	/* Alt-4		*/
anExitKeys[12] := SW_ALT_5	/* Alt-5		*/
anExitKeys[13] := SW_ALT_6	/* Alt-6		*/
anExitKeys[14] := SW_ALT_7	/* Alt-7		*/
anExitKeys[15] := SW_ALT_8	/* Alt-8		*/
anExitKeys[16] := SW_ALT_9	/* Alt-9		*/
anExitKeys[17] := SW_ALT_S	/* Alt-S		*/
anExitKeys[18] := SW_ALT_H	/* Alt-H		*/
anExitKeys[19] := SW_ALT_Y	/* Alt-Y		*/
anExitKeys[20] := SW_TILDY	/* `   Video menu	*/
anExitKeys[21] := SW_ALT_Z	/* Alt-Z		*/
anExitKeys[22] := SW_ALT_R	/* Alt-R		*/
anExitKeys[23] := SW_ALT_B	/* Alt-B		*/
anExitKeys[24] := SW_ALT_F10	/* Alt-F10		*/
anExitKeys[25] := SW_ALT_F	/* Alt-F                */
anExitKeys[26] := SW_ALT_F4	/* Alt-F4               */
anExitKeys[27] := SW_ALT_V	/* Alt-V                */
anExitKeys[28] := SW_ALT_E	/* Alt-E		*/
anExitKeys[29] := SW_ALT_I	/* Alt-I                */

anExitKeys[30] := SW_FUTURE	/* Reserved for future use */
anExitKeys[31] := SW_FUTURE	/* Reserved for future use */

anExitKeys[32] := SW_ALT_X	/* Alt-X */

/* Define Arrays */


acComBoardOption[1]	:= "Standard  "
acComBoardOption[2]	:= "Ast 4 Port"
acComBoardOption[3]	:= "Digi Board"

anComBoardOption[1]	:= STANDARD		/* 8  ports */
anComBoardOption[2]	:= AST4			/* 8  ports */
anComBoardOption[3]	:= DIGI			/* 32 ports */

acSWOpenCom[1]		:= "SWOpenCom(nPort,4000,4000,nComOption)"
acSWOpenCom[2]		:= "SWOpenAST(nPort,4000,4000,nComOption)"
acSWOpenCom[3]		:= "SWOpenDig(nPort,4000,4000,nComOption)"

acSWCloseCom[1]		:= "SWCloseCom(nPort,nComOption)"
acSWCloseCom[2]		:= "SWCloseAST(nPort,nComOption)"
acSWCloseCom[3]		:= "SWCloseDig(nPort,nComOption)"

acTermOption[1]		:= "TTY   "
acTermOption[2]		:= "ANSI  "
acTermOption[3]		:= "VT-100"
acTermOption[4]		:= "VT-52 "

acCOMPortOption[1]	:= "COM1 "
acCOMPortOption[2]	:= "COM2 "
acCOMPortOption[3]	:= "COM3 "
acCOMPortOption[4]	:= "COM4 "
acCOMPortOption[5]	:= "COM5 "
acCOMPortOption[6]	:= "COM6 "
acCOMPortOption[7]	:= "COM7 "
acCOMPortOption[8]	:= "COM8 "
acCOMPortOption[9]	:= "COM9 "
acCOMPortOption[10]	:= "COM10"
acCOMPortOption[11]	:= "COM11"
acCOMPortOption[12]	:= "COM12"
acCOMPortOption[13]	:= "COM13"
acCOMPortOption[14]	:= "COM14"
acCOMPortOption[15]	:= "COM15"
acCOMPortOption[16]	:= "COM16"

acBaudOption[1]		:= "    50"
acBaudOption[2]		:= "    75"
acBaudOption[3]		:= "   110"
acBaudOption[4]		:= "   134"
acBaudOption[5]		:= "   300"
acBaudOption[6]		:= "   600"
acBaudOption[7]		:= "  1200"
acBaudOption[8]		:= "  1800"
acBaudOption[9]		:= "  2000"
acBaudOption[10]	:= "  2400"
acBaudOption[11]	:= "  3600"
acBaudOption[12]	:= "  4800"
acBaudOption[13]	:= "  7200"
acBaudOption[14]	:= "  9600"
acBaudOption[15]	:= " 19200"
acBaudOption[16]	:= " 38400"
acBaudOption[17]	:= " 57600"
acBaudOption[18]	:= "115200"

acParityOption[1]	:= "NONE "
acParityOption[2]	:= "ODD  "
acParityOption[3]	:= "EVEN "
acParityOption[4]	:= "SPACE"
acParityOption[5]	:= "MARK "

anParity[1]		:= SWPARITYNONE
anParity[2]		:= SWPARITYODD
anParity[3]		:= SWPARITYEVEN
anParity[4]		:= SWPARITYSTICK
anParity[5]		:= SWPARITYMSTICK

acWordOption[1]		:= "5"
acWordOption[2]		:= "7"
acWordOption[3]		:= "8"

acStopBitsOption[1]	:= "1"
acStopBitsOption[2]	:= "2"

/* Define Generic Variables */

cDoubleBar		:= ""
lnPortActive 		:= SWFALSE
nWait			:= 60		/* Dialer wait time */
nCallCount		:= 0		/* Dialer call count */
nCursorType		:= 1
cFileName		:= space(FILELEN)
nMaxRow			:= 24		/* Temp assign for error handler */
nTransStatusType	:= 0		/* Default status box for file transfers */
nComOption		:= 0		/* nOption on open and close COM functions */

/* Define Flow Control Variables */

lXONXOFFlowControl	:= SWFALSE	/* XON/XOFF flow control off by default */
lRTSCTSFlowControl	:= SWFALSE	/* RTS/CTS flow control off by default */
lDTRDSRFlowControl	:= SWFALSE	/* DTR/DSR flow control off by default */
lCDFlowControl		:= SWFALSE	/* Carried detect flow control off by default */


/* Check For Color And Define Color Strings */

if iscolor()
   nTermColor   := SWBitOr(SWBldAtrib(SWWHITE,SWBLUE),SWINTENSE)
   nBarColor    := SWBitOr(SWBldAtrib(SWWHITE,SWMAGENTA),SWINTENSE)
   SWSetTerm(2,nTermColor)			/* Attribute for writing / clearing */
   SWSetTrans(4,nTermColor)			/* File Transfer Box Color */
   SWSetTrans(5,nTermColor)			/* File Transfer Text Color */
   SWSetTrans(6,SWBldAtrib(SWBLUE,SWCYAN))	/* File Transfer Graph Color */
   cText1Color	:= "w+/b,w+/rb+,n"
   cText2Color	:= "gr+/b,gr+/rb+,n"
   cPromptColor	:= "gr+/bg+,w+/b,n"
   cTBColor	:= "w+/b,w+/bg+,n"
else
   nTermColor   := SWBldAtrib(SWWHITE,SWBLACK)
   nBarColor    := SWBldAtrib(SWBLACK,SWWHITE)
   cText1Color	:= "w+/n,n/w+,n"
   cText2Color	:= "w/n,n/w,n"
   cPromptColor	:= "n/w,w/n,n"
   cTBColor	:= "w/n,n/w,n"
endif


/* Get Environment For Databases */

cDBFPath := ""
cDBFPath := alltrim(getenv("SWTALK"))		/* set SWTALK=<path> */

if (substr(cDBFPath,len(cDBFPath),1) != "\") .and. (len(cDBFPath) != 0)
   cDBFPath := cDBFPath +"\"
endif


/* Check For Databases */

if !file(cDBFPath+"SWDial.dbf")
   ErrorToneOut("Missing "+cDBFPath+"SWDial.dbf file...",3," Error ")
   restscreen(0,0,24,79,cOpenScreen)
   quit
endif

if !file(cDBFPath+"SWDeFalt.dbf")
   ErrorToneOut("Missing "+cDBFPath+"SWDeFalt.dbf file...",3," Error ")
   restscreen(0,0,24,79,cOpenScreen)
   quit
endif


/* Open Databases */

select 1
use (cDBFPath + "swdefalt")
go 1


select 2
use (cDBFPath + "swdial")
go 1



/* Define STATIC variables */

select SWDeFalt
go 1
nTerm		= fnTerm		/* Terminal type from database */
nPort		= fnPort		/* COM port value from database */
nBaud		= fnBaud		/* Baud rate from database */
nParity		= fnParity		/* Parity from database */
nWord		= fnWord		/* Word length from database */
nStop		= fnStop		/* Stop bits from database */
cModem		= fcModem		/* Modem setup string from database */
nMaxRow		= fnMaxRow		/* Max row from database */
nBoard		= fnBoard		/* COM board installed from database */
cSWOpenCom      = acSWOpenCom[nBoard]   /* Macro for COM board open */
cSWCloseCom	= acSWCloseCom[nBoard]  /* Macro for COM board close */

cLastPhone      := " "
cLastName       := " "

/* Define Terminal Defaults */

SWTermExit(anExitKeys)
SWSetTerm(3,nMaxRow-1)		/* Set max row for terminal emulation */

if iscolor()

   nStartVideoMode := SWSetVideo(3)	/* Get Clipper default video mode */

   do case
      case nMaxRow == 24
         SWSetFont(2)			/* Set CGA 8x16 font */
	 nCursorType := 1

      case nMaxRow == 42
         SWSetFont(0)			/* Set EGA 8x8 font */
	 nCursorType := 3

      case nMaxRow == 49
         SWSetFont(0)			/* Set VGA 8x8 font */
	 nCursorType := 3

   endcase
else
   nStartVideoMode := SWSetVideo(7)
   nMaxRow := 24	
   SWSetTerm(3,nMaxRow-1)		/* Set max row for terminal emulation */
endif

setcolor(cText1Color)
SWClearScreen(0,0,nMaxRow,79,nTermColor)
OpenScreen()
DisplayBar(COMBAR)			/* Display COM settings */
cTermScreen := savescreen(0,0,23,79)
SetComTable()				/* Set all Base I/O and IRQs */
SetUpPort()				/* Open COM port */

nTermRow := 0				/* Define starting terminal row */
nTermCol := 0				/* Define starting terminal column */

do while SWTRUE

   restscreen(0,0,23,79,cTermScreen)
   DisplayBar(COMBAR)
   @nTermRow,nTermCol say ""
   SWSCurPos(nTermRow,nTermCol)
   SWSetTerm(7,nTermRow)		/* Set terminal current row */
   SWSetTerm(8,nTermCol)		/* Set terminal current column */
   keyboard ""				/* Flush keyboard buffer */

   do case
      case nTerm == 1
         nExitKey := SWTTYTerm(nPort)	/* TTY terminal mode */

      case nTerm == 2
         nExitKey := SWANSITerm(nPort)	/* ANSI terminal mode */

      case nTerm == 3
         nExitKey := SWVT100Term(nPort)	/* VT-100 terminal mode */

      case nTerm == 4
         nExitKey := SWVT52Term(nPort)	/* VT-52 terminal mode */

   endcase

   nTermRow := SWGetRow()		/* Get current row of terminal */
   nTermCol := SWGetCol()		/* Get current column of terminal */
   cTermScreen := savescreen(0,0,23,79)

   if nExitKey == SW_ALT_Z
      nExitKey := MainMenu()
   endif

   do case
      case nExitKey == anExitKeys[1]		/* Alt-C */
         SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
	 nTermRow := 0
	 nTermCol := 0
	 SWSCurPos(0,0)
	 @0,0 say ""
	 SWSetTerm(7,0)		/* Set terminal current row */
	 SWSetTerm(8,0)		/* Set terminal current column */
	 cTermScreen := savescreen(0,0,23,79)

      case nExitKey == anExitKeys[2]		/* PgUp */
         nReturnCode := TransferOpts(10,10)
	 if nReturnCode != 0
 	    FileTransfers(0,5,anExitKeys[2],nReturnCode)
         endif

      case nExitKey == anExitKeys[3]		/* PgDn */
         nReturnCode := TransferOpts(10,10)
	 if nReturnCode != 0
 	    FileTransfers(0,5,anExitKeys[3],nReturnCode)
         endif

      case nExitKey == anExitKeys[4]		/* Alt-P */
         ComParms(1,40,@nTerm,@nPort,@nBaud,@nParity,@nWord,@nStop)

      case nExitKey == anExitKeys[5]		/* Alt-D */
         SWDialDir(0,0)

      case nExitKey == anExitKeys[6]		/* Alt-M */
         HotKeys(4,5)

      case nExitKey == anExitKeys[7]		/* Alt-0 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt0),MACROCR,chr(13)))

      case nExitKey == anExitKeys[8]		/* Alt-1 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt1),MACROCR,chr(13)))

      case nExitKey == anExitKeys[9]		/* Alt-2 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt2),MACROCR,chr(13)))

      case nExitKey == anExitKeys[10]		/* Alt-3 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt3),MACROCR,chr(13)))

      case nExitKey == anExitKeys[11]		/* Alt-4 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt4),MACROCR,chr(13)))

      case nExitKey == anExitKeys[12]		/* Alt-5 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt5),MACROCR,chr(13)))

      case nExitKey == anExitKeys[13]		/* Alt-6 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt6),MACROCR,chr(13)))

      case nExitKey == anExitKeys[14]		/* Alt-7 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt7),MACROCR,chr(13)))

      case nExitKey == anExitKeys[15]		/* Alt-8 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt8),MACROCR,chr(13)))

      case nExitKey == anExitKeys[16]		/* Alt-9 */
         select SWDeFalt
	 SWTXString(nPort,strtran(trim(fnAlt9),MACROCR,chr(13)))

      case nExitKey == anExitKeys[17]		/* Alt-S */
         SystemDefaults(3,20)

      case nExitKey == anExitKeys[18]		/* Alt-H */
         HangUp()

      case nExitKey == anExitKeys[19]		/* Alt-Y */
         cHolder := "AUTO ANSWER ON"
	 SWPutStr(nMaxRow,1,cHolder,nBarColor)
         SWMAutoAns(nPort,SWCSMON)
	 SWWait(SWSECOND)
	 DisplayBar(COMBAR)

      case nExitKey == anExitKeys[20]		/* '*/
         if iscolor()
            VideoMode(10,10,@nTermRow)
	 else
   	    ErrorToneOut("Color Video Adapter Not Available",3," Error ")
	 endif   

      case nExitKey == anExitKeys[22]		/* Alt-R */
      	 nCallCount := 0
         if cLastPhone != " "
            AutoDial(14,1,cLastName,cLastPhone,SWTRUE,SWFALSE,"M")
         else
	    ErrorToneOut("No Previous Number To Dial",1," Error ")
         endif

      case nExitKey == anExitKeys[23]		/* Alt-B */
	 setcursor(0)
	 SWPutStr(nMaxRow,1,"*** BREAK *** ",nBarColor)
         SWTXBreak(nPort,SWTRUE)
	 SWWAIT(3)
         SWTXBreak(nPort,SWFALSE)
	 DisplayBar(COMBAR)
	 setcursor(nCursorType)

      case nExitKey == anExitKeys[24]		/* Alt-F10 */
         if anComBoardOption[nBoard] == STANDARD
            ResetIRQBaseIO(6,15)
	 else
	    ErrorToneOut("This Option Only Available On Stanadard COM1-COM8 Adapters",3," Error ")
	 endif

      case nExitKey == anExitKeys[25]		/* Alt-F9 */
         SWFileDir()

      case nExitKey == anExitKeys[26]		/* Alt-F4 */
      	 cCOMSPEC := getenv("COMSPEC")
	 if empty(cCOMSPEC)
	    ErrorToneOut("Missing: SET COMSPEC=<drive:><path>\COMMAND.COM in AUTOEXEC.BAT",3," Error ")
	 else
	    nComOption := SWNORESTORE	/* Set nComOption To Retain All Current COM Settings */
	    nHolder := &cSWCloseCom	/* Close COM Port With nComOption */

            setcolor("7/0")
	    SWClearScreen(0,0,nMaxRow,79,SWBldAtrib(SWWHITE,SWBLACK))
	    setcursor(nCursorType)
	    ?"Enter 'EXIT' to return to Silver Talk III"
	    run (cCOMSPEC)
	    setcolor(cText1Color)

	    nComOption := 0		/* Set nComOption Back To Normal */
	    nHolder := &cSWOpenCom

	 endif

      case nExitKey == anExitKeys[27]		/* Alt-V */
      	 ViewFile(0,5)

      case nExitKey == anExitKeys[28]		/* Alt-E */
         cHolder := iif(SWSetTerm(1),"  ECHO OFF    ","   ECHO ON    ")
	 SWPutStr(nMaxRow,1,cHolder,nBarColor)
	 SWSetTerm(1,iif(SWSetTerm(1),SWFALSE,SWTRUE))
	 SWWAIT(SWSECOND)
	 DisplayBar(COMBAR)

      case nExitKey == anExitKeys[29]
      	 VersionDispaly(0,0)

      case nExitKey == anExitKeys[30]

      case nExitKey == anExitKeys[31]

      case nExitKey == anExitKeys[32]		/* Alt-X */
         if ExitToDos()
	    exit
	 endif
   endcase

enddo
nReturnCode := &cSWCloseCom
close all
SWSetVideo(nStartVideoMode)
restscreen(0,0,24,79,cOpenScreen)
RETURN(NIL)




/*
**
** Function Name: AttachMacros() -> cString
**
**
** Description:
**
**	Attach keyboard macros to a telephone number in the dialing directory.	
**
** Returns:
**
**	cString		= A string of Alt-# macros from 0-9 attached to dial.
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION AttachMacros()
LOCAL nRow, nCol, nRowOffset, nColOffset, nChoice, acMacro[10], nLoop, cString, cAttachScreen, cChar, nLength, nOnColor, nOffColor

nChoice    := 1
nRow       := 4
nCol       := 39
nRowOffset := 11
nColOffset := 27
cString    := trim(fcMacros)
cChar	   := " "
nOnColor   := SWBitOr(SWBldAtrib(SWBROWN,SWBLUE),SWINTENSE)
nOffColor  := SWBitOr(SWBldAtrib(SWWHITE,SWBLUE),SWINTENSE)

for nLoop := 1 to 10
   acMacro[nLoop] := " "

next

for nLoop := 1 to len(cString)
    acMacro[val(substr(cString,nLoop,1))+1] := substr(cString,nLoop,1)

next

cAttachScreen := savescreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet)
Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Attach Macro Dial ")

do while SWTRUE
    SWPutStr(nRow+1,nCol+1, "Keyboard Macro Alt-0   ",iif(acMacro[1]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+2,nCol+1, "Keyboard Macro Alt-1   ",iif(acMacro[2]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+3,nCol+1, "Keyboard Macro Alt-2   ",iif(acMacro[3]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+4,nCol+1, "Keyboard Macro Alt-3   ",iif(acMacro[4]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+5,nCol+1, "Keyboard Macro Alt-4   ",iif(acMacro[5]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+6,nCol+1, "Keyboard Macro Alt-5   ",iif(acMacro[6]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+7,nCol+1, "Keyboard Macro Alt-6   ",iif(acMacro[7]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+8,nCol+1, "Keyboard Macro Alt-7   ",iif(acMacro[8]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+9,nCol+1, "Keyboard Macro Alt-8   ",iif(acMacro[9]  ==" ",nOffColor,nOnColor))
    SWPutStr(nRow+10,nCol+1,"Keyboard Macro Alt-9   ",iif(acMacro[10] ==" ",nOffColor,nOnColor))

    @nRow+1,nCol+24  prompt iif(acMacro[1] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[2] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[3] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[4] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[5] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[6] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[7] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[8] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[9] ==" ","Off","On ") 
    @row()+1,nCol+24 prompt iif(acMacro[10]==" ","Off","On ") 
    menu to nChoice

    do case
       case nChoice == 0
       	  exit 

       case nChoice == 1
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 2
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 3
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 4
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 5
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 6
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 7
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 8
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 9
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

       case nChoice == 10
          acMacro[nChoice] := iif(acMacro[nChoice]==" ",str(nChoice-1,1,0)," ")

    endcase

enddo

cString := ""

for nLoop := 1 to 10
    if acMacro[nLoop] != " "
       cString := cString+acMacro[nLoop]

    endif
next

restscreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,cAttachScreen)

RETURN(cString)




/*
**
** Function Name: AutoDial(nRow,nCol,cName,cPhone,lBox,
**			   lDialOriginTag,cDialType) -> nStatus
**
**	nRow		= Starting row of dialer
**	nCol		= Starting column of dialer
**	cName		= Name of dialing number
**	cPhone		= Phone number to dial
**	lBox		= If box should be drawn
**	lDialOriginTag	= Origen of function call
**	cDialType	= (Tagged or Manual, etc...)
**	
**
**
** Description:
**
**	Dials numbers from dialing directory or from manual dial.
**	This function also displays call progress.
**	
**
** Returns:
**
**	nStatus		= Status of last dial
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION AutoDial(nRow,nCol,cName,cPhone,lBox,lDialOriginTag,cDialType)

FIELD fnAlt0, fnAlt1, fnAlt2, fnAlt3, fnAlt4, fnAlt5, fnAlt6, fnAlt7, fnAlt8, fnAlt9

LOCAL nRowOffSet, nColOffSet, nPass, cModemResponse, nTotalCalls, nPause, nPauseTimer, nWaitTimer, nMult, nWaitCurrent, nPauseCurrent, nKey, lPassLoop, nKeyPress, nStatus, nLoop, cMacros

nRowOffset      := nRow+4
nColOffSet      := nCol+77
nPass		:= 0
cModemResponse	:= ""
nTotalCalls	:= 0
nPause		:= 4
nMult		:= .0559
nPauseTimer	:= 1
nWaitTimer	:= 2
nKey		:= 0
nStatus		:= 9999

if nCallCount == 0
   cAutoScreen := savescreen(nRow-1,nCol-1,nRowOffSet+1,nColOffSet+1)
endif

setcolor(cText1Color)

if lBox
   Box(nRow-1,nCol-1,nRowOffSet+3, nColOffSet+1," Re-Dial ")
   @nRowOffSet+1,nCol-1       say ""
   @nRowOffSet+1,nColOffSet+1 say ""
   @nRowOffSet+1,nCol         say replicate(cDoubleBar,78)
else
   SWClearScreen(nRow,nCol,nRowOffSet,nColOffSet,nTermColor)
endif

@nRow,nCol+1    say "   Dialing :                                Total Completed Calls :"
@row()+1,nCol+1 say "    Number :                                  Wait For Connection :     Secs"
@row()+1,nCol+1 say "      Pass :                                  Pause Between Calls :     Secs"
@row()+1,nCol+1 say " Last Call :                                   Time Start Of Dial :"
@row()+1,nCol+1 say " Time Left :                              Time Start Of This Call :"

if lBox
   @nRow-1,38 say ""
else
   @nRow-1,38 say ""
endif

@nRowOffSet+1,38 say ""
for nLoop := nRow to nRowOffSet
   @nLoop,38 say ""
next

@row()+2,nCol+1 say "      Recycle          Remove From List          Change wait          Abort"
setcolor(cText2Color)
@row(),nCol+1  say "Space"
@row(),nCol+20 say "Del"
@row(),nCol+46 say "End"
@row(),nCol+67 say "Esc"

@nRow+3,nCol+69 say time()

SWSetUART(nPort,nBaud,nParity,nWord,nStop)

DisplayBar(COMBAR)

SWCrtTimer(nPauseTimer,nPause*SWSECOND)		/* Create pause timer */
SWCrtTimer(nWaitTimer,nWait*SWSECOND)		/* Create dial wait timer */

keyboard chr(1)					/* Stuff keyboard with NON used key */

do while nKey != K_ESC
   setcursor(0)
   setcolor(cText2Color)
   nPass++					/* Inc pass counter */
   nCallCount++					/* Inc call counter */
   @nRow,nCol+14   say padr(cName,23)
   @nRow,nCol+69   say nCallCount pict"999"
   @nRow+1,nCol+14 say padr(cPhone,17)
   @nRow+1,nCol+69 say nWait pict"999"
   @nRow+2,nCol+14 say nPass pict"999"
   @nRow+2,nCol+69 say nPause pict"999"
   @nRow+4,nCol+69 say time()

   SWFlushRX(nPort)
   SWMDial(nPort,trim(cPhone))		/* Dial number */
   cLastPhone := trim(cPhone)		/* Assign cLastPhone for Alt-R Redial */
   cLastName  := trim(cName)		/* Assign cLastName  for Alt-R Redial */

   SWRestrtTm(nWaitTimer,nWait*SWSECOND)	/* Restart dial wait timer */
   lPassLoop := SWTRUE

   do while lPassLoop
   
      nWaitCurrent := SWGTimer(nWaitTimer)*nMult
      @nRow+4,nCol+14 say nWaitCurrent pict"999.999"

      if !SWRXEmpty(nPort)

         /* Read modem responses */

         if SWMGetResp(nPort,@cModemResponse,1) <> SWCTIMEDOUT
            do case
               case cModemResponse == "NO DIALTONE"   .or. cModemResponse == "6"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 6

               case cModemResponse == "NO CARRIER"    .or. cModemResponse == "3"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 7

               case cModemResponse == "ERROR"         .or. cModemResponse == "4"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 4

               case cModemResponse == "BUSY"          .or. cModemResponse == "7"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 7

               case cModemResponse == "OK"            .or. cModemResponse == "0"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 0

               case cModemResponse == "NO ANSWER"     .or. cModemResponse == "8"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 8

    	       case cModemResponse == "CONNECT"       .or. cModemResponse == "1"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 1

  	       case cModemResponse == "CONNECT 1200"  .or. cModemResponse == "5"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 1

	       case cModemResponse == "CONNECT 2400"  .or. cModemResponse == "10"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 1

	       case cModemResponse == "CONNECT 4800"  .or. cModemResponse == "11"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 1

   	       case cModemResponse == "CONNECT 9600"  .or. cModemResponse == "12"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 1

	       case cModemResponse == "CONNECT 19200" .or. cModemResponse == "14"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)
	          nStatus := 1

  	       case cModemResponse == "CARRIER 300"  .or. cModemResponse == "40"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)

  	       case cModemResponse == "CARRIER 1200"  .or. cModemResponse == "46"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)

	       case cModemResponse == "CARRIER 2400"  .or. cModemResponse == "47"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)

	       case cModemResponse == "CARRIER 4800"  .or. cModemResponse == "48"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)

   	       case cModemResponse == "CARRIER 9600"  .or. cModemResponse == "50"
                  @nRow+3,nCol+14 say padr(cModemResponse,13)

 	    endcase

         endif
      
      endif

      /* Display seconds after modem check */

      nWaitCurrent :=SWGTimer(nWaitTimer)*nMult
      @nRow+4,nCol+14 say nWaitCurrent pict"999.999"

      /* If the current loop seconds have timed out set lPassLoop to .F. */

      if nWaitCurrent == 0
         lPassLoop := SWFALSE
         @nRow+3,nCol+14 say padr("TIMED OUT",13)

      endif

      nKey := inkey()

      /* Case statement for user key press */

      do case
         case lastkey() == K_ESC	/* Abort, ESC key pressed */
	    nKeyPress := K_ESC
	    nKey      := K_ESC
            @nRow+1,nCol+14 say padr("Redial Aborted",17)
	    SWWait(SWSECOND)
	    keyboard chr(1)
	    lPassLoop := SWFALSE
	    nStatus := K_ESC
	    SWTXChar(nPort,13)		/* Hang up for a NO CARRIER Dial */	

         case lastkey() == 32		/* Recycle, Space bar pressed */
	    nKeyPress := 32
	    SWWait(SWSECOND)
            @nRow+1,nCol+14 say padr("Recycle",17)
	    SWWait(9)
	    keyboard chr(1)
	    lPassLoop := SWFALSE
	    nStatus := 7

         case lastkey() == K_END	/* End, End key pressed */
	    nKeyPress := K_END
	    SWStopTm(nWaitTimer)
	    @nRow+1,nCol+69 get nWait pict "999"
	    read
	    @nRow+1,nCol+69 say nWait pict "999"
	    SWRestrtTm(nWaitTimer,nWait*SWSECOND)
	    keyboard chr(1)

         case lastkey() == K_DEL	/* Del, Delete key pressed */
	    if lDialOriginTag		/* Check for tag dial */
	       replace fcTag with space(1)
	       nKeyPress := 32
               @nRow+1,nCol+14 say padr("Delete From List",17)
	       SWWait(SWSECOND)
               @nRow+1,nCol+14 say padr("Recycle",17)
	       SWWait(9)
	       keyboard chr(1)
	       lPassLoop := SWFALSE
	       nStatus := 7

	    endif

      endcase

      /* Case statement for modem and call status */

      do case
         case nStatus == K_DEL .or. nStatus == 8	/* BUSY or NO ANSWER */
	    if lDialOriginTag				/* Check for tag dial */
	       nKeyPress := K_ESC
	       nKey      := K_ESC
	       keyboard chr(1)
	       lPassLoop := SWFALSE

	    else
  	       keyboard chr(1)
	       lPassLoop := SWFALSE

            endif

         case nStatus == 1				/* CONNECT */
            nKeyPress := 99
	    nKey      := K_ESC
	    SWWait(SWSECOND)
	    keyboard chr(1)
            lPassLoop := SWFALSE

      endcase

      if !lDialOriginTag .and. nStatus != 1  	/* If not CONNECT and not a tag dial */
         nStatus := 9999			/* Set nStatus to dummy value */
      endif	 

   enddo

   if (nKeyPress != K_ESC) .or. (nKeyPress == K_ESC .and. lDialOriginTag .and. nStatus != K_ESC)
      SWTXChar(nPort,13)	/* Hang up NO CARRIER Dial */	
      @nRow,nCol+14 say padr("Pausing...",23)
      SWRestrtTm(nPauseTimer,nPause*SWSECOND)

      nPauseCurrent := 4			/* Seed for do while loop */

      do while nPauseCurrent != 0		/* Pause loop display */
         nPauseCurrent :=SWGTimer(nPauseTimer)*nMult
	 @nRow+4,nCol+14 say nPauseCurrent pict"999.999"
	 inkey()
         if lastkey() == K_ESC
	    nPauseCurrent := 0

	 endif

     	 if nStatus == 1
	    SWPutStr(nRow+1,nCol+14,padr("Connected",17),SWBitOr(nTermColor,SWBLINK))
	    tone(2500,2)
	    tone(4500,1)

	 endif

      enddo

      if nStatus != 1	      /* If not CONNECT flush receive queue */
         SWFlushRX(nPort)

      endif 

   endif

enddo

@nRow+6,nCol+1 say space(77)

SWDSyTimer(nPauseTimer)		/* Delete system timer nPauseTimer */
SWDSyTimer(nWaitTimer)		/* Delete system timer nWaitTimer */

if !lDialOriginTag .or. nStatus == K_ESC	/* Only on last call */
   restscreen(nRow-1,nCol-1,nRowOffSet+1,nColOffSet+1,cAutoScreen)
   cAutoScreen := ""				/* Release some memory */

endif

setcursor(nCursorType)

if nStatus == 1 .and. cDialType != "M"
   if len(fcMacros) > 0
      cMacros = trim(fcMacros)
      select SWDeFalt

      for nLoop := 1 to len(cMacros)
          cHolder := "fnALT"+substr(cMacros,nLoop,1)
          SWTXString(nPort,strtran(trim(&cHolder),MACROCR,chr(13)))
	  SWWait(SWSECOND)

      next

      select SWDial

   endif

endif



RETURN(nStatus)



/*
**
** Function Name: ComParms(nRow,nCol,nTerm,nPort,nBaud,;
**			   nParity,nWord,nStop) -> NIL
**
** 	@nRow		= Row to start box.
**	@nCol		= Col to start box.
**	@nTerm		= STATIC terminal mode.
**	@nPort		= STATIC COM port.
**	@nBaud		= STATIC baud rate.
**	@nParity	= STATIC parity setting.
**	@nWord		= STATIC word length or data bits.
**	@nStop		= STATIC stop bits.
**
**
** Description:
**
**	Set the STATIC communications parameters for program.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/


FUNCTION ComParms(nRow,nCol,nTerm,nPort,nBaud,nParity,nWord,nStop)

LOCAL nLoop, nChoice, nOption, nRowOffSet, nColOffSet, cComParmsScreen, nOldPort, nReturnCode

nRowOffSet := 9
nColOffSet := 27
nOldPort   := nPort
nOldBoard  := nBoard

cComParmsScreen := savescreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet)

cHolder	   := ""

do while SWTRUE

   nRowOffSet := 9
   nColOffSet := 27

   Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Terminal Setup ")

   nRowOffSet := 1
   nColOffSet := 17

   setcolor(cText2Color)
   @nRow+nRowOffSet, nCol+nColOffSet say acTermOption[nTerm]
   @row()+nRowOffSet,nCol+nColOffSet say acCOMPortOption[nPort+1]
   @row()+nRowOffSet,nCol+nColOffSet say alltrim(acBaudOption[ascan(acBaudOption,padl(alltrim(str(nBaud,6,0)),6))])
   @row()+nRowOffSet,nCol+nColOffSet say acParityOption[ascan(anParity,nParity)]
   @row()+nRowOffSet,nCol+nColOffSet say acWordOption[ascan(acWordOption,str(nWord,1,0))]
   @row()+nRowOffSet,nCol+nColOffSet say acStopBitsOption[nStop]
   @row()+nRowOffSet,nCol+nColOffSet say acComBoardOption[nBoard]

   nRowOffSet := 1
   nColOffSet := 2

   setcolor(cText1Color)
   @nRow+nRowOffSet, nCol+nColOffSet prompt "Terminal Mode"
   @row()+nRowOffSet,nCol+nColOffSet prompt "COM Port     "
   @row()+nRowOffSet,nCol+nColOffSet prompt "Baud Rate    "
   @row()+nRowOffSet,nCol+nColOffSet prompt "Parity       "
   @row()+nRowOffSet,nCol+nColOffSet prompt "Word Length  "
   @row()+nRowOffSet,nCol+nColOffSet prompt "Stop Bits    "
   @row()+nRowOffSet,nCol+nColOffSet prompt "Com Board    "
   @row()+nRowOffSet,nCol+nColOffSet prompt "Save Settings To Disk"

   menu to nChoice

   nRowOffSet := 0
   nColOffSet := 17

   do case
      case nChoice == 1			/* Terminal Mode */
         nOption := nTerm
	 for nLoop := 1 to 4
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt acTermOption[nLoop]

  	 next
	 menu to nOption
	 if nOption != 0
	    nTerm := nOption

	 endif

      case nChoice == 2			/* COM Port */
   	 nOption := nPort+1
         for nLoop := 1 to anComBoardOption[nBoard]
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt acCOMPortOption[nLoop]

	 next
	 menu to nOption
	 if nOption != 0
	    if cHolder  == ""
 	       cHolder     := cSWCloseCom

	    endif
	    nPort := nOption-1

	 endif

      case nChoice == 3			/* Baud Rate */
         nOption := ascan(acBaudOption,padl(alltrim(str(nBaud,6,0)),6))
         for nLoop := 1 to 18
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt padr(alltrim(acBaudOption[nLoop]),6)

	 next
	 menu to nOption
 	 if nOption != 0
	    nBaud := val(alltrim(acBaudOption[nOption]))

  	 endif

      case nChoice == 4			/* Parity */
   	 nOption := ascan(anParity,nParity)
	 for nLoop := 1 to 5
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt acParityOption[nLoop]

	 next
	 menu to nOption
	 if nOption != 0
	    nParity := anParity[nOption]

	 endif

      case nChoice == 5			/* Word Length */
   	 nOption := ascan(acWordOption,str(nWord,1,0))
         for nLoop := 1 to 3
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt acWordOption[nLoop]

  	 next
 	 menu to nOption
	 if nOption != 0
	    nWord := val(acWordOption[nOption])

	 endif

      case nChoice == 6			/* Stop Bits */
   	 nOption := nStop
         for nLoop := 1 to 2
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt acStopBitsOption[nLoop]
	 next

	 menu to nOption
	 if nOption != 0
	    nStop := nOption

	 endif

      case nChoice == 7			/* Com Boards */
   	 nOption := nBoard
         for nLoop := 1 to 3
	    @nRow+nChoice+nRowOffSet,nCol+nColOffSet prompt acComBoardOption[nLoop]

	 next
	 menu to nOption
	 if nOption != 0
	    nBoard := nOption
	    if cHolder  == ""
 	       cHolder     := cSWCloseCom

	    endif
	    cSWOpenCom  := acSWOpenCom[nOption]
	    cSWCloseCom := acSWCloseCom[nOption]

	 endif

      case nChoice == 8			/* Save Settings */
         select SWDeFalt
	 go 1
	 replace fnTerm   with nTerm 
	 replace fnBoard  with nBoard
	 replace fnPort   with nPort 
	 replace fnBaud   with nBaud 
	 replace fnParity with nParity 
	 replace fnWord   with nWord 
	 replace fnStop   with nStop 
	 exit

      case nChoice == 0
   	 exit

   endcase
enddo

nReturnCode := SWCNOUARTPRESENT

if (nPort != nOldPort) .or.(nBoard != nOldBoard)
   nHolder := nPort			/* Hold new COM port */
   nPort   := nOldPort			/* Assign old COM port */

   nReturnCode := &cHolder		/* Close old COM port */
   nPort   := nHolder			/* Move new port to port */
   lnPortActive := SWFALSE		/* Set new COM port to NOT active */
   nReturnCode := &cSWOpenCom		/* Open new COM port */

   if nReturnCode != SWCSUCCESSFUL
      lnPortActive := SWFALSE

   else
      cHolder	   := ""	
      lnPortActive := SWTRUE		/* If SWCSUCCESSFUL, port active */

   endif

else

   if lnPortActive
      nReturnCode  := SWCSUCCESSFUL

   else
      nReturnCode := SWCNOUARTPRESENT

   endif

endif

if nReturnCode != SWCSUCCESSFUL .or. !lnPortActive
   lnPortActive := SWFALSE
   ErrorToneOut(SWErrToTxt(nReturnCode,0)+", Open COM Port Error, Please Choose Another ",0," Error ")

else
   lnPortActive := SWTRUE
   SWSetUART(nPort,nBaud,nParity,nWord,nStop)

endif

nRowOffSet := 9
nColOffSet := 27
restscreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,cComParmsScreen)

RETURN(NIL)



/*
**
** Function Name: Box(nRow1,nCol1,nRow2,nCol2,cHeading) -> NIL
**
** 	nRow1		= Upper row for box.
**	nCol1		= Upper column for box.
**	nRow2		= Bottom row for box.
**	nCol2		= Bottom column for box.
**	cHeading	= Box heading.
**
**
** Description:
**
**	Display a box on screen.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION Box(nRow1,nCol1,nRow2,nCol2,cHeading)
setcolor(cText1Color)
@nRow1,nCol1,nRow2,nCol2 box B_DOUBLE_SINGLE+space(1)
setcolor(cPromptColor)
@nRow1,nCol1+1 say cHeading
setcolor(cText1Color)
RETURN(NIL)




/*
**
** Function Name: DisplayAdir(nRow1,nCol1,nTotalFiles,cFileSpec) -> NIL
**
** 	nRow1		= Row for adir() box.
**	nCol1		= Column for adir() box.
**	nTotalFiles	= Total number of file in the chosen file spec.
**	cFileSpec	= Directory to list.
**	
**
**
** Description:
**
**	Display an achoice() box on the screen with the options to choose
**	a desired file.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION DisplayAdir(nRow1,nCol1,nTotalFiles,cFileSpec)

LOCAL nLoop, nRow2, nCol2,cDirScreen, nReturnCode
LOCAL acFileNames[nTotalFiles], anSizes[nTotalFiles], adDates[nTotalFiles], acTimes[nTotalFiles]

nRow2     := nRow1 + 10
nCol2     := nCol1 + 44

cDirScreen := savescreen(nRow1,nCol1,nRow2,nCol2)

Box(nRow1,nCol1,nRow2,nCol2," Directory: "+cFileSpec+" ")
@nRow2-2,nCol1   say ""
@nRow2-2,nCol2   say ""
@nRow2-2,nCol1+1 say replicate(cDoubleBar,43)

SWPutStr(nRow2-1,nCol1+1,padc(" Processing ",43),SWBitOr(nBarColor,SWBLINK))

adir(cFileSpec,acFileNames,anSizes,adDates,acTimes)

for nLoop := 1 to nTotalFiles
   acFileNames[nLoop] := padr(acFileNames[nLoop],13)+;
   			 padr(str(anSizes[nLoop],10,0),12)+;
			 padr(dtoc(adDates[nLoop]),10)+;
			 padr(acTimes[nLoop],8)

next
release anSizes, adDates, acTimes

asort(acFileNames)

setcolor(cPromptColor)
@nRow2-1,nCol1+1 say padc(" ESC to EXit  or  ENTER to Choose ",43)
setcolor(cText1Color)

setcursor(0)
nReturnCode := achoice(nRow1+1,nCol1+1,nRow2-3,nCol2-1,acFileNames)

if nReturnCode != 0
   cFileName := trim(substr(acFileNames[nReturnCode],1,12))
   cFileName := substr(cFileSpec,1,SplitPath(cFileSpec))+cFileName

endif

restscreen(nRow1,nCol1,nRow2,nCol2,cDirScreen)

RETURN(NIL)




/*
**
** Function Name: DisplayBar(nBar) -> NIL
**
** 	nBar		= Type of bar to display.
**	
**
** Description:
**
**	Display status bar on bottom of screen.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION DisplayBar(nBar)

LOCAL cBar, cSpaceChar

cSpaceChar := "  "

do case
   case nBar == 1		/* Standard COM parameters bar */
      cBar := padr(;
	   " Alt-Z FOR HELP"+;
	   cSpaceChar+;
	   TermToText(nTerm)+;
	   cSpaceChar+;
	   acBaudOption[ascan(acBaudOption,padl(alltrim(str(nBaud,6,0)),6))]+;
	   " "+;
	   substr(acParityOption[ascan(anParity,nParity)],1,1)+;
	   acWordOption[ascan(acWordOption,str(nWord,1,0))]+;
	   acStopBitsOption[nStop]+;
	   cSpaceChar+;
	   acCOMPortOption[nPort+1]+;
	   cSpaceChar+;
	   "Copyright (c)1991 SilverWare Inc";
	   ,80)

   case nBar == 2		/* ASCII file transfer bar */
      cBar := padc("ASCII File Transfer, Press ESC To Exit",80)

   case nBar == 3		/* View file bar */
      cBar := padc("Ctrl-PgUp: Top of file    PgUp: Previous page    PgDn: Next page    Esc: Exit",80)

endcase

SWPutStr(nMaxRow,0,cBar,nBarColor)
RETURN 0



/*
**
** Function Name: EditModem() -> NIL
**
**
** Description:
**
**	Edit modem setup string in SWDeFalt.dbf
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION EditModem()

LOCAL cModemScreen, nRow1, nRow2, nCol1, nCol2

nRow1 := 10
nCol1 := 07
nRow2 := 12
nCol2 := 71

select SWDeFalt
go top

cModemScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2," Modem Setep String ")

@nRow1+1,nCol1+2 say "Enter Setup String: " get fcModem
read
restscreen(nRow1,nCol1,nRow2,nCol2,cModemScreen)
RETURN(NIL)



/*
**
** Function Name: ErrorSys()
**
**
**
** Description:
**
**	SilverWare replacement for Clipper ErrorSys().
**	This is designed to close all com ports if a critical error
**	occurs.
**
**	Note:  automatically executes at startup
**
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

PROC ErrorSys()
	ErrorBlock( {|e| CritError(e)} )
RETURN


STATIC FUNC CritError(e)

LOCAL nI, nReturnCode

SWClearScreen(0,0,nMaxRow,79,nTermColor)

ErrorToneOut("An ERROR has occured, Closeing all COM ports...",2," Critical Error ")
nReturnCode := &cSWCloseCom

ErrorToneOut("An ERROR has occured, Deleting all timers...",2," Critical Error ")
SWDalTimer()

inkey(1)

if ( e:genCode == EG_OPEN .and. NetErr() .and. e:canDefault )
   /* driver default */
   RETURN(SWTRUE)									/* NOTE */
endif

/* put a message to STDOUT */
? "Error"

if ( !Empty(e:subsystem()) )
   ?? " " + e:subsystem() + "/" + Ltrim(Str(e:subCode()))
endif

if ( !Empty(e:description()) )
   ?? "  " + e:description()
endif

if ( !Empty(e:operation()) )
   ?? ": " + e:operation()
endif

if ( !Empty(e:filename()) )
   ?? ": " + e:filename()
endif

if ( e:genCode == EG_OPEN .or. e:genCode == EG_CREATE )
   ?? "  (DOS error " + Ltrim(Str(e:osCode)) + ")"
endif

/* traceback */
nI := 2
do while ( !Empty(ProcName(nI)) )
   ? "Called from", Trim(ProcName(nI)) + ;
     "(" + Alltrim(Str(ProcLine(nI))) + ")  "
   nI++
enddo

ERRORLEVEL(1)
QUIT

RETURN(SWTRUE)



/*
**
** Function Name: ErrorTone() -> NIL
**
**
** Description:
**
**	Generate error tone.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION ErrorTone()

LOCAL nLoop

for nLoop := 1 to 4
   tone(500*nLoop,1)
next
RETURN(NIL)



/*
**
** Function Name: ErrorToneOut(cString,nWaitTime,cBarString) -> NIL
**
** 	cString		= Error string to display.
**	nWaitTime	= Number of seconds to display error.
**	cBarString	= String to send to the box() function.
**
**
** Description:
**
**	Display error message and generate error tone.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION ErrorToneOut(cString,nWaitTime,cBarString)

LOCAL cErrorScreen, nRow1, nCol1, nRow2, nCol2

nRow1 := 10
nCol1 := 0
nRow2 := 12
nCol2 := 79

cErrorScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2,cBarString)
@nRow1+1,nCol1+1 say padc(cString,78)
ErrorTone()
setcursor(0)
inkey(nWaitTime)
restscreen(nRow1,nCol1,nRow2,nCol2,cErrorScreen)
setcursor(nCursorType)
RETURN(NIL)



/*
**
** Function Name: ExitToDos() -> NIL
**
**
** Description:
**
**	Display a the exit to DOS box on screen and prompt (Y/N) to exit.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION ExitToDos()

LOCAL cExit, cExitScreen, nRow1, nRow2, nCol1, nCol2

nRow1 := 2
nCol1 := 2
nRow2 := 4
nCol2 := 25
cExit = "N"
cExitScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2," Quit ")
@nRow1+1,nCol1+2 say "Exit TO DOS? (Y/N)" get cExit pict"!" valid(cExit$"YN")
read
restscreen(nRow1,nCol1,nRow2,nCol2,cExitScreen)
RETURN(iif(cExit=="N",SWFALSE,SWTRUE))



/*
**
** Function Name: FileTransfers(nRow,nCol,nDirection,nType) -> nReturnCode
**
** 	nRow		= Top row of display box for @get of file name. 
**	nCol		= Top column of display box for @get of file name. 
**	nDirection	= File transfer direction. (upload / download)
**	nType		= Type of transfer. (X, Y, Batch and ASCII)
**
**
** Description:
**
**	Display a box on screen and ask for file name if needed.  This 
**	function also displays the status after transfer to the screen.
**
**
** Returns:
**
**	nReturnCode	= Result of file transfer.
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION FileTransfers(nRow,nCol,nDirection,nType)

LOCAL cYN, lOKToTransfer, nReturnCode, cGetFileScreen, acProtocol[7], nRowOffSet, nColOffSet

acProtocol[1] := " XMODEM "
acProtocol[2] := " YMODEM "
acProtocol[3] := " YMODEM Batch "
acProtocol[4] := " ASCII "
acProtocol[5] := " 1K-XMODEM "
acProtocol[6] := " 1K-XMODEM-G "
acProtocol[7] := " YMODEM-G Batch "


cFileName     := space(FILELEN)
lOKToTransfer := SWTRUE
cYN	      := "N"
nRowOffSet    := 3
nColOffSet    := 67
nReturnCode   := 1

cGetFileScreen := savescreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet)


do while SWTRUE

   if (nDirection == SW_PGDN) .and. ((nType == 3) .or. (nType == 7))  /* RX and YMODEM Batch */
      exit
   else
      Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,acProtocol[nType])
      setcolor(cText2Color)
      @nRow+nRowOffSet,nCol+nColOffSet-18 say " Alt-F Directory "
      setcolor(cText1Color)
      @nRow+1,nCol+1 say "Enter File Name : " get cFileName
      read
      if cFileName == space(FILELEN)
         lOKToTransfer := SWFALSE
	 exit
      endif
      if nDirection == SW_PGDN		/* RX */
         if file(cFileName)
	    setcolor(cText2Color)
            @nRow+2,nCol+1 say "File Exists, Overwrite (Y/N) " get cYN pict"!" valid(cYN$"YN")
	    read
	    setcolor(cText1Color)
	    if cYN == "Y"
	       exit
	    else
	       lOKToTransfer := SWFALSE
	    endif
	 else
	    lOKToTransfer := SWTRUE
	    exit
	 endif   
      else				/* TX */
         if !file(cFileName)
	    setcolor(cText2Color)
            @nRow+2,nCol+1 say "File Does Not Exists"
	    setcolor(cText1Color)
	    SWWait(2*SWSECOND)
            @nRow+2,nCol+1 say "                    "
	    cFileName := space(FILELEN)
	    loop
	 else
	    lOKToTransfer := SWTRUE
	    exit
	 endif
      endif
   endif

enddo

restscreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,cGetFileScreen)

cFileName := trim(cFileName)

if lOKToTransfer

   /* Set nTransStatusType for file transfer */
	
   do case
      case nTransStatusType == 1
         SWSetTrans(3,1)		/* Turn transfer status box */
	 SWSetTrans(4,nTermColor)	/* Set transfer box border color */
	 SWSetTrans(5,nTermColor)	/* Set transfer box text color */
	 SWSetTrans(7,8)		/* Set transfer box status row */

      case nTransStatusType == 2
         SWSetTrans(3,2)		/* Turn transfer status line */
	 SWSetTrans(4,nBarColor)	/* Set transfer line background color */
	 SWSetTrans(5,nBarColor)	/* Set transfer line text color */
	 SWSetTrans(7,nMaxRow)		/* Set transfer line status row */

      case nTransStatusType == 3
         SWSetTrans(3,0)		/* Turn transfer status off */
	 SWPutStr(nMaxRow,1,iif(nDirection == SW_PGUP,"Sending       ","Receiving     "),nBarColor)
	 setcursor(0)

      otherwise
         SWSetTrans(3,1)		/* Turn transfer status box on */

   endcase

   setcursor(0)
   if nDirection == SW_PGUP		/* PgUp, Send a file(s) */
      do case
         case nType == 1
            nReturnCode := SWTXMODEM(nPort,cFileName)	/* Xmodem */

         case nType == 2
            nReturnCode := SWTYMODEM(nPort,cFileName)	/* Ymodem */

         case nType == 3
            nReturnCode := SWTYMODEMB(nPort,cFileName)	/* Ymodem Batch */

         case nType == 4				/* Ascii */
	    SWSetTerm(0,ESC)	/* Set single EXIT key for ASCII transfer */
	    DisplayBar(ESCBAR)
            nReturnCode := SWTXASCII(nPort,cFileName,SWTRUE)

         case nType == 5
            nReturnCode := SWTXMOD1K(nPort,cFileName)	/* 1K-Xmodem */

         case nType == 6
            nReturnCode := SWTXMOD1KG(nPort,cFileName)	/* 1K-Xmodem-G */

         case nType == 7
            nReturnCode := SWTYMODGB(nPort,cFileName)	/* Ymodem-G Batch */

      endcase
   else				/* PgDn, Receive a file(s) */
      do case
         case nType == 1
            nReturnCode := SWRXMODEM(nPort,cFileName)	/* Xmodem */

         case nType == 2
            nReturnCode := SWRYMODEM(nPort,cFileName)	/* Ymodem */
 
         case nType == 3
            nReturnCode := SWRYMODEMB(nPort)		/* Ymodem Batch */

         case nType == 4				/* Ascii */
	    SWSetTerm(0,ESC)
	    DisplayBar(ESCBAR)
            nReturnCode := SWRXASCII(nPort,cFileName,SWTRUE,-1)

         case nType == 5
            nReturnCode := SWRXMOD1K(nPort,cFileName)	/* 1K-Xmodem */

         case nType == 6
            nReturnCode := SWRXMOD1KG(nPort,cFileName)	/* 1K-Xmodem-G */

         case nType == 7
            nReturnCode := SWRYMODGB(nPort,cFileName)	/* Ymodem-G Batch */

      endcase
   endif
   setcursor(nCursorType)
endif

keyboard ""
if nReturnCode != 1		/* Display return code from transfer */
   ErrorToneOut("Last Message -> "+SWErrToTxt(nReturnCode,0),3," Transfer Status ")
endif
DisplayBar(COMBAR)
RETURN(nReturnCode)



/*
**
** Function Name: HangUp() -> NIL
**
**
** Description:
**
**	Hang up the phone. (ATH0)
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION HangUp()
setcursor(0)
SWPutStr(nMaxRow,1,"DISCONNECTING ",nBarColor)
SWMEscape(nPort)
SWMHook(nPort,SWCSMOFF)
SWWait(SWSECOND)
DisplayBar(COMBAR)
setcursor(nCursorType)
RETURN(NIL)



/*
**
** Function Name: HotKeys(nRow,nCol) -> NIL
**
** 	nRow	= Top row for edit box.
**	nCol	= Top column for edit box.
**	
**
** Description:
**
**	Display a box on screen and edit keyboard macros. (Alt-M)
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION HotKeys(nRow,nCol)

LOCAL cKeyboardScreenm, nRowOffset, nColOffSet

nRowOffSet := 11
nColOffSet := 59

cKeyboardScreen := savescreen(nRow,nCol,nRow+17,nCol+nColOffSet)
Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Keyboard Macros ")
Box(nRow+13,nCol,nRow+17,nCol+nColOffSet," Information ")

@nRow+14,nCol+1 say "To add a Carriage Return <CR> to the Keyboard Macro"
@row()+1,nCol+1 say "insert a ^M, (carret and a uppercase M) with your macro."
@row()+1,nCol+1 say "Example: John Smith password^M"

select SWDeFalt

setcursor(nCursorType)

@nRow+1,nCol+1  say "Alt-0 " get fnAlt0
@row()+1,nCol+1 say "Alt-1 " get fnAlt1
@row()+1,nCol+1 say "Alt-2 " get fnAlt2
@row()+1,nCol+1 say "Alt-3 " get fnAlt3
@row()+1,nCol+1 say "Alt-4 " get fnAlt4
@row()+1,nCol+1 say "Alt-5 " get fnAlt5
@row()+1,nCol+1 say "Alt-6 " get fnAlt6
@row()+1,nCol+1 say "Alt-7 " get fnAlt7
@row()+1,nCol+1 say "Alt-8 " get fnAlt8
@row()+1,nCol+1 say "Alt-9 " get fnAlt9
read

setcursor(0)
restscreen(nRow,nCol,nRow+17,nCol+nColOffSet,cKeyboardScreen)

RETURN(NIL)



/*
**
** Function Name: MainMenu() -> nReturnCode
**
** 
** Description:
**
**	Display a box on screen with all program options.  Uses the prompt
**	command to choose option then returns the option chosen.
**
** Returns:
**
**	nReturnCode	= Option to execute.
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION MainMenu()

LOCAL nRow, nCol, nChoice, cMainMenuScreen, nRowOffSet, nColOffSet, nReturnCode

nRow 	    := 0
nCol 	    := 0
nRowOffSet  := 21
nColOffSet  := 45
nReturnCode := 0

cMainMenuScreen := savescreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet)

Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Main Menu ")

set message to nMaxRow

@nRow+1,nCol+1  prompt " Alt-X     Exit To Dos                      "  message { || MessageBlock("Exit SilverTalk III to Dos") }					// 1
@row()+1,nCol+1 prompt " Alt-C     Clear Screen                     "  message { || MessageBlock("Clear terminal screen") }						// 2
@row()+1,nCol+1 prompt " PgUp      Up-Load File                     "  message { || MessageBlock("Up-load a file via file transfer protocol") } 			// 3
@row()+1,nCol+1 prompt " PgDn      Down-Load File                   "  message { || MessageBlock("Down-load a file via file transfer protocol") }			// 4
@row()+1,nCol+1 prompt " Alt-P     Communications Parameters        "  message { || MessageBlock("Set program communications parameters") }				// 5 
@row()+1,nCol+1 prompt " Alt-D     Dialing Directory                "  message { || MessageBlock("Pop-up dialing directory") }						// 6
@row()+1,nCol+1 prompt " Alt-M     Keyboard Macros                  "  message { || MessageBlock("Define keyboard macros") }						// 7
@row()+1,nCol+1 prompt " Alt-S     System Setup Menu                "  message { || MessageBlock("System default and setup menu") }					// 8
@row()+1,nCol+1 prompt " Alt-H     Hang-Up                          "  message { || MessageBlock("Disconnect telephone") }						// 9
@row()+1,nCol+1 prompt " Alt-Y     Turn Auto Answer On              "  message { || MessageBlock("Turn auto-answer on") }						// 10
@row()+1,nCol+1 prompt " `         Set 25, 43 or 50 line mode       "  message { || MessageBlock("Configure screen settings for  25, 43 or 50 line terminal mode") }	// 11
@row()+1,nCol+1 prompt " Alt-Z     Help Screen (This Screen)        "  message { || MessageBlock("Main menu and help screen. (This screen)") }				// 12
@row()+1,nCol+1 prompt " Alt-R     Redial Last Phone Number         "  message { || MessageBlock("Re-dial last dialed phone number") }					// 13
@row()+1,nCol+1 prompt " Alt-B     Transmit Break Signal            "  message { || MessageBlock("Transmit a break signal") }						// 14
@row()+1,nCol+1 prompt " Alt-F10   Reset IRQs / Base IOs To Defaults"  message { || MessageBlock("Reset all COM IRQs and Base I/O addresses to defaults") }		// 15
@row()+1,nCol+1 prompt " Alt-F     File Directory                   "  message { || MessageBlock("File directory listing") }						// 16
@row()+1,nCol+1 prompt " Alt-F4    Dos Gateway  (EXIT To Return)    "  message { || MessageBlock("Shell to Dos. (type EXIT to return)") }				// 17
@row()+1,nCol+1 prompt " Alt-V     View A File                      "  message { || MessageBlock("View an ASCII file") }						// 18
@row()+1,nCol+1 prompt " Alt-E     Toggle Echo (On/Off)             "  message { || MessageBlock("Toggle terminal mode character echo (ON/OFF)") }			// 19
@row()+1,nCol+1 prompt " Alt-I     Program Information              "  message { || MessageBlock("SilverTalk III Program Information") }				// 20
menu to nChoice

set message to

DisplayBar(COMBAR)			/* Display COM settings */

do case
   case nChoice == 1
      nReturnCode := SW_ALT_X

   case nChoice == 2
      nReturnCode := SW_ALT_C

   case nChoice == 3
      nReturnCode := SW_PGUP

   case nChoice == 4
      nReturnCode := SW_PGDN

   case nChoice == 5
      nReturnCode := SW_ALT_P

   case nChoice == 6
      nReturnCode := SW_ALT_D

   case nChoice == 7
      nReturnCode := SW_ALT_M

   case nChoice == 8
      nReturnCode := SW_ALT_S

   case nChoice == 9
      nReturnCode := SW_ALT_H

   case nChoice == 10
      nReturnCode := SW_ALT_Y

   case nChoice == 11
      nReturnCode := SW_TILDY

   case nChoice == 13
      nReturnCode := SW_ALT_R

   case nChoice == 14
      nReturnCode := SW_ALT_B

   case nChoice == 15
      nReturnCode := SW_ALT_F10

   case nChoice == 16
      nReturnCode := SW_ALT_F

   case nChoice == 17
      nReturnCode := SW_ALT_F4

   case nChoice == 18
      nReturnCode := SW_ALT_V

   case nChoice == 19
      nReturnCode := SW_ALT_E

   case nChoice == 20
      nReturnCode := SW_ALT_I

endcase
restscreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,cMainMenuScreen)
RETURN(nReturnCode)




/*
**
** Function Name: MessageBlock(cString) -> ""
**
** 	cString		= String to display.
**	
**
**
** Description:
**
**	By pass the set message to command for the prompt command.
**	
**
** Returns:
**
**	""	= NULL message string
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION MessageBlock(cString)

SWPutStr(nMaxRow,0,padc(cString,80),nBarColor)
setcursor(0)

RETURN("")




/*
**
** Function Name: OpenScreen() -> NIL
**
**
** Description:
**
**	Display open screen information.
**
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION OpenScreen()

LOCAL nRow, nCol

setcursor(0)

nRow	:= 1
nCol	:= 2

@nRow,nCol say    "                                         "
@row()+1,nCol say "                                               "
@row()+1,nCol say "                                              "
@row()+1,nCol say "                                              "
@row()+1,nCol say "                   "
@row()+1,nCol say "                                   "
@row()+1,nCol say "                                "
@row()+1,nCol say "                                    "
@row()+1,nCol say "                          "

@row()+2,nCol say "                    "
@row()+1,nCol say "                              "
@row()+1,nCol say "                               "
@row()+1,nCol say "                              "
@row()+1,nCol say "                     "
@row()+1,nCol say "                           "
@row()+1,nCol say "                     "
@row()+1,nCol say "                          "
@row()+1,nCol say "                   "

nRow := 11
nCol := 57

@nRow,nCol say    " "
@row()+1,nCol say "           "
@Row()+1,nCol say "           "
@row()+1,nCol say "           "
@row()+1,nCol say "           "
@row()+1,nCol say "           "
@row()+1,nCol say "           "
@row()+1,nCol say "           "
@row()+1,nCol say " "

inkey(1)

Box(4,58,8,77,"")

@5,60 say "  A SilverWare"
@6,60 say "      (TM)"
@7,60 say "Terminal Program"

inkey(2)
SWClearScreen(0,0,nMaxRow,79,nTermColor)

@3,0  say padc("S I L V E R    T A L K   III",80)
@5,0  say padc("Version "+SWTALKIII,80)
@7,0  say padc("SilverClip Communications Library Demo",80)
@9,0  say padc("DISCLAIMER",80)

@11,7 say padr("SilverWare Inc. MAKES NO WARRANTIES, express or implied concerning",73)
@12,7 say padr("this software including, BUT NOT LIMITED TO, implied warranties of",73)
@13,7 say padr("MERCHANTABILITY and/or FITNESS for a particular purpose.  SilverWare",73)
@14,7 say padr("Inc. Will NOT BE LIABLE for any damages, CONTINGENT or CONSEQUENTIAL,",73)
@15,7 say padr("from the use of the product material presented by  SilverWare Inc..",73)
@16,7 say padr("REGISTERED USERS OF SilverClip. Feel free to use ANY or ALL source",73)
@17,7 say padr("code from this program for your own development purposes.  This",73)
@18,7 say padr("program is written in Clipper 5, utilizing The SilverClip Library.",73)
?
?
@row(),0  say padc("Press Any Key To Continue",80)
inkey(10)
SWClearScreen(0,0,nMaxRow,79,nTermColor)
setcursor(nCursorType)

RETURN(NIL)



/*
**
** Function Name: ParityToText(nParity) -> cParity
**
** 	nParity		= Numeric parity value.
**	
**
** Description:
**
**	Converts the numeric parity value to a text string for display
**	purposes.
**	
**
** Returns:
**
**	cParity		= Text parity value. (N,O,E,S,M)
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION ParityToText(nParity)

LOCAL cParity

do case
   case nParity == SWPARITYNONE
      cParity	:= "N"
   case nParity == SWPARITYODD
      cParity	:= "O"
   case nParity == SWPARITYEVEN
      cParity	:= "E"
   case nParity == SWPARITYSTICK
      cParity	:= "S"
   case nParity == SWPARITYMSTICK
      cParity	:= "M"
endcase

RETURN(cParity)



/*
**
** Function Name: ResetIRQBaseIO() -> NIL
**
**
** Description:
**
**	Reset all the base I/O addresses and IRQs to defaults.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION ResetIRQBaseIO(nRow,nCol)

LOCAL cYN, cBaseIOScreenm, nRowOffset, nColOffSet, nGetOffSet

ErrorTone()
cYN := YesOrNo("This Will Set All Standard COM1-COM8 Base IO Addresses And IRQs To Defaults")

if cYN == "Y"
   select SWDeFalt
   go top
   repl fnIRQ1 with IRQ4
   repl fnIRQ2 with IRQ3
   repl fnIRQ3 with IRQ5
   repl fnIRQ4 with IRQ7
   repl fnIRQ5 with IRQ5
   repl fnIRQ6 with IRQ7
   repl fnIRQ7 with IRQ5
   repl fnIRQ8 with IRQ7

   repl fnBaseIO1 with COM1BASEIO
   repl fnBaseIO2 with COM2BASEIO
   repl fnBaseIO3 with 1000
   repl fnBaseIO4 with 744
   repl fnBaseIO5 with 1000
   repl fnBaseIO6 with 744
   repl fnBaseIO7 with 1000
   repl fnBaseIO8 with 744
   SetComTable()


   select SWDeFalt

   nRowOffSet := 9
   nColOffSet := 43
   nGetOffSet := 25

   cBaseIOScreenm := savescreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet)
   Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," New IRQs and Base IO Addresses ")

   @nRow+1,nCol+1  	say "COM1 ->  IRQ " get fnIRQ1
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO1
   
   @row()+1,nCol+1 	say "COM2 ->  IRQ " get fnIRQ2
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO2

   @row()+1,nCol+1 	say "COM3 ->  IRQ " get fnIRQ3
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO3

   @row()+1,nCol+1 	say "COM4 ->  IRQ " get fnIRQ4
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO4

   @row()+1,nCol+1 	say "COM5 ->  IRQ " get fnIRQ5
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO5
   
   @row()+1,nCol+1 	say "COM6 ->  IRQ " get fnIRQ6
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO6

   @row()+1,nCol+1 	say "COM7 ->  IRQ " get fnIRQ7
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO7

   @row()+1,nCol+1 	say "COM8 ->  IRQ " get fnIRQ8
   @row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO8
   clear gets
   inkey(5)

   restscreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,cBaseIOScreenm)

endif
RETURN(NIL)



/*
**
** Function Name: SetComTable() -> NIL
**
**
** Description:
**
**	Set the internal COM port table for base I/O and IRQs defined in
**	SWDeFalt.dbf.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SetComTable()

FIELD fnBaseIO1, fnBaseIO2, fnBaseIO3, fnBaseIO4, fnBaseIO5, fnBaseIO6, fnBaseIO7, fnBaseIO8, fnIRQ1, fnIRQ2, fnIRQ3, fnIRQ4, fnIRQ5, fnIRQ6, fnIRQ7, fnIRQ8

select SWDeFalt
go top

/* Set Base IO Address */

SWSetComm(0,COM1,fnBaseIO1)
SWSetComm(0,COM2,fnBaseIO2)
SWSetComm(0,COM3,fnBaseIO3)
SWSetComm(0,COM4,fnBaseIO4)
SWSetComm(0,COM5,fnBaseIO5)
SWSetComm(0,COM6,fnBaseIO6)
SWSetComm(0,COM7,fnBaseIO7)
SWSetComm(0,COM8,fnBaseIO8)

/* Set IRQ */

SWSetComm(1,COM1,fnIRQ1)
SWSetComm(1,COM2,fnIRQ2)
SWSetComm(1,COM3,fnIRQ3)
SWSetComm(1,COM4,fnIRQ4)
SWSetComm(1,COM5,fnIRQ5)
SWSetComm(1,COM6,fnIRQ6)
SWSetComm(1,COM7,fnIRQ7)
SWSetComm(1,COM8,fnIRQ8)

RETURN(NIL)



/*
**
** Function Name: SetIRQBaseIO(nRow,nCol) -> NIL
**
**	nRow	= Top row for display box.
**	nCol	= Top column for display box.
**	
**
** Description:
**
**	Display a box on screen and allows editing of base I/O and IRQs in
**	the SWDeFalt.dbf.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SetIRQBaseIO(nRow,nCol)

LOCAL cBaseIOScreenm, nRowOffset, nColOffSet, nGetOffSet

select SWDeFalt

nRowOffSet := 9
nColOffSet := 43
nGetOffSet := 25

cBaseIOScreenm := savescreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet)
Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Set IRQs and Base IO Addresses ")

@nRow+1,nCol+1  	say "COM1 ->  IRQ " get fnIRQ1
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO1

@row()+1,nCol+1 	say "COM2 ->  IRQ " get fnIRQ2
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO2

@row()+1,nCol+1 	say "COM3 ->  IRQ " get fnIRQ3
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO3

@row()+1,nCol+1 	say "COM4 ->  IRQ " get fnIRQ4
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO4

@row()+1,nCol+1 	say "COM5 ->  IRQ " get fnIRQ5
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO5

@row()+1,nCol+1 	say "COM6 ->  IRQ " get fnIRQ6
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO6

@row()+1,nCol+1 	say "COM7 ->  IRQ " get fnIRQ7
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO7

@row()+1,nCol+1 	say "COM8 ->  IRQ " get fnIRQ8
@row(),nCol+nGetOffSet	say " Base IO "     get fnBaseIO8
read

restscreen(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,cBaseIOScreenm)
SetComTable()

RETURN(NIL)


/*
**
** Function Name: SetUpPort() -> NIL
**
**
** Description:
**
**	Initial COM port open and UART setup.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SetUpPort()

LOCAL nReturnCode

setcolor(cPromptColor)
setcursor(0)
SWPutStr(0,0,"Initializing",SWBitOr(nBarColor,SWBLINK))
setcolor(cText1Color)
select SWDeFalt
go top

nReturnCode := 1
nReturnCode := &cSWOpenCom

* SWOpenCom(nPort,RXQUEUE,TXQUEUE,0)

if nReturnCode != SWCSUCCESSFUL
   nPort := SWCNOUARTPRESENT
   if SWUARTPres(COM4BASEIO)
      replace fnBaseIO4 with 744
      SWSetComm(0,COM4,744)
      nPort := COM4
   endif

   if SWUARTPres(COM3BASEIO)
      replace fnBaseIO3 with 1000
      SWSetComm(0,COM3,1000)
      nPort := COM3
   endif

   if SWUARTPres(COM2BASEIO)
      replace fnBaseIO2 with COM2BASEIO
      SWSetComm(0,COM2,COM2BASEIO)
      nPort := COM2
   endif

   if SWUARTPres(COM1BASEIO)
      replace fnBaseIO1 with COM1BASEIO
      SWSetComm(0,COM1,COM1BASEIO)
      nPort := COM1
   endif

   if nPort == SWCNOUARTPRESENT
      SWClearScreen(0,0,nMaxRow,79,nTermColor)
      ErrorToneOut("No COM Ports Detected On This Machine..",3," Error ")
      QUIT 	
   else
      nReturnCode := &cSWOpenCom

*      SWOpenCom(nPort,RXQUEUE,TXQUEUE,0)

      nBaud   := 2400
      nParity := SWPARITYNONE
      nWord   := 8
      nStop   := 1
      select SWDeFalt
      go top
      replace fnPort		with nPort
      replace fnBaud		with 2400
      replace fnParity		with SWPARITYNONE
      replace fnWord		with 8
      replace fnStop		with 1
      SWSetUART(nPort,nBaud,nParity,nWord,nStop)
      DisplayBar(COMBAR)

      if !empty(fcModem)
         SWMTXCmd(nPort,trim(fcModem))	/* Send Modem Setup String */
      endif

      lnPortActive := SWTRUE
   endif
else
   lnPortActive := SWTRUE
   SWSetUART(nPort,nBaud,nParity,nWord,nStop)

   select SWDeFalt 
   go top
   if !empty(fcModem)
      SWMTXCmd(nPort,trim(fcModem))	/* Send Modem Setup String */
   endif   

endif
@0,0 say space(14)

setcursor(nCursorType)

RETURN(NIL)




/*
**
** Function Name: SplitPath(cString) -> nReturnCode
**
** 	cString		= File spec. <Path>
**
**
** Description:
**
**	Get the end character position of a file spec string.
**	
**
** Returns:
**
**	nReturnCode	= Character position.
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SplitPath(cString)

LOCAL nLencString, nLoop, nReturnCode

nReturnCode := 0
cString     := alltrim(cString)
nLencString := len(cString)

for nLoop := nLencString to 1 step -1
    if substr(cString,nLoop,1) == "\" .or. substr(cString,nLoop,1) == ":"
       nReturnCode := nLoop
       exit
    endif
next

RETURN(nReturnCode)




/*
**
** Function Name: SWClearScreen(nRow1,nCol1,nRow2,nCol2,nAttrib)
**
**	nRow1		= Top row for clear screen.
**	nCol1		= Top column for clear screen.
**	nRow2		= Bottom row for clear screen.
**	nCol2		= Bottom column for clear screen.
**	nAttrib		= Attribute for clear screen.
**
**
** Description:
**
**	Works same as @...clear, except this will work with EGA 43 and VGA 50
**	line modes.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SWClearScreen(nRow1,nCol1,nRow2,nCol2,nAttrib)

LOCAL nLoop

setcursor(0)
for nLoop := nRow1 to nRow2
   SWPutStr(nLoop,nCol1,space(nCol2-nCol1+1),nAttrib)
next
setcursor(nCursorType)
RETURN(NIL)



/*
**
** Function Name: SWDialDir(nTBTopRow,nTBTopCol) -> NIL
**
** 	nTBTopRow	= Top row for dialing directory.
**	nTBTopCol	= Top column for dialing directory.
**	
**
** Description:
**
**	This function uses a TBrowse obj class to create a dialing directory.
**	The dir supports del, edit, dialing and movement.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SWDialDir(nTBTopRow,nTBTopCol)

LOCAL objTBDialDir, objTBColumn, nKey, lTagField, cTagCharacter, nOption, nLoop, nCol, nTBBotRow, nTBBotCol, nOffSet, cDialScreen, cManualPhone, cYN

lTagField 	:= SWFALSE
cTagCharacter 	:= chr(16)
nOffSet		:= 13
nTBBotRow	:= nTBTopRow+nOffset+8
nTBBotCol	:= nTBTopCol+79

select SWDial

cDialScreen := savescreen(nTBTopRow,nTBTopCol,nTBBotRow,nTBBotCol)

setcolor(cText1Color)

Box(nTBTopRow,nTBTopCol,nTBBotRow,nTBBotCol," Dialing Directory ")

@nTBTopRow+2,nTBTopCol  say ""
@nTBTopRow+2,nTBBotCol  say ""
@nTBTopRow+nOffset,nTBTopCol say ""
@nTBTopRow+nOffset,nTBBotCol say ""
@nTBBotRow-2,nTBTopCol	 say ""
@nTBBotRow-2,nTBBotCol	 say ""
@nTBBotRow-2,nTBTopCol+1 say replicate(cDoubleBar,78)

@nTBTopRow+nOffset+1,3 say "     Scroll Up                   Select Entry                     Revise  "
@row()+1,3 say             "     Scroll Dn                     Tag Entry                  Revise Cell "
@row()+1,3 say             "     First Page                Manual Dial                    Erase Entry "
@row()+1,3 say             "    Last Page                  Dial Tagged Entry(s)           Clear Taged "
@row()+1,3 say             "    Exit                          Dial Selected               Attach Macro"

setcolor(cText2Color)

@nTBTopRow+nOffset+1,3  say "PgUp"
@nTBTopRow+nOffset+1,32 say "/"
@nTBTopRow+nOffset+1,63 say "Alt-R"

@row()+1,3 say              "PgDn"
@row(),32  say              "Space"
@row(),63  say              "R"

@row()+1,3 say              "Home"
@row(),32  say              "M"
@row(),63  say              "E"

@row()+1,3 say              "End"
@row(),32  say              "D"
@row(),63  say              "C"

@row()+1,3 say              "Esc"
@row(),32  say              "<CR>"
@row(),63  say              "S"

setcolor(cText1Color)

objTBDialDir := TBrowseDB(nTBTopRow+1,nTBTopCol+1,nTBTopRow+nOffSet,nTBBotCol-1)

objTBDialDir:colSep	:= "  "

objTBDialDir:headSep	:= ""

objTBDialDir:footSep	:= ""

objTBDialDir:colorSpec	:= cTBColor

objTBColumn := TBColumnNew( "Tag", {|| padl(fcTag,3)} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "#", {|| str(recno(),3,0)} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "Name", {|| fcName} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "Phone", {|| fcPhone} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "Baud", {|| fnBaud} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "P", {|| ParityToText(fnParity)} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "W", {|| fnWord} )
objTBDialDir:addColumn( objTBColumn )

objTBColumn := TBColumnNew( "S", {|| fnStop} )
objTBDialDir:addColumn( objTBColumn )

do while SWTRUE

   setcursor(0)	

   if objTBDialDir:colPos == 1
      objTBDialDir:right()
   endif

   nKey := SWStabilize(objTBDialDir)

   if objTBDialDir:stable
      nKey := inkey(0)
   endif

   do case
      case nKey == K_DOWN
         objTBDialDir:down()

      case nKey == K_UP
      	 objTBDialDir:up()

      case nKey == K_PGDN
         objTBDialDir:pageDown()

      case nKey == K_PGUP
         objTBDialDir:pageUp()

      case nKey == K_RIGHT
         objTBDialDir:right()

      case nKey == K_LEFT
         objTBDialDir:left()

      case nKey == K_HOME
         objTBDialDir:goTop()

      case nKey == K_END
         objTBDialDir:goBottom()

      case nKey == K_CTRL_LEFT
         objTBDialDir:panLeft()

      case nKey == K_CTRL_RIGHT
         objTBDialDir:panRight()

      case nKey == K_CTRL_HOME
         objTBDialDir:panHome()

      case nKey == K_CTRL_END
         objTBDialDir:panEnd()

      case upper(chr(nKey)) == "D"		/* Dial Entry */
         nBaud   = fnBaud
	 nParity = fnParity
	 nWord	 = fnWord
	 nStop	 = fnStop
      	 nCallCount := 0
	 objTBDialDir:colPos := 3
         objTBDialDir:refreshCurrent()
         nHolder := AutoDial(nTBBotRow-7,nTBTopCol+1,fcName,fcPhone,SWFALSE,SWFALSE,"D")
	 cLastPhone := trim(fcPhone)
	 cLastName  := trim(fcName)
	 if nHolder == 1
	    exit

         endif

      case upper(chr(nKey)) == "M"		/* Manual Dial */
         setcursor(nCursorType)
      	 cManualPhone := space(54)
         @nTBBotRow-1,nTBTopCol+2 say "Enter Phone Number -> " get cManualPhone
	 read
 	 @nTBBotRow-1,nTBTopCol+2 say space(77)
	 if !empty(trim(cManualPhone))
	    cLastPhone := trim(cManualPhone)
	    cLastName  := "Manual Dial"
	    nCallCount := 0
	    nHolder = AutoDial(14,1,cLastName,cLastPhone,SWFALSE,SWFALSE,"M")
	    if nHolder == 1
	       exit

	    endif

	 endif

      case upper(chr(nKey)) == "C"		/* Clear All Marked */
         replace all fcTag with space(1)
	 objTBDialDir:goTop()

      case upper(chr(nKey)) == "E"		/* Delete Record */
         setcursor(nCursorType)
         cYN := "N"
         @nTBBotRow-1,nTBTopCol+2 say "Are You Sure You Want To Delete (Y/N) " get cYN pict"!" valid(cYN$"YN")
	 read
	 if cYN == "Y"
     	    replace fcTag	with space(1)
	    replace fnBaud	with 2400
	    replace fnParity	with SWPARITYNONE
	    replace fnWord	with 8
	    replace fnStop	with 1
	    replace fcName	with replicate(".",len(fcName))
	    replace fcPhone	with replicate(".",len(fcPhone))
	    replace fcMacros	with space(10)
	    objTBDialDir:refreshCurrent()
	 endif
	 @nTBBotRow-1,nTBTopCol+2 say space(77)

      case nKey == 32				/* Space Bar */
   	 replace fcTag with iif(fcTag==space(1),cTagCharacter,space(1))
	 objTBDialDir:refreshCurrent()
	 SWStabilize(objTBDialDir)
	 objTBDialDir:down()

      case nKey == K_RETURN		/* Dial Tagged Entries */
         nCallCount  := 0
	 objTBDialDir:colPos := 3
         if TagDialer(nTBBotRow-7,nTBTopCol+1,objTBDialDir) == 1
	    exit
	 endif
      	
      case upper(chr(nKey)) == "R"

         setcursor(nCursorType)
      	 
         do case
	    case objTBDialDir:colPos == 3	/* Edit Name */
	       if fcName==replicate(".",len(fcName))
	          replace fcName with space(len(fcName))
	       endif
	       @row(),col() get fcName
	       read

	    case objTBDialDir:colPos == 4	/* Edit Phone */
	       if fcPhone==replicate(".",len(fcPhone))
	          replace fcPhone with space(len(fcPhone))
	       endif
	       @row(),col() get fcPhone
	       read

	    case objTBDialDir:colPos == 5	/* Edit Baud Rate */
	       nOption := ascan(acBaudOption,padl(alltrim(str(fnBaud,6,0)),6))
	       nCol := col()
	       for nLoop := 1 to 18
	          @row(),nCol prompt acBaudOption[nLoop]
	       next
	       menu to nOption
	       if nOption != 0
	          replace fnBaud with val(alltrim(acBaudOption[nOption]))
	       endif

	    case objTBDialDir:colPos == 6	/* Edit Parity */
	       nOption := ascan(anParity,fnParity)
	       nCol := col()
	       for nLoop := 1 to 5
	          @row(),nCol prompt substr(acParityOption[nLoop],1,1)
	       next
	       menu to nOption
	       if nOption != 0
	          replace fnParity with anParity[nOption]
	       endif

	    case objTBDialDir:colPos == 7	/* Edit Word Length */
	       nOption := ascan(acWordOption,str(fnWord,1,0))
	       nCol := col()
	       for nLoop := 1 to 3
	          @row(),nCol prompt acWordOption[nLoop]
	       next
	       menu to nOption
	       if nOption != 0
	          replace fnWord with val(acWordOption[nOption])
	       endif

	    case objTBDialDir:colPos == 8	/* Edit Stop Bits */
	       nOption := fnStop
	       nCol := col()
	       for nLoop := 1 to 2
	          @row(),nCol prompt acStopBitsOption[nLoop]
	       next
	       menu to nOption
	       if nOption != 0
	          replace fnStop with nOption
	       endif

	 endcase
	 objTBDialDir:refreshCurrent()

      case nKey == K_ALT_R		/* Alt-R */
         objTBDialDir:panHome()
         objTBDialDir:right()
         objTBDialDir:right()
	 SWStabilize(objTBDialDir)

      	 /* Edit Name */
         setcursor(nCursorType)
         if fcName==replicate(".",len(fcName))
	    replace fcName with space(len(fcName))
	 endif
	 @row(),col() get fcName
	 read
	 objTBDialDir:refreshCurrent()
	 objTBDialDir:right()
	 SWStabilize(objTBDialDir)

 	 /* Edit Phone */
         setcursor(nCursorType)
         if fcPhone==replicate(".",len(fcPhone))
            replace fcPhone with space(len(fcPhone))
	 endif
	 @row(),col() get fcPhone
	 read
	 objTBDialDir:refreshCurrent()
	 objTBDialDir:right()
	 SWStabilize(objTBDialDir)

	 /* Edit Baud Rate */
         nOption := ascan(acBaudOption,padl(alltrim(str(fnBaud,6,0)),6))
	 nCol := col()
	 for nLoop := 1 to 18
	    @row(),nCol prompt acBaudOption[nLoop]
	 next
	 menu to nOption
	 if nOption != 0
	    replace fnBaud with val(alltrim(acBaudOption[nOption]))
	 endif
	 objTBDialDir:refreshCurrent()
	 objTBDialDir:right()
	 SWStabilize(objTBDialDir)

	 /* Edit Parity */
	 nOption := ascan(anParity,fnParity)
	 nCol := col()
	 for nLoop := 1 to 5
	    @row(),nCol prompt substr(acParityOption[nLoop],1,1)
	 next
	 menu to nOption
	 if nOption != 0
	    replace fnParity with anParity[nOption]
	 endif
	 objTBDialDir:refreshCurrent()
	 objTBDialDir:right()
	 SWStabilize(objTBDialDir)

	 /* Edit Word Length */
	 nOption := ascan(acWordOption,str(fnWord,1,0))
	 nCol := col()
	 for nLoop := 1 to 3
	    @row(),nCol prompt acWordOption[nLoop]
	 next
	 menu to nOption
	 if nOption != 0
	    replace fnWord with val(acWordOption[nOption])
	 endif
	 objTBDialDir:refreshCurrent()
	 objTBDialDir:right()
	 SWStabilize(objTBDialDir)

	 /* Edit Stop Bits */
	 nOption := fnStop
	 nCol := col()
	 for nLoop := 1 to 2
	    @row(),nCol prompt acStopBitsOption[nLoop]
	 next
	 menu to nOption
	 if nOption != 0
	    replace fnStop with nOption
	 endif
	 objTBDialDir:refreshCurrent()
	 objTBDialDir:home()

      case upper(chr(nKey)) == "S"
         replace fcMacros with AttachMacros()

      case nKey == K_ESC
	 exit

   endcase


enddo
restscreen(nTBTopRow,nTBTopCol,nTBBotRow,nTBBotCol,cDialScreen)

RETURN(NIL)




/*
**
** Function Name: SWFileDir() -> NIL
**
**
** Description:
**
**	Get file specs for dir, and total files to be allocated in the adir()
**	function.  SWFileDir() calls DisplayAdir() to display file information
**	in a achoice() box.
**
**		Note:  This function is assigned to the Alt-F key with the
**		       set key <> to command and it is an exit key from the
**		       terminal modes.  It is always active!
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SWFileDir()

LOCAL nTotalFiles, nRow1,nCol1,nRow2, nCol2, cFileSpec, cFileDirScreen
LOCAL GetList := {}

nRow1   := 4
nCol1   := 2
nRow2   := nRow1 + 2
nCol2   := nCol1 + 67

cFileDirScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
cFileSpec := space(40)

Box(nRow1,nCol1,nRow2,nCol2," Enter File Specs or <CR> for *.* ")
@nRow1+1,nCol1+1 say "Please Enter File Spec : " get cFileSpec
read


if lastkey() != K_ESC
   if cFileSpec == space(40)
      cFileSpec := "*.*"
   else
      cFileSpec := trim(cFileSpec)
   endif

   nTotalFiles := adir(cFileSpec)

endif

restscreen(nRow1,nCol1,nRow2,nCol2,cFileDirScreen)

if lastkey() != K_ESC
   if nTotalFiles != 0
      DisplayAdir(8,20,nTotalFiles,cFileSpec)
   else
      ErrorToneOut("No Files Found For File Specification Entered",3," Error ")

   endif

endif

setcursor(nCursorType)

RETURN(NIL)




/*
**
** Function Name: SWFlowControl(nRow1,nCol1) -> NIL
**
** 	nRow1	= Row for flow control menu box.
**	nCol1	= Column for flow control menu box.
**	
**
**
** Description:
**
**	Display a box on screen with the options to set various flow controls.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SWFlowControl(nRow1,nCol1)

LOCAL nRow2, nCol2, nChoice, cFlowScreen

nRow2   := nRow1 + 5
nCol2   := nCol1 + 41
nChoice := 1

cFlowScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2," Flow Control Menu ")
setcursor(0)

do while .t.
   setcolor(cPromptColor)
   @nRow1+1,nCol1+38 say iif(lXONXOFFlowControl,"On ","Off")
   @Row()+1,nCol1+38 say iif(lRTSCTSFlowControl,"On ","Off")
   @Row()+1,nCol1+38 say iif(lDTRDSRFlowControl,"On ","Off")
   @Row()+1,nCol1+38 say iif(lCDFlowControl,"On ","Off")

   setcolor(cText1Color)
   @nRow1+1,nCol1+1 prompt "XON / XOFF Software Flow Control    "
   @Row()+1,nCol1+1 prompt "RTS / CTS HardWare Flow Control     "
   @Row()+1,nCol1+1 prompt "DTR / DSR HardWare Flow Control     "
   @Row()+1,nCol1+1 prompt "Carrier Detect HardWare Flow Control"
   menu to nChoice

   do case
      case nChoice == 1
         lXONXOFFlowControl := iif(lXONXOFFlowControl,SWFALSE,SWTRUE)
	 SWSXOnOffF(nPort,lXONXOFFlowControl)

      case nChoice == 2
         lRTSCTSFlowControl := iif(lRTSCTSFlowControl,SWFALSE,SWTRUE)
	 SWSRTSCTSF(nPort,lRTSCTSFlowControl)

      case nChoice == 3
         lDTRDSRFlowControl := iif(lDTRDSRFlowControl,SWFALSE,SWTRUE)
	 SWSDTRDSRF(nPort,lDTRDSRFlowControl)

      case nChoice == 4
         lCDFlowControl := iif(lCDFlowControl,SWFALSE,SWTRUE)
	 ?"lCDFlowControl ->",lCDFlowControl
	 wait
	 SWSCDFlo(nPort,lCDFlowControl)

      case nChoice == 0
         exit

   endcase

enddo

restscreen(nRow1,nCol1,nRow2,nCol2,cFlowScreen)

RETURN(NIL)




/*
**
** Function Name: SWStabilize(objTBParm) -> NIL
**
**	objTBParm	= Object to stabilize.
**	
**
** Description:
**
**	Stabilize an object.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SWStabilize(objTBParm)

LOCAL nKey

nKey := 0

do while !objTBParm:stabilize()
   nKey := InKey()
   if nKey != 0
      exit		 /* Abort if a key is waiting */
   endif
enddo

setcursor(0)

RETURN(nKey)




/*
**
** Function Name: SWTransStatus(nRow1, nCol1) -> NIL
**
** 	nRow1		= Upper row for box.
**	nCol1		= Upper column for box.
**	
**
**
** Description:
**
**	Display a box on screen with prompt command to set a file
**	transfer status type.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SWTransStatus(nRow1, nCol1)

LOCAL nRow2, nCol2, nChoice, cTransStatusScreen

nRow2   := nRow1 + 4
nCol2   := nCol1 + 27
nChoice := 1

cTransStatusScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2," Transfer Status ")
setcursor(0)

@nRow1+1,nCol1+1 prompt "Box Status Display        "
@Row()+1,nCol1+1 prompt "Line Status Display       "
@Row()+1,nCol1+1 prompt "No Status Display (On/Off)"
menu to nChoice

do case
   case nChoice == 1
      nTransStatusType := 1

   case nChoice == 2
      nTransStatusType := 2

   case nChoice == 3
      nTransStatusType := 3

endcase

restscreen(nRow1,nCol1,nRow2,nCol2,cTransStatusScreen)

RETURN(NIL)




/*
**
** Function Name: SystemDefaults(nRow1,nCol1) -> NIL
**
** 	nRow1		= Upper row for box.
**	nCol1		= Upper column for box.
**	
**
**
** Description:
**
**	Display a box on screen with prompt command to set a system default.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION SystemDefaults(nRow1,nCol1)

LOCAL nRow2, nCol2, nChoice

nRow2   := nRow1 + 5
nCol2   := nCol1 + 26
nChoice := 1

Box(nRow1,nCol1,nRow2,nCol2," System Menu ")

do while SWTRUE
   @nRow1+1,nCol1+1 prompt "Port IRQ & BASE I/O Setup"
   @Row()+1,nCol1+1 prompt "Set Flow Control Type    "
   @Row()+1,nCol1+1 prompt "Modify Modem Setup String"
   @Row()+1,nCol1+1 prompt "Transfer Display Type    "
   menu to nChoice

   do case
      case nChoice == 1
         if anComBoardOption[nBoard] == STANDARD
            SetIRQBaseIO(10,5)
	 else
	    ErrorToneOut("This Option Only Available On Stanadard COM1-COM8 Adapters",3," Error ")
	 endif

      case nChoice == 2
         SWFlowControl(14,9)

      case nChoice == 3
         EditModem()

      case nChoice == 4
         SWTransStatus(12,40)

      case nChoice == 0
         exit

   endcase

enddo
RETURN(NIL)



  
/*
**
** Function Name: TagDialer(nRow,nCol,objTBDNum) -> nReturnCode
**
**	nRow		= Starting row of dialer
**	nCol		= Starting column of dialer
**	objTBDNum	= Object for tBrowse class
**
**
** Description:
**
**	Dials tagged numbers from dialing directory.
**	This function will call the AutoDial() function which will display
**	call progress.
**	
**
** Returns:
**
**	nReturnCode		= Status of last dial
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION TagDialer(nRow,nCol,objTBDNum)

LOCAL nReturnCode, nDialPass

nDialPass   := 0
nReturnCode := 0

objTBDNum:goTop()
SWStabilize(objTBDNum)

do while SWTRUE

   if objTBDNum:hitBottom
      objTBDNum:goTop()
      SWStabilize(objTBDNum)
      if nDialPass == 0
         setcursor(0)
         @nRow+6,nCol+1 say "No Tagged Entries Found" 
	 ErrorTone()
	 inkey(2)
         @nRow+6,nCol+1 say space(70)
         setcursor(nCursorType)
         exit

      else
         nDialPass := 0

      endif

   endif

   if fcTag != " "
      ++nDialPass
      cLastPhone  := trim(fcPhone)
      cLastName   := trim(fcName)
      nBaud        = fnBaud
      nParity      = fnParity
      nWord        = fnWord
      nStop        = fnStop
      nReturnCode := AutoDial(nRow,nCol,fcName,fcPhone,SWFALSE,SWTRUE,"T")
      do case
         case nReturnCode == K_ESC
	    exit

         case nReturnCode == 1
	    exit

      endcase

   endif

   objTBDNum:refreshCurrent()
   objTBDNum:down()

   if SWStabilize(objTBDNum) == K_ESC
      nReturnCode := 1
      exit

   endif	

enddo

RETURN(nReturnCode)



/*
**
** Function Name: TermToText(nTerm) -> cTerm
**
** 	nTerm		= Numeric terminal value.
**	
**
** Description:
**
**	Converts the numeric terminal value to a text string for display
**	purposes.
**	
**
** Returns:
**
**	cTerm		= Text terminal value. (ANSII, TTY, VT-100, VT-52)
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION TermToText(nTerm)

LOCAL cTerm

do case
   case nTerm == 1
      cTerm	:= "TTY   "
   case nTerm == 2
      cTerm	:= "ANSI  "
   case nTerm == 3
      cTerm	:= "VT-100"
   case nTerm == 4
      cTerm	:= "VT-52 "
endcase

RETURN(cTerm)



/*
**
** Function Name: TransferOpts(nRow,nCol) -> nTransOption
**
** 	nRow	= Top row for display box.
**	nCol	= Top column for display box.
**
**
** Description:
**
**	Display a box on screen with file transfer options.  It uses the
**	prompt command to choose a file transfer protocol to use. 
**
**
** Returns:
**
**	nTransOption	= File transfer type chosen.
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION TransferOpts(nRow,nCol)

LOCAL nTransOption, cTransScreen, nRowOffset, nColOffset

nRowOffset   := 8
nColOffset   := 15
nTransOption := 1
cTransScreen := savescreen(nRow,nCol,nRow+nRowOffset,nCol+nColOffset)

Box(nRow,nCol,nRow+nRowOffset,nCol+nColOffset," Protocols ")

@nRow+1,nCol+1  prompt "XMODEM        "
@Row()+1,nCol+1 prompt "YMODEM        "
@Row()+1,nCol+1 prompt "YMODEM Batch  "
@Row()+1,nCol+1 prompt "ASCII         "
@Row()+1,nCol+1 prompt "1K-XMODEM     "
@Row()+1,nCol+1 prompt "1K-XMODEM-G   "
@Row()+1,nCol+1 prompt "YMODEM-G Batch"
menu to nTransOption

restscreen(nRow,nCol,nRow+nRowOffset,nCol+nColOffset,cTransScreen)

RETURN(nTransOption)




/*
**
** Function Name: VersionDisplay(nRow1,nCol1) -> cYN
**
** 	nRow		= Row to start file entry box.
**	nCol		= Column to start file entry box.
**	
**
**
** Description:
**
**	Display a box on screen with program information.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION VersionDisplay(nRow1,nCol1)
LOCAL nRow2, nCol2, cVerScreen, cRev

nRow2   := nRow1 + 5
nCol2   := nCol1 + 57

cVerScreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2," Program Information ")
cRev := alltrim(str(SWAsyncRev(),2,0))
@nRow1+1,nCol1+1 say os()
@row()+1,nCol1+1 say version()
@row()+1,nCol1+1 say "SilverTalk III "+SWTALKIII
@row()+1,nCol1+1 say SWAsyncVer(1)

setcursor(0)
inkey(0)
restscreen(nRow1,nCol1,nRow2,nCol2,cVerScreen)

RETURN(NIL)




/*
**
** Function Name: VideoMode(nRow,nCol,cTermScreen) -> NIL
**
** 	nRow		= Row to start file entry box.
**	nCol		= Column to start file entry box.
**	@cTermScreen	= Previously saved terminal screen.
**
**
** Description:
**
**	Display a box on screen and get video mode selection.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION VideoMode(nRow,nCol,nTermRow)

LOCAL lCga, lEga, lVga, nMaxVideo, nChoice, nOldMaxRow

lCga       := SWTRUE
lEga       := SWFALSE
lVga       := SWFALSE
nMaxVideo  := 4
nChoice    := 1
nOldMaxRow := nMaxRow

nMaxVideo := SWIsEGAVGA()

if nMaxVideo == 1
   lEga := SWTRUE
endif

if nMaxVideo == 2
   lEga := SWTRUE
   lVga := SWTRUE
endif

Box(nRow,nCol,nRow+4,nCol+10," Video ")
@nRow+1,  nCol+1 prompt "CGA 80x25"
@row()+1, nCol+1 prompt "EGA 80x43"
@row()+1, nCol+1 prompt "VGA 80x50"
menu to nChoice

do case
   case nChoice == 1
      if lCga
         SWSetVideo(3)
	 SWSetFont(2)		/* Set CGA 8x16 font */
         nMaxRow := 24
	 SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
	 nTermRow := iif(nTermRow > 23,23,nTermRow)
	 DisplayBar(COMBAR)
	 nCursorType := 1
      else
         ErrorToneOut("CGA Video Mode Is Not Support On This Adapter",3," Error ")
      endif	 

   case nChoice == 2
      if lEga
         SWSetVideo(3)
	 SWSetFont(0)		/* Set EGA 8x8 font */
         nMaxRow := 42
	 SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
	 nTermRow := iif(nTermRow > 41,41,nTermRow)
	 DisplayBar(COMBAR)
	 nCursorType := 3
      else
         ErrorToneOut("EGA Video Mode Is Not Support On This Adapter",3," Error ")
      endif

   case nChoice == 3
      if lVga
         SWSetVideo(3)
	 SWSetFont(0)		/* Set VGA 8x8 font */
         nMaxRow := 49
	 SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
	 DisplayBar(COMBAR)
	 nCursorType := 3
      else
         ErrorToneOut("VGA Video Mode Is Not Support On This Adapter",3," Error ")
      endif
endcase

select SWDeFalt
go 1
replace fnMaxRow with nMaxRow

SWSetTerm(3,nMaxRow-1)		/* Set max row for terminal emulation */
setcursor(nCursorType)

RETURN(NIL)



/*
**
** Function Name: ViewFile(nRow,nCol) -> cYN
**
** 	nRow		= Row to start file entry box.
**	nCol		= Column to start file entry box.
**	
**
**
** Description:
**
**	Display a box on screen and ask for file name if needed.
**	Memoread() and memoedit() the file entered.
**	
**
** Returns:
**
**	NIL
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION ViewFile(nRow,nCol)

LOCAL nRowOffSet, nColOffSet, nHandle, nFileSize

nRowOffSet    := 3
nColOffSet    := 67
cFileName     := space(FILELEN)
nFileSize     := 0
nHandle	      := -1

Box(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," View File ")
setcolor(cText2Color)
@nRow+nRowOffSet,nCol+nColOffSet-18 say " Alt-F Directory "
setcolor(cText1Color)
@nRow+1,nCol+1 say "Enter File Name : " get cFileName
read

do while SWTRUE
   if cFileName == space(FILELEN)
      exit
   else
      if file(cFileName)
         nHandle := fopen(cFileName,0)
	 if nHandle != -1
	    nFileSize := fseek(nHandle,0,2)	&& Get file size in bytes
            fclose(nHandle)
	 endif
	 if nFileSize > (memory(0) * 1024) .or. nFileSize > 64000
            ErrorToneOut(cFileName+" Is To Large To Fit In Memory",3," Error ")
	 else
            Box(0,0,23,79," "+alltrim(cFileName)+" ")
            DisplayBar(VIEWBAR)
	    memoedit(memoread(cFileName),1,1,22,78,SWFALSE)
	 endif
	 exit
      else
         ErrorToneOut(cFileName+" Not Found",3," Error ")
	 loop
      endif
   endif
enddo
RETURN(NIL)



/*
**
** Function Name: YesOrN(cString) -> cYN
**
** 	cString		= Question string for yes or no answer. 
**	
**
**
** Description:
**
**	Display a box on screen with a question.  The user is prompted
**	for a (Y/N) response to the question.
**	
**
** Returns:
**
**	cYN	= (Y/N) response to the question.
**  
**
** Author:
**  #001   Tue 26-Feb-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
*/

FUNCTION YesOrNo(cString)

LOCAL cYN, cYNSreen, nRow1, nRow2, nCol1, nCol2

cYN   := "N"
nRow1 := 10
nCol1 := 0
nRow2 := 13
nCol2 := 79

cYNSreen := savescreen(nRow1,nCol1,nRow2,nCol2)
Box(nRow1,nCol1,nRow2,nCol2,"")

@nRow1+1,nCol1+2  say padc(cString,77)
@nRow1+2,nCol1+30 say "Are You Sure? (Y/N)" get cYN pict"!" valid(cYN$"YN")
read

restscreen(nRow1,nCol1,nRow2,nCol2,cYNSreen)

RETURN(cYN)




*** EOF ***


