/********************************************************
 STRHEX.CPP
 Hopefully fixes CT3's StrToHex and HexToStr Functions
 A.C. Silvestri
 January 6, 1995

 Compile With MSC 8.0:
 cl /c /AL /FPa /Gs /Gh /Oalti /Zl /W4 /WX strhex.cpp

 Notes:
 1) Both Functions return NIL if a problem occurs.
 2) Protected Mode Compatible
 ********************************************************/

extern "C" {
  #include <extend.api>
  #include <vm.api>
}

/********************************************************/

extern "C" CLIPPER StrToHex(void) {
  // Check for First Character Parameter
  if (_parinfo(0) == 0 || _parinfo(1) != CHARACTER) {
    _ret();
    return;
    } 

  // Get Input String and its Length
  BYTEP str = (unsigned char *)_parc(1);
  int strlen = _parclen(1);

  // Allocate VM Memory For Hex String
  int hexlen = 2 * strlen;
  HANDLE hhexstr = _xvalloc((USHORT)hexlen, 0);
  if (hhexstr == 0) {
    _ret();
    return;
    }
  BYTEP phexstr = (BYTEP)_xvlock(hhexstr);
  if (phexstr == NULL) {
    _xvfree(hhexstr);
    _ret();
    return;
    }

  // Make Hexadecimal String
  for (int i = 0, j = 0; i < strlen; i++) {
    BYTE ch = str[i];
    int nibble = ch >> 4;
    if (nibble >= 0 && nibble <= 9)
      phexstr[j++] = (BYTE)('0' + nibble);
    else
      phexstr[j++] = (BYTE)('A' + nibble - 10);
    nibble = ch & 0x0F;
    if (nibble >= 0 && nibble <= 9)
      phexstr[j++] = (BYTE)('0' + nibble);
    else
      phexstr[j++] = (BYTE)('A' + nibble - 10);
    }

  // While VM Segment still locked, return Hexadecimal String to Clipper
  _retclen((char *)phexstr, hexlen);

  // Unlock and Deallocation VM Segment
  _xvunlock(hhexstr);
  _xvfree(hhexstr);
}


/********************************************************/

extern "C" CLIPPER HexToStr(void) {
  // Check for First Character Parameter
  if (_parinfo(0) == 0 || _parinfo(1) != CHARACTER) {
    _ret();
    return;
    } 

  // Get Input Hexadecimal String and its Length
  BYTEP hexstr = (unsigned char *)_parc(1);
  int hexlen = _parclen(1);

  // Input Hex String must have even number of characters
  if (hexlen & 0x01) {
    _ret();
    return;
    }

  // Allocate VM Memory For String
  int strlen = hexlen / 2;
  HANDLE hstr = _xvalloc((USHORT)strlen, 0);
  if (hstr == 0) {
    _ret();
    return;
    }
  BYTEP pstr = (BYTEP)_xvlock(hstr);
  if (pstr == NULL) {
    _xvfree(hstr);
    _ret();
    return;
    }

  // Translate Hexadecimal String
  // Remember only valid Hex chars are '0'..'9', 'A'.. 'F'
  for (int i = 0, j = 0; i < hexlen; i++, j++) {
    BYTE hexch = hexstr[i];
    if (hexch >= '0' && hexch <= '9')
      pstr[j] = (BYTE)((hexch - '0') << 4);
    else if (hexch >= 'A' && hexch <= 'F')
      pstr[j] = (BYTE)((hexch - 'A' + 10) << 4);
    else
      break;
    hexch = hexstr[++i];
    if (hexch >= '0' && hexch <= '9')
      pstr[j] = (BYTE)(pstr[j] + hexch - '0');
    else if (hexch >= 'A' && hexch <= 'F')
      pstr[j] = (BYTE)(pstr[j] + hexch - 'A' + 10);
    else
      break;
    }

  // While VM Segment still locked and no errors occured, return 
  // Hexadecimal String to Clipper
  if (i < hexlen)
    _ret();
  else
    _retclen((char *)pstr, strlen);

  // Unlock and Deallocation VM Segment
  _xvunlock(hstr);
  _xvfree(hstr);
}
