/****************************************************************************
* File Name: STCBAR.PRG                                                     *
* Description: Demo program for Graph_sbar()                                *
* Author: CIBERTEC Developement Team for Clipper Plus Magazine Mexico       * 
* Date: 14/Sep/1995                                                         *
* Requieres: CA-Clipper 5.3                                                 *
* Compile: CLIPPER STCBAR /N                                                *
* Link: BLINKER FI STCBAR LIB LLIBG                                         *
*       EXOSPACE FI STCBAR LIB LLIBG                                        *   
* Public Domain by CIBERTEC Mexico                                          *
*****************************************************************************/

#DEFINE PIX_HOR 500             // pixels over X axis
#DEFINE PIX_VER 300             // pixels over Y axis
#DEFINE PIX_X_0 70              // Starting point on X axis
#DEFINE PIX_Y_0 390             // Starting point on Y axis

#INCLUDE "LLIBG.CH"             // needed to go graphics !

/****************************************************************************
* Function: Main()                                                          *
* Description: Test function for Graph_sbar()                               *
* Author: CIBERTEC Development Team for Clipper Plus Magazine Mexico        *
* Date: 14/Sep/1995                                                         *
*****************************************************************************/

FUNCTION Main
	LOCAL aValues
	aValues := {{20,20,30,15,21,45},;
		{31,21,7,9,12,31,41},;
		{55,20,25,7,9,12,23,11},;
		{31,21,31,41},;
		{55,7,9,12,23,11},;
		{31,21,31,41,15,20,25},;
		{55,7,9,12,23,11},;
		{15,40,45,10,15,20,15,20,25,30,35,50},;            
		{31,21,31,41},;
		{55,7,9,12,23,11},;
		{31,21,31,41,15,20,25},;
		{15,20,25,20,25,20,25}} // Values to be graph
	Graph_sbar(aValues,.T.)         // let's graph !
RETURN (NIL)
/* End Main() */

/****************************************************************************
* Function: GRAPH_SBAR(<aValues>,<lGrid>)                                   *
* Parametros: <aValues> array with values to be graph                       *
*             <lGrid> logical value indicating if a grid is desired         *
* Returns : NIL                                                             *
* Description: Draw a stacked bar graph                                     *
* Author: CIBERTEC Development Team for Clipper Plus Magazine Mexico        *
* Date: 14/Sep/1995                                                         *
*****************************************************************************/

FUNCTION Graph_sbar(aValues,lGrid)
	LOCAL nVideoMode      // to save current video mode
	LOCAL nSumMax := 0     
	LOCAL nSum := 0
	LOCAL nGreatArr       // longest array in parameter <aValues>
	LOCAL nYvalIni
	LOCAL nValor := 0     // scaled values
	LOCAL nYvalFin
	LOCAL nDivs           // to calculate Y axis divisions
	LOCAL nInterval       // to calculate the value of each division over Y axis
	LOCAL nTemp           // temp variable
	LOCAL nBarWidth
	LOCAL nPixAssign

	nGreatArr := LEN(aValues[1])      // initialize the value
	nVideoMode := GMODE()             // what video mode are we using ?
	GMODE(LLG_VIDEO_VGA_640_480_16)   // activate graphic mode


	/* which is the longest array ? */
	AEVAL(aValues,{|aDato, nPos| nGreatArr := IF(LEN(aDato) > nGreatArr,nPos,nGreatArr)})

	/* sum the longest array's values */
	AEVAL(aValues[nGreatArr],{|nVal, nPos| nSumMax += nVal})

	/* how many divisions over the Y axis ?  */
	nDivs := PIX_VER / 10  

	/* calculating every division value */
	nInterval := nSumMax / 10

	/* scaling and drawing divisions on Y axis */

	FOR x :=  90 TO PIX_Y_0 STEP nDivs
		nTemp :=  INT(nSumMax - nValor)               // value to be drawn
		GLINE(PIX_X_0 - 10,;                          // drawing separator
			x,;
			PIX_X_0 + IF(lGrid,PIX_HOR,10),;      // grid or separator ?
					x,;
					15,LLG_MODE_SET)
		GWRITEAT(PIX_X_0 - 40,; 
			x - 5,; 
			LTRIM(STR(nTemp)),;
			15,;
			LLG_MODE_SET) // print value division
		nValor += nInterval   // create a new interval
	NEXT

	nBarWidth := PIX_HOR / LEN(aValues)     // how width will be the bar?

	nYvalIni := PIX_Y_0                     // initial values

	nPixAssign := 0         
	nXvalIni := PIX_X_0

	/* the next code block:
			+ Sums all the arrays individually
			+ Scales each value in every array
			+ draws each bar */

	AEVAL(aValues, {|aVal, nPos|;
	   AEVAL(aVal,{|nElem| nSum += nElem}),;
	      nPixAssign := (nSum * PIX_VER) / nSumMax,;
	      AEVAL(aVal,{|nElem, nPos|; 
		 nYvalFin := nYvalIni - ((nElem * nPixAssign) / nSum),; 
		 GRECT(nXvalIni,nYValIni,;
		    nXvalIni + (nBarWidth / 2), nYvalFin,;
		    LLG_FILL,;
		    nPos,;
		    LLG_MODE_SET),;
		 nYvalIni := nYvalFin }),;
	      nXvalIni += nBarWidth,; 
	      nYvalIni := PIX_Y_0 })

	/* ooops! forgot to draw axis !!!, let's do it now */

	GLINE(70,90,70,390,15,LLG_MODE_SET)
	GLINE(70,390,570,390,15,LLG_MODE_SET)

	/* hit any key and ... back to the first video mode */

	INKEY(0)
	CLEAR
	GMODE(nVideoMode)
RETURN (NIL)
/End Graph_sbar() */

