*  FILE NAME: TAGROLL.PRG
*  BY: Sunset Software...Bill Kersey
*  NOTICE: Enhanced DBMS PD_SCRL program
*  DATE: 7/17/90
*  DESC: A non_array pick list with tag
*        Requires that the database have a field named "T" (C,1)
*        I have removed the filter, alias and other database selections
*        since my programs do not use them.
*  DATA FILES: Uses the file that is selected when called.
*!--------------------------------------------------------------------------

PROCEDURE TAGROLL
 parameters fld,trow,tcol,brow,hlp,fldtitle,tagem
 * Assumes enviroment already setup
 *** parameters values
 * trow  = top row		       *** dimensions of the of the window ***
 * tcol  = top column		   *** The bottom col position is not required
 * brow  = bottom row
 * hlp = .t. = display help
 * fldtitle= field titles	   *** LEN(t_bannet)=0 = no field titles
 * tagem = .t. = do tag code
 GO TOP
 frec = RECNO()

 * exits TAGROLL and returns to the calling program if EOF()
 * calling program check EOF() for escape or no pick
 * calling program also check "T's" for tags
 * this could be modified to set record pointed to EOF() if tag
 *  was enabled and nothing was tagged
 IF EOF()
 RETURN                                     && returns EOF()=no records
ENDIF

* store last recno() in lrec
GO BOTTOM
lrec = RECNO()                              && Last

* go back to the top
GO frec
SET EXACT OFF                               &&
SET ESCAPE OFF                              &&

* setting of colors for the scroll is done once
* highlighting is done by using gets instead of changing colors
IF ISCOLOR()                                &&
 SET COLOR TO w+/ ,+w/r                     &&
ELSE                                        &&
 SET COLOR TO w+/ ,n/w                      &&
ENDIF                                       &&

* calculate the number of lines for scroll display
wndht = (brow -trow) +1                     &&
scrnrow = trow                              &&
                                            &&

* draw the box/window on the screen
STORE 1 to blook,slen                       &&
STORE len(fld) to elen                      &&
STORE 0 to col_len                          &&
STORE .f. to last                           &&
DO WHILE blook < elen                       &&
 STORE slen to blook                        && begin length
 STORE at("+",substr(fld,blook,elen)) to elook  &&
 IF elook = 0                               &&
  IF blook # elen                           &&
   STORE substr(fld,blook,len(fld)) to word &&
   STORE .t. to last                        &&
  ENDIF                                     &&
 ELSE                                       &&
  STORE substr(fld,blook,elook-1) to word   &&
 ENDIF                                      &&
 STORE col_len+len(&word) to col_len        &&
 IF last                                    &&
  EXIT                                      &&
 ENDIF                                      &&
 STORE blook+elook to slen                  &&
ENDDO                                       &&
STORE tcol+col_len to bcol                  &&
@ trow-1, tcol-1 to brow +1,bcol double     &&
IF len(fldtitle) > 0                        &&
 @trow-1,tcol say fldtitle                  &&
ENDIF                                       &&
IF hlp                                      &&
 STORE brow+2 to hlprow                     &&
 @ hlprow,0 clear                           &&
 IF .NOT. tagem                             &&
  *@ trow-1, tcol-1 to brow +1,bcol double  &&
  STORE "PICK Help" to msg
  IF bcol-tcol > len(msg)
   STORE msg+replicate(".",(bcol-tcol) -len(msg)) to msg
  ENDIF
  @ hlprow,tcol say msg                     &&
  STORE hlprow+1 to hlprow                  &&
  STORE " E =End   F =Forward   D =Page Dn                  " to P_Help
  @ hlprow,tcol say P_Help
  STORE hlprow+1 to hlprow                  &&
  STORE " T =Top   B =Back      U =PgUp         Enter =Exit " to P_Help
  @ hlprow,tcol say P_Help                  &&
 ELSE                                       &&
  STORE "TAG Help" to msg
  IF bcol-tcol > len(msg)
   STORE msg+replicate(".",(bcol-tcol) -len(msg)) to msg
  ENDIF
  @ hlprow,tcol say msg                     &&
  STORE hlprow+1 to hlprow                  &&
  STORE " E =End   F =Forward   D =Page Dn   ! =Tag Down     SpaceBar =Tag/UnTag  " to P_Help
  @ hlprow,tcol say P_Help                  &&
  STORE hlprow+1 to hlprow                  &&
  STORE " T =Top   B =Back      U =PgUp      ^ =UnTag Down   Enter =Exit          " to P_Help
  @ hlprow,tcol say P_Help                  &&
 ENDIF                                      &&
ENDIF                                       &&

* initial display of records for scroll - highlighting top record"
noerase = .f.
DO tagdsp with .t.,.t.                      &&
DO WHILE .t.                                &&
 xkey = 0                                   &&
 DO WHILE xkey = 0                          &&
  xkey = inkey()                            &&
 enddo                                      &&
 do CASE                                    &&
  CASE xkey = 33                            &&  "!" key = tag from here to end of the file
   IF tagem                                 && 	is tag enabled
    STORE RECNO() to sav_place              && 	save current record	number
    DO WHILE .not. EOF()                    && 	set tag from here to end
     replace t with ">"                     &&
     SKIP                                   &&
    enddo                                   &&
    go sav_place                            && 	back to where we started
    DO tagdsp with noerase,.t.              &&  update display with no clear
   ENDIF                                    &&
  CASE xkey = 94                            &&  "^" key = untag from here to end of the file
   if tagem                                 &&  is tage enabled
    STORE RECNO() to sav_place              && 	save current record number
    DO WHILE .not. EOF()                    &&  reset tag from here to end
     replace t with " "                     &&
     SKIP                                   &&
    enddo                                   &&
    go sav_place                            && back to where we started
    DO tagdsp with noerase,.t.              && update display with no clear
   ENDIF                                    &&
  CASE xkey = 32                            && spacebar key = tag this record
   IF tagem                                 && is tag enabled
    IF t = ">"                              && toggle tag
     replace t with " "                     &&
    ELSE                                    &&
     replace t with ">"                     &&
    ENDIF                                   &&
    @ scrnrow,tcol get t                    && update display line
    CLEAR GETS                              &&
    * IF clipper                            && automatic scan down if clipper
    *  keyboard(chr(24))                    &&
    * ENDIF                                 &&
   ENDIF                                    &&
  CASE xkey = 13                            && Enter key = return
   set escape on                            &&
   RETURN                                   && You should go bottom & skip +1 here
  CASE xkey = 27                            && Esc key = no selec
   SET ESCAPE ON                            &&
   GO BOTTOM                                && 
   SKIP +1                                  && set eof()
   RETURN                                   &&
  CASE xkey = 98 .or. xkey = 66 .or. xkey=5 && "B" key = back one record
   IF RECNO() <> frec                       && if record # is not equal to frec (first record = bof() )
    IF scrnrow > trow                       &&
     @ scrnrow,tcol say &fld                &&
     scrnrow = scrnrow -1                   &&
     SKIP -1                                &&
     lightfld = &fld                        &&
     @ scrnrow,tcol get lightfld            &&
     CLEAR GETS                             &&
    ELSE                                    &&
     SKIP -1                                &&
     DO tagdsp with noerase,.t.             &&
    ENDIF                                   &&
   ENDIF                                    &&
  CASE xkey =102 .or. xkey =70 .or. xkey=24 && "F" key = forward one record
   IF RECNO() <> lrec                       && if record # is not equal to lrec (last record = EOF() )
    IF scrnrow < brow                       &&
     @ scrnrow,tcol say &fld                &&
     scrnrow = scrnrow +1                   &&
     SKIP 1                                 &&
     lightfld = &fld                        &&
     @ scrnrow,tcol get lightfld            &&
     CLEAR GETS                             &&
    ELSE                                    &&
     SKIP 2 - wndht                         &&
     DO tagdsp with noerase,.f.             &&
    ENDIF                                   &&
   ENDIF                                    &&
  CASE xkey =100 .or. xkey =68	.or. xkey=3 && "D" key =  PgDn  (page down)
   IF RECNO() <> lrec                       && if not end of file - redisplay scroll one scroll down
    SKIP trow-scrnrow +(2 * wndht) -1       &&
    IF EOF()                                &&
     SKIP - wndht                           &&
     DO tagdsp with noerase,.f.             &&
    ELSE                                    &&
     SKIP 1 -wndht                          &&
     DO tagdsp with noerase,.t.             &&
    ENDIF                                   &&
   ENDIF                                    &&
  CASE xkey =117 .or. xkey =85 .or. xkey =18  && "U" key = PgUp (page up)
   IF RECNO() <> frec                       &&if not top of file - redisplay scroll one scroll lenght up
    SKIP trow-scrnrow - wndht               &&
    IF bof()                                &&
     go frec                                &&
     DO tagdsp with noerase,.t.             &&
    ELSE                                    &&
     DO tagdsp with noerase,.f.             &&
    ENDIF                                   &&
   ENDIF                                    &&
  CASE xkey =116 .or. xkey =84 .or. xkey=1  && "T" key = home key has been pressed
   IF RECNO() <> frec                       && redisplay scroll starting at the top of file
    GO frec                                 &&
    DO tagdsp with noerase,.t.              &&
   ENDIF                                    &&
  CASE xkey =101 .or. xkey =69 .or. xkey=6  && "E" key = end key has been pressed
   IF RECNO() <> lrec                       && redisplay scroll from bottom of the file
    GO lrec                                 &&
    SKIP 1 - wndht                          &&
    IF bof()                                &&
     GO frec                                &&
    ENDIF                                   &&
    DO tagdsp with noerase,.f.              &&
   ENDIF                                    &&
 ENDCASE                                    &&
ENDDO                                       &&
RETURN                                      &&

