***********************************
* Program:     Soundx.prg
* Author:      Timothy Wong
* Date:        May 11, 1989
* Version:     Clipper Summer '87, Clipper Tools I
* Note(s):     This is an alternate SOUNDEX UDF that allows
*              punctuation in the input strings.  This algorithm
*              was taken from page 392, "Sorting and Searching",
*              Volume 3 of "The Art of Computer Programming",
*              by Donald Knuth, Addison/Wesley publisher.
*
*              THIS FUNCTION REQUIRES CLIPPER TOOLS I!
*
* Copyright (C) 1989 Nantucket Corp., ALL RIGHTS RESERVED
***********************************
FUNCTION SoundexII
   PARAMETERS InStr
   PRIVATE RetVal, TempStr, ZeroStr

   ZeroStr = "000"
   InStr = UPPER(InStr)          && convert to UPPER case
   RetVal = LEFT(InStr,1)        && STEP 1
   TempStr = SUBSTR(InStr,2,LEN(InStr) - 1)     && use the rest

   && STEP 2
   && now strip out all duplicate charaters and remove all
   && occurances of "A,E,H,I,O,U,W,Y" and puntuation characters
   TempStr = CHARREM([AEHIOUWY!(){};:" ',.?0123456789],;
      CHARLIST(TempStr))

   && STEP 3 & 4
   && check for special case of strings less than length of 3
   IF LEN(TempStr) >= 3
      TempStr = LEFT(TempStr,3)
   ELSE
      TempStr = TempStr + LEFT(ZeroStr,3-LEN(TempStr))
   ENDIF

   && now replace:-
   &&    B,F,P,V with 1
   &&    C,G,J,K,Q,S,X,Z with 2
   &&    D,T with 3
   &&    l with 4
   &&    m,n with 5
   &&    r with 6
   CHARREPL("BFPVCGJKQSXZDTLMNR",@TempStr,"111122222222334556")
   RetVal = RetVal + TempStr

RETURN RetVal
