*******************
*******************
**
**   Source File ... DBGMAP.PRG
**
**   Application ... DBGMap v1.0
**                   Copyright (c) 1992 Lamaura Development Limited
**                   All Rights Reserved
**
**   Author ........ Jan Holbech Larsen based on work by Philip de Lisle
**   Last Update ... 12 November 1992 at 2:59
**   Purpose ....... Preparation Program for SOS Debug! v1.0
**   Requires ...... getdrive.obj, clipper.lib, extend.lib
**
*******************
*******************

parameters cFile, cScript
private hDbg, hScript, cScriptTxt, bDuplicate, c1stDup
*
*
*
if Start()
   do while MoreDirs()
      cDir = NextDir()
      private aPrg[adir(cDir+'*.Prg')]
      adir(cDir+'*.prg', aPRG)
      for i = 1 to len(aPrg)
         DoPrg(cDir,aPrg[i])
      next
   enddo
   Stop()
endif

return
*
*
*
function MoreDirs
return at(chr(255),cScriptTxt) <> 0
*
*
*
function NextDir
   private cDir
   cDir = alltrim(substr(cScriptTxt,1,at(chr(255),cScriptTxt)-1))
   cScriptTxt = substr(cScriptTxt,at(chr(255),cScriptTxt)+1)
   cDir = cDir + iif(substr(cDir,-1)='\', '', '\')
return (cDir)
*
*
*
function Start
   private bAgain, cPrg, nBufferSize, nBufferSize, hScript
   @ 00,00 clear
   @ 00,00 say 'DBGMap v1.0'
   @ 01,00 say 'Copyright (c) 1992 Lamaura Development Limited.  All Rights Reserved'
   if type('cFile') == 'U'
      @ 04,00 say 'Format is DBGMAP <dbgfilename> [<scriptfilename>]'
      @ 06,00 say 'where <dbgfilename>    = Name of 1st .OBJ in Application (inc. path)'
      @ 07,00 say '      <scriptfilename> = Name of a file containing a list of .PRG directories'
      return .f.
   endif
   @ 03,00 say 'Processing...'
   if type('cScript') == 'U'
      cScriptTxt = curdir()
      cScriptTxt = getdrive() + ':' + iif(empty(cScriptTxt), '', '\') + cScriptTxt + '\'+chr(255)
   else
      hScript = fopen(cScript)
      if hScript = -1
         @ 05,00 clear to 24,79
         @ 05,00 say upper(cScript) + ' - FOPEN() Error' + chr(7)
         inkey(0)
         return .f.
      endif
      cScriptTxt = ''
      bAgain = .t.
      do while bAgain
         cPrg = space(16384)
         nBufferSize = fread(hScript, @cPrg, 16384)
         if nBufferSize == 0
            exit
         else
            bAgain = (nBufferSize == 16384)
            cScriptTxt = cScriptTxt+upper(cPrg)
         endif
      enddo
      cScriptTxt = alltrim(memotran(cScriptTxt,chr(255),chr(255)))
      if substr(cScriptTxt,-1) <> chr(255)
         cScriptTxt = cScriptTxt+chr(255)
      endif
      fclose(cScript)
   endif
   if '.'$cFile
      cFile = stuff(cFile, at('.', cFile), 4, '')
   endif
   hDbg = fcreate(cFile + '.DBG')
   if hDbg = -1
      @ 05,00 clear to 24,79
      @ 05,00 say upper(cFile) + '.DBG - FCREATE() Error' + chr(7)
      inkey(0)
      return .f.
   endif
   Private aFields[03]
   aFields[01] = 'Lead       C 001  '
   aFields[02] = 'Name       C 012  '
   aFields[03] = 'Path       C 128  '
   DbfCreate(aFields,cFile+'.DBF')
   select 0
   use (cFile+'.DBF') alias DBG
   index on Lead+Name to (cFile+'.NTX')
   bDuplicate = .f.
   SetWindow(05,00,24,79)
return .t.
*
*
*
function Stop
   index on descend(Lead)+Path to (cFile+'.NTX')
   goto top
   do while .not. eof()
      if Lead == '|'
         fwrite(hDBG, Lead + pad(trim(Name),10) + trim(Path) + chr(13)+chr(10))
      else
         fwrite(hDBG, Lead + pad(trim(Name),12) + trim(Path) + chr(13)+chr(10))
      endif
      skip +1
   enddo
   use
   fclose(hDbg)
   erase (cFile + '.DBF')
   erase (cFile + '.NTX')
   SetWindow(00,00,24,79)
   if bDuplicate
      @ 03,00 clear to 24,79
      @ 04,00 say 'WARNING:  Duplicate procedure or function names found'
      @ 05,00 say '          1st duplicate is ' + c1stDup
      @ 07,00 say '          Consult documentation'
      ?? chr(7)
   endif
   ?
return ''
*
*
*
function DoPrg
   parameters cDir, cPrgName
   private hPrg, bAgain, cPrg, nBufferSize, nF, nP, nFunc, nProc, nFunction, nProcedure, nStart, nCRLF, cLine, nBufferSize
   seek '^'+upper(cPrgName)
   if (! bDuplicate) .and. found()
     c1stDup = upper(cPrgName) + '  (1)'
     bDuplicate = .t.
   endif
   append blank
   replace Lead with '^', Name with upper(cPrgName), Path with upper(cDir+cPrgName)
   seek '|'+upper(substr(cPrgName,1,at('.',cPrgName)-1))
   if (! bDuplicate) .and. found() .and. ;
        (cFile == upper(substr(cPrgName,1,at('.',cPrgName)-1)))
     c1stDup = upper(substr(cPrgName,1,at('.',cPrgName)-1)) + '  (2)'
     bDuplicate = .t.
   endif
   append blank
   replace Lead with '|', Name with upper(substr(cPrgName,1,at('.',cPrgName)-1)), Path with upper(cDir+cPrgName)
   hPrg = fopen(cDir+cPrgName)
   if hPrg = -1
      SetWindow(00,00,24,79)
      @ 05,00 clear to 24,79
      @ 05,00 say upper(cDir+cPrgName) + ' - FOPEN() Error' + chr(7)
      inkey(0)
      use
      fclose(hDbg)
      fclose(cScript)
      erase (cFile + '.DBG')
      erase (cFile + '.DBF')
      erase (cFile + '.NTX')
      quit
   endif
   ?? upper(cDir+cPrgName)
   ?
   bAgain = .t.
   do while bAgain
      cPrg = space(16384)
      nBufferSize = fread(hPrg, @cPrg, 16384)
      if nBufferSize == 0
         exit
      endif
      cPrg = trim(cPrg)
      bAgain = (nBufferSize == 16384)
      if bAgain
         do while substr(cPrg, len(cPrg), 1) # chr(13)
            cPrg = substr(cPrg, 1, len(cPrg)-1)
            fseek(hPrg, -1, 1)
         enddo
      endif
      cPrg = upper(cPrg)
      do while .t.
         nFunction  = at(chr(10)+"FUNCTION ",cPrg)
         nProcedure = at(chr(10)+"PROCEDURE ",cPrg)
         nFunc = at(chr(10)+"FUNC ",cPrg)
         nProc = at(chr(10)+"PROC ",cPrg)
         if (nProc == 0) .and. (nFunc == 0) .and. (nProcedure == 0) .and. (nFunction == 0)
            exit
         endif
         do case
            case nFunc = 0
                 nF = nFunction
            case nFunction = 0
                 nF = nFunc
            otherwise
                 nF = min(nFunc, nFunction)
         endcase
         do case
            case nProc = 0
                 nP = nProcedure
            case nProcedure = 0
                 nP = nProc
            otherwise
                 nP = min(nProc, nProcedure)
         endcase
         do case
            case nF = 0
                 nStart = nP
            case nP = 0
                 nStart = nF
            otherwise
                 nStart = min(nF, nP)
         endcase
         cPrg = substr(cPrg, nStart)
         nCRLF = at(chr(13), cPrg)
         cLine = substr(cPrg, 1, iif(nCRLF=0, 255, nCRLF)-1)
         cPrg = substr(cPrg, len(cLine))
         cLine = pad(substr(cLine, at(' ',cLine)+1, 10), 10)
         if at('(',cLine) > 0
            cLine = pad(substr(cLine, 1, at('(',cLine)-1), 10)
         endif
         seek '|'+upper(cLine)
         if (! bDuplicate) .and. found()
           c1stDup = upper(cLine) + '  (3)'
          bDuplicate = .t.
         endif
         append blank
         replace Lead with '|', Name with upper(cLine), Path with upper(cDir+cPrgName)
      enddo
   enddo
   fclose(hPrg)
RETURN ''
*
*
*
function DbfCreate
   parameters aFields, cDbfName
   private i
   select 0
   create ('TMP.DBF')
   for i = 1 to len(aFields)
      append blank
      replace Field_Name with substr(aFields[i],1,10),;
              Field_Type with substr(aFields[i],12,1),;
              Field_Len with val(substr(aFields[i],13,4)),;
              Field_Dec with val(substr(aFields[i],18,1))
   next
   create (cDbfName) from ('TMP.DBF')
   use
   erase ('TMP.DBF')
RETURN ''
*
*
*
function SetWindow
   parameters nSRow, nSCol, nERow, nECol
   call __SETWIN with word(nSRow),word(nSCol),word(nERow),word(nECol)
return ''
*
*
* EOF DBGMAP.PRG
