* File Name: SN.PRG
* Called by: DOS
*     Scope: Serializes application
*    Author: David W. Benson
*      Date: 03/24/89
*  Copyright (C) 1988 2nd Story Computing - All rights reserved
*
*
*        To serialize an application, include a function like
*        the one below in your code.  The character string
*        (!@#$%^&* in this example) should not appear anywhere
*        else in your code.  The string must contain exactly
*        the same number of characters as you s/n.
*
*        Compile with:
*
*                  tlink sn,,,clipper extend
*
*
*        Test program:
*
*                  clear
*                  @ 12,30 say "S/N: " + serial_no()
*                  quit
*
*                  FUNCTION serial_no
*                  return("!@#$%^&*")
*
clear
set confirm on

fname = space(8)
s_str = space(8)
r_str = space(8)

@ 1,1 say "Enter file name (without ext):" get fname pict '@!'
read

if empty(fname)
   quit
endif

if !file("&fname..EXE")
   quit
endif

@ 2,7 say "Enter string to replace:" get r_str ;
           valid(len(trim(r_str)) = 8 .or. len(trim(r_str)) = 0)
read

if empty(r_str)
   quit
endif

@ 3,4 say "Enter serial number string:" get s_str ;
           valid(len(trim(s_str)) = 8 .or. len(trim(s_str)) = 0)
read

if empty(s_str)
   quit
endif

if !serialno(trim(fname)+".EXE", r_str, s_str)
   
   ? "Not serialized"

else

   ? "Copy serialized"

endif

quit
*


FUNCTION serialno
parameters fn, oldstr, newstr

hdl = fopen(fn, 2)                            && open file to serialize

buffer = space(4096)                          && init buffer

start = fseek(hdl, 0, 0)                      && get start position

do while .t.

   bytes_read = fread(hdl, @buffer, 4096)     && get 4k block

   os = at(oldstr, buffer)                    && search block for oldstr
   
   if os > 0                                  && if found

      fseek(hdl, (start + os) - 1, 0)         && goto start of oldstr
      
      fwrite(hdl, newstr)                     && write over with newstr
      
      fclose(hdl)                             && close EXE
                                              
      return .t.                              && return serialized
   
   endif                                      && not found so

   ? ltrim(str(start + bytes_read ,7)) + ;    && show file position
     " - bytes read"
   
   if bytes_read < 4096                       && if eof

      fclose(hdl)                             && close EXE

      return .f.                              && return not serialized

   else                                       && or if not eof

      start = fseek(hdl, -7, 1)               && back up len(oldstr-1) in
                                              && case its on a 4k boundry

      buffer = space(4096)                    && re-initialize buffer

   endif

enddo                                         && and continue search
*

