
/*

           COPYRIGHT (c) 1991 by Rodd Graham.  ALL RIGHTS RESERVED.

    Title: Seek bug workaround for Clipper 5.01
   Author: Rodd Graham
           Software Services
           6803 W. 64th Street
           Overland Park, Kansas 66202
           913-384-2809
     Date: July 11, 1991

    Usage: Compile with /M /N /L /W
           Include SeekFix.CH in all OTHER Clipper 5.01 code
           Link with SeekFix.OBJ

     Desc: Uses softseeking coupled with a final comparison between the
           seek value and the index expression evaluation to overcome the
           internal clipper error localized to the found() function and its
           underlying variable.  When Nantucket fixes bug, remove inclusion
           of SeekFix.CH; stop linking with SeekFix.OBJ

Recommendation: Develop a standard include file for YOUR company/person, and
                use a nested include reference to SeekFix.CH.  Then, you will
                only need to remove the include from a single file
                (YourSTD.CH) when the fix is made.  Further, companywide
                extensions to clipper can be made in this file.  (EXAMPLE:
                The default #xcommand below resides in our company include
                file)

*/

#xcommand DEFAULT <x> TO <y> [TYPE <z>] => ;
  <x> := iif(valtype(<x>)$(valtype(<y>)+upper(#<z>)),<x>,<y>)

static FoundFlags[250]

static function SetSoftSeek(Mode)
return (iif(ValType(Mode)$"L",Set(_SET_SOFTSEEK,Mode),Set(_SET_SOFTSEEK)))

function FoundFix
return (FoundFlags[Select()])

function DBSeekFix(Value,SoftSeekMode)
  local WorkArea := select()

  default SoftSeekMode to SetSoftSeek()

  dbseek(Value,.t.)

  if !(FoundFlags[WorkArea] := (&(IndexKey(0)) = Value)) .and. !SoftSeekMode
    goto 0
  endif

return (FoundFlags[WorkArea])
