/* Clipper 5.X Mouse Test Program to demonstrate use of 
   Sacramento, CA Clipper User Group Mouse LIB.  Developed
   by Dave Palmer CIS 73123,3354.
   Compile with MakeObj.BAT
   Link with Blinker @Mtest
*/
#INCLUDE "INKEY.CH"
#INCLUDE "DVS.CH"
#INCLUDE "DVMOUSE.CH"
#INCLUDE "SETCURS.CH"
#INCLUDE "SET.CH"
#INCLUDE "MPROMPT.CH"
#INCLUDE "DVCOLOR.CH"

/* Call Custom Errorsys as Main
   ErrorSys( <bMainFunc>,<bIndexFunc> )
   Where bMainFunc = Your main program routine
         bIndexFunc= Your Index Routine in case of Index Corruption
*/

function start
errorsys({||main()})
return(nil)

function Main
	local getlist:={},mEventList,aclrs,nEvent,noldEvent,nkey,apos,nvert,nhoriz
	nvert:=0
	nHoriz:=0
	aclrs:=ColorStart() // Located at end of this program
  Nevent:=0
  nOldEvent:=1
  MStart()

	MChgCsr(M_NORMAL)

	MsPEED(20,20)
	MouseOff()
bOXIT(0,0,MAXROW(),MAXCOL(),9,BACKCLR(aclrs),0)

bOXIT(20,0,24,MAXCOL(),7,SUBCLR(ACLRS),0)
@ 21,2 SAY "Mouse Row " Color Subclr(Aclrs)
@ 22,2 say "Mouse Col " Color Subclr(Aclrs)
@ 21,26 say "Mouse Left   " Color Subclr(aclrs)
@ 22,26 say "Mouse Right  " Color Subclr(Aclrs)
@ 23,26 say "Mouse Middle " color Subclr(aclrs)
@ 21,46 say "Mouse Senstv" color Subclr(aclrs)
@ 23,46 say "Screen Saver" color Subclr(aclrs)
MchkBox(21,60,Subclr(aclrs))
MchkBox(23,60,Subclr(aclrs))

// Character Definitions
Boxit(4,60,18,76,11,mainclr(aclrs),2,shadclr(aclrs))
@ 4,63  SAY "Cursor Mask" COLOR revclr(mainclr(ACLRS))
@ 6,67  SAY CHR(M_NORMAL) COLOR mainclr(aclrs)
@ 8,67  SAY CHR(M_ARROW)  COLOR mainclr(aclrs)
@ 10,67 SAY CHR(M_TRASH_CAN) COLOR mainclr(aclrs)
@ 12,67 SAY CHR(M_HOUR_FILLED) COLOR mainclr(aclrs)
@ 14,67 SAY CHR(M_HOUR_EMPTY) COLOR mainclr(aclrs)
@ 16,67 SAY chr(M_HAND) COLOR MAINCLR(ACLRS)

// Three Check Boxes top Of Screen
MChkBox(0,1,revclr(BackClr(aclrs)))
MchkBox(0,30,Revclr(BackClr(aclrs)))
mChkBox(0,77,revclr(BackClr(aclrs)))

// Explain Top 3 CheckBoxes
@ 0,3  SAY "MouseGet" COLOR revclr(BackClr(aclrs))
@ 0,32 SAY "MousePrompt" COLOR revclr(BackClr(aclrs))
@ 0,65 SAY "MouseBrowse" COLOR revclr(BackClr(aclrs))

// Six Checkboxes for Mouse Icons
MChkbox(6,70,mainclr(aclrs))
MChkbox(8,70,mainclr(aclrs))
Mchkbox(10,70,mainclr(Aclrs))
MChkbox(12,70,mainclr(aclrs))
MChkBox(14,70,mainclr(aclrs))
MchkBox(16,70,Mainclr(aclrs))

// Add Events For Mouse Icons
MeventList:=mAddEvent(6,70,6,70,MEventList)
MeventList:=mAddEvent(8,70,8,70,MeventList)
MeventList:=mAddEvent(10,70,10,70,MeventList)
MeventList:=mAddEvent(12,70,12,70,MeventList)
MeventList:=MaddEvent(14,70,14,70,Meventlist)
MEventList:=MaddEvent(16,70,16,70,Meventlist)


SET(_SET_CURSOR,SC_NONE)
Do While .T.
	nKey:=Minkey()

IF nKey !=0
	if nkey==K_MOUSE_2
    	MOUSEOFF()
		SETCOLOR("7/0")
		CLS
		MouseEnd()
		Mouseoff()
	    QUIT
	ENDIF

IF Mregion(0,76,0,78)
	MouseOff()
	MChkBoxFil(0,77,revclr(BackClr(aclrs)))

	MBrowse(aclrs,mEventList)

	MchkBox(0,77,revclr(BackClr(aclrs)))
Elseif Mregion(0,1,0,3)
	MChkBoxFil(0,1,Revclr(BackClr(aclrs)))
	GetTest(Aclrs)
	MChkBox(0,1,Revclr(BackClr(Aclrs)))

Elseif MRegion(0,30,0,30)
	mChkBoxFil(0,30,Revclr(backclr(aclrs)))
	Mpromptest(aclrs)
	MchkBox(0,30,Revclr(Backclr(aclrs)))
Elseif Mregion(21,60,21,60)
			 MchkBoxfil(21,60,Subclr(aclrs))
    	     @ 21,63 say "Vert ,Horiz" Color Subclr(aclrs)
			 @ 22,63 Get nHoriz Pict "999" Color Subclr(aclrs)
			 @ 22,68 get nVert  Pict "999" Color Subclr(aclrs)
			 Read
			 Mspeed(nVert,nHoriz)
			 MchkBox(21,60,subclr(aclrs))
Elseif Mregion(23,60,23,60)
			 MChkboxFil(23,60,Subclr(aclrs))
			 ScrSave()
			 MchkBox(23,60,Subclr(aclrs))
Elseif (nEvent:=MGetEvent(mEventList))>0
			MOUSEOFF()
			MChkBox(Meventop(Meventlist,noldevent),;
            MEventleft(Meventlist,nOldevent),mainclr(ACLRS))
  			MChkBoxFil(Meventop(Meventlist,nEvent),;
            MeventLeft(Meventlist,nEvent),mainclr(aclrs))
            MouseOn()
    		 IF nEvent==1
				MChgCsr(M_NORMAL)
			 ELSEIF nEvent==2
				MchgCsr(M_ARROW)
			 ELSEIF nEvent==3
				MchgCsr(M_TRASH_CAN)
			 ELSEIF nEvent==4
				MChgCsr(M_HOUR_FILLED)
			 ELSEIF nEvent==5
				MChgCsr(M_HOUR_EMPTY)
			 Elseif nEvent==6
	            MchgCsr(M_HAND)
		     Endif
    		nOldEvent:=nEvent
endif
endif // nkey
@ 21,12 say STR(Mrow(),6) Color Subclr(aclrs)
@ 22,12 say STR(Mcol(),6) Color Subclr(aclrs)

IF nkey==K_MOUSE_1
		@ 21,42 SAY "YES" Color Subclr(Aclrs)
ELSE
		@ 21,42 SAY "NO " Color Subclr(Aclrs)
ENDIF
IF nkey==K_MOUSE_2
		@ 22,42 SAY "YES" Color Subclr(Aclrs)
ELSE
		@ 22,42 SAY "NO " Color Subclr(Aclrs)
ENDIF
IF nkey==K_MOUSE_3
		@ 23,42 SAY "YES" Color Subclr(Aclrs)
ELSE
		@ 23,42 SAY "NO " Color Subclr(Aclrs)
ENDIF

Enddo



Return(nil)


// Atprompt test Function
//*************************
Function mPromptest(aclrs)
//***************************
	local x,_aPrompts,aoldvideo
	SET(_SET_MESSAGE,2);SET(_SET_MCENTER,.T.)
	Mouseoff()
	aoldvideo:=Savevideo(3,9,17,50)

	Boxit(3,9,17,35,8,Subclr(aclrs),2,shadclr(aclrs))
	@ 5,10 prompt " This is Prompt ONE " pcolor barclr(aclrs) ;
		      message " Message for Prompt ONE " mcolor Backclr(ACLRS) ;
					poffpos 17 poffclr ClrSep(barclr(aclrs),5) ;
					shadow Shadowclr subclr(aclrs)
	@ 7,10 prompt " This is Prompt Two " pcolor barclr(aclrs) ;
		      message " ********* Message For Prompt Two ********** " mcolor BackClr(aclrs);
					poffpos 17 poffclr ClrSep(barclr(aclrs),5) ;
					shadow Shadowclr subclr(aclrs)
	@ 9,10 prompt " This is Prompt Three " pcolor barclr(aclrs) ;
		      message " Message For Prompt Three [ Unselectable ]" mcolor BackClr(aclrs) ;
					poffpos 18 poffclr ClrSep(barclr(aclrs),5) NOSELECT ;
					shadow Shadowclr subclr(aclrs)
	@ 11,10 prompt " This is Prompt Four " pcolor barclr(aclrs) ;
					poffpos 17 poffclr ClrSep(barclr(aclrs),5)  ;
					shadow Shadowclr subclr(aclrs)
	@ 13,10 prompt " This is Prompt Five " pcolor barclr(aclrs) ;
		      message " Message For Prompt Five " mcolor BackClr(aclrs) ;
					poffpos 19 poffclr ClrSep(barclr(aclrs),5)   ;
					shadow Shadowclr subclr(aclrs)
	@ 15,10 prompt " This is Prompt Six " pcolor barclr(aclrs) ;
		      message " Message For Prompt Six " mcolor BackClr(aclrs)  ;
					poffpos 15 poffclr ClrSep(barclr(aclrs),5)    ;
					shadow Shadowclr subclr(aclrs)
	menu to x
	Restvideo(aoldvideo)
Return(nil)
//*********************************
STATIC FUNCTION GetTest(aclrs)
//*********************************
	local getList:={},aGets[2,30],x,nRow,nCol,TmpVideo
	Set(_SET_MESSAGE,22);SET(_SET_MCENTER,.T.)
	tmpvideo:=Savevideo(1,2,22,Maxcol()-2)
	Boxit(2,2,22,maxcol()-2,8,winclr(aclrs),2,shadclr(aclrs))
	Nrow:=3
	Ncol:=4

	for x:=1 to 30
		if x==10
			 agets[1,x]:="Date var"
			 agets[2,x]:=Date()
		elseif x==22
			agets[1,x]:="Numeric "
			agets[2,x]:=x
		else
		agets[1,x]:=replicate(chr(x),10)
		agets[2,x]:=Space(10)
	 endif
		@ nrow++,ncol Say agets[1,x] Color Clrsep(Winclr(aclrs),5) ;
			        Get Agets[2,x] Color winclr(aclrs) ;
							Message Replicate(chr(x),20) Mcolor REVCLR(WINCLR(aclrs))
 if x==15
		NRow:=3
		NCol:=41
 endif
Next
Read

	SetTimer(aGets[2,22])
Restvideo(tmpvideo)
RETURN(NIL)


//****************************
Static Function ColorStart()
//****************************
local aClrs
SetBlink(.f.)
			 if iscolor()

        aClrs:={"14/1*,1/7,0,0,15/1 ",;
                  "4/7,15/4,0,0,1/7   ",;
                  "15/0*,0/7,0,0,14/0*",;
                  "1/15,15/1,0,0,0/15 ",;
                  "0/7,15/1,0,0,1/7   ",;
                  "11/4*,1/7,0,0,0/4  ",;
                  "2/15,7/4,0,0,4/15  ",;
                  "1/7,15/1*,0,0,4/15 ",;
                  "15/4,15/1,0,0,1/4  ",;
                 "7/0,0/7,0,0,10,0"}

      Else
          aClrs:={"7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0",;
                    "7/0,0/7,0,0,7/0"}
ENDIF
Return(aClrs)

