TITLE A&D Co. Scale interface module for DBXL 	(c) 1989
;						ec roberts
;						R. Stewart 
;
; scale.bin is passed a string DS:BX with first 3 bytes = hex addr of com port
; DBXL code looks like:
;	load scale
;	.
;	.
;	.
;	getweight = '3F8               ' && address for com1:
;	call scale with getweight  	 && goes out to com1: 
;					 && and puts weight in getweight
;	hdr = substr(getweight,1,3)
;	realweight = val(substr(getweight,4))
;	@ 10,10 say 'This sample weighs ' get realweight
;	read
;	.
;	.
;	.
; returns; on key hit or 17 byte string from scale LF terminated
;	   if LF occurs w/o 17 data bytes then wait for next 17
;	   return a string @ DS:BX = 17_byte_DATA,NULL (18 byte total)
;          data looks like 'ST,+0000.000  g<cr><lf>'

LF	equ	0ah
BAUD	equ	4800/100	;because of a masm bug, we need to reduce
				; the size of the argument
; line control bits
D_BITS	equ	 2h		; word size: 0h = 5, 1h = 6, 2h = 7, 3h = 8
S_BITS	equ	 0h		; 0h = 1 stop bit, 4h = 2 stop bits
E_PAR	equ	18h
O_PAR	equ	08h
M_PAR	equ	28h
S_PAR	equ	38h

	DOSSEG
	.MODEL	LARGE	;.model & .code are new to masm ver 5.x
	ORG	0h
	.CODE

scale	proc	near
	mov	ax,0
	mov	cs:buf_idx,ax
	mov	cs:buf_dbxl,bx

	call	setup

lp:	mov	ax,0
	mov	cs:buf_idx,ax

	call	wt_dat

	cmp	cs:buf_idx,17
	jne	lp
	retf
scale	endp

setup	proc	near
	mov	bx,cs:buf_dbxl		; get base addr
	xor	dx,dx
	mov	al,[bx +0]

	call	ASC2BIN

	jc	set1			; if error take defalt
	mov	dh,al
	mov	al,[bx +1]

	call	ASC2BIN

	jc	set1			; if error take defalt
	mov	cx,4
	shl	ax,cl
	mov	dl,al
	mov	al,[bx +2]

	call	ASC2BIN

	jc	set1			; if error take defalt
	or	dl,al
	mov	cs:l_addr,dx

set1:	mov	dx,cs:l_addr		; get base addr
	add	dx,3			; set dlab
	mov	al,80h
	out	dx,al

	dec	dx
	dec	dx
	mov	bx,cs:l_baud		; set baud rate
	mov	al,bh
	out	dx,al

	dec	dx
	mov	al,bl
	out	dx,al

	add	dx,3			; set line control
	mov	ax,cs:l_cont
	out	dx,ax

	inc	dx			; set DTR, RTS on
	mov	al,3
	out	dx,al

	ret
setup	endp

wt_dat	proc	near
wlp:	mov	ah,11		; keyboard hit?
	int	21h
	cmp	al,0		; 0 = no keys waiting
	je	wchk
	mov	ah,8		; get key hit and ret
	int	21h
	mov	bx,cs:buf_dbxl
	mov	byte ptr [bx],0 ; set output buff to 0 length
	pop	dx		; clear near call to this routine
	retf			; return to dbxl/qs

wchk:	mov	dx,cs:l_addr		; get base addr
	add	dx,5			; set line stat reg

	in	al,dx

	and	al,1			; test rcv'r rdy
	jz	wlp
	mov	dx,cs:l_addr		; get base addr

	in	al,dx			; get data

	and	al,7fh
	mov	si,cs:buf_idx
	mov	bx,cs:buf_dbxl
	mov	byte ptr[bx][si],al
	inc	si
	mov	byte ptr[bx][si],0	; add NULL terminator
	mov	cs:buf_idx,si
	cmp	al,LF			; test for EOL (LF)
	jnz	wlp
	ret
wt_dat	endp

buf_dbxl       dw      0	;holder for address passed by dbxl/qs
buf_idx        dw      0	;counter for string length

l_addr	 dw	 2f8h			;8250 address
l_baud	 dw	 1152/BAUD		;baud rate (real number is
					; 115200, but must be reduced for
					; masm to handle it properly
l_cont	 dw	 E_PAR OR D_BITS OR S_BITS	;line cntrol

;-----------------------------------------------------------------------------

; ASC2BIN - Converts an ASCII character to binary
;	    Input:    AL = ASCII character (0-F)
;	    Returns:  if CF = 0, then AL = Binary number
;		      if CF = 1, then invalid (AL is unchanged)

ASC2BIN proc near
	cmp	al,'0'                          ;check for hex character
	jb	invalid

	cmp	al,'9'
	jbe	strip				;number is '0' - '9'

	cmp	al,'A'
	jb	invalid 			;number is < 'A'

	cmp	al,'F'
	jle	good				;number is <= 'F'

	cmp	al,'a'
	jb	invalid 			;number is < 'a'

	cmp	al,'f'
	ja	invalid 			;number is > 'f'

good:
	add	al,9				;number is 'A' - 'F'

strip:
	and	al,0fh				;strip off upper nibble
	ret					;return

invalid:
	stc					;set carry flag (error)
	ret					;return

ASC2BIN endp
	end
