; Program ...: Say2File.ASM
; Author ....: Keith Mund
; Date ......: May 1, 1987
;
;----------------------------------------------------------------------------
; DOS equates
;
DOSINT  EQU     21H             ; DOS functions interrupt.
HANCREA EQU     3CH             ; Handle file create function (and open).
HANCLOS EQU     3EH             ; Handle file close.
HANWRIT EQU     40H             ; Handle file write.
HANDUPL EQU     45H             ; Duplicate existing handle.
HANFORC EQU     46H             ; Redirect handle.
STDPRN  EQU     04H             ; Standard printer device file handle.
;
;----------------------------------------------------------------------------
; ASCII equates, function codes and status return codes, etc.
;
LF      EQU     0AH             ; ASCII line feed.
CR      EQU     0DH             ; ASCII carriage return.
EOF     EQU     1AH             ; ASCII end of file.
;
DO_CLOS EQU     'C'             ; Close and restore function.
DO_OPEN EQU     'O'             ; Open and redirect function.
;
CLOS_ER EQU     'C'             ; Error closing the file.
DUPL_ER EQU     'D'             ; Handle duplication error.
OPEN_ER EQU     'O'             ; Error opening the file.
REDI_ER EQU     'R'             ; Redirection error.
SUCCESS EQU     ' '             ; Successful operation.
SYNT_ER EQU     'S'             ; Syntax error.
;
TO_UP   EQU     011011111B      ; Upper case conversion mask.
;
;----------------------------------------------------------------------------
; Segment and offset definition.
;
CSEG    SEGMENT PARA PUBLIC 'CODE'
;
        ORG     0
;
        ASSUME  CS:CSEG,DS:CSEG,ES:CSEG
;
MAIN    PROC    FAR
;
        JMP     START           ; Skip over the data area.
;
;----------------------------------------------------------------------------
; Constants and variables.
;
        DB      CR
        DB      'Say2File.BIN by Keith Mund',CR,LF
        DB      'Copyright (C) 1987 Ashton-Tate',CR,LF,EOF
ACTIVE  DB      0               ; Active/inactive flag.
HANDLE  DW      ?               ; Spool file handle.
OLD_PRN DW      ?               ; Old printer device file handle.
CREOF   DB      CR,EOF          ; To append to spool file before close.
;
;----------------------------------------------------------------------------
; The actual routine starts here.
; Every return instruction returns to dBASE III PLUS and the code moves 
; forward in a straight line fashion for structure.
;
START:  MOV     SI,BX           ; Pointer to variable passed from dBASE III PLUS.
;
;----------------------------------------------------------------------------
; Check to see if a variable was passed, see note below.
;
        MOV     AX,DS           ; The data segment is non-zero when a 
        OR      AX,AX           ; variable is passed from dBASE III PLUS.
        JNZ     Q_CLOS          ; Continue if not zero,
        RET                     ; or else return to dBASE III PLUS.
;
;----------------------------------------------------------------------------
; Check for a request for a close.
;
Q_CLOS: MOV     AL,[SI]         ; Get the command character (byte 1).
        AND     AL,TO_UP        ; Make uppercase.
        CMP     AL,DO_CLOS      ; Close function requested?
        JNE     Q_OPEN          ; If not, check for open.
;
;----------------------------------------------------------------------------
; Restore the original printer device and close the files.
;
CLOSE:  MOV     AL,CS:ACTIVE    ; Is another redirection in effect?
        OR      AL,AL
        JNZ     CLOSE0          ; If not, continue with close,
;
        MOV     AL,'A'          ;     or else return an activity error.
        MOV     [SI],AL         ;     Store the status in the memory variable.
        RET
;
CLOSE0: MOV     AH,HANFORC      ; Make the standard printer device
        MOV     BX,CS:OLD_PRN   ;     track the original handle from
        MOV     CX,STDPRN       ;     before the redirection.
        INT     DOSINT          ; Ignore any error.
;
        MOV     AH,HANCLOS      ; Close the duplicate of the original 
        MOV     BX,CS:OLD_PRN   ;     standard print device.
        INT     DOSINT          ; Ignore any error.
;
CLOSE1: MOV     AH,HANWRIT      ; Write a CR,EOF to the output file.
        PUSH    DS              ; Save the data segment passed from dBASE.
        PUSH    CS              ; Now make the DS point to the data in 
        POP     DS              ;     this code segment.
        MOV     BX,CS:HANDLE    ; This specifies the output file.
        MOV     CX,2            ; Bytes to write.
        MOV     DX,OFFSET CS:CREOF
        INT     DOSINT          ; Write them.
        POP     DS              ; Restore the original data segment.
;
CLOSE2: MOV     AH,HANCLOS      ; Close the output file.
        MOV     BX,CS:HANDLE
        INT     DOSINT
        JC      CLOSE3          ; If an error, jump to report it,
;
        MOV     AL,SUCCESS      ;     or else, return no error.
        JMP     CLOSE4
;
CLOSE3: MOV     AL,CLOS_ER
;
CLOSE4: MOV     [SI],AL         ; Store the status in the memory variable.
        MOV     CS:ACTIVE,0     ; Redirection flag set to 'not in effect'.
        RET
;
;----------------------------------------------------------------------------
; Check for a request to open a file and redirect the printer output.
;
Q_OPEN: CMP     AL,DO_OPEN      ; Open function?
        JE      OPEN
;
        MOV     AL,SYNT_ER
        MOV     [SI],AL         ; Store the status in the memory variable.
        RET
;
;----------------------------------------------------------------------------
; Try to do the redirection request
;
OPEN:   MOV     AL,CS:ACTIVE    ; Check for redirection already in effect.
        OR      AL,AL
        JZ      OPEN0           ; If not, continue with redirection,
;
        MOV     AL,'A'          ; or else quit.
        MOV     [SI],AL         ; Store the status in the memory variable.
        RET
;
OPEN0:	MOV     AH,HANDUPL      ; Duplicate the existing printer handle.
        MOV     BX,STDPRN
        INT     DOSINT
        JNC     CREATE          ; If successful, create the new output file,
;
        MOV     AL,DUPL_ER      ;     or else return an error.
        MOV     [SI],AL         ; Store the status in the memory variable.
        RET

;----------------------------------------------------------------------------
; Create a new file for the printer output.
;
CREATE: MOV     CS:OLD_PRN,AX   ; Save the old printer handle.
        MOV     AH,HANCREA      ; Create the file now.
        MOV     CX,0            ; No attributes set.
        MOV     DX,SI           ; Filename begins character 2 only,
        INC     DX              ;      which is located at...
        INT     DOSINT  
;
        JNC     REDIR
;
        MOV     AH,HANCLOS      ; If there is an error, close the 
        MOV     BX,CS:OLD_PRN   ;     duplicate of the original prn device.
        INT     DOSINT          ; Ignore any close error.
        MOV     AL,OPEN_ER
        MOV     [SI],AL         ; Store the status in the memory variable.
        RET
;
REDIR:  MOV     CS:HANDLE,AX    ; Save the handle.
        MOV     AH,HANFORC      ; Do the redirection.
        MOV     BX,CS:HANDLE    ; The output file.
        MOV     CX,STDPRN       ; The original printer.
        INT     DOSINT
        JNC     REDIR1
;
        MOV     AH,HANCLOS      ; Attempt to close the duplicate of 
        MOV     BX,CS:OLD_PRN   ;     the original prn.
        INT     DOSINT          ; Ignore any error.
        MOV     AH,HANCLOS      ; Attempt to close the printer
        MOV     BX,CS:HANDLE    ;     redirection file.
        INT     DOSINT          ; Ignore any error.
        MOV     AL,REDI_ER
        MOV     [SI],AL         ; Store the status in the memory variable.
        RET
;
REDIR1: MOV     CS:ACTIVE,-1    ; Active flag set true - redirection exists.
        MOV     AL,SUCCESS
        MOV     [SI],AL         ; Store the status in the memory variable.
        RET
;
;----------------------------------------------------------------------------
;
MAIN    ENDP
CSEG    ENDS
        END
;
;----------------------------------------------------------------------------
;                           *** Note ***
;
; This test is an attempt to check that the call to Say2File.BIN included a
; parameter.  Without one, Say2File.BIN could return a result to an unknown
; location.  Segment register DS = 0 seems to be true any time dBASE III
; PLUS calls a .BIN module and no variable is passed.  Since this is not
; documented, this apparent fact could change in any future release.  It
; is also possible that it may not always be a faithful test for the
; existence of a parameter.  
;
; I justify including this test in this module because it works.
