
Function Main()
  LOCAL oReport, nCount := 0

  // open our sample database  
  use SERVICES alias SERVICES via "DBF"
  SERVICES->( dbGoTop() )

  // create the report object
  oReport := ReportNew( { "Sample Report from Reporter Class" } )

  // make some minor adjustments
  oReport:Portrait := .T.  // Portrait orientation
  oReport:Compressed := .F.    // NOT Compressed print
  oReport:GrayBar := .T.   // Gray Bar
  oReport:lCursorBar := .F.

  // add the columns
  oReport:AddColumn( { "Service", "Activity" }, {|| SERVICES->DESCRIPT } )
  oReport:AddColumn( "Interval", {|| SERVICES->INTERVAL } )
  oReport:AddColumn( "Schd", {|| SERVICES->SCHEDULED }, .T. )   // rotate the header

  // loop thru the dbf
  do while .not. SERVICES->( eof() )
    
    nCount++
    oReport:PrintLine()  // print a line of the report

    SERVICES->( dbSkip() )

  enddo

  // print the total count
  oReport:PrintLine( { "Total: " +alltrim( str( nCount, 5, 0 ) ) } )

  // done, display and/or print it!
  oReport:Close()

return NIL
  