/*
    John Agusta, February 8, 1992

    REPLTEST.PRG
           Minimum code to test the REPLALL() function.
           Run REPLTEST.EXE from any subdirectory

    Compile instructions:

               clipper repltest /n /w

    Link instructions:

               rtlink fi repltest

*/

Function Main()
LOCAL	aStruc	// Array defining structure for test databases

Clear Screen

// Check to see if test databases exist
If File("Name.dbf") .or. File("Inactive.dbf")
   ? "Name.dbf or Inactive.dbf exist in current directory"
   ? "Unable to run test replace program.  Try running in a"
   ? "different directory.  Press any key to quit"
   Inkey(0)
   Return NIL
Endif

// Define database structure in array
aStruc := {{"LNAME", "C", 20, 0} , ;
          {"FNAME", "C", 15, 0} , ;
          {"AGE", "N", 3, 0} , ;
          {"GENDER", "C", 1, 0}}

// create NAME.DBF on-the-fly with DBCREATE()
dbcreate("NAME", aStruc)
USE Name

APPEND BLANK
Name->LName  := "Smith"
Name->FName  := "John"
Name->Age    := 27
Name->Gender := "M"

APPEND BLANK
Name->LName  := "Mouse"
Name->FName  := "Mickey"
Name->Age    := 51
Name->Gender := "M"

? "NAME.DBF as it exists"
NAME->(dbGoTop())  // Reposition to top of file in NAME.DBF
DO WHILE !Name->(EOF())
   ? NAME->FName, NAME->LName, NAME->Age, NAME->Gender
   SKIP ALIAS NAME
ENDDO

NAME->(dbGoTop())  // Reposition to top of file in NAME.DBF

// create INACTIVE.DBF on-the-fly with DBCREATE()
dbcreate("INACTIVE", aStruc)
USE INACTIVE NEW

APPEND BLANK
ReplAll("NAME", "INACTIVE")  // Copy record to INACTIVE.DBF

SKIP ALIAS NAME	             // Skip to next record in NAME.DBF
INACTIVE->(dbAppend())       // Append a new record in INACTIVE.DBF
ReplAll("NAME", "INACTIVE")  // Copy record to INACTIVE.DBF

? "INACTIVE.DBF after copying records from NAME.DBF using REPLALL()"
INACTIVE->(dbGoTop())  // Reposition to top of file in NAME.DBF
DO WHILE !INACTIVE->(EOF())
   ? INACTIVE->FName, INACTIVE->LName, INACTIVE->Age, INACTIVE->Gender
   SKIP ALIAS INACTIVE
ENDDO

Close Name
Close Inactive

// Delete test files
FErase("Name.dbf")
FErase("Inactive.dbf")

RETURN NIL


#include "dbstruct.ch"

Function ReplAll(cSource, cDest)
LOCAL n,               ;   // counter
      aSourceDBS,      ;   // array for source database structure
      aDestDBS,        ;   // array for destination database structure
      nDestSubscr,     ;   // field number for destination database
      nFieldCnt            // number of fields in source database

nFieldCnt  := (cSource)->(FCount())
aSourceDBS := (cSource)->(dbStruct())
aDestDBS   := (cDest)->(dbStruct())

For n := 1 to nFieldCnt
   nDestSubscr := (cDest)->(FieldPos(aSourceDBS[n, DBS_NAME]))
   IF nDestSubscr <> 0 .and. ;
         aSourceDBS[n, DBS_TYPE] == aDestDBS[nDestSubscr, DBS_TYPE] .and. ;
         aSourceDBS[n, DBS_LEN]  == aDestDBS[nDestSubscr, DBS_LEN] .and. ;
         aSourceDBS[n, DBS_DEC]  == aDestDBS[nDestSubscr, DBS_DEC]

      (cDest)->(FIELDPUT(nDestSubscr, (cSource)->(FIELDGET(n))))
   ENDIF
Next n
return( NIL )
