*----------------------------------------------------------*
*---      Program:  PSTRU.PRG                           ---*
*---       Author:  Jeffrey Sovel                       ---*
*---                                                    ---*
*---      Purpose:  Allows user to print the structure  ---*
*---                of mulitiple files.                 ---*
*---                                                    ---*
*--- Demonstrates:  Multiple Serial Item Selection      ---*
*---                using Achoice()                     ---*
*---                                                    ---*
*---   Parameters:  None                                ---*
*----------------------------------------------------------*

*----------  Set Environment  -----------------------------*
SET TALK OFF
SET SCORE OFF

*----------  Set Up Screen  -------------------------------*
CLEAR
SET COLOR TO N+/N
@ 0,0,24,79 BOX REPLICATE(CHR(219),9)
SET COLOR TO W/RB
@ 0,0 TO 1,79
SET COLOR TO W+/RB
@ 0,28 SAY " .Dbf Structure Printer "

*----------  Display Help Information  --------------------*
WINDOW(3,2,17,26," Keys ","W/B","W+/R")
SET COLOR TO W/B
FOR I = 4 TO 15 STEP 2
@ I,2 SAY CHR(179) + SPACE(23) + CHR(179)
@ I+1,2 SAY CHR(195) + REPLICATE(CHR(196),23) + CHR(180)
@ I,14 SAY CHR(179)
@ I+1,14 SAY CHR(197)
NEXT
@ 5,2 SAY CHR(198) + REPLICATE(CHR(205),23) + CHR(181)
@ 5,14 SAY CHR(216)
@ 16,14 SAY CHR(179)
@ 17,14 SAY CHR(193)

SET COLOR TO R+/B
@ 04,3 SAY "   Press"
@ 06,3 SAY "Cursor Keys"
@ 08,3 SAY "  <Enter> "
@ 10,3 SAY "    <A>  "
@ 12,3 SAY "    <C>  "
@ 14,3 SAY "   <F10>  "
@ 16,3 SAY "   <Esc>  "

SET COLOR TO GR+/B
@ 04,16 SAY "    To"
@ 06,16 SAY "  Move   "
@ 08,16 SAY "Tag/UnTag"
@ 10,16 SAY " Tag All "
@ 12,16 SAY "  Clear  "
@ 14,16 SAY "  Print  "
@ 16,16 SAY "  Quit   "

*---  Load Arrays with Directory/.Dbf File information  ---*
DNUM = ADIR("*.DBF")

IF DNUM == 0
  CLEAR
  ? "SORRY, NO DBF's FOUND"
  QUIT
ENDIF

DECLARE DBFNAME[DNUM], FINC[DNUM], DBFS[DNUM]
ADIR("*.DBF",DBFNAME)
AFILL(FINC,"   ")
FOR I = 1 TO DNUM
DBFS[I] = FINC[I] + " " + DBFNAME[I]
NEXT

*----------  Sort the File Name Array  --------------------*
ASORT(DBFNAME)

*---  Display File Names in a Dynamically Sized Window  ---*
DMAX = MIN(22,DNUM+3)
WINDOW(3,45,DNUM+5,65," Databases ","R+/W","W+/R")
SET COLOR TO B/W,N/GB
OLDPICK = 1
CURRENT = 1
NEXTFLD = 1
DO WHILE LASTKEY() <> -9 .AND. LASTKEY() <> 27
FOR I = 1 TO DNUM
DBFS[I] = FINC[I] + " " + DBFNAME[I]
NEXT
ACHOICE(5,47,DMAX+1,62,DBFS,"","PICKFUNC",OLDPICK,CURRENT)
ENDDO

IF LASTKEY() = 27
SET COLOR TO
@ 23,0 CLEAR TO 24,79
@ 24,0
RETURN
ENDIF

*--------  Print the Structures  --------------------------*
WINDOW(10,30,14,50," Now Printing ","W/RB","RB/W")
SET COLOR TO *W+/RB
FOR I = 1 TO NEXTFLD - 1
II = STR(I,3)
X = ASCAN(DBFS,II)
@ 12,40-(LEN(DBFNAME[X])/2) SAY DBFNAME[X]
USE (DBFNAME[X])

*---  Put Field Information Into Arrays  ---*
F = FCOUNT()
DECLARE FLNAME[F], FTYPE[F],FSIZ[F], FDEC[F], FLDS[F],
AFIELDS(FLNAME, FTYPE, FSIZ, FDEC)

*---  Combine the Field Information into a  ---*
*---  Single Array for Easier Viewing       ---*
FOR J = 1 TO F
L = LEN(TRIM(FLNAME[J]))
FLDS[J] = FLNAME[J] + SPACE(12-L) + FTYPE[J] + ;
   "   " + STR(FSIZ[J],3) + "  " + STR(FDEC[J],2)
NEXT
ASORT(FLDS)
DO PRNTSTRU
NEXT
SET COLOR TO
@ 23,0 CLEAR TO 24,79
@ 24,0
*----------------------------------------------------------*
FUNCTION WINDOW
PARAMETER BTOP, BLEFT, BBOT, BRIGHT, BSTR, COLOR1, COLOR2

SET COLOR TO
@ BTOP+1, BLEFT+2 CLEAR TO BBOT+1,BRIGHT+2
SET COLOR TO &COLOR1
@ BTOP, BLEFT CLEAR TO BBOT,BRIGHT
@ BTOP, BLEFT TO BBOT,BRIGHT
SET COLOR TO &COLOR2
@ BTOP,BLEFT+((BRIGHT-BLEFT)/2)-(LEN(BSTR)/2) + 1 SAY BSTR
RETURN .T.
*----------------------------------------------------------*
FUNCTION PICKFUNC
PARAMETERS MESSAGE, CURRENT, RELATIVE
RTN = 2

LKEY = LASTKEY()
DO CASE
*--------------------------------------------------------*
CASE LKEY = -9 .OR. LASTKEY() = 27               &&  <F10>
RTN = 0
*--------------------------------------------------------*
CASE LKEY = 13                                 &&  <Enter>
IF EMPTY(FINC[CURRENT])
FINC[CURRENT] = TRANSFORM(NEXTFLD,"999")
OLDPICK = CURRENT
NEXTFLD = NEXTFLD + 1
CURPOS = RELATIVE
RTN = 0
ELSE
THISONE = FINC[CURRENT]
FINC[CURRENT] = "   "   &&  BLANK OUT CURRENT CHOICE
NEXTFLD = NEXTFLD - 1   &&  DECREMENT NEXTFLD VAR
FOR I = 1 TO DNUM
IF FINC[I] < THISONE
*--- STAY THE SAME ---*
DBFS[I] = FINC[I] + " " + DBFNAME[I]
ELSE
*--- ADJUST THE ORDER ---*
FINC[I] = STR(VAL(FINC[I])-1,3)
DBFS[I] = FINC[I] + " " + DBFNAME[I]
ENDIF
NEXT
OLDPICK = CURRENT
RTN = 0
ENDIF
*--------------------------------------------------------*
CASE LKEY = 67 .OR. LKEY = 99               &&  <C> or <c>
AFILL(FINC,"   ")                         &&  Clear
NEXTFLD = 1
OLDPICK = CURRENT
CURPOS = RELATIVE
RTN = 0
*--------------------------------------------------------*
CASE LKEY = 65 .OR. LKEY = 97               &&  <A> or <a>
FOR I = 1 TO DNUM
FINC[I] = STR(I,3)
DBFS[I] = FINC[I] + " " + DBFNAME[I]
NEXT
NEXTFLD = DNUM + 1
OLDPICK = CURRENT
CURPOS = RELATIVE
RTN = 0
*--------------------------------------------------------*
ENDCASE
RETURN RTN
*----------------------------------------------------------*
PROCEDURE PRNTSTRU

SET PRINT ON
SET CONSOLE OFF
? REPLICATE("=",79)
? "==" + SPACE(26) + ".dbf Structure Printer"
?? SPACE(27) + "=="
? "=="  + SPACE(75) + "=="
? "==    File: " + DBFNAME[X] + SPACE(12-LEN(DBFNAME[X]))
?? TRANSFORM(RECCOUNT(),"999,999,999")
?? " Records       Last Updated: " + DTOC(LUPDATE())
?? "     =="
? REPLICATE("=",79)
?
TITLE = "Fld Name  Type Size Dec"
ULTITLE = "-----------------------"
? TITLE + "     " + TITLE + "     " + TITLE
? ULTITLE + "     " + ULTITLE + "     " + ULTITLE
COL = 1
FOR Z = 1 TO F
DO CASE
CASE COL = 1
? FLDS[Z]
CASE COL = 2 .AND. Z <= F
?? "     " + FLDS[Z]
CASE COL = 3 .AND. Z <= F
?? "     " + FLDS[Z]
ENDCASE
COL = IIF(COL = 3,1,COL + 1)
NEXT
SET PRINT OFF
SET CONSOLE ON
EJECT
RETURN
