/*
   Kevin J. Stricklin  71117,1437
   3/21/91

   Based on an upload by Hugh Hemington, 72447-3475   LASENV.ZIP

   I took his code and changed it a little to make it easier to support 
   more printer types.  I included methods to print on a Toshiba P351sx,
   Epson, Epson LQ, and PCL4 compatible printers.  My idea was to create 
   a printer specific character string and position it using standard
   Clipper positioning.  On the printers I have supported, it prints a
   string of graphics just like it would a string of characters.

   Written in v5.0.  Except for syntax should work in Summer'87.

   compile with  /n
*/
   
function bar
   set print on
   set console off

   ? 'Example PostNet bar code'
   ? 'This is the zip        : 29607-3464'
   ? 'This is Psuedo Bar Code: ' + PsuedoBar('296073464')
   ? 'This is the real thing : ' + PostNet('29607-3464', 'Epson')

   eject

   set console on
   set print off
return NIL   


//  check for valid looking zipcode (ie: $ '123456789' .and. len(zc) == 9 )

function PostNet( cZipCode, cPrinter )
   local cZipBar := '', pZipBar := ''
   
   cZipCode := trim(strtran(cZipCode, '-'))

   if len(cZipCode) == 9

      pZipBar := PsuedoBar( cZipCode )

      cZipBar := PrinterBar(pZipBar, cPrinter)

   endif
return (cZipBar)


/*  Function argument is a 9 character string,
    returns a psuedo barcode (ie: 1 00011 00101 00110 etc... 1 )

    0 represents a short bar; 1 represents a tall bar
*/

function PsuedoBar ( cZipCode )
   local counter, EdCode := 0, cdigit,;
         rtn_code := '1' // Starting Tall Bar

   for counter = 1 to 10
      if counter < 10   //  generate Error detection Code
         EdCode += val(substr(cZipCode, counter, 1))
      else
         cZipCode += if(right(str(EdCode,2),1) == '0', '0',;  //else
                        str((val(left(str(EdCode,2),1))+1)*10-EdCode,1))
      endif
      cdigit := substr(cZipCode, counter, 1)
      do case
         case cDigit == '1'
            rtn_code += '00011'
         case cDigit == '2'
            rtn_code += '00101'
         case cDigit == '3'
            rtn_code += '00110'
         case cDigit == '4'
            rtn_code += '01001'
         case cDigit == '5'
            rtn_code += '01010'
         case cDigit == '6'
            rtn_code += '01100'
         case cDigit == '7'
            rtn_code += '10001'
         case cDigit == '8'
            rtn_code += '10010'
         case cDigit == '9'
            rtn_code += '10100'
         otherwise
            rtn_code += '11000'
      endcase
   next
   rtn_code += '1' // Ending Tall Bar
return (rtn_code)


/* This function accepts a Psuedo Bar Code and a printer emulation.
   Returns a printer specific bar code.   */

function PrinterBar( pZipBar, cPrinter )
   local cZipBar, counter

   do case
      case cPrinter == 'Toshiba'
         // 180 dpi, 4 bytes per column, bars 3 col wide, space 5 col wide
         // tall bar 24 pins high, short bar 12 pins high
         cZipBar := chr(27)+';0416'  // start 180dpi graphics, send 416 cols
         for counter = 1 to 52
            if substr(pZipBar,counter,1) == '1'
               cZipBar += replicate(chr(63),12)  // 3 full height bars
            else
               cZipBar += chr( 0)+chr( 0)+chr(63)+chr(63)+;  // 3
                          chr( 0)+chr( 0)+chr(63)+chr(63)+;  // half height
                          chr( 0)+chr( 0)+chr(63)+chr(63)    // bars
            endif
            cZipBar += replicate( chr(0), 20 ) // 5 empty bars
         next

      case cPrinter == 'EpsonLQ'
         // 180 dpi, 3 bytes per column, bars 3 col wide, space 5 col wide
         // tall bar 24 pins high, short bar 12 pins high
         cZipBar := chr(27)+'*'+chr(39)+chr(160)+chr(1) // start 180dpi graphics,
                                                        // send 416 cols
         for counter = 1 to 52
            if substr(pZipBar,counter,1) == '1'
               cZipBar += replicate(chr(255),9)
            else
               cZipBar += chr( 0)+chr(15)+chr(255)+;
                          chr( 0)+chr(15)+chr(255)+;
                          chr( 0)+chr(15)+chr(255)
            endif
            cZipBar += replicate( chr(0), 15 )
         next

      case cPrinter == 'Epson'
         // 120 dpi, 1 byte per column, bars 2 col wide, space 4 col wide
         // tall bar 8 pins high, short bar 4 pins high
         cZipBar := chr(27)+'L'+chr(56)+chr(1) // start 120 dpi graphics,
                                                // send  312 cols
         for counter = 1 to 52
            if substr(pZipBar,counter,1) == '1'
               cZipBar += chr(255) + chr(255)
            else
               cZipBar += chr(15)  + chr(15)
            endif
            cZipBar += replicate( chr(0), 4)
         next

      case cPrinter == 'PCL4'
         // 300 dpi, vector graphics, bars 6 dots wide, spaces 8 dots wide
         // tall bars 40 dots high, short bars 16 dots high
         cZipBar := chr(27) + '*p-40Y'//move from baseline to top of char box
         for counter = 1 to 52
            if substr(pZipBar,counter,1) == '1'
               cZipBar += chr(27) + '*c6a40b0P'
            else
               // 6 wide, 16 high, solid black 
               cZipBar += chr(27) + '*p+24Y'  //move down to start short bar
               cZipBar += chr(27) + '*c6a16b0P'
               cZipBar += chr(27) + '*p-24Y'  //move up to start all chars
            endif
            cZipBar += chr(27) + '*p+14X'   //move 14 dots right
         next
         cZipBar += chr(27) + '*p+40Y' //move cursor back to baseline
      endcase
return (cZipBar)
