/*********************************************************progmetr.prg
*  Function prog_meter(nCount,nTotal,nColorCode,lDisplay,cDisplaycolor)
*
*  Purpose: Display horizontal progress meter on line 25
*           non-destructively to allow messages to display on same line.
*
*           Modeled after similar function by Artful Applications
*           written in "C".  This one is rewritten in pure Clipper.
*
*
*  Paramenters:
*						nCount   	->		Current item in progress
*						nTotal    	->		Total to be processed
*						nColorcode	->		Color number
*						lDisplay  	->		Boolean to control display of "(xx%)"
*                                   completion dispaly in column 75
*                 cDispcolor  ->    Color string for lDisplay
*
*
*
* Written by Rick Newton CIS 75517,2410
*
* Placed into the public domain.  Drop me a line and tell me what you
* think.
*
*********************************************************************/


// Demo calling function below:


SET CURSOR OFF
@ 0,0,maxrow(),maxcol() BOX REPL(CHR(176),9) COLOR "b/w"
@ MAXROW(),0 SAY PADR("Counting...please wait",80," ") COLOR "gr+/bg"
FOR i = 1 to 10000
	prog_meter(i,10000,,,"gr+/bg")
NEXT i

/*
  Will also work with INDEX ON in EVAL clause
*/




FUNCTION prog_meter(nCount,nTotal,nColorCode,lDisplay,cDispcolor)
LOCAL nCol    := nCount/nTotal*80
LOCAL nMaxRow := MAXROW()

ldisplay   := IIF(lDisplay==NIL,.f.,ldisplay)
nColorCode := IIF(nColorCode==NIL,79,nColorCode)
IF lDisplay
    @ nMaxrow,74   SAY "(   %)" COLOR cDispcolor
    @ nMaxrow,75 SAY TRAN(nCount/nTotal*100,"999") COLOR cDispcolor
ENDIF

// This is what does all the work.  We save the screen, change the
// color attribute to the nColorcode passed, then restore it.
// The rectangle saved and restored changes size based on the
// value of nCol, which is a LOCAL calculated from first 2 parameters
// passed in.  It is very similar to a the window shadow functions
// you see all over the place.

RESTSCREEN(nMaxrow,0,nMaxrow,nCol,;
      TRANSFORM( SAVESCREEN(nMaxrow,0,nmaxrow,nCol), ;
      REPLICATE("X"+CHR(nColorCode), ncol-0+1 ) ) )
RETURN .t.
