*===============================================================*
*
*   ProDemo.Prg:  Demonstration of a PROFILER.
*
*        Author:  Craig Yellick, Alto Microcomputer, Inc.
*                 7107 Ohms Lane, Minneapolis, Minnesota 55435
*                 Voice (612) 835-1080; CIS 76247,541
*
*          Note:  Uses Clipper 5.0-specific syntax.
*
*  Compile PROFILER.PRG and PRODEMO.PRG, then link:
*
*  rtlink file prodemo, profiler lib clipper, extend
*
*---------------------------------------------------------------*
*
*  No copyrights, no restrictions, no nothin'.
*
*---------------------------------------------------------------*


***  Delete this definition to have preprocessor remove
*    calls to PROFILE()
*
#define TESTING


***  If TESTING is defined, convert simple calls to PROFILE
*    into calls with standard info.
*
#ifdef TESTING
  #define PROFILE(comment)  Profile(comment, ;
                            procname(), procline(), readvar())
#endif


***  "ifndef" checks for something NOT defined,
*    so if TESTING isn't defined, the calls to PROFILE
*    will be completely eliminated from the code.
*
#ifndef TESTING
  #define PROFILE()
#endif


***  Let's get things rolling by taking a snap shot
*    of our start-up conditions.
*
Profile("Initial Load From DOS")


@ 0,0 clear
@ 1,0 say "ProDemo.Exe:  Demonstration of a PROFILER by Craig Yellick."


***  Designate a "hot-key" to call the profiler
*    from any wait-state.
*
set key 376 to PrfKey  // 376 is Alt-1


***  Watch the available memory drop as this
*    function is called repeatedly.
*
@ 4,0 say "Calling a memory-chewing function 20 times..."
@ 5,0
for i= 1 to 20
  ?? chr(250)
  Hog(ltrim(str(i)))
next i


@ 7,0 say "Inserting a few manual calls to the profiler..."
PROFILE("First manual call")
PROFILE("Another manual call")


***  Since we established a "hot-key", pressing it
*    during the READ will create an entry in the
*    profiler output file.
*
abc:= space(10)
@ 8, 0 say "Press ENTER to continue."
@ 9, 0 say "Press ALT-1 to invoke profiler via hot-key. " get abc
read


***  Make a few more calls before exiting
*
Hog("X")
Hog("Y")
Hog("Z")

@ 11, 0 say "The file PROFILER.TXT contains the results of this demonstration."
@ 12, 0 say "Exiting to DOS."
@ 14, 0

PROFILE("Exiting to DOS")

quit

* end proc ProDemo2
*---------------------------------------------------------------*

function Hog
*
*  A function that chews up memory.
*
parameter c
public hog_&c.
hog_&c.:= space(10000)
PROFILE("Hog(" +c +")")
return ""

*===============================================================*
* eof ProDemo2.Prg
