************
* q.prg
* written by Eric Eisenhower to demonstrate spooler routines in PrintQ.asm
************
PRIVATE scr,opt,temp,fcount
SCR=SPACE(4096)
SAVE SCREEN TO scr
CLEA
fcount=ShowF()
opt=0
IF MajorDos() < 3
	WAIT "Dos version 3.00 or greater is required"
	RETURN
ENDIF
IF !SpoolInst()
	Wait "Spooler not installed"
	RETURN
ENDIF
DO WHILE .t.
	@ 4,70 SAY "Choose:"
	@ 5,70     PROMPT "DISPLAY  "
	@ 6,70     PROMPT "ADD      "
	IF fcount#0
		@ 7,70 PROMPT "KILL FILE"
		@ 8,70 PROMPT "KILL ALL "
	ELSE
		@ 7,70 SAY "KILL FILE"
		@ 8,70 SAY "KILL ALL"
	ENDIF
	opt=0
	MENU TO opt
	DO CASE
		CASE opt=0
			EXIT
		CASE opt=1
			fcount=ShowF()
		CASE opt=2
			temp=SPACE(64)
			@ 24,0 SAY "FILE? " GET temp
			READ
			@ 24,0
			IF !EMPTY(temp)
				HandErr(Spool(Trim(temp)))
				fcount=ShowF()
			ENDIF
		CASE opt=3
			temp=GetF()
			IF !EMPTY(temp)
				HandErr(SpoolCanc(temp))
			ENDIF
			fcount=ShowF()
		CASE opt=4
			SpoolKill()
			fcount=ShowF()
	ENDCASE
ENDDO
RESTORE SCREEN FROM scr
RETURN


FUNCTION SHOWF
PRIVATE i,temp
i=0
@ 4,0 CLEA
@ 4,0 SAY "Currently printing:"
DO WHILE .t.
    temp=SpoolQ(i)
    IF !EMPTY(temp)
    	@ 5+i,0 SAY TEMP
    ELSE
    	EXIT
    ENDIF
    i=i+1
ENDDO
@ 5+i+1,0 SAY LTRIM(STR(i))+" files in queue"
@ 5+i+2,0 SAY IIF(SpoolErr()#0,"Errors indicate that the spooler may be off-line","")
RETURN(i)

FUNCTION HandErr
PARA temp
IF TEMP=0
	RETURN(.t.)
ELSE
	DO CASE
		CASE temp=1
			@ 24,0 SAY "Invalid function"
		CASE temp=2
			@ 24,0 SAY "File not found"
		CASE temp=3
			@ 24,0 SAY "Path not found"
		CASE temp=4
			@ 24,0 SAY "Too many open files"
		CASE temp=5
			@ 24,0 SAY "Access denied"
		CASE temp=8
			@ 24,0 SAY "Queue full"
		CASE temp=9
			@ 24,0 SAY "Spooler busy"
		CASE temp=12
			@ 24,0 SAY "Name too long"
		CASE temp=15
			@ 24,0 SAY "Invalid Drive"
		OTHERWISE
			@ 24,0 SAY "Unknown Error: "+LTRIM(STR(temp))
	ENDCASE
	INKEY(0)
	RETURN(.f.)
ENDIF
RETURN(.t.)

FUNCTION GetF
PRIVATE i,temp
DECLARE q[32]
i=0
@ 4,0 CLEA
@ 4,0 SAY "Select file to kill from queue"
DO WHILE .t.
    temp=SpoolQ(i)
    IF !EMPTY(temp)
    	q[i+1]=TEMP
    	@ 5+i,0 PROMPT TEMP
    ELSE
    	EXIT
    ENDIF
    i=i+1
ENDDO
@ 5+i+1,0 SAY LTRIM(STR(i))+" files in queue"
@ 5+i+2,0 SAY IIF(SpoolErr()#0,"Errors indicate that the spooler may be off-line","")
IF i#0
	i=0
	MENU to i
ENDIF
IF i#0
	RETURN(TRIM(q[i]))
ELSE
	RETURN("")
ENDIF
RETURN("")
