.XLIST
PAGE ,132
TITLE "PrintQ.ASM -> Assembly routines for Clipper"
.XALL
.LIST
;------------------------------------------------------------------------------
; Filename: PrintQ.ASM
; Date....: January, 1988
; Author..: Eric Eisenhower 
; Notes...: User-defined dBASE functions in 8086 assembly for Clipper.
;
; Spooler functions only work with DOS >= 3.00:
;	SpoolInst() ::= True if print spooler installed.
;	SpoolQ()    ::= Returns files in the print queue.
;	SpoolKill() ::= Clears the print queue, and returns 0.
;	SpoolErr()  ::= Returns spooler error count.
;	Spool()     ::= Spit a file into the print queue.
;	SpoolCanc() ::= Cancel a file in the print queue.
;	SpoolGo     ::= Resume printing after a hold be SpoolQ()
;
; Generic DOS functions:
;	MajorDos()  ::= Returns major dos version level (3.? returns 3)
;	MinorDos()  ::= Returns minor dos version level (3.1 returns 1)


	PUBLIC SpoolInst
	PUBLIC SpoolQ
	PUBLIC SpoolKill
	PUBLIC SpoolErr
	PUBLIC Spool
	PUBLIC SpoolCanc
	PUBLIC SpoolGo
	PUBLIC MajorDos
	PUBLIC MinorDos

; Clipper return value calls

	EXTRN	_PARINFO:FAR	; fetch info on paramaters passed to me
	EXTRN	_PARC:FAR	; fetch character string
	EXTRN	_PARDS:FAR	; fetch date type from date string "YYYYMMDD"
	EXTRN	_PARL:FAR	; fetch logical true or false
	EXTRN	_PARNI:FAR	; fetch word as numeric
	EXTRN	_PARNL:FAR	; fetch double word as numeric
	EXTRN	_PARND:FAR	; fetch floating point as numeric

	EXTRN	_RETC:FAR	; return character string
	EXTRN	_RETDS:FAR	; return date type from date string "YYYYMMDD"
	EXTRN	_RETL:FAR	; return logical true or false
	EXTRN	_RETNI:FAR	;return word as numeric
	EXTRN	_RETNL:FAR	; return double word as numeric
	EXTRN	_RETND:FAR	; return floating point as numeric

; Macroes

CallDos MACRO	dosfunc		;Call dos
	MOV	AH,dosfunc
	INT	21h
	ENDM

GetChar MACRO	num		;Get character parameter
	MOV	AX,num		;Get parameter <num> by
	PUSH	AX		;putting <num> on the stack
	CALL	_PARC		;Get character parameter
	ADD	SP,2		;Fix up stack
	ENDM			;AX:BX points to ASCIIZ string

RestR	MACRO		;Restore registers
	POP	ES
	POP	DS
	POP	BP
	ENDM

RetInt  MACRO   Reg	;Return Integer
	PUSH	Reg
	CALL	_RETNI
	POP	Reg
	ENDM


RetLog	MACRO	Reg	;Return logical value
	PUSH	Reg
	CALL	_RETL	; return logical value to Clipper
	POP	Reg
	ENDM

SendCh	MACRO	chr	;Send a char to serial card
	LOCAL	TOP
	MOV	DX,SERIAL+5
TOP:
	IN	AL,DX
	TEST	AL,20h
	JZ	TOP
	MOV	AL,chr
	MOV	DX,SERIAL
	OUT	DX,AL
	ENDM

SaveR	MACRO		;Save registers
	PUSH	BP
	MOV	BP,SP
	PUSH	DS
	PUSH	ES
	ENDM

Spooler MACRO SpoolFunc
	MOV	AH,01
	MOV	AL,SpoolFunc
	INT	47
	ENDM


DGROUP	GROUP	DATASG	;Clipper's Data Segment

; the 'public' in the next statement combines the datasg
; to Clipper's DGROUP group
DATASG	SEGMENT	PUBLIC	'DATA'

;spooler packet
PLEV	DB	0		; Spooler packet level
POFF	DW	0		; ASCIIZ offset of character parameters
PSEG	DW	0		; ASCIIZ segment of character parameters

DATASG	ENDS			; end of datasg (in DGROUP)

_PROG	SEGMENT

	ASSUME	CS:_PROG,DS:DGROUP,ES:DGROUP


;------------------------------------------------------------------------------
;  SpoolInst()
;  Syntax: SpoolInst()
;  Return: Logical true print spooler was installed

SpoolInst PROC FAR
	SaveR

	Spooler	00		; get installed status
	CMP	AL,0FFh		; FF if spooler installed
	MOV	BX,1		; TRUE
	JZ	SHORT SPR
	MOV	BX,0
SPR:
	RestR

	RetLog  BX

	RET

SpoolInst ENDP

;------------------------------------------------------------------------------
;  SpoolQ()
;  Syntax: SpoolQ(n)
;	where n=offset from top of queue. 0 = file currently printing
;  Return: Returns contents of print queue.
;  NOTE: Queue is frozen until call is made to SpoolGo()
;        A call to spoolinst will be sufficient to resume printing .
;        PLEASE do not call this routine if SpoolInst() does not return
;        a true value.  I cannot guarentee what might happen.
;        Returns a null if queue slot is empty

SpoolQ	PROC FAR
	SaveR

	MOV	AX,1		;Get parameter 1 by
	PUSH	AX		;putting 1 on the stack
	CALL	_PARNI		;Get numeric parameter in AX
	ADD	SP,2		;Fix up stack
	PUSH	AX		; Save it temporarily

	Spooler	04		; get queue contents

	POP	AX		; restore numeric parameter
	PUSH	DS		; Save pointer to queue
	PUSH	SI
         
	MOV	BX,4		; multiply parameter to get para offset
	MUL	BX

	POP	DX
	POP	CX
	ADD	CX,AX

	RestR

	PUSH	CX		; put return value on the stack
	PUSH	DX
	CALL	_RETC		; return Character value to Clipper
	POP	BX		; restore the stack
	POP	BX

	RET

SpoolQ   ENDP

;------------------------------------------------------------------------------
;  SpoolKill()
;  Syntax: SpoolKill()
;  Return: Clears the print queue and returns 0.

SpoolKill PROC FAR
	SaveR

	Spooler	03		; clear queue
	MOV	BX,0

	RestR

	RetInt	BX

	RET

SpoolKill ENDP

;------------------------------------------------------------------------------
;  SpoolErr()
;  Syntax: SpoolErr()
;  Return: Returns spooler error count
;  Note: All print functions are frozen till SpoolGo() is called.

SpoolErr PROC FAR
	SaveR

	Spooler	04		; get queue contents

	RestR

	RetInt	DX

	RET

SpoolErr ENDP

;------------------------------------------------------------------------------
;  Spool()
;  Syntax: Spool("D:\PATH\FILENAME")
;  Return: 0, or spooler error code

Spool	PROC FAR
	SaveR
	GetChar	1

	MOV	PLEV,0
	MOV	PSEG,AX
	MOV	POFF,BX
	LEA	DX,DGROUP:PLEV
	Spooler	01		; submit file

	JC	SHORT LEAVESP
	MOV	AX,0 

LEAVESP:
	RestR
	RetInt	AX
	RET

Spool   ENDP

;------------------------------------------------------------------------------
;  SpoolCanc()
;  Syntax: SpoolCanc("D:\PATH\FILENAME")
;  Return: 0, or spooler error code

SpoolCanc PROC FAR
	SaveR
	GetChar	1

	MOV	DS,AX		; point to file to be killed
	MOV	DX,BX
	Spooler	02		; cancel file
	JC	SHORT LEAVEC	; If error, return the code
	MOV	AX,0		; Set return value to 0

LEAVEC:
	RestR
	RetInt	AX
	RET

SpoolCanc ENDP

;------------------------------------------------------------------------------
;  SpoolGo()
;  Syntax: SpoolGo()
;  Return: Returns error code from spooler.  Should always be 0.

SpoolGo  PROC FAR
	SaveR

	Spooler	05		; end hold
	JC	SHORT LEAVESG
	MOV	AX,0

LEAVESG:
	RestR
	RetInt	AX
	RET

SpoolGo ENDP

;------------------------------------------------------------------------------
;  MajorDos()
;  Syntax: MajorDos()
;  Return: Integer representing major dos version number

MajorDos PROC FAR
	SaveR

	CallDos	30h	; Get dos ver
	MOV	BX,00		; Clear return value
	MOV	BL,AL		; Move version number to BX

	RestR
	RetInt	BX
	RET

MajorDos ENDP

;------------------------------------------------------------------------------
;  MinorDos()
;  Syntax: MinorDos()
;  Return: Integer representing Minor dos version number

MinorDos PROC FAR
	SaveR

	CallDos	30h		; Get dos ver
	MOV	BX,00		; Clear return value
	MOV	BL,AH		; Move minor number to BX

	RestR
	RetInt	BX
	RET

MinorDos ENDP


_PROG ENDS

	END

; EOF PrintQ.asm -----------------------------------------------------------
