/*
**͸
**
**      File: prglist.c
**
**        By: Marek I. Karon [CompuServe 72400,2726]
**            (c) Copyright 1991-93 Marek I. Karon
**            Executable and source code may be used and
**            distributed at no charge only. No warranties or
**            liabilities of any kind accepted. Comments welcome.
**
**     Using: Borland Turbo C++ 3.0
**            FUNCky II library
**            Blinker 2.01 linker
**            Pklite Professional 1.15
**
**    Update: Wed  01-13-1993  11:09
**
**   Purpose: listing of .prg files in directory or
**            other text files with byte and line count. If binary
**            files are included the line count will be meaningless.
**            Assumes all files are accessible and includes
**            no error checking (possible network conflicts).
**
**    Syntax: PRGLIST [FileSpec] [>device]
**            FileSpec may include optional drive,path,files,extension.
**            If none specified on the command line, the default is
**            "*.prg" that is all [.prg] files in current directory.
**            Output may be redirected to device other than the screen,
**            such as printer or disk file.
**
**;
*/

#include "\funcky\header\c\FUNCky.h"
#include <process.h>
#include <stdlib.h>
#include <io.h>

void main(int argc, char *argv[])
{
    char FileSpec[90] ;           /* filespec to process */
    char FileName[90] ;           /* single filename to process */
    char FullPath[90] ;           /* full path for each filename to process */
    char JustPath[90] ;           /* just path for each filename to process */
    char drive[3], path[65] ;     /* filespec components */
    char fname[16], ext[5]  ;     /* filespec components */
    int n = 0 ;                   /* file processed count */
    int FileHandle ;
    long TotalLines = 0, TotalBytes = 0 ;
    long lines, bytes ;
    char TempBuffer[90], TempBuffer2[90] ;

    _stdoutline( "" ) ;
    _stdoutline( "   PRGLIST ver 2.10  (01-13-93)  (c) Copyright 1991-93 Marek Karon " ) ;
    _stdoutline( "  " ) ;

    /* check if argument passed, otherwise pass default -> "*.prg" */
    if( argc < 2 )
        strcpy( FileSpec, "*.prg" );
    else
        strcpy( FileSpec, argv[1] );

    /* split filespec into valid components */
    _fsplit( FileSpec, drive, path, fname, ext);

    if( _empty(drive) )
		_curdrive(drive);

    if( _empty(path) )
		_getdir(drive, path);

    /* build back valid drive specifier */
    _fmake(drive, path, fname, ext, FileSpec);
    _fmake(drive, path, NULL, NULL, JustPath);

    _stdout("   FILES--> ") ;
    _stdoutline ( _lower(FileSpec, NULL) ) ;
    _stdoutline( "  " ) ;
    _stdoutline( "       <Name>           <Lines>     <Bytes>        <Date>   <Time> " ) ;

    _setdatef("MMMDD,YY");

    _findfirst( FileSpec, A_NORMAL, FileName ) ;

    /* process until no more files */
    DOWHILE( FileName[0] )

        /* append path to filename */
        _catstr( JustPath, FileName, FullPath ) ;

        /* file number */
        _strjustify( _itoa(++n, NULL), 5, J_RIGHT, TempBuffer );
        _stdout(TempBuffer);
        _stdout(". ");

        /* file name */
        _lower( FileName, NULL );
        _strjustify( FileName, 12, J_LEFT, TempBuffer );
        _stdout(TempBuffer);

        /* line count */
        FileHandle = _fopen( FullPath, O_READONLY ) ;
        lines = _flinecount( FileHandle ) ;
        TotalLines = TotalLines + lines ;
        _ltoa( lines, TempBuffer) ;
        _fclose( FileHandle ) ;
        _comma(TempBuffer, NULL ) ;
        _strjustify( TempBuffer, 12, J_RIGHT, TempBuffer2 );
        _stdout( TempBuffer2 ) ;

        /* file size in bytes */
        bytes = _findsize() ;
        TotalBytes = TotalBytes + bytes ;
        _ltoa( bytes, TempBuffer ) ;
        _comma( TempBuffer, NULL ) ;
        _strjustify( TempBuffer, 12, J_RIGHT, TempBuffer2 );
        _stdout( TempBuffer2 ) ;

        /* file date */
        _finddatef( TempBuffer ) ;
        _strjustify( TempBuffer, 15, J_RIGHT, TempBuffer2 );
        _stdout( TempBuffer2 ) ;

        /* file time */
        _findtime( TempBuffer ) ;
        _strjustify( TempBuffer,  8, J_RIGHT, TempBuffer2 );
        _stdoutline( TempBuffer2 ) ;

        _findnext(FileName);

    ENDDO

    _stdoutline( "  " ) ;

    _stdout( "       TOTAL:      " );

    /* print total lines */
    _ltoa( TotalLines, TempBuffer ) ;
    _comma( TempBuffer, NULL ) ;
    _strjustify( TempBuffer, 12, J_RIGHT, TempBuffer2 );
    _stdout( TempBuffer2 ) ;

    /* print total bytes */
    _ltoa( TotalBytes, TempBuffer ) ;
    _comma( TempBuffer, NULL ) ;
    _strjustify( TempBuffer, 12, J_RIGHT, TempBuffer2 );
    _stdoutline( TempBuffer2 ) ;

    exit( 0 ) ;
}

/***eof:prglist.c***/
