* ========================================================================== *
* pops.prg -- demonstration program for Clipper Summer '87 menuing.
* -------------------------------------------------------------------------- *
*
* Conventions used for variables and arrays in this program are as follows:
* ------------------------------------------------------------------------
*    scr_?     - used for saving entire screens with SAVE SCREEN TO... command
*    c_?       - predefined color string settings.
*    t,l       - base windowing coordinates.
*    mode, id  - used in PopUP procedure.
*
* --------------------------------------------------------------------------- *
* For each pull-down menu, there must be two arrays and several memvars, 
* as follow.  (Note: * in the following cases represents the menu key strokes 
* used to get to the specified procedure; []'s indicate arrays.)
*
*    m_*[]     - arrays of popup menu choices.                  (String values)
*    n_*[]     - arrays of available popup menu choices.        (Logical value)
*    a_*       - menu choice value                              (Numeric value)
*    w_*       - portions of screen saved with SaveScreen() function. (? value)
*    t_*       - top                                            (Numeric value)
*    l_*       - left                                           (Numeric value)
*    b_*       - bottom                                         (Numeric value)
*    r_*       - right                                          (Numeric value)
*
* -------------------------------------------------------------------------- *

SAVE SCREEN TO scr_DOS
DO logo

* ----------------------------------- *
* variables for color settings.       *
* ----------------------------------- *
   c_defa = SetColor()                 && - default color setting
IF IsColor()
   c_gets = "W/N,R/W,,,N/W"            && - red on white get fields
   c_pass = "W/N,X"                    && - invisable get fields
   c_says = "W/N,BG+/B,,,W/N"          && - bright cyan on blue gets.
   c_pops = "W+/N,W+/B,,,W/N"          && - see p. 6-18
ELSE
   c_gets = c_defa
   c_pass = c_defa
   c_says = c_defa
   c_pops = c_defa
ENDI
SET color TO (c_gets)

* -------------------------------------------------------------------------- *
* variables used for popup menus.     *
* ----------------------------------- *
PUBL r 
r = 10   && min. window width.

* ----------------------------------- *
* main loop here.                     *
* ----------------------------------- *
DO WHIL .T.
   DO m_ WITH 3, 3
ENDD

RETU

* -------------------------------------------------------------------------- *
PROC logo
CLEA
@ 4,10 TO 20,70 DOUBLE
INKEY(5)
RETU
* -------------------------------------------------------------------------- *
PROC PopUP
PARAMETERS mode, id
PRIVATE LvlNo, LvlPr, PrID, Word, Title

DO CASE
CASE mode = 1                          && store things going in.

   LvlNo = Len(Trim(id))               && this level number.
   LvlPr = Max( 0, LvlNo-1)            && previous level number.

   t&id  = t + LvlNo
   l&id  = l + LvlNo
   b&id  = MIN( (t&id  + Len( m&id )), 23)

   * This loop determines the width needed for the pull-down window.
   * First based upon the minimum standard window.
   r&id  = r
   FOR i = 1 TO Len( m&id )
      r&id = MAX( ( r&id ), (Len( m&id.[ i ] )) )
   NEXT
   r&id = r&id + l&id - 1

   * Then based upon the width of the parent's window.
   IF LvlPr > 0
      prid = Substr(id,1,Len(id)-1)
      r&id = MAX( r&id, r&prid + 1 )   && should be one longer than parent's.
   ENDI

   * Then based upon max. window size.
   r&id = MIN( r&id, 79)

   * This loop determines the first available option.
   a&id = 0
   FOR i = 1 TO Len( m&id )
      IF n&id.[ i ]
         a&id = i
         EXIT
      ENDI
   NEXT

   * save screen area and draw box.
   w&id  = SAVESCREEN(t&id -1,l&id -1,b&id ,r&id +1)
   @ t&id -1,l&id -1 TO b&id ,r&id +1 

   * This section writes the name of the parent menu at the top of the box.
   IF LvlPr = 0
      title = "/"
   ELSE
      title = m&prid.[ a&prid ]
   ENDI
   @ t&id -1,l&id SAY title

CASE mode = 2                          && get menu choice.
   a&id  = AChoice(t&id , l&id , b&id , r&id , m&id, n&id, "", a&id )

CASE mode = 3                          && reset the environment.
   @ t&id -1,l&id -1 CLEAR TO b&id ,r&id +1
   RestScreen(t&id -1,l&id -1,b&id ,r&id +1,w&id )

ENDC

RETU
* ========================================================================== *
* "/" menu.
PROC m_
PARA t, l
SET color TO (c_pops)

PUBL m_, n_, t_, l_, b_, r_, w_, a_
DECL m_[10] 
     m_[ 1] = "Worksheet"
     m_[ 2] = "Range"
     m_[ 3] = "Copy"
     m_[ 4] = "Move"
     m_[ 5] = "File"
     m_[ 6] = "Print"
     m_[ 7] = "Graph"
     m_[ 8] = "Data"
     m_[ 9] = "System"
     m_[10] = "Quit"
DECL n_[10] 
     n_[ 1] = .T. && "Worrksheet"
     n_[ 2] = .F. && "Range"
     n_[ 3] = .F. && "Copy"
     n_[ 4] = .F. && "Move"
     n_[ 5] = .T. && "File"
     n_[ 6] = .F. && "Print"
     n_[ 7] = .F. && "Graph"
     n_[ 8] = .F. && "Data"
     n_[ 9] = .T. && "System"
     n_[10] = .T. && "Quit"

DO PopUP WITH 1, "_"

DO WHIL .T.

   DO PopUP WITH 2, "_"

   DO CASE
    CASE a_ =  0  && {Esc}
      EXIT
    CASE a_ =  1  && "World-Wide"
      DO m_w 
    CASE a_ =  2  && "Range"
    CASE a_ =  3  && "Copy"
    CASE a_ =  4  && "Move"
    CASE a_ =  5  && "File"
      DO m_f
    CASE a_ =  6  && "Print"
    CASE a_ =  7  && "Graph"
    CASE a_ =  8  && "Data"
    CASE a_ =  9  && "System"
      SAVE SCREEN TO scr_sys
      RUN C:\command.com
      REST SCREEN FROM scr_sys
      RELE scr_sys
    CASE a_ = 10  && "Quit"
      DO m_q 
   ENDC

ENDD

DO PopUP WITH 3, "_"
RELE m_, n_, t_, l_, b_, r_, w_, a_

SET color TO (c_defa)

RETU
* ------------------------------------ *
* /Worksheet
PROC m_w

PUBL m_w, n_w, t_w, l_w, b_w, r_w, w_w, a_w
DECL m_w[ 9] 
     m_w[ 1] = "Global"
     m_w[ 2] = "Insert"
     m_w[ 3] = "Delete"
     m_w[ 4] = "Column"
     m_w[ 5] = "Erase"
     m_w[ 6] = "Titles"
     m_w[ 7] = "Window"
     m_w[ 8] = "Status"
     m_w[ 9] = "Page"
DECL n_w[ 9] 
     n_w[ 1] = .T. && "Global"
     n_w[ 2] = .F. && "Insert"
     n_w[ 3] = .F. && "Delete"
     n_w[ 4] = .F. && "Column"
     n_w[ 5] = .F. && "Erase"
     n_w[ 6] = .F. && "Titles"
     n_w[ 7] = .F. && "Window"
     n_w[ 8] = .F. && "Status"
     n_w[ 9] = .F. && "Page"

DO PopUP WITH 1, "_w"

DO WHIL .T.
  
   DO PopUP WITH 2, "_w"

   DO CASE
    CASE a_w =  0  && {Esc}
      EXIT
    CASE a_w =  1  && "Global"
      DO m_wg 
    CASE a_w =  2  && "Insert"
    CASE a_w =  3  && "Delete"
    CASE a_w =  4  && "Column"
    CASE a_w =  5  && "Erase"
    CASE a_w =  6  && "Titles"
    CASE a_w =  7  && "Window"
    CASE a_w =  8  && "Status"
    CASE a_w =  9  && "Page"
   ENDC

ENDD

DO PopUP WITH 3, "_w"
RELE m_w, n_w, t_w, l_w, b_w, r_w, w_w, a_w

RETU
* ------------------------------------ *
* /Worksheet Global
PROC m_wg

PUBL m_wg, n_wg, t_wg, l_wg, b_wg, r_wg, w_wg, a_wg
DECL m_wg[ 7] 
     m_wg[ 1] = "Format"
     m_wg[ 2] = "Label-prefix"
     m_wg[ 3] = "Column-width"
     m_wg[ 4] = "Recalculation"
     m_wg[ 5] = "Protection"
     m_wg[ 6] = "Default"
     m_wg[ 7] = "Zero"
DECL n_wg[ 7] 
     n_wg[ 1] = .T. && "Format"
     n_wg[ 2] = .T. && "Label-prefix"
     n_wg[ 3] = .F. && "Column-width"
     n_wg[ 4] = .T. && "Recalculation"
     n_wg[ 5] = .T. && "Protection"
     n_wg[ 6] = .T. && "Default"
     n_wg[ 7] = .F. && "Zero"

DO PopUP WITH 1, "_wg"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wg"
  
   DO CASE
    CASE a_wg =  0  && {Esc}
      EXIT
    CASE a_wg =  1  && "Format"
      DO m_wgF
    CASE a_wg =  2  && "Label-prefix"
      DO m_wgL
    CASE a_wg =  3  && "Column-width"
    CASE a_wg =  4  && "Recalculation"
      DO m_wgR
    CASE a_wg =  5  && "Protection"
      DO m_wgP
    CASE a_wg =  6  && "Default"
      DO m_wgD
    CASE a_wg =  7  && "Zero"
   ENDC

ENDD

DO PopUP WITH 3, "_wg"
RELE m_wg, n_wg, t_wg, l_wg, b_wg, r_wg, w_wg, a_wg

RETU
* ------------------------------------ *
* /Worksheet Global Format
PROC m_wgf

PUBL m_wgf, n_wgf, t_wgf, l_wgf, b_wgf, r_wgf, w_wgf, a_wgf
DECL m_wgf[10] 
     m_wgf[ 1] = "Fixed"
     m_wgf[ 2] = "Scientific"
     m_wgf[ 3] = "Currency"
     m_wgf[ 4] = ","
     m_wgf[ 5] = "General"
     m_wgf[ 6] = "+/-"
     m_wgf[ 7] = "Percent"
     m_wgf[ 8] = "Date"
     m_wgf[ 9] = "Text"
     m_wgf[10] = "Hidden"
DECL n_wgf[10] 
     n_wgf[ 1] = .T. && "Fixed"
     n_wgf[ 2] = .T. && "Scientific"
     n_wgf[ 3] = .T. && "Currency"
     n_wgf[ 4] = .T. && ","
     n_wgf[ 5] = .F. && "General"
     n_wgf[ 6] = .T. && "+/-"
     n_wgf[ 7] = .T. && "Percent"
     n_wgf[ 8] = .T. && "Date"
     n_wgf[ 9] = .T. && "Text"
     n_wgf[10] = .T. && "Hidden"

DO PopUP WITH 1, "_wgf"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgf"
  
   DO CASE
    CASE a_wgf =  0  && {Esc}
      EXIT
    CASE a_wgf =  1  && "Fixed"
      EXIT
    CASE a_wgf =  2  && "Scientific"
      EXIT
    CASE a_wgf =  3  && "Currency"
      EXIT
    CASE a_wgf =  4  && ","
      EXIT
    CASE a_wgf =  5  && "General"
      EXIT
    CASE a_wgf =  6  && "+/-"
      EXIT
    CASE a_wgf =  7  && "Percent"
      EXIT
    CASE a_wgf =  8  && "Date"
      EXIT
    CASE a_wgf =  9  && "Text"
      EXIT
    CASE a_wgf = 10  && "Hidden"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgf"
RELE m_wgf, n_wgf, t_wgf, l_wgf, b_wgf, r_wgf, w_wgf, a_wgf

RETU
* ------------------------------------ *
* /Worksheet Global Label-Prefix
PROC m_wgl

PUBL m_wgl, n_wgl, t_wgl, l_wgl, b_wgl, r_wgl, w_wgl, a_wgl
DECL m_wgl[ 3] 
     m_wgl[ 1] = "Left"
     m_wgl[ 2] = "Right"
     m_wgl[ 3] = "Center"
DECL n_wgl[ 3] 
     n_wgl[ 1] = .F. && "Left"
     n_wgl[ 2] = .T. && "Right"
     n_wgl[ 3] = .T. && "Center"

DO PopUP WITH 1, "_wgl"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgl"
  
   DO CASE
    CASE a_wgl =  0  && {Esc}
      EXIT
    CASE a_wgl =  1  && "Left"
      EXIT
    CASE a_wgl =  2  && "Right"
      EXIT
    CASE a_wgl =  3  && "Center"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgl"
RELE m_wgl, n_wgl, t_wgl, l_wgl, b_wgl, r_wgl, w_wgl, a_wgl

RETU
* ------------------------------------ *
* /Worksheet Global Recalculation
PROC m_wgr

PUBL m_wgr, n_wgr, t_wgr, l_wgr, b_wgr, r_wgr, w_wgr, a_wgr
DECL m_wgr[ 6] 
     m_wgr[ 1] = "Natural"
     m_wgr[ 2] = "Column-wise"
     m_wgr[ 3] = "Row-wise"
     m_wgr[ 4] = "Automatic"
     m_wgr[ 5] = "Manual"
     m_wgr[ 6] = "Iteration"
DECL n_wgr[ 6] 
     n_wgr[ 1] = .T. && "Natural"
     n_wgr[ 2] = .T. && "Column-wise"
     n_wgr[ 3] = .T. && "Row-wise"
     n_wgr[ 4] = .F. && "Automatic"
     n_wgr[ 5] = .T. && "Manual"
     n_wgr[ 6] = .T. && "Iteration"

DO PopUP WITH 1, "_wgr"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgr"
  
   DO CASE
    CASE a_wgr =  0  && {Esc}
      EXIT
    CASE a_wgr =  1  && "Natural"
      EXIT
    CASE a_wgr =  2  && "Column-wise"
      EXIT
    CASE a_wgr =  3  && "Row-wise"
      EXIT
    CASE a_wgr =  4  && "Automatic"
      EXIT
    CASE a_wgr =  5  && "Manual"
      EXIT
    CASE a_wgr =  6  && "Iteration"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgr"
RELE m_wgr, n_wgr, t_wgr, l_wgr, b_wgr, r_wgr, w_wgr, a_wgr

RETU
* ------------------------------------ *
* /Worksheet Global Protection
PROC m_wgp

PUBL m_wgp, n_wgp, t_wgp, l_wgp, b_wgp, r_wgp, w_wgp, a_wgp
DECL m_wgp[ 2] 
     m_wgp[ 1] = "Enable"
     m_wgp[ 2] = "Disable"
DECL n_wgp[ 2] 
     n_wgp[ 1] = .T. && "Enable"
     n_wgp[ 2] = .F. && "Disable"

DO PopUP WITH 1, "_wgp"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgp"
  
   DO CASE
    CASE a_wgp =  0  && {Esc}
      EXIT
    CASE a_wgp =  1  && "Enable"
      EXIT
    CASE a_wgp =  2  && "Disable"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgp"
RELE m_wgp, n_wgp, t_wgp, l_wgp, b_wgp, r_wgp, w_wgp, a_wgp

RETU
* ------------------------------------ *
* /Worksheet Global Default
PROC m_wgd

PUBL m_wgd, n_wgd, t_wgd, l_wgd, b_wgd, r_wgd, w_wgd, a_wgd
DECL m_wgd[ 6] 
     m_wgd[ 1] = "Printer"
     m_wgd[ 2] = "Directory"
     m_wgd[ 3] = "Status"
     m_wgd[ 4] = "Update"
     m_wgd[ 5] = "Other"
     m_wgd[ 6] = "Quit"
DECL n_wgd[ 6] 
     n_wgd[ 1] = .T. && "Printer"
     n_wgd[ 2] = .F. && "Directory"
     n_wgd[ 3] = .F. && "Status"
     n_wgd[ 4] = .F. && "Update"
     n_wgd[ 5] = .T. && "Other"
     n_wgd[ 6] = .T. && "Quit"

DO PopUP WITH 1, "_wgd"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgd"
  
   DO CASE
    CASE a_wgd =  0  && {Esc}
      EXIT
    CASE a_wgd =  1  && "Printer"
      DO m_wgdP
    CASE a_wgd =  2  && "Directory"
    CASE a_wgd =  3  && "Status"
    CASE a_wgd =  4  && "Update"
    CASE a_wgd =  5  && "Other"
      DO m_wgdO
    CASE a_wgd =  6  && "Quit"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgd"
RELE m_wgd, n_wgd, t_wgd, l_wgd, b_wgd, r_wgd, w_wgd, a_wgd

RETU
* ------------------------------------ *
* /Worksheet Global Default Printer
PROC m_wgdp

PUBL m_wgdp, n_wgdp, t_wgdp, l_wgdp, b_wgdp, r_wgdp, w_wgdp, a_wgdp
DECL m_wgdp[11] 
     m_wgdp[ 1] = "Interface"
     m_wgdp[ 2] = "Auto-LF"
     m_wgdp[ 3] = "Left"
     m_wgdp[ 4] = "Right"
     m_wgdp[ 5] = "Top"
     m_wgdp[ 6] = "Bottom"
     m_wgdp[ 7] = "Pg-length"
     m_wgdp[ 8] = "Wait"
     m_wgdp[ 9] = "Setup"
     m_wgdp[10] = "Name"
     m_wgdp[11] = "Quit"
DECL n_wgdp[11] 
     n_wgdp[ 1] = .F. && "Interface"
     n_wgdp[ 2] = .T. && "Auto-LF"
     n_wgdp[ 3] = .F. && "Left"
     n_wgdp[ 4] = .F. && "Right"
     n_wgdp[ 5] = .F. && "Top"
     n_wgdp[ 6] = .F. && "Bottom"
     n_wgdp[ 7] = .F. && "Pg-length"
     n_wgdp[ 8] = .T. && "Wait"
     n_wgdp[ 9] = .F. && "Setup"
     n_wgdp[10] = .F. && "Name" 
     n_wgdp[11] = .T. && "Quit"

DO PopUP WITH 1, "_wgdp"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgdp"
  
   DO CASE
    CASE a_wgdp =  0  && {Esc}
      EXIT
    CASE a_wgdp =  1  && "Interface"
    CASE a_wgdp =  2  && "Auto-LF"
    CASE a_wgdp =  3  && "Left"
    CASE a_wgdp =  4  && "Right"
    CASE a_wgdp =  5  && "Top"
    CASE a_wgdp =  6  && "Bottom"
    CASE a_wgdp =  7  && "Pg-length"
    CASE a_wgdp =  8  && "Wait"
    CASE a_wgdp =  9  && "Setup"
    CASE a_wgdp = 10  && "Name"
    CASE a_wgdp = 11  && "Quit"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgdp"
RELE m_wgdp, n_wgdp, t_wgdp, l_wgdp, b_wgdp, r_wgdp, w_wgdp, a_wgdp

RETU
* ------------------------------------ *
* /Worksheet Global Default Other
PROC m_wgdo

PUBL m_wgdo, n_wgdo, t_wgdo, l_wgdo, b_wgdo, r_wgdo, w_wgdo, a_wgdo
DECL m_wgdo[ 3] 
     m_wgdo[ 1] = "International"
     m_wgdo[ 2] = "Help"
     m_wgdo[ 3] = "Clock"
DECL n_wgdo[ 3] 
     n_wgdo[ 1] = .T. && "International"
     n_wgdo[ 2] = .F. && "Help"
     n_wgdo[ 3] = .F. && "Clock"

DO PopUP WITH 1, "_wgdo"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgdo"
  
   DO CASE
    CASE a_wgdo =  0  && {Esc}
      EXIT
    CASE a_wgdo =  1  && "International"
      DO m_wgdoI
    CASE a_wgdo =  2  && "Help"
    CASE a_wgdo =  3  && "Clock"
   ENDC

ENDD

DO PopUP WITH 3, "_wgdo"
RELE m_wgdo, n_wgdo, t_wgdo, l_wgdo, b_wgdo, r_wgdo, w_wgdo, a_wgdo

RETU
* ------------------------------------ *
* /Worksheet Global Default Other International
PROC m_wgdoi

PUBL m_wgdoi, n_wgdoi, t_wgdoi, l_wgdoi, b_wgdoi, r_wgdoi, w_wgdoi, a_wgdoi
DECL m_wgdoi[ 5] 
     m_wgdoi[ 1] = "Punctuation"
     m_wgdoi[ 2] = "Currency"
     m_wgdoi[ 3] = "Date"
     m_wgdoi[ 4] = "Time"
     m_wgdoi[ 5] = "Quit"
DECL n_wgdoi[ 5] 
     n_wgdoi[ 1] = .F. && "Punctuation"
     n_wgdoi[ 2] = .F. && "Currency"
     n_wgdoi[ 3] = .F. && "Date"
     n_wgdoi[ 4] = .F. && "Time"
     n_wgdoi[ 5] = .T. && "Quit"

DO PopUP WITH 1, "_wgdoi"

DO WHIL .T.
  
   DO PopUP WITH 2, "_wgdoi"
  
   DO CASE
    CASE a_wgdoi =  0  && {Esc}
      EXIT
    CASE a_wgdoi =  1  && "Punctuation"
    CASE a_wgdoi =  2  && "Currency"
    CASE a_wgdoi =  3  && "Date"
    CASE a_wgdoi =  4  && "Time"
    CASE a_wgdoi =  5  && "Quit"
      EXIT
   ENDC

ENDD

DO PopUP WITH 3, "_wgdoi"
RELE m_wgdoi, n_wgdoi, t_wgdoi, l_wgdoi, b_wgdoi, r_wgdoi, w_wgdoi, a_wgdoi

RETU
* ------------------------------------ *
* /File
PROC m_f

PUBL m_f, n_f, t_f, l_f, b_f, r_f, w_f, a_f
DECL m_f[ 8] 
     m_f[ 1] = "Retrieve"
     m_f[ 2] = "Save"
     m_f[ 3] = "Combine"
     m_f[ 4] = "Xtract"
     m_f[ 5] = "Erase"
     m_f[ 6] = "List"
     m_f[ 7] = "Import"
     m_f[ 8] = "Directory"
DECL n_f[ 8] 
     n_f[ 1] = .F. && "Retrieve"
     n_f[ 2] = .T. && "Save"
     n_f[ 3] = .F. && "Combine"
     n_f[ 4] = .F. && "Xtract"
     n_f[ 5] = .F. && "Erase"
     n_f[ 6] = .F. && "List"
     n_f[ 7] = .F. && "Import"
     n_f[ 8] = .F. && "Directory"

DO PopUP WITH 1, "_f"

DO WHIL .T.
  
   DO PopUP WITH 2, "_f"
  
   DO CASE
    CASE a_f =  0  && {Esc}
      EXIT
    CASE a_f =  1  && "Retrieve" 
    CASE a_f =  2  && "Save"     
      DO m_fs
    CASE a_f =  3  && "Combine"  
    CASE a_f =  4  && "Xtract"   
    CASE a_f =  5  && "Erase"    
    CASE a_f =  6  && "List"     
    CASE a_f =  7  && "Import"   
    CASE a_f =  8  && "Directory"
   ENDC

ENDD

DO PopUP WITH 3, "_f"
RELE m_f, n_f, t_f, l_f, b_f, r_f, w_f, a_f

RETU
* ------------------------------------ *
* /File Save
PROC m_fs

PUBL m_fs, n_fs, t_fs, l_fs, b_fs, r_fs, w_fs, a_fs
DECL m_fs[ 2] 
     m_fs[ 1] = "Cancel"
     m_fs[ 2] = "Replace"
DECL n_fs[ 2] 
     n_fs[ 1] = .T. && "Cancel"
     n_fs[ 2] = .T. && "Replace"

DO PopUP WITH 1, "_fs"

DO WHIL .T.
  
   DO PopUP WITH 2, "_fs"
  
   DO CASE
    CASE a_fs =  0  && {Esc}
      EXIT
    CASE a_fs =  1  && 
    CASE a_fs =  2  && 
   ENDC

ENDD

DO PopUP WITH 3, "_fs"
RELE m_fs, n_fs, t_fs, l_fs, b_fs, r_fs, w_fs, a_fs

RETU
* ------------------------------------ *
* /Quit
PROC m_q

PUBL m_q, n_q, t_q, l_q, b_q, r_q, w_q, a_q
DECL m_q[ 2] 
     m_q[ 1] = "No"
     m_q[ 2] = "Yes"
DECL n_q[ 2] 
     n_q[ 1] = .T. && "No"
     n_q[ 2] = .T. && "Yes"

DO PopUP WITH 1, "_q"

DO WHIL .T.
  
   DO PopUP WITH 2, "_q"

   DO CASE
    CASE a_q =  0  && {Esc}
      EXIT
    CASE a_q =  1  && "No"
      EXIT
    CASE a_q =  2  && "Yes"
      REST SCREEN FROM scr_DOS
      @ 24,0
      QUIT
   ENDC

ENDD

DO PopUP WITH 3, "_q"
RELE m_q, n_q, t_q, l_q, b_q, r_q, w_q, a_q

RETU
