* dB_FUNCT.prg - 03/15/87
* Set up user defined functions for dBASE III.
* Suggestions / examples by John Wright.
*
* PROCEDURE / FUNCTION LIST
* -------------------------
* AGE        Calculate someone's age using the date of birth
* ELAPSED    Calculate elapsed time between two time strings
* NICEDATE   Returns a detailed string for a date value
* NICETIME   Returns a time string with am/pm designation
* PUTCOMMA   Takes a number and inserts commas to separate
* PUTPERCT   Converts number to a percent with % sign
* ==========================================================
* LTRIM      Work-around for dBASE III without LTRIM().


PROCEDURE AGE
* Calculates age from date of birth and the current date.
* Returns a character string with the number of years old.
* The 365.25 figure is used to adjust for leap years.

PARAMETER birthdate
PUBLIC yearsold
STORE STR(INT((DATE()-birthdate)/365.25),3) TO yearsold


PROCEDURE ELAPSED
* Creates two public variables: hourtime & elaptime
* Given the two time strings: "12:30:45","13:46:17"
* hourtime = 1.25
* elaptime = "1 hour, 15 minutes, 32 seconds"

PARAMETER tc1,tc2
PUBLIC hourtime,elaptime

TH1=VAL(SUBSTR(TC1,1,2))
TM1=VAL(SUBSTR(TC1,4,2))
TS1=VAL(SUBSTR(TC1,7,2))
TT1=(TH1*3600)+(TM1*60)+TS1

TH2=VAL(SUBSTR(TC2,1,2))
IF TH2 < TH1
 TH2=TH2+24
ENDIF
TM2=VAL(SUBSTR(TC2,4,2))
TS2=VAL(SUBSTR(TC2,7,2))
TT2=(TH2*3600)+(TM2*60)+TS2

TTT=TT2-TT1

TTH=TTT/3600
TTH=INT(TTH)
IF TTH > 0
  IF TTH = 1
   STORE "1 hour, " TO elaptime
  ELSE
   STORE STR(TTH,2)+" hours, " TO elaptime
  ENDIF
 TTT=TTT-(TTH*3600)
ELSE
 STORE "" TO elaptime
ENDIF

TTM=TTT/60
TTM=INT(TTM)
IF TTM > 0
  IF TTM = 1
   STORE elaptime+"1 minute, " TO elaptime
  ELSE
   STORE elaptime+STR(TTM,2)+" minutes, " TO elaptime
  ENDIF
 TTT=TTT-(TTM*60)
ENDIF

TTS=TTT
IF TTS = 1
 STORE elaptime+"1 second" TO elaptime
ELSE
 STORE elaptime+STR(TTS,2)+" seconds" TO elaptime
ENDIF

STORE TTH+ROUND(TTM/60,2) TO hourtime


PROCEDURE NICEDATE
* Example: 12/25/86 = "December 25, 1986"

PARAMETER dodate

IF DAY(dodate) < 10
 ??CMONTH(dodate)+STR(DAY(dodate),2)+","+STR(YEAR(dodate),5)
ELSE
 ??CMONTH(dodate)+STR(DAY(dodate),3)+","+STR(YEAR(dodate),5)
ENDIF
* If you have dBASE III Plus use " "+LTRIM(STR(DAY(dodate)))
* instead of the above IF/ELSE statement.


PROCEDURE NICETIME
* Example: "14:25:23" = " 2:25pm"

PARAMETER dotime

STORE VAL(SUBSTR(dotime,1,2)) TO CHKTIME
STORE SUBSTR(dotime,3,3) TO ADDMIN
IF CHKTIME < 13
 STORE STR(CHKTIME,2)+ADDMIN+"am" TO showtime
ELSE
 STORE CHKTIME-12 TO CHKTIME
 STORE STR(CHKTIME,2)+ADDMIN+"pm" TO showtime
ENDIF
??showtime


PROCEDURE PUTCOMMA
* Display a number with commas
* nv1 = number to convert
* nv2 = length of string to return
* nv3 = number of decimal places
* maximum numeric value: 999,999,999

PARAMETERS nv1,nv2,nv3

 IF nv3 > 0
  STORE STR(nv1,10+nv3,nv3) TO SPLIT
  STORE 4+nv3 TO REST
 ELSE
  * assumes 0 decimal places
  STORE STR(nv1,9) TO SPLIT
  STORE 3 TO REST
 ENDIF
 DO CASE
  CASE nv1 > 999999
   SHOW=SUBSTR(SPLIT,1,3)+","+SUBSTR(SPLIT,4,3)+",";
   +SUBSTR(SPLIT,7,REST)
  CASE nv1 > 999
   SHOW=SUBSTR(SPLIT,1,6)+","+SUBSTR(SPLIT,7,REST)
  CASE nv1 < 1000
   SHOW=SPLIT
 ENDCASE

* STORE LTRIM(SHOW) TO SHOW
* use following fix for "pre-Plus" version of dBASE III
  DO LTRIM WITH SHOW

 IF LEN(SHOW) > nv2
  * return "*"s since number is greater than space available
  STORE SUBSTR("*********************",1,nv2) TO SHOW
 ELSE
  * add spaces to the left of SHOW variable
  STORE nv2 - LEN(SHOW) TO GAP
  STORE SPACE(GAP)+SHOW TO SHOW
 ENDIF
??SHOW


PROCEDURE PUTPERCT
* Display a number as a percent; including % sign.
* nv1 = number to convert
* nv2 = length of string to return
* nv3 = number of decimal spaces

PARAMETERS nv1,nv2,nv3

STORE nv2 - 1 TO NV4
STORE nv1*100 TO NV5
STORE ROUND(NV5,nv3) TO PART1
STORE STR(PART1,NV4,nv3) TO PART2
STORE PART2+"%" TO SHOW
??SHOW


* ===== function for dBASE III =========

PROCEDURE LTRIM
* Mimics the dBASE III Plus LTRIM() command.
* Strips leading blanks off a character string.

PARAMETER variable

DO WHILE SUBSTR(variable,1,1) = " "
  STORE LEN(variable)-1 TO varlen
  STORE SUBSTR(variable,2,varlen) TO variable
ENDDO

return