/////////////////////////////////////////////////////////////////////////
//                                                                     //
// PlsWait() Function - For Use with Clip-4-Win                        //
//                                                                     //
// Puts up a Please Wait Dialog Box while running a back ground Task   //
//                                                                     //
// You need to create a Dialog Resource "ONEMOMENT" with a Title Bar   //
//                                                                     //
// Call like PlsWait(hCallWind,"Running Report",{||Report()})          //
//                                                                     //
// Place in the Public domain by Paul Richards Compuserve 100325,3104  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
FUNCTION PlsWait(       ; // Put Up Please Wait Dialog    //
                 hWnd,  ; // Calling Window               //
                 nText, ; // Text to Show                 //
                 cbFunc ; // Code Block to run            //
                )                                         //
////////////////////////////////////////////////////////////
Return DialogBox( _GetInstance() , "ONEMOMENT", hWnd, ;
           {|hDlg, nMsg, nWparam, nLparam|;
           PWFunc( hDlg,nMsg,nWparam,nLparam,hWnd,nText,cbFunc ) } )
Static Function PWFunc(hDlgWnd,nMsg,nWparam,nLparam,hWnd,nText,cbFunc)
STATIC lFirst,hW,cbF
do Case
   Case nMsg == WM_INITDIALOG
        SendMessage( hDlgWnd, WM_SETTEXT, 0 , nText )
        hW     := hWnd        // Setup Statics
        cbF    := cbFunc
        lFirst := .T.
        Return 1
   Case nMsg == WM_PAINT
        if lFirst
           lFirst := .F.
           PostMessage( hDlgWnd, WM_USER+1, 0, 0 )
        endif
        Return( 0 )
   Case nMsg == WM_USER+1
        Eval(cbF,hDlgWnd)  // Evaluate Code Block passing Dialog Handle
        EndDialog(hDlgWnd)
        Return 1
EndCase
Return 0




