
 ****************************************************************************
 * Name:      Per_Back.prg                                                  *
 * Task:      Backup files to removable media                               *
 *                                                                          *
 * Function:  HNEW()    New disk                                            *
 *            HPROMPT() Text on line 24                                     *
 *            HSORRY()  Popup window                                        *
 *                                                                          *
 * Procedure:                                                               *
 *            HSTAT     Display status                                      *
 *                                                                          *
 * Local:                                                                   *
 *            lrow      display pointer                                     *
 *            lclm      display pointer                                     *
 *            lbyte_tot bytes to be copied                                  *
 *            lbyte_cop bytes copied                                        *
 *            lfile_no  file number (ARRAY pointer)                         *
 *            lfiles    No of files to back up                              *
 *            lsource   Source file *.*                                     *
 *            lname     name of file without extension                      *
 *            linfile   F handle                                            *
 *            loutfile  F handle                                            *
 *            lxx       temporary                                           *
 *            lread     read value and bytes read                           *
 *            lwrite    bytes written                                       *
 *            ldrive    drive to backup to                                  *
 *            ldisk_no  disk number in use                                  *
 *            linc      no of bytes copied each time round the loop         *
 *            lbuffer   text buffer                                         *
 *            lpos      position in input file relative to 0                *
 *            lexit     logical counter                                     *
 *            lbackno   a number given a backup set                         *
 *            ARname[]  array with file names                               *
 *            ARsize[]  array with file sizes                               *
 ****************************************************************************

PRIV lrow,lclm,lbyte_tot,lbyte_cop,lfile_no,linfile,lxx,lread,ldrive,lbackno,;
     ldisk_no,linc,lbuffer,loutfile,lpos,lexit,lwrite,lname,lfiles,lpath,lsource

******************************************************************************
SET CURSOR OFF
CLEAR
@  1,0  TO 24,79
@  6,40 TO 23,75
@ 13,40 TO 13,75
SET COLO TO n/w
@ 1,2 SAY " BACKUP FILES TO REMOVABLE MEDIA "
@ 6,42 SAY " STATUS "
SET COLO TO w/n
@ 13,40 SAY ""
@ 13,75 SAY ""

lbackno = SECONDS()    && A serial number for the backup set

@  3,5  SAY "Source Drive\path..."
@  4,5  SAY "Source file ........"
@  5,5  SAY "Target Drive........"
@  8,42 SAY "Estimated Time......"
@  9,42 SAY "Bytes to Copy......."
@ 11,42 SAY "Bytes Copied........"
@ 12,42 SAY "Completed...........           %"
@ 14,42 SAY "Diskettes Needed:"
@ 16,42 SAY '5 "  360 Kb........'
@ 17,48 SAY "1.2 Mb........"
@ 19,42 SAY '3 "  720 Kb........'
@ 20,48 SAY "1.4 Mb........"

******************************************************************************
DO WHIL .T.
   lpath   = "C:\"+CURDIR()+"\"
   lpath   = lpath+SPAC(30-LEN(lpath))
   lsource = "*.*         "
   ldrive  = "A"
   HPROMPT("Enter Source: path and file info, Target drive                      [ESC]-Quit")
   @ 3,27 GET lpath
   @ 4,27 GET lsource
   @ 5,27 GET ldrive PICT "@A !"
   SET CURSOR ON
   READ
   SET CURSOR OFF
   lpath=TRIM(lpath)
   lsource=TRIM(lsource)
   IF ! ldrive $"AB"
     HSORRY("SORRY, Drive does not contain a removable media")
   ELSE
     lfiles = ADIR(lpath+lsource)      && See how many .dbt & .dbf files
     IF lfiles = 0
        HSORRY("Sorry, No files found")
     ELSE
        EXIT
     ENDI
   ENDI
ENDD

IF LASTKEY()<>27

 ****************** Read file names into Array and count bytes ****************
 lbyte_tot = 0                       && bytes to be backed up
 lbyte_cop = 0                       && bytes backed up so far
 PRIV ARname[lfiles]
 PRIV ARsize[lfiles]
 ADIR(lpath+lsource,ARname,ARsize) && read names to ARname[], sizes to ARsize
 FOR lxx = 1 TO lfiles
   lbyte_tot = lbyte_tot + ARsize[lxx]
 NEXT
 ******************************************************************************

 DO HSTAT
 ******************* Display number of disks needed **************************
 lxx=lbyte_tot/360000
 @ 16,63 SAY LTRIM(STR(IF(lxx>INT(lxx),INT(lxx)+1,INT(lxx))))
 lxx=lbyte_tot/1200000
 @ 17,63 SAY LTRIM(STR(IF(lxx>INT(lxx),INT(lxx)+1,INT(lxx))))
 lxx=lbyte_tot/720000
 @ 19,63 SAY LTRIM(STR(IF(lxx>INT(lxx),INT(lxx)+1,INT(lxx))))
 lxx=lbyte_tot/1400000
 @ 20,63 SAY LTRIM(STR(IF(lxx>INT(lxx),INT(lxx)+1,INT(lxx))))
 *****************************************************************************

 linc     = 1024
 lrow     = 8
 lclm     = 5
 ldisk_no = 1

 IF HNEW()

  FOR lfile_no = 1 TO lfiles

   lbuffer  = SPAC(linc)
   lname    = ARname[lfile_no]
   linfile  = FOPEN(lpath+lname)            && Open the source file
   loutfile = FCREATE(ldrive+":"+lname)     && Create the target file
   lpos     = 0
   lexit    = .F.

   @ lrow,lclm SAY lname
   SET COLO TO *w/n
   @ lrow,lclm+12 SAY " *"
   SET COLO TO w/n

   DO WHIL .T.
    lread     = FREAD(linfile,@lbuffer,linc)    && read buffer
    lwrite    = FWRITE(loutfile,lbuffer,lread)  && write buffer
    lpos      = lpos+lwrite
    lbyte_cop = lbyte_cop+lwrite
    DO HSTAT
    IF lwrite < lread       && THE WHOLE FILE DID NOT FIT
       FSEEK(linfile,lpos)       && position pointer where text ended
       FCLOSE(loutfile)          && close the outfile
       ldisk_no = ldisk_no+1            && increment disk number
       IF HNEW()
          loutfile = FCREATE(ldrive+":"+lname)  && continue on a new disk
       ELSE
          lexit = .T.  && user decided to Quit
          EXIT
       ENDI
    ELSE
       IF lread = 0    && File has been successfully copied
          @ lrow,lclm+12 SAY " "
          lclm=IF(lrow<>22,lclm,IF(lclm=23,5,23))
          lrow=IF(lrow<>22,lrow+1,8)
          EXIT
       ENDI
    ENDI
   ENDD

   FCLOSE(linfile)
   FCLOSE(loutfile)

   IF lexit
      @ lrow,lclm+12 SAY "  "
      EXIT
   ENDI

  NEXT

  IF ! lexit
   HSORRY("BACKUP COMPLETED")
  ENDI

 ENDI
ENDI

SET CURSOR ON
CLEAR
RETU

******************************************************************************
******************************************************************************
FUNC HNEW           && prompt for a new disk
PRIV lscreen,PX_disk,PX_number,PX_byte,ltemp,lfile

lscreen = SAVESCREEN(21,0,23,79)
DO WHIL .T.
   lxx = "PLEASE Put Backup Disk No ["+STR(ldisk_no,2)+"] in Target drive ["+ldrive+"]"
   @ 21,(76-LEN(lxx))/2,23,(82+LEN(lxx))/2 BOX ""
   @ 22,(80-LEN(lxx))/2 SAY lxx

   HPROMPT("Wait Mode:                 Press ANY KEY to Continue                [ESC]-Quit")
   IF INKEY(0)=27      && WAIT
      RESTSCREEN(21,0,23,79,lscreen)
      RETU .F.        && --------> [ESC]
   ELSE
      HPROMPT("Backup:                       DISK ACCESS                           [ESC]-Quit")
      lxx = FCREATE(ldrive+":temp")
      IF lxx<>-1       && disk is write ready
         ERASE &ldrive.:temp
         IF FILE(ldrive+":per_back.mem")
            REST FROM &ldrive.:per_back.mem ADDI
         ELSE
            PX_disk   = ldisk_no
            PX_number = 0
         ENDI
         IF (PX_disk<ldisk_no.AND.PX_number<>lbackno).OR.PX_disk>=ldisk_no  && All test passed
            ******* deleting all files on target ****************
            ltemp = ADIR(ldrive+":*.*")  && count files meeting wildcard
            PRIV ARtemp[ltemp]
            ADIR(ldrive+":*.*",ARtemp) && read names to ARtemp[]
            FOR lxx = 1 TO ltemp
              lfile = ARtemp[lxx]
              ERASE &ldrive.:&lfile
            NEXT
            *****************************************************
            PX_disk   = ldisk_no
            PX_number = lbackno
            PX_byte   = lbyte_tot
            SAVE TO &ldrive.:per_back.mem ALL LIKE PX_*
            RESTSCREEN(21,0,23,79,lscreen)
            RETU .T.
         ELSE
            HSORRY("Sorry, This disk has already been used")
         ENDI
      ELSE
         HSORRY("Sorry, No disk in drive or Write-protected / Unformatted disk")
      ENDI
   ENDI
ENDD
******************************************************************************
******************************************************************************
PROC HSTAT       && progress status
PRIV ltime

ltime = (lbyte_tot-lbyte_cop)/2900    && I found speed to be approx 2900 b/sec

@  8,66 SAY SUBS(STR(INT(ltime/3600%24)+10^2,2+1),2)+":"+;   && Hours
            SUBS(STR(INT(ltime/60%60)+10^2,2+1),2)+":"+;     && Minutes
            SUBS(STR(INT(ltime%60)+10^2,2+1),2)              && Seconds
@  9,63 SAY TRAN(lbyte_tot-lbyte_cop,"999,999,999")
@ 11,63 SAY TRAN(lbyte_cop,"999,999,999")
@ 12,69 SAY TRAN(ROUND(lbyte_cop/lbyte_tot*100,0),"999")

RETU
******************************************************************************
******************************************************************************
FUNC HSORRY
PARA lstring
PRIV lscreen,lxx

 ****************************************************************************
 * Syntax:   HSORRY(<expC>)                                                 *
 * Argument: <expC> is string to be shown on screen.                        *
 * Return:   .T.                                                            *
 * Usage:    Used to display a message when the user has made a misstake.   *
 * Note:     The message is placed in a box, and is allways displayed on    *
 *           line 21.                                                       *
 * Example:  HSORRY("Sorry, The name is not valid")                         *
 ****************************************************************************

 lscreen = SAVESCREEN(20,0,22,79)
 TONE(900,1)
 TONE(900,1)
 TONE(900,1)
 TONE(900,2)
 @ 20,(76-LEN(lstring))/2,22,(82+LEN(lstring))/2 BOX ""
 @ 21,(80-LEN(lstring))/2-1 SAY " "+lstring+" "
 HPROMPT("                        Press ANY key to continue")
 INKEY(0)
 RESTSCREEN(20,0,22,79,lscreen)

RETU .T.



******************************************************************************
******************************************************************************
FUNC HPROMPT
PARA lstring

 ****************************************************************************
 * Syntax:   HPROMPT(<expC>)                                                *
 * Argument: <expC> is the text to be displayed on line 24 in inverse.      *
 * Return:   .T.                                                            *
 * Usage:    To display a prompt line corresponding to current action.      *
 * Note:                                                                    *
 * Example:  HPROMPT("text on line 24")                                     *
 ****************************************************************************

 SET COLO TO n/w
 @ 24,1 SAY lstring+SPAC(78-LEN(lstring))
 SET COLO TO w/n

RETU .T.

