/*
    HM_TOUR.PRG
*/


#include "inkey.ch"
#include "hormenu.ch"

//---------
func main()
local nTop := 3, nLeft := 0
local aMenu := {;
                    "Overview: What's the Hormenu Collection?",;
                    "The ADhormenu() Syntax",;
                    "The Default Active Keys and Mouse Spots",;
                    "Demo: The Basic Implementation",;
                    "The ADhormenu() APIs",;
                    "Demos: Extending Its Functionality",;
                    "A Quick Syntax Reference",;
                    "Print Documentation";
               }
local aTrigger := { 1,17,20,11,17,22,16 }
local aBlock := {;
                    {|e| ADviewfile( "overview.hm" )},;
                    {|e| ADviewfile( "syntax.hm" )},;
                    {|e| ADviewfile( "keys.hm" )},;
                    {|e| ADviewfile( "hm_demo1.prg", {||Xdemo1()} )},;
                    {|e| ADviewfile( "api.hm" )},;
                    {|e| Xfunction(e)},;
                    {|e| ADviewfile( "quickref.hm" )},;
                    {|e| Xprintdocs(e)};
                }

Xintro()
ADvermenu( nTop, nLeft, aMenu, aTrigger, aBlock )
ADcredit(13,16)
setblink( .t. )
return nil


//--------------------
func Xfunction( e, cDbf )
local nTop := ADvm_row(e) + 1, nLeft := ADvm_left(e) + 4
local aMenu := {;
                    "Assigning Option-Dependent Procedures",;
                    "Implementing PullDown Menus";
               }
local xBlock := {;
                    {|e| ADviewfile( "hm_demo2.prg", {||Xdemo2()} )},;
                    {|e| ADviewfile( "hm_demo3.prg", {||Xdemo3()} )};
                }
ADvermenu( nTop, nLeft, aMenu, {25,11,5,5}, xBlock )
return nil

//---------------
func Xprintdocs(e)
local nTop := ADvm_row(e) + 1, nLeft := ADvm_left(e) + 4, xx
local aMenu := {;
                    "Overview.hm",;
                    "Syntax.hm",;
                    "API.hm",;
                    "Quickref.hm",;
                    "HM_tour.prg",;
                    "HM_demo1.prg",;
                    "HM_demo2.prg",;
                    "HM_demo3.prg";
                }
local bConfig := {|e| ADvm_taglist(e), ADvm_returntype( e, VM_CHAR_RETVAL )}
local aScn := ADmessage( { "Tag files for printing" },,, .f., .f. )
local aFiles := ADvermenu( nTop, nLeft, aMenu,,, bConfig )

if isprinter()
    for xx = 1 to len( aFiles )
        fwrite( 4, memoread( aFiles[xx] ) )
        fwrite( 4, chr(12) )
    next
else
    ADmessage( { "Printer Not Ready",;
                 "NOTE: Check out PDBM??.ZIP",;
                 "for a mouseable dialog box";
                } )
endif

ADrestscn( aScn )
return nil


//-----------
func Xdemo1()
local aMenu := { "Databases", "Utilities", "Quit" }
local nSel := ADhormenu( aMenu )
ADmessage( { "Selected" + str(nSel, 2) } )
return nil


//-----------
func Xdemo2()
local aMenu := { "Databases", "Utilities", "Quit" }
ADhormenu( aMenu,, {|e| Xsel1_handler(e)} )
return nil

//------------------
func Xsel1_handler(e)
local nSel := ADhm_current(e)
local aMsg := {;
                "Selected ",;
                "Think of this message box as a major procedure that you call.",;
                "When the procedure ends, control goes back to the menu.",;
                "Note that the Esc key and the right mouse button are not active.",;
                "Typically, that's how you want them - there is a 'Quit' option.";
              }

if nSel = 1
    aMsg[1] += "Databases."
    ADmessage( aMsg )
elseif nSel = 2
    aMsg[1] += "Utilities."
    ADmessage( aMsg )
elseif nSel = 3
    ADhm_exit(e)
endif
return nil


//-----------
func Xdemo3()
local aScn
local aMenu := { "Databases", "Utilities", "Quit" }
local bConfig := {|e| ADhm_extra( e,;
                                  {|ee| aScn := ADsavescn( 1,0,1,79 ),;   
                                        ADsay( 1,0, repl( "", 80 ), ADhm_colors(ee)[1] );   
                                  },;   
                                  ,;
                                  {|ee| ADrestscn( aScn )};
                                ),;
                      ADhm_pulldown( e, {1,2,3} );
                 }
ADhormenu( aMenu,;
           ,;
           {;
                {|e| X3databases(e)},;
                {|e| X3utilities(e)},;
                {|e| X3quit(e)};
           },;
           bConfig;
         )
return nil

//--------------------------
func X3databases( nHMEngine )
local aMenu := { "Client", "Hardware", "Software" }
local aProcess := {;
                    {|e|ADmessage( { "Client" } )},;
                    {|e|ADmessage( { "Hardware" } )},;
                    {|e|ADmessage( { "Software" } )};
                  }
ADpulldown( nHMEngine, aMenu,, aProcess )
return nil


//--------------------------
func X3utilities( nHMEngine )
local aMenu := { "Reindex", "Backup", "ChangeDirectory" }
local aProcess := {;
                    {|e|ADmessage( { "Reindex" } )},;
                    {|e|ADmessage( { "Backup" } )},;
                    {|e|ADmessage( { "ChangeDirectory" } )};
                  }
ADpulldown( nHMEngine, aMenu,, aProcess )
return nil


//---------------------
func X3quit( nHMEngine )
local aMenu := { "Yes", "No" }
if ADpulldown( nHMEngine, aMenu ) = 1
    ADhm_exit( nHMEngine )
endif
return nil


//-----------
func Xintro()
cls
ADmessage( {;
                "The Horizontal Menu Collection of the Frankie Library",;
                "Version 1.00",;
                "A Mouseable Horizontal Menu Engine and APIs",;
                "",;
                "",;
                "Copyright (c) The Programmer's Desk, 1992, 1993",;
                "Press any key";
           }, 7, 10, .f. )
ADxwait()
return nil

