/*
    HM_DEMO3.PRG

    Demonstration of a pulldown menu.  It also demonstrates the use of the
    following APIs:

    ADhm_extra() - designates codeblocks to be EVALuated just before
        displaying the menu, right after displaying the menu, and just
        before exiting.

    ADhm_pulldown() - specifies which menu options are to be automatically
        pulled down when they get highlighted.

    ADhm_exit() - instructs the engine to terminate.

    ADpulldown() - implements a pulldown vertical menu off the horizontal
        menu
*/


//---------
func main()
local aScn
local aMenu := { "Databases", "Utilities", "Quit" }
local bConfig := {|e| ADhm_extra( e,;
                                  {|ee| aScn := ADsavescn( 1,0,1,79 ),;   
                                        ADsay( 1,0, repl( "", 80 ), ADhm_colors(ee)[1] );   
                                  },;   
                                  ,;
                                  {|ee| ADrestscn( aScn )};
                                ),;
                      ADhm_pulldown( e, {1,2,3} );
                 }
ADhormenu( aMenu,;
           ,;
           {;
                {|e| X3databases(e)},;
                {|e| X3utilities(e)},;
                {|e| X3quit(e)};
           },;
           bConfig;
         )
return nil

//--------------------------
func X3databases( nHMEngine )
local aMenu := { "Client", "Hardware", "Software" }
local aProcess := {;
                    {|e|ADmessage( { "Client" } )},;
                    {|e|ADmessage( { "Hardware" } )},;
                    {|e|ADmessage( { "Software" } )};
                  }
ADpulldown( nHMEngine, aMenu,, aProcess )
return nil


//--------------------------
func X3utilities( nHMEngine )
local aMenu := { "Reindex", "Backup", "ChangeDirectory" }
local aProcess := {;
                    {|e|ADmessage( { "Reindex" } )},;
                    {|e|ADmessage( { "Backup" } )},;
                    {|e|ADmessage( { "ChangeDirectory" } )};
                  }
ADpulldown( nHMEngine, aMenu,, aProcess )
return nil


//---------------------
func X3quit( nHMEngine )
local aMenu := { "Yes", "No" }
if ADpulldown( nHMEngine, aMenu ) = 1
    ADhm_exit( nHMEngine )
endif
return nil


