#include "mouse.ch"
#include "inkey.ch"
#include "fileio.ch"
#include "memoedit.ch"
#include "box.ch"

#command DEFAULT <p> TO <val> [, <pn> to <valn>];
		=> ;
		<p> = iif(<p> = NIL, <val>, <p>) ;
		[;<pn> = iif(<pn> = NIL, <valn>,<pn>)]

Function OpenDBF(_DbfVar,_xAlias)
*****************************************************************************
*	Function Open() 														*
*	Description - Opens a database and all associated indeces and assigns	*
*				  the database to an alias. 								*
*	EXPLAINATION: 1) The first byte of a .DBF file is either 03h (no memos) *
*				  or 83h (yes memos).  If 'USE' doesn't see one of these    *
*				  two bytes at offset 0 it reports a 'Corruption Detected'  *
*				  error.  We then can open the file with fopen() and change *
*				  this first byte to any byte of our choosing.	We must 	*
*				  then write our own function to open the .DBF file so that *
*				  the byte is changed back to 03h or 83h respectively.		*
*				  On a network the file must be open shared for this to 	*
*				  work with more than one user concurrently.  Now noone 	*
*				  else can open our files with dBase, Paradox, etc. unless	*
*				  they know the file header structure and know how to fix	*
*				  it manually.	Critical fields can be encrypted before 	*
*				  being written to provide additional security. 			*
*				  2)We can also make opening files with multiple indeces	*
*				  easy without having to remember the index names.	We can	*
*				  pass the function an array with the database file name as *
*				  the first element and the indeces as elements 2 - n.	The *
*				  OpenDBF function opens all of them in the sequence passed *
*				  and assigns the database to an alias.  From now on we 	*
*				  access the file using the alias.							*
*				  3) We can also determine if the file was opened by using	*
*				  the select() function.  If the file is already open it	*
*				  returns a certain value, if it is opened successfully it	*
*				  returns another value, and if the user opts to quit		*
*				  retries it returns still another value.  If the file does *
*				  not exist it will allow this to pass and let the custom	*
*				  error handler deal with the problem.						*
*   Variables - 1)_DbfVar=string variable which contains the database name  *
*	(required)		  followed by a comma followed by each index to open	*
*					  each followed by a comma. 							*
*				2)_xAlias=the alias to open the file under.  All references *
*				   to this database should then be made by this alias.		*
*	Returns - 0 is open is successful, 1 if already open, -1 if not opened	*
*****************************************************************************
	Local _Message, _Answer, _Title, _Junk, _Lkey, i, result, handle, DbfType
	result:=select(_xAlias) 				// See if the file is already open
	DbfType:=" "
	if(result == 0)
		if(substr(_DbfVar[1],len(_DbfVar[1])-3,1) != ".") // If database doesn't
			_DbfVar[1]:=_DbfVar[1]+".dbf"                 // end in .DBF, add it
		endif
		if file(_DbfVar[1]) 						// Only try this if the file
			handle:=fopen(_DbfVar[1],FO_READWRITE)	// exists.	Open the file...
			fseek(handle,0,FS_SET)					// Go to the first byte
			fread(handle,@DbfType,1)				// Read it.
			if(DbfType == chr(88))				// If ASCII 'X' (you can make it anything)
				fseek(handle,0,FS_SET)			// Go to first byte
				fwrite(handle,chr(03))			// No Memos
			elseif(DbfType == chr(89))			// if ASCII 'Y' (you can make it anything)
				fseek(handle,0,FS_SET)			// Go to first byte
				fwrite(handle,chr(131)) 		// Yes Memos
			endif
			fclose(handle)						// Close the file
        endif
		Use &(_DbfVar[1]) alias &(_xAlias) New	// Now let clipper open it
		handle:=fopen(_DbfVar[1],FO_READWRITE)	// Repeat the above steps in
		fseek(handle,0,FS_SET)					// reverse to change the first
		fread(handle,@DbfType,1)				// byte back.
		if(DbfType == chr(03))				// No Memos
			fseek(handle,0,FS_SET)			// Go to first byte
			fwrite(handle,chr(88))			// ASCII 'X'
		elseif(DbfType == chr(131)) 		// Yes Memos
			fseek(handle,0,FS_SET)			// Go to first byte
			fwrite(handle,chr(89))			// ASCII 'Y'
		endif
    else
		return(1)				// Database is already open!
	endif
	if(select(_xAlias) != 0)	// Successful open.
		for i=2 to len(_DbfVar) 	// First element is .DBF name so start at 2.
			dbSetIndex(_DbfVar[i])	// Native clipper for 'set index to <cExpr>'
		next
		return(0)
	else
		// Attempt retries until the user presses the [esc] key...

		_Message:="The database "+_xAlias+" is currently in use by "+;
		"another user, would you like to wait until it becomes "+;
		"available?"
		_Title:="Unable to Open Database"
		// Mouseable answer box
		_answer:=yes_or_no(10,10,,,_Title,_Message,"w/r,w+/r",.t.)
		if _answer
			// Pop a message onto the screen
			_junk:=xMessage(10,10,"Press [esc] to abort retries...")
			handle:=fopen(_DbfVar[1],FO_READWRITE)	// Open the file...
			fseek(handle,0,FS_SET)					// Go to the first byte
			fread(handle,@DbfType,1)				// Read it.
			if(DbfType == chr(88))				// If ASCII 'X' (you can make it anything)
				fseek(handle,0,FS_SET)			// Go to first byte
				fwrite(handle,chr(03))			// No Memos
			elseif(DbfType == chr(89))			// if ASCII 'Y' (you can make it anything)
				fseek(handle,0,FS_SET)			// Go to first byte
				fwrite(handle,chr(131)) 		// Yes Memos
			endif
			fclose(handle)						// Close the file
        endif
		while _answer
			use &(_DbfVar[1]) alias &(_xAlias) New	// Keep trying to open it
			if(select(_xAlias) == 0)
				_lkey:=inkey()
				if _lkey == 27
					handle:=fopen(_DbfVar[1],FO_READWRITE)	// Repeat the above steps in
					fseek(handle,0,FS_SET)					// reverse to change the first
					fread(handle,@DbfType,1)				// byte back.
					if(DbfType == chr(03))				// No Memos
						fseek(handle,0,FS_SET)			// Go to first byte
						fwrite(handle,chr(88))			// ASCII 'X'
					elseif(DbfType == chr(131)) 		// Yes Memos
						fseek(handle,0,FS_SET)			// Go to first byte
						fwrite(handle,chr(89))			// ASCII 'Y'
					endif
                    win_rest(_junk)
					return(-1)			// Unable to open the file and user
				endif					// said to quit trying.
			else
				handle:=fopen(_DbfVar[1],FO_READWRITE)	// Repeat the above steps in
				fseek(handle,0,FS_SET)					// reverse to change the first
				fread(handle,@DbfType,1)				// byte back.
				if(DbfType == chr(03))				// No Memos
					fseek(handle,0,FS_SET)			// Go to first byte
					fwrite(handle,chr(88))			// ASCII 'X'
				elseif(DbfType == chr(131)) 		// Yes Memos
					fseek(handle,0,FS_SET)			// Go to first byte
					fwrite(handle,chr(89))			// ASCII 'Y'
				endif
                win_rest(_junk)
				for i=2 to len(_DbfVar)
					dbSetIndex(_DbfVar[i])
				next
				return(0)		// File opened successfully
			endif
		end
	endif
return(-1)

function Win_Save(_top,_left,_bottom,_right)
*******************************************************************************
*	Function Win_Save														  *
*	Description: saves the area of the screen with the given coordinates with *
*				 the coordinates at the beginning of the screen string.  Use  *
*				 'Win_Rest' to restore the area.                              *
*	Variables: _top - top coordinate of area								  *
*	(Required) _left - left coordinate of area								  *
*			   _bottom - bottom coordinate of area							  *
*			   _right - right coordinate of area							  *
*	Returns - string of saved area with the coordinates at the beginning.	  *
*******************************************************************************
	Default _top to 0,;
			_left to 0,;
			_bottom to maxrow(),;
			_right to maxcol()

return chr(_top)+chr(_left)+chr(_bottom)+chr(_right)+savescreen(_top,_left,_bottom,_right)

function Win_rest(Win_Str)
*****************************************************************
*	Function Win_Rest											*
*	Description: restores area of screen saved by 'Win_Save'    *
*	Variable (required): Win_Str - String saved by 'Win_save'   *
*	Returns: nothing											*
*****************************************************************
	restscreen(asc(substr(Win_Str,1,1)),asc(substr(Win_Str,2,1)),;
			   asc(substr(Win_Str,3,1)),asc(substr(Win_Str,4,1)),;
			   substr(Win_Str,5))
return(NIL)

function GetKey(_WaitTime)
*********************************************************************************
*	Function GetKey 															*
*	Description: returns the inkey code or mouse code of the next button pushed *
*	Variable: WaitTime (optional): Time to wait before returning a zero 		*
*	Returns: Inkey code or mouse code pushed or zero if none					*
*********************************************************************************
Local _Lkey,_Mkey,_StartTime,_CurrentTime

_StartTime:=time()

if _IsMouse()
	_ShowMouse()
	_Lkey:=0
	_Mkey:=0
	while (_Lkey == 0) .and. (_Mkey == 0)
		_Lkey := inkey()
		_Mkey := _MBStat()
		if (_WaitTime == NIL)
			exit
		else
			if ( Seconds()-NumSeconds(_StartTime) >= _WaitTime) .and. (_WaitTime != 0)
				exit
			endif
		endif
	end
	_HideMouse()
else
	_Lkey:=inkey(_WaitTime)
endif

if (_Lkey != 0)
	return(_Lkey)
elseif (_Mkey != 0)
	inkey(.1)
	return(1000+_Mkey)
else
	return(NIL)
endif

function SubTime(_EndTime,_StartTime)
****************************************************************************
*	Function SubTime													   *
*	Description: subtracts the second time parameter from the first 	   *
*	Variables (required): _EndTime - the ending time					   *
*						  _StartTime - the starting time				   *
*	Returns: the difference between the _StartTime and the _EndTime 	   *
****************************************************************************
Local _StartHrs,_StartMins,_StartSecs,_EndHrs,_EndMins,_EndSecs

_StartHrs:=val(substr(_StartTime,1,2))
_StartMins:=val(substr(_StartTime,4,2))
_StartSecs:=val(substr(_StartTime,7,2))
_EndHrs:=val(substr(_EndTime,1,2))
_EndMins:=val(substr(_EndTime,4,2))
_EndSecs:=val(substr(_EndTime,7,2))

if _EndSecs < _StartSecs
	_EndMins -= 1
	_EndSecs+=60
endif
if _EndMins < _StartMins
	_EndHrs -= 1
	_EndMins += 60
endif
if _EndHrs < _StartHrs
    _EndHrs+=24
endif

return(padl(alltrim(str(_EndHrs-_StartHrs)),2,"0")+":"+;
	   padl(alltrim(str(_EndMins-_StartMins)),2,"0")+":"+;
	   padl(alltrim(str(_EndSecs-_StartSecs)),2,"0"))

function NumSeconds(_Time)
*******************************************************************************
*	Function NumSeconds 													  *
*	Description: Gives the number of seconds to the given time from 00:00:00  *
*	Variable (required): _Time - time to count to.							  *
*	Returns: Number of seconds from 00:00:00 until the given time			  *
*******************************************************************************
Local _Hrs,_Mins,_Secs
_Hrs:=val(substr(_Time,1,2))
_Mins:=val(substr(_Time,4,2))
_Secs:=val(substr(_Time,7,2))
return(_Secs+(_Mins*60)+(_Hrs*3600))


* Message.prg
* All functions which put messages on the screen and optionally return a
* result.  Not menu functions.
* 1) Message
* 3) xMessage
* 2) yes_or_no


Function Message(_Top,_Left,_Bottom,_Right,_Title,_Message,_Colors,_Center)
*******************************************************************************
*	Function Message														  *
*	Description: Places a box on the screen with the given message displayed  *
*				 in the given colors, centered if specified.				  *
*	Variables: _Top (required): top coordinate of the box					  *
*			   _Left (required): left coordinate of the box 				  *
*			   _Bottom (required): bottom coordinate of the box 			  *
*			   _Right (required): right coordinate of the box				  *
*			   _Title (Optional): Title of box								  *
*			   _Message (Required): Message to displayed					  *
*			   _Colors (Optional): Colors in which to display box			  *
*			   _Center (Optional): If .t. the box will be centered on screen  *
*	Returns: Nothing
*******************************************************************************
Local _MessageWidth,_BoxWidth,_NumLines,_PreColor,_PreCursor,_NumSpaces,_Scratch
private _T,_L,_B,_R,_C,_scratch1

_PreColor:=setcolor()
_PreCursor:=setcursor()
_MessageWidth:=len(_Message)

DEFAULT _Top TO 0,;
		_Left TO 0,;
		_Center TO .f.

set cursor off
setcolor(_Colors)
if empty(_Right)
	if (_Left+_MessageWidth+2 < 79)
		_Right:=_Left+_MessageWidth+2
	else
		_Right:=79
	endif
endif
_BoxWidth:=_Right-_Left+1
_NumLines:=mlcount(_Message,_BoxWidth-2)

if empty(_Bottom)
	if (_left+_MessageWidth+2 < 79)
		_Bottom:=_Top+7
	else
		_Bottom:=_Top+6+_NumLines
		if _Bottom > 24
			_Bottom:=24
		endif
	endif
endif

if _Center
	_NumSpaces:=80-(_Right-_Left+1)
	_NumSpaces:=int(_NumSpaces/2)
	_Left:=_NumSpaces
	_Right:=_Left+_BoxWidth
endif
if !empty(_Title)
	if len(_Title) > _BoxWidth
		_Title:=substr(_Title,1,_BoxWidth)
	endif
endif
_T:=_Top+2
_R:=_Right-1
_L:=_Left+1
_B:=_Bottom-5
_C:=_Colors
_Scratch:=explobox(_Top,_Left,_Bottom,_Right,"Ŀ ",_C,_Title)
_Scratch1:=int((_Right-_Left+1)/2)-3
_Scratch1:=_Left+_Scratch1
setcolor("n/w")
@ _Bottom-3,_Scratch1 TO _Bottom-1,_Scratch1+5
@ _Bottom-2,_Scratch1+1 say " OK "
setcolor(_Colors)
memoedit(_Message,_T,_L,_B,_R,.f.,"msgs")
win_rest(_Scratch)
setcolor(_PreColor)
setcursor(_PreCursor)
return(NIL)

Function xMessage(_Top,_Left,_Message,_Colors,_Center)
*******************************************************************************
*	Function xMessage														  *
*	Description: Places a box on the screen with the given message displayed  *
*				 in the given colors, centered if specified.				  *
*	Variables: _Top (required): top coordinate of the box					  *
*			   _Left (required): left coordinate of the box 				  *
*			   _Message (Required): Message to displayed					  *
*			   _Colors (Optional): Colors in which to display box			  *
*			   _Center (Optional): If .t. the box will be centered on screen  *
*	Returns: string to be used with win_rest() to remove to message 		  *
*******************************************************************************
Local _MessageWidth,_BoxWidth,_NumLines,_PreColor,_PreCursor,_NumSpaces,_Scratch
Local _Scratch1,_Bottom,_Right

_PreColor:=setcolor()
_PreCursor:=setcursor()
_MessageWidth:=len(_Message)

DEFAULT _Top TO 0,;
		_Left TO 0,;
		_Center TO .f.

set cursor off
setcolor(_Colors)
_Right:=_Left+_MessageWidth+1
if _Right > 79
	_Right:=79
endif
if _Right == 79
	_Left:=_Right-_MessageWidth-2
endif
if _Left < 0
	_Left:=0
endif
_BoxWidth:=_Right-_Left+1
_Message:=substr(_Message,1,_BoxWidth-2)

_Bottom:=_Top+2

if _Center
	_NumSpaces:=80-(_Right-_Left+1)
	_NumSpaces:=int(_NumSpaces/2)
	_Left:=_NumSpaces
	_Right:=_Left+_BoxWidth
endif

_Scratch:=explobox(_Top,_Left,_Bottom,_Right,"Ŀ ",_Colors)
@ _Top+1,_Left+1 say _Message
setcolor(_PreColor)
setcursor(_PreCursor)
return(_Scratch)

Function Yes_or_No(_Top,_Left,_Bottom,_Right,_Title,_Message,_Colors,_Center)
*******************************************************************************
*	Function Yes_or_No														  *
*	Description: Places a box on the screen with the given message displayed  *
*				 in the given colors, centered if specified.				  *
*	Variables: _Top (required): top coordinate of the box					  *
*			   _Left (required): left coordinate of the box 				  *
*			   _Bottom (required): bottom coordinate of the box 			  *
*			   _Right (required): right coordinate of the box				  *
*			   _Title (Optional): Title of box								  *
*			   _Message (Required): Message to displayed					  *
*			   _Colors (Optional): Colors in which to display box			  *
*			   _Center (Optional): If .t. the box will be centered on screen  *
*	Returns: .t. if user answers yes, .f. if user answers no				  *
*******************************************************************************
Local _MessageWidth,_BoxWidth,_NumLines,_PreColor,_PreCursor,_NumSpaces,_Scratch
PRIVATE _Answer:=.t.,_R,_L,_B,_C,_T,_scratch1

_PreColor:=setcolor()
_PreCursor:=setcursor()
_MessageWidth:=len(_Message)

DEFAULT _Top TO 0,;
		_Left TO 0,;
		_Center TO .f.

set cursor off
setcolor(_Colors)
if empty(_Right)
	if (_Left+_MessageWidth+2 < 79)
		_Right:=_Left+_MessageWidth+2
	else
		_Right:=79
	endif
endif
_BoxWidth:=_Right-_Left+1
if _BoxWidth < 20
	_BoxWidth:=20
	_Right:=_Left+19
	if _Right > 79
		_Left:=_Left-(_Right-79)
		_Right:=79
	endif
endif
_NumLines:=mlcount(_Message,_BoxWidth-2)

if empty(_Bottom)
	if (_left+_MessageWidth+2 < 79)
		_Bottom:=_Top+7
	else
		_Bottom:=_Top+6+_NumLines
		if _Bottom > 24
			_Bottom:=24
		endif
	endif
endif

if _Center
	_NumSpaces:=80-(_Right-_Left+1)
	_NumSpaces:=int(_NumSpaces/2)
	_Left:=_NumSpaces
	_Right:=_Left+_BoxWidth
endif

if len(_Title) > _BoxWidth
	_Title:=substr(_Title,1,_BoxWidth)
endif
_T:=_Top+2
_R:=_Right-1
_L:=_Left+1
_B:=_Bottom-5
_C:=_Colors
_Scratch:=explobox(_Top,_Left,_Bottom,_Right,"Ŀ ",_C,_Title)
_Scratch1:=int((_Right-_Left+1)/2)-7
_Scratch1:=_Left+_Scratch1
setcolor("n/w")
@ _B+1,_Scratch1 TO _B+3,_Scratch1+6
@ _B+2,_Scratch1+1 say " Yes "
@ _B+1,_Scratch1+8 CLEAR TO _B+3,_Scratch1+13
@ _B+2,_Scratch1+9 say " No "
setcolor(_Colors)
memoedit(_Message,_T,_L,_B,_R,.f.,"Yon")
win_rest(_Scratch)
setcolor(_PreColor)
setcursor(_PreCursor)
return(_Answer)

static function Yon(mode,line,col)
Local _ret_val,_lkey,_Scratch1
if (mode == ME_IDLE)
	_lkey = getkey(0)
	do case
		case _lkey == K_LMOUSE
			_Scratch1:=int((_R-_L+1)/2)-7
			_Scratch1:=_L+_Scratch1
            if (_MRow() >= _B+1) .and. (_MRow() <= _B+3)
				if (_MCol() >=_scratch1) .and. (_MCol() <= _Scratch1+6)
                    setcolor("n/w")
					@ _B+1,_Scratch1 TO _B+3,_Scratch1+6
					@ _B+2,_Scratch1+1 say " Yes "
					@ _B+1,_Scratch1+8 CLEAR TO _B+3,_Scratch1+13
					@ _B+2,_Scratch1+9 say " No "
					setcolor(_C)
					_answer:=.t.
                endif
            endif
			if (_MRow() >= _B+1) .and. (_MRow() <= _B+3)
				if (_MCol() >=_scratch1+8) .and. (_MCol() <= _Scratch1+13)
                    setcolor("n/w")
					@ _B+1,_Scratch1 CLEAR TO _B+3,_Scratch1+6
					@ _B+2,_Scratch1+1 say " Yes "
					@ _B+1,_Scratch1+8 TO _B+3,_Scratch1+13
					@ _B+2,_Scratch1+9 say " No "
					setcolor(_C)
					_answer:=.f.
                endif
            endif
			keyboard chr(K_LMOUSE)
        case _lkey == K_RMOUSE
			keyboard chr(K_CTRL_W)
		case _lkey == K_LRMOUSE
			keyboard chr(K_CTRL_W)
		case (_lkey == K_ENTER)
			keyboard chr(K_CTRL_W)
		case (_lkey == K_TAB) .or. (_lkey == K_LEFT) .or. (_lkey == K_RIGHT)
			if _answer
				_Answer:=.f.
				_Scratch1:=int((_R-_L+1)/2)-7
				_Scratch1:=_L+_Scratch1
                setcolor("n/w")
				@ _B+1,_Scratch1 CLEAR TO _B+3,_Scratch1+6
				@ _B+2,_Scratch1+1 say " Yes "
				@ _B+1,_Scratch1+8 TO _B+3,_Scratch1+13
				@ _B+2,_Scratch1+9 say " No "
				setcolor(_C)
            else
				_Answer:=.t.
				_Scratch1:=int((_R-_L+1)/2)-7
				_Scratch1:=_L+_Scratch1
				setcolor("n/w")
				@ _B+1,_Scratch1 TO _B+3,_Scratch1+6
				@ _B+2,_Scratch1+1 say " Yes "
				@ _B+1,_Scratch1+8 CLEAR TO _B+3,_Scratch1+13
				@ _B+2,_Scratch1+9 say " No "
				setcolor(_C)
            endif
			keyboard chr(_lkey)
		otherwise
			keyboard chr(_lkey)
	endcase
endif
return(ME_DEFAULT)

static function msgs(_mode, _line, _col)
local _lkey
if (_mode == ME_IDLE)
	_lkey:=getkey(0)
	do case
		case _lkey == K_LMOUSE
			keyboard chr(K_CTRL_W)
        case _lkey == K_RMOUSE
			keyboard chr(K_CTRL_W)
        case _lkey == K_LRMOUSE
			keyboard chr(K_ESC)
        case _lkey == K_RETURN
			keyboard chr(K_CTRL_W)
		otherwise
			keyboard chr(_lkey)
	endcase
endif
return(ME_DEFAULT)

