/*

Program Name  npSpell.prg

Purpose       Spell checker for Funck(y) II's notepad()

Author        Stephen L. Woolstenhulme    CIS 73060,1302
              3805 Indigo Drive
              Plano, Texas 75075

Notice        Copyright (c) 1992
              Stephen L. Woolstenhulme
              All Rights Reserved

Function      npSpell( np, cDelim )

Parameters    "np"      The NotePad object to check.

              "cDelim"  An optional character string of delimiters for
                        tokens.  I recommend you let npSpell use its
                        defaults!

*/

#include "inkey.ch"
#include "FUNCky.ch"
#define K_ALT_BS 270

#xcommand ifNil <xVar> is <xVal> => ;
                <xVar> := iif( <xVar> == Nil, <xVal>, <xVar> )

function npSpell( np, cDelim )
   local aCurWin := {}, aNewWin := {}, aSkipAll := {}
   local cWord, cScrn := savescreen( 0, 0, maxrow(), maxcol() )
   local i, nPos, nWordCount := 0
   local lFound
   local cTitleBuffer := '', nTitlePos := 0, nTitleAttr := 0

   gettitle( @cTitleBuffer, @nTitlePos, @nTitleAttr )
   npSetBookMark( np, 10 )
   
   if cDelim == Nil
       cDelim := chr(9) + chr(10) + chr(12) + chr(13) + chr(32) + chr(38) + ;
                 '~`$%^@.,-_!?/\|;:(){}[]<>#+=*"0123456789'
   endif
   
   if select( 'dict' ) == 0
       use np_dict alias dict shared new
   
       if ! file( 'npalpha' + indexext() )
           @ maxrow(), 0 say padc( 'Indexing Main Dictionary Alphabetically ...', maxcol() + 1 ) color 'w+/rb'
           index on dict->WORD to npalpha
           set index to
       endif
   
       if ! file( 'npsound' + indexext() )
           @ maxrow(), 0 say padc( 'Indexing Main Dictionary By Soundex ...', maxcol() + 1 ) color 'w+/rb'
           index on soundex( dict->WORD ) to npsound
           set index to
       endif
   
       set index to npalpha, npsound
   endif

   if select( 'dictu' ) == 0
        
       if ! file( 'np_dictu.dbf' )
           dbcreate( 'np_dictu.dbf', dict->( dbstruct() ) )
       endif
   
       use np_dictu alias dictu shared new
   
       if ! file( 'npalphau' + indexext() )
           @ maxrow(), 0 say padc( 'Indexing Auxiliary Dictionary ...', maxcol() + 1 ) color 'w+/rb'
           index on dictu->WORD to npalphau
           set index to
       endif
   
       set index to npalphau
   endif

   npHome( np )
   
   do while ! npIsToken( np, cDelim )
       npTokenRight( np, cDelim )
   enddo
   
   nPos := npCsrIndex( np, 0 )
   cls( 23, chr( 177 ) )
   aCurWin := { npWinTop( np ), npWinLeft( np ), npWinBottom( np ), npWinRight( np ) }
   aNewWin := { 2, 5, round( maxrow()*.3, 0 ), maxcol() - 5 }
   npWinResize( np, aNewWin[1], aNewWin[2], aNewWin[3], aNewWin[4] )
   
   box( npWinTop( np )-1,               ;
        npWinLeft( np )-2,              ;
        npWinBottom( np )+1,            ;
        npWinRight( np )+2, '', 23 )     
   npDisplay( np )
   settitle( ' Suggested Words ', 1, 31 )
   
   box( npWinBottom( np ) + 4,        ;
        npWinLeft( np ) - 2,          ;
        npWinBottom( np ) + 14,       ;
        npWinRight( np ) + 2, '', 23 )     
   @ maxrow(), 0 say padc( 'Checking spelling ...', maxcol() + 1 ) ;
                            color 'w+/rb'
   
   do while npCsrIndex( np ) < npBuffSize( np )
       cWord := padr( upper( npGetToken( np, cDelim ) ), len( dict->WORD ) )
       
       if ! empty( cWord )
           nWordCount++
           lFound := dict->( dbseek( cWord, .t. ) ) // look in main dictionary
           
           if ! lFound
               if left( cWord, 1 ) == "'"
                   cWord := padr( substr( cWord, 2 ), len( dict->WORD ) )
               endif
               
               if right( trim( cWord), 1 ) == "'"
                   cWord := padr( substr( cWord, 1, len( trim( cWord ) ) - 1 ), len( dict->WORD ) )
               endif
               
               if right( trim( cWord ), 2 ) == "'S" // check root of 'S words
                   cWord := strtran( cWord, "'S", "  " )
               endif
               
               lFound := dict->( dbseek( cWord, .t. ) )
               
               if ! lFound      // check user dictionary
                   lFound := dictu->( dbseek( cWord, .t. ) )
               endif
               
               // check 'skip all' array
               if ! lFound .and. ascan( aSkipAll, cWord ) == 0
                   if spellFix( np, cDelim, cWord, aSkipAll )
                       loop
                   else
                       exit
                   endif
               endif
           endif
       endif

       npTokenRight( np, cDelim )
   enddo
   
   @ maxrow(), 0 say padc( ' Dictionary checked ' + ;
                             ltrim( str( nWordCount, 5 ) ) + ;
                           ' times.  Press any key to continue ... ', ;
                             maxcol() + 1 ) color 'w+/rb'
   inkey(0)
   restscreen( 0, 0, maxrow(), maxcol(), cScrn )
   npWinResize( np, aCurWin[1], aCurWin[2], aCurWin[3], aCurWin[4] )
   settitle( cTitleBuffer, nTitlePos, nTitleAttr )
   
   box( npWinTop( np ) - 1,          ;
        npWinLeft( np )-2,             ;
        npWinBottom( np )+1,           ;
        npWinRight( np )+2, '', 23 )
        npUnMark( np )
        npgobookmark( np, 10 )
        npDisplay( np )
   @ npWinBottom( np ) + 1, npWinLeft( np ) say 'F1:Help' 
   @ npWinBottom( np ) + 1, npWinLeft( np ) + 10 say 'F2:Spell' 
   @ npWinBottom( np ) + 1, npWinRight( np ) - 19 say  'F10:Exit' 
   @ npWinBottom( np ) + 1, npWinRight( np ) - 8 say 'Esc:Abort' 
        
return NIL

static function spellFix( np, cDelim, cWord, aSkipAll )
    local getlist := {}
    local aAlpha := array(7), aSound := array(7)
    local i, nRecno := dict->( recno() ), cChoice
    local cOldWord := npGetToken( np, cDelim ), cLookUp := space(16)
    local cRoot := strtran( cOldWord, "'" )
    local nAlpha, nSound
    local lContinue := .t., lRetVal := .t.
    
    npMarkToken( np, cDelim )
    npDisplay( np )
    csrput( npScrRow( np ), npScrCol( np ) )
    lContinue := .t.
    dict->( dbSeek( cWord, .t. ) )
    nAlpha := dict->( recno() )
    dict->( dbsetorder(2) )
    dict->( dbgotop() )
    dict->( dbseek( cWord, .t. ) )
    nSound := dict->( recno() )
    dict->( dbsetorder(1) )
    dict->( dbgoto( nAlpha ) )
    
    do while lContinue
        nSound := dict->( recno() )
        // load array of options from the alpha index
        dict->( dbskip( -4 ) )
        
        for i := 1 to 7
                aAlpha[i] := dict->WORD
                dict->( dbskip(1) )
        next
        
        // load array of options from the soundex index
        dict->( dbsetorder(2) )
        dict->( dbgoto( nSound ) )
        dict->( dbskip( -4 ) )
        
        for i := 1 to 7
                aSound[i] := dict->WORD
                dict->( dbskip(1) )
        next
        
        dict->( dbsetorder(1) )
        dict->( dbgoto( nAlpha ) )
        
        // call skip/add/edit/look up/scroll code here.
        
        @ npWinBottom( np )+5, npWinLeft( np ) +  6 say ' Alphabetical Order '
        @ npWinBottom( np )+6, npWinLeft( np ) +  6 say '  '
        @ npWinBottom( np )+5, npWinLeft( np ) + 46 say ' Soundex Order '
        @ npWinBottom( np )+6, npWinLeft( np ) + 46 say '  '
        
        for i := 1 to 7
                @ npWinBottom( np )+6+i, npWinLeft( np ) + 8  say chr(i+64) + '. ' + ;
                capFirst( aAlpha[i] )
                @ npWinBottom( np )+6+i, npWinLeft( np ) + 48 say chr(i+71) + '. ' + ;
                capFirst( aSound[i] )
        next
        
        @ maxrow(), 0 clear
        @ maxrow(), 0        say ' 1:Skip '
        @ maxrow(), col()+ 1 say ' 2:Skip All '
        @ maxrow(), col()+ 1 say ' 3:Add '
        @ maxrow(), col()+ 1 say ' 4:Edit '
        @ maxrow(), col()+ 1 say ' 5:Look Up '
        @ maxrow(), col()+ 1 say ' -:Up '
        @ maxrow(), col()+ 1 say ' +:Down '
        @ maxrow(), col()+ 1 say ' Esc:Abort '
        inkey(0)
        cChoice := upper( chr( lastkey() ) )
        
        do case
                
        case cChoice $ 'ABCDEFGHIJKLMN'  // picked from alpha/soundex lists
            
            if at( cChoice, 'ABCDEFG' ) > 0
                    cWord := aAlpha[ at( cChoice, 'ABCDEFG' ) ]
            elseif at( cChoice, 'HIJKLMN' ) > 0
                    cWord := aSound[ at( cChoice, 'HIJKLMN' ) ]
            endif
            
            
            do case
                    
            case cRoot == capfirst( cRoot ) // match proper case
                    cWord := capfirst( trim( cWord ) )
                    
            case cRoot == upper( cRoot ) // match upper case
                    cWord := upper( trim( cWord ) )
                    
            otherwise
                    cWord := lower( trim( cWord ) )
                    
            endcase
            
            if left( cOldWord, 1 ) == "'"
                    cWord := "'" + cWord
            endif
            
            if right( cOldWord, 1 ) == "'"
                    cWord := trim( cWord ) + "'"
            endif
            
            npDeleteBlock( np )
            npInsertText( np, cWord )
            npDisplay( np )
            lContinue := .f.
            
        case cChoice == '1'              // picked skip
            npWordRight( np )
            lContinue := .f.
                
        case cChoice == '2'              // picked skip all
            cWord := padr( upper( cWord ), len( DICT->WORD ) )
            aadd( aSkipAll, padr( upper( npGetToken( np, cDelim ) ), len( dict->WORD ) ) )
            lContinue := .f.
            
        case cChoice == '3'              // add to dictionary
            dictu->( dbappend() )
            dictu->( rlock() )
            dictu->WORD := upper( cWord )
            dictu->( dbcommit() )
            dictu->( dbunlock() )
            lContinue := .f.
            
        case cChoice == '4'              // edit
            @ maxrow(), 0 say padc( 'Make changes, then press F10 ... ', maxcol() + 1 ) 
            npSetBookMark( np, 10 )
            notepad( np )
            npGoBookMark( np, 10 )
            lContinue := .f.
                
        case cChoice == '5'              // look up
            cLookUp := space(16)
            @ maxrow(), 0 clear
            @ maxrow(), 0 say 'Find words beginning with' get cLookUp
            read
            
            if ! lastkey() == K_ESC .and. ! empty( cLookUp )
                 dict->( dbseek( upper( trim( cLookUp ) ), .t. ) )
            endif
            
        case cChoice == '-'              // skip up
            dict->( dbskip(-5) )
            nAlpha := dict->( recno() )
            
            dict->( dbsetorder(2) )
            dict->( dbgoto(nSound) )
            dict->( dbskip(-5) )
            nSound := dict->( recno() )
            
            dict->( dbsetorder(1) )
            dict->( dbgoto(nAlpha) )
            
        case cChoice == '+'               // skip down
            dict->( dbskip(5) )
            nAlpha := dict->( recno() )
            
            dict->( dbsetorder(2) )
            dict->( dbgoto(nSound) )
            dict->( dbskip(5) )
            nSound := dict->( recno() )
            
            dict->( dbsetorder(1) )
            dict->( dbgoto(nAlpha) )
        
        case lastkey() == K_ESC
            lRetVal := .f.
            lContinue := .f.

        endcase
    enddo
    
    @ maxrow(), 0 clear
    
return lRetVal


static function npTokenRight( np, cDelim )    // Not in Funck(y), but needed.
    do while npIsToken( np, cDelim ) .and. ;
        npCsrIndex( np ) < npBuffSize( np )
        npCsrRight( np, 1 )
    enddo
    
    do while ! npIsToken( np, cDelim ) .and. ;
        npCsrIndex( np ) < npBuffSize( np )
        npCsrRight( np, 1 )
    enddo
return Nil

static function npTokenLeft( np, cDelim )     // Not in Funck(y), but needed.
    do while npIsToken( np, cDelim ) .and. ;
        npCsrIndex( np ) > 1
        npCsrLeft( np, 1 )
    enddo
        
    do while ! npIsToken( np, cDelim ) .and. ;
        npCsrIndex( np ) > 1
        npCsrLeft( np, 1 )
    enddo
return Nil

