* PROGRAM...:  INDEX.PRG
* AUTHOR....:  Alan Mulquinn
* DATE......:  May 15, 1985
* NOTICE....:  Copyright (C) 1985, Nantucket Inc.
* NOTES.....:  Produces Clipper .NTX (Index) files

* REVISONS..:  John Wright - 09/14/87
*              Added ability to display NTX value.
*              Dates sorted using DTOS not DTOC.

* Revised - 08/06/88 - ability to Escape from screen

STORE SPACE(8) TO db,nt

CLEAR
SET CONFIRM ON
* If command line argument exists, check to see that it's a valid
* file name.  If not, quit program.
IF db <> SPACE(8)
 dbf=UPPER(db)
 file= "&dbf"+".DBF"
 IF .NOT. FILE("&file")
  ? "&file does not exist"
  ? "Returning to DOS"
  RETURN
 ENDIF
  @ 10, 47 SAY dbf PICT "@!"
ENDIF

* If file name is valid or no name is given print initial screen
frame = "ͻȺ"
@ 6,26,8,53 BOX frame
@ 8,28 SAY "CLIPPER INDEXING UTILITY"
@ 1,0,7,79 BOX frame
stat_line = ""
SET COLOR TO 0/7
com_line="INDEX ON "
@ 23,0 SAY com_line + SPACE(79-LEN(com_line))
SET COLOR TO 7/0,0/7,0
@ 10, 20 SAY "Name of file to index....:"
* If no file name provided in command line prompt for one and check
* validity
IF db = SPACE(8)
 DO WHILE .T.
  dbf=SPACE(8)
  @ 10, 47 GET dbf PICT "@!"
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  dbf= TRIM(dbf)
  file= "&dbf"+".DBF"
  IF .NOT. FILE("&file")
   @ 21, 0
   @ 21, 27 SAY "&file does not exist"
  ELSE
   EXIT
  ENDIF
 ENDDO
ENDIF
* reset default drive if necessary so that .NTX is on same drive
* as .DBF
IF SUBSTR(dbf,2,1)=":"
 start=3
 drive=SUBSTR(dbf,1,1)
 SET DEFAULT TO &drive
ELSE
 start=1
ENDIF
@ 21,0
@ 22,3 SAY "Indexing: &file"
USE &dbf
* erase smaller box
@ 6,26,8,53 BOX ""
@ 7,20 SAY REPL("",35)
add_on=""
a=1
row = 2
col = 3
* get fieldnames and print in box
DO WHILE a < 26
 FOR x = a TO a+4
 @ row,col say fieldname(x)
 row=row+1
 NEXT
 IF "" = FIELDNAME(x)
  EXIT
 ELSE
  row=2
  a=a+5
  col=col+15
 ENDIF
ENDDO

IF nt <> SPACE(8)
 ntx_file=UPPER(nt)+SPACE(8)
ELSE
 ntx_file=dbf+SPACE(8)
ENDIF
ntx_file=SUBSTR(ntx_file,1,8)

over_write="N"
DO WHILE .T.
 @ 11,27 SAY "NTX file name.....:"
 @ 11,47  GET ntx_file PICT "@!"
 READ
 IF LASTKEY() = 27
  RETURN
 ENDIF
 IF start = 3
  ntx_file=drive+":"+ntx_file
 ENDIF
 IF FILE("&NTX_FILE..NTX")
  STORE "Y" TO jdw_view
  @ 13,18 SAY "NTX file exists... view index key? " GET jdw_view PICT "Y"
  READ
  @ 13,0
  IF jdw_view = "Y"
   USE &dbf INDEX &ntx_file
   STORE INDEXKEY(0) TO CHK_KEY
   @ 13,10 SAY "Index key: "+CHK_KEY
   USE &dbf
  ENDIF
  @ 16,15 SAY "File already exists....Overwrite? " GET over_write PICT "Y"
  READ
  @ 12,0 CLEAR TO 22,80
  IF over_write = "Y"
   EXIT
  ELSE
   ntx_file=space(8)
  ENDIF
 ELSE
  EXIT
 ENDIF
ENDDO
@ 16,0
row=12
field="f"
index_size=0
cmd_size=21
field_cnt=0
DO WHILE "" <> TRIM(field) .and. index_size<=100 .and. cmd_size<=254
 @ row,23 SAY "    Index field.......:"
 DO WHILE .T. .and. "" <> TRIM(field)
  field=SPACE(10)
  @ row,47 GET field PICT "!!!!!!!!!!"
  READ
  @ 21,0
  field=TRIM(field)
  DO CASE
  CASE field="RECNO()"
   field="STR(RECNO(),10)"
   field_cnt=field_cnt+1
   index_size=index_size+10
   EXIT
  CASE TYPE("&field")="U" .and. "" <> field
   @ 21,0
   @ 21,27 SAY "Field does not exist"
  CASE TYPE("&field")="M"
   @ 21,0
   @ 21,20 SAY "Do you really want to index a memo field?"
  CASE TYPE("&field")="L"
   @ 21,0
   @ 21,27 SAY "Logical fields cannot be indexed"
  OTHERWISE
   DO CASE
   CASE TYPE("&field")="N"
    * STR() with no parameters returns field length &
    * decimals in Clipper
    index_size=index_size+LEN(STR(&field))
    field_cnt=field_cnt+1
    field="STR(&field)"
    EXIT
   CASE TYPE("&field")="D"
    field="DTOS(&field)"
    index_size=index_size+8
    field_cnt=field_cnt+1
    EXIT
   OTHERWISE
    IF ""=TRIM(field)
     add_on=" TO "+ntx_file
     EXIT
    ELSE
     index_size=index_size+LEN(&field)
     field_cnt=field_cnt+1
     EXIT
    ENDIF
   ENDCASE
  ENDCASE
 ENDDO
 stat_line=stat_line+"+"+TRIM(field)
 * If first field print on command line without "+" otherwise
 * add a "+"
 IF "INDEX ON" = TRIM(com_line)
  com_line=com_line+TRIM(field)
 ELSE
  com_line=com_line+"+"+TRIM(field)
  * If command line larger than 78 scroll it off left side of screen
  wide =LEN(com_line)
  IF wide > 78
   com_line=SUBSTR(com_line,wide-78)
  ENDIF
 ENDIF
 SET COLOR TO 0/7
 @ 23,0 SAY com_line + SPACE(79-LEN(com_line))
 SET COLOR TO 7/0
 row=row+1
 cmd_size=LEN(stat_line)+21
 @ 22,55 SAY "key field size="+STR(index_size,3)
ENDDO
*Put finishing touches on command line
IF LEN(com_line) > 78
 com_line=SUBSTR(com_line,LEN(add_on)+1)+add_on
ELSE
 com_line=SUBSTR(com_line,1,LEN(com_line)-1)+add_on
ENDIF
SET COLOR TO 0/7
@ 23,0 SAY com_line + SPACE(79-LEN(com_line))
SET COLOR TO 7/0
If index_size = 0
 CLEAR
 ? "No field specified for index key"
 ? "Returning to DOS"
 RETURN
ENDIF
If index_size > 100
 CLEAR
 ? "Index key greater than 100 - Indexing aborted"
 ? "Returning to DOS"
 RETURN
ENDIF
IF cmd_size > 254
 CLEAR
 ? "Command line too long - Indexing aborted"
 ? "Returning to DOS"
 RETURN
ENDIF
*  If field date or numeric and only field, strip functions
IF field_cnt=1 .and. "DTOC(" $ stat_line
 stat_line=SUBSTR(stat_line,7,AT(")",stat_line)-7)
 com_line="INDEX ON "+stat_line+add_on
 SET COLOR TO 0/7
 @ 23,0 SAY com_line + SPACE(79-LEN(com_line))
 SET COLOR TO 7/0
ELSE
 IF field_cnt=1 .and. "STR(" $ stat_line
  stat_line=SUBSTR(stat_line,6,AT(")",stat_line)-6)
  com_line="INDEX ON "+stat_line+add_on
  SET COLOR TO 0/7
  @ 23,0 SAY com_line + SPACE(79-LEN(com_line))
  SET COLOR TO 7/0
 ELSE
  stat_line=SUBSTR(stat_line,2,LEN(stat_line)-2)
 ENDIF
ENDIF
records = STR(LASTREC())
INDEX ON &stat_line TO &ntx_file
CLOSE DATABASES
RETURN
