/*
These are some of the Netware API functions that I developed using the
NanForum Library.  I needed these particular functions for some of the
projects that I was working on.  For this reason, I haven't had the
opportunity to place them in the NanForum Library format.  I apologize
for this, but my time is extremely limited.

I have worked on several other API functions, however, not all of them
work as well as these.  These functions have all worked well for me, so
I am placing them into the public domain in hopes that they can help
somebody else the way they helped me.  Because I have not placed them in
the NanForum Library, I don't expect them to be placed in the library,
but if they are, that is perfectly fine.

These functions can be extracted from this file, changed, reformatted,
restructured, and applied in any way seen fit.  I make no claim
whatsoever to ownership of these functions.  I actually owe the
contributers to the Nanforum Library, especially Ted Means for his
FtInt86() function and Glenn Scott for the examples he gave within the
library itself.  I am using Charles Rose's 'Programmer's Guide to
Netware' for the registers needed, and applying them the the FtInt86()
function.  That's it.  I developed the RegTest.prg to test some of the
applications, however most of them cannot be tested this way because
most functions require a string parameter to be passed and/or returned.

Included here is a better version of the RegTest() procedure. The one
currently on the NanForum still does not report the HI and LOW registers
in the correct columns.  This one does.


I will be happy, however to offer any assistance - time permitting -
to anyone having problems or questions in using these functions.
Feel free to call or leave Email.

Colin L. Feeser - Development Orientation Software.
E-mail me at 72441,3362 or call 404 982-0202





#include "FTINT86.CH"
#define DOS         33



/******************** NOVELL NETWORK SPECIFIC API FUNCTIONS *****************/

Function SetBMode( nMode )  // SET BROADCAST MODE
                            // nMode => 0 = NORMAL
                            //          1 = CONSOLE ONLY
                            //          2 = STORE CONSOLE; DISCARD USER; NO RETRIEVE
                            //          3 = STORE BOTH; NO RETRIEVE
                            //          4 = GET CURRENT MODE
                            // Return =>    Current Mode

  local aRegs[ INT86_MAX_REGS ]

  aRegs[ AX ]      := makehi( 222 )                       // DEh
  aRegs[ DX ]      := nMode

  ft_int86( DOS, aRegs )

Return(IF(lowbyte(aRegs[AX])<0,lowbyte(aRegs[AX])+256,lowbyte(aRegs[AX])))



Function pStation()  // GET PHYSICAL STATION NUMBER
                     // Returns 6 character Hexadecimal Physical Node Address

  local aRegs[ INT86_MAX_REGS ]


  aRegs[ AX ]      := makehi( 238 )                       // EEh

  ft_int86( DOS, aRegs )

  Return(subs(ft_byt2hex(chr(aRegs[CX])),1,2)+;
         subs(ft_byt2hex(chr(aRegs[BX])),1,2)+;
         subs(ft_byt2hex(chr(aRegs[AX])),1,2))



Function IDNum()   // Returns Local Logical Connection Number
  local aRegs[ INT86_MAX_REGS ]


  aRegs[ AX ]      := makehi( 220 )             // DCh

  ft_int86( DOS, aRegs )

  Return(lowbyte(aRegs[ AX ])+256)



Function NextDrv()   // Returns the letter of the Last Local Drive
  local aRegs[ INT86_MAX_REGS ]

  aRegs[ AX ]      := makehi(219)                        // DBh

  ft_int86( DOS, aRegs )

Return( chr((lowbyte(aRegs[AX])+256)+65))



Function ClrConn( Conn )    // Clears the Specified Connection
                                   // from the File Server to prevent
                                   // Collision of open files during
                                   // Period Rollover. Connection should
                                   // only be cleared if necessary files
                                   // are opened.

  local aRegs[ INT86_MAX_REGS ],cResponce,cRequest


  cRequest  :=chr(210)
  cRequest  +=chr(Conn)
  cRequest  := i2bin( len(cRequest)) +cRequest
  cResponce := space(2)


  aRegs[ AX ]      := makehi( 227 )                       // E3h
  aRegs[ DS ]      := cRequest
  aRegs[ ES ]      := cResponce
  aRegs[ SI ]      := REG_DS
  aRegs[ DI ]      := REG_ES

  ft_int86( DOS, aRegs )

  cResponce := aRegs[ES]

return(LOWBYTE(aRegs[AX]))

Function SetNetErrMode(nMode)

local aRegs[ INT86_MAX_REGS ]

  /*****  Set Network Error Mode  *****
    0 = Default Mode displays messages
    1 = Does not invoke INT 24h,
        Returns Netware error code.
        for all file I/O calls in AL
    2 = Attempts to map NW error to
        DOS error and return it
        (No INT 24h).
   ************************************/
  aRegs[ AX ]      := makehi( 221 )                       // DDh
  aRegs[ DX ]      := nMode                               // 01h

  ft_int86( DOS, aRegs )

RETURN(NIL)

function FSLogin( cUser,cPassword )        // Logs User onto network.
                                           // Pass User ID and Password.
                                           // NOTE: Uses unencryted
                                           // passwords, therefore,
                                           // server must be set to use
                                           // such.

  local aRegs[ INT86_MAX_REGS ],cResponce,cRequest
  cRequest := chr(20)
  cRequest += i2bin(1)+chr(len(cUser))+cUser+chr(len(cPassword))+cPassword
  cRequest := i2bin( len(cRequest)) +cRequest


  cResponce := space(2)


  aRegs[ AX ]      := makehi( 227 )                       // E3h
  aRegs[ DX ]      := NIL
  aRegs[ DS ]      := cRequest
  aRegs[ ES ]      := cResponce
  aRegs[ SI ]      := REG_DS
  aRegs[ DI ]      := REG_ES

  ft_int86( DOS, aRegs )
  cResponce := aRegs[ES]
     ? IF(lowbyte(aRegs[AX])<0,lowbyte(aRegs[AX])+256,lowbyte(aRegs[AX]))
     ? highbyte(aRegs[AX])
     ? SUBS(cResponce,9,48)
  ENDIF


  return NIL    // NOTE - This can be set to return the responce code
                // instead of printing it.


function LastDrv()      // Function to return the last available local
                        // drive using Netware Shell API.
  local aRegs[ INT86_MAX_REGS ]

  aRegs[ AX ]      := makehi(219)                        // DBh

  ft_int86( DOS, aRegs )

  Return(chr((lowbyte(aRegs[AX])+256)+65))



/***************** END NOVELL NETWORK SPECIFIC API FUNCTIONS ****************/
