/*
 * File......: MAXCONN.PRG
 * Author....: Rodgers Moore
 * CIS ID....: 75730,2244
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Rodgers Moore and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_MAXCONN()
 *  $CATEGORY$
 *      File Server
 *  $ONELINER$
 *      Return Maximum Connections for the default Server
 *  $SYNTAX$
 *
 *      fn_MaxConn() -> nConnections_Supported
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      The Maximum number connections supported by the default File
 *      Server.  It will be a number in the range of 4 to 250.
 *      When not logged in to a Server, return value is undetermined.
 *      Also, testing shows the number to be above the valid range.
 *
 *  $DESCRIPTION$
 *
 *      This is a high-level wrapper around fn_getFSI() that just
 *      returns the Max Connections supported by the default File Server.
 *      If fn_getFSI returns an empty array, indicating an error, then
 *      this function will return 0 and you should check fn_error().
 *     
 *  $EXAMPLES$
 *
 *      qout( "Maximum File Server Connections: " + fn_maxconn() )
 *
 *  $SEEALSO$
 *     fn_get_fsi()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_MaxConn()
   local aInf := fn_getFSI()
   return iif( empty( aInf ), 0, aInf[4] )


