/*
 * File......: VERPASS.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_vBndOPw()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Verify Bindery Object Password
 *  $SYNTAX$
 *
 *     FN_vBndOPw(cObject, nType, cPassWord) => lVerifed
 *
 *  $ARGUMENTS$
 *
 *     <cObject> is the name of the Bindery Object to which you want to
 *     verify the password.  Max Length = 47
 *
 *     <nType> is the Bindery Object Type.  Manifest constants
 *	       describing the defined types are included in the NETTO.CH
 *	       header file.
 *
 *     <cPassWord> string containing the current password to be
 *		      checked for validity. Can be a maximun of 126
 *		      characters, must be in upper case, Null = no password.
 *
 *
 *  $RETURNS$
 *
 *     <lVerified> is a logical whether password was verified.
 *
 *  $DESCRIPTION$
 *
 *     This function compares the supplied password to the password
 *     stored in the bindery for the object.  If the passwork is the
 *     same it will return a true, if not it will return a false.
 *
 *     NOTE!  This function does _not_ support encrypted passwords.
 *     Due to licensing restrictions from Novell, we could not include
 *     encrypted support in this public domain release.  However, it
 *     is available.  See elsewhere in the Norton Guide for details
 *     on password encryption support.
 *
 *  $EXAMPLES$
 *
 *     lVerified :=  FN_vBndOPw("KEVIN",OT_USER,"123EWR")
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227
#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cPass)
    default cobject to "KEVIN"
    default ntype to "1"
    default cpass to ""
    IF FN_vBndOPw(cObject,Val(nType),cPass)
      Qout("Password is correct.")
    ELSE
      Qout("Password has not been verified.")
    ENDIF

  RETURN ( nil )

#endif

FUNCTION FN_vBndOPw(cObject, nType, cPassWord)

#ifdef NOENCRYPTION
  LOCAL cSend := I2BYTE(63);           // 3Fh API Request Code
         + W2HILO(nType);              // nw_int Object type
         + fn_NameL(cObject,48);       // Object Name
         + fn_NameL(cPassWord,128);    // Password Length encoded

RETURN (_fnReq(NW_LOG,cSend,"") == ESUCCESS)

#else

RETURN (_fnVerPW3(Upper(cObject), nType, Upper(cPassWord)) == ESUCCESS)

#endif

