/*
 * File......: LPTCAPT.PRG
 * Author....: Christopher Shortt / Kevin Maher
 * CIS ID....: 72760,3271
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Christopher Shortt and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define    LPTCAPTURE      223     /* DFh; Don't change */

#define    START_LPT         0     /* Don't change */
#define    END_LPT           1     /* Don't change */
#define    CANCEL_LPT        2     /* Don't change */
#define    FLUSH_LPT         3     /* Don't change */
#define    START_SPECIFIC    4     /* Don't change */
#define    END_SPECIFIC      5     /* Don't change */
#define    CANCEL_SPECIFIC   6     /* Don't change */
#define    FLUSH_SPECIFIC    7     /* Don't change */

#define    IS_SPECIFIC(x)      (((x)>=4).and.((x)<=7))   /* Don't change! */


/*  $DOC$
 *  $FUNCNAME$
 *     fn_sLPTCap()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Start LPT Capture
 *  $SYNTAX$
 *
 *     fn_sLPTCap() -> nil
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     Nil
 *
 *  $DESCRIPTION$
 *
 *  This function starts the capture process to the default LPT.  If you
 *  are running versions of Novell above 2.01, you will also need to set
 *  the print queue in order to perform a capture.  See the FN_ScapPQ()
 *  function.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *      LOCAL nServerId := FN_DefCid()
 *      LOCAL nQueue
 *      if FN_netver() > 2.0                // Link capture to PRINTQ_0
 *         nQueue := FN_gBndOID("PRINTQ_0", OT_PRINT_QUEUE)
 *         fn_Scappq(1,nServerId,nQueue)
 *      endif
 *      fn_sLPTCap()                        // Start the capture process
 *  return NIL
 *
 *  $SEEALSO$
 *   fn_cLPTCap() fn_fLPTCap() fn_eLPTCap() fn_ScapPQ()
 *  $END$
 */


function fn_sLPTCap()
  return _fnlpt( START_LPT )



/*  $DOC$
 *  $FUNCNAME$
 *     fn_eLPTCap()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     End LPT Capture
 *  $SYNTAX$
 *
 *     fn_eLPTCap() -> nil
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     Nil
 *
 *  $DESCRIPTION$
 *
 *  This function ends the capture process to the default LPT.
 *  Unlike the Cancel function, this call releases the captured data
 *  to the printer.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *     return fn_eLPTCap()
 *
 *  return NIL
 *
 *  $SEEALSO$
 *     fn_sLPTCap() fn_fLPTCap() fn_cLPTCap()
 *  $END$
 */



function fn_eLPTCap()
  return _fnlpt( END_LPT )



/*  $DOC$
 *  $FUNCNAME$
 *     fn_cLPTCap()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Cancel LPT Capture
 *  $SYNTAX$
 *
 *     fn_cLPTCap() -> nil
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     NIL
 *
 *  $DESCRIPTION$
 *
 *  This function cancels the capture process to the default LPT. It does not
 *  send any data from the capture file to the printer.
 *
 *  $EXAMPLES$
 *
 *       function main()
 *         return fn_cLPTCap()
 *
 *  $SEEALSO$
 *   fn_sLPTCap() fn_fLPTCap() fn_eLPTCap()
 *  $END$
 */


function fn_cLPTCap()
  return _fnlpt( CANCEL_LPT )



/*  $DOC$
 *  $FUNCNAME$
 *     fn_fLPTCap()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Flushes the LPT capture buffer for the default printer.
 *  $SYNTAX$
 *
 *     fn_fLPTCap() -> nil
 *
 *  $ARGUMENTS$
 *
 *     None.
 *
 *  $RETURNS$
 *
 *     Nil
 *
 *  $DESCRIPTION$
 *
 *  This function flushes the capture buffer associated to the default
 *  printer by releasing the buffer to the printer if the capture was
 *  to a network printer. If the capture is to a file, the file is closed.
 *  The connection to the print queue is maintained by this call and
 *  the capture continues. A new capture file is created with the next
 *  charater sent after this call.
 *
 *  This call clears the Capture in Progress and Print Job Valid flags while
 *  maintaining the LPT Capture and Print Queue Capture flags.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *     return fn_fLPTCap()
 *
 *  $SEEALSO$
 *   fn_sLPTCap() fn_eLPTCap() fn_cLPTCap()
 *  $END$
 */


function fn_fLPTCap()
  return _fnlpt( FLUSH_LPT )



/*  $DOC$
 *  $FUNCNAME$
 *     fn_sSpLPTc()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Start specific LPT capture
 *  $SYNTAX$
 *
 *     fn_sSpLPTc( nLPTNo ) -> nil
 *
 *  $ARGUMENTS$
 *
 *     <nLPTno> is the specific LPT capture buffer to cancel.
 *				1 - LPT1, 2 - LPT2, 3 - LPT3
 *
 *  $RETURNS$
 *
 *      Nil
 *
 *  $DESCRIPTION$
 *
 *  This function starts the capture process associated with a specific LPT.
 *  If you are running versions of Novell above 2.01, you will also need to
 *  set the print queue in order to perform a capture.  See the FN_ScapPQ()
 *  function.
 *
 *  $EXAMPLES$
 *
 *  function StartSpecific(nLpt)
 *      LOCAL nServerId := FN_DefCid()
 *      LOCAL nQueue
 *      if FN_netver() > 2.0                // Link capture to PRINTQ_0
 *         nQueue := FN_gBndOID("PRINTQ_0", OT_PRINT_QUEUE)
 *         fn_Scappq(nLpt,nServerId,nQueue)
 *      endif
 *      fn_ssLPTC(nLpt)                    // Start the capture process
 *  return NIL
 *
 *  $SEEALSO$
 *   fn_cSpLPTc() fn_fSpLPTc() fn_eSpLPTc() fn_Scappq()
 *  $END$
 */


function fn_sSpLPTc( nLPTNo )
  return _fnlpt( START_SPECIFIC, nLPTNo )


/*  $DOC$
 *  $FUNCNAME$
 *     fn_eSpLPTc()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     End specific LPT capture
 *  $SYNTAX$
 *
 *     fn_eSpLPTc( nLPTNo ) -> nil
 *
 *  $ARGUMENTS$
 *
 *     <nLPTno> is the specific LPT capture buffer to end.
 *				1 - LPT1, 2 - LPT2, 3 - LPT3
 *
 *  $RETURNS$
 *
 *     Nil
 *
 *  $DESCRIPTION$
 *
 *  This function ends the capture process to a specific LPT.
 *  Unlike the Cancel function, this call releases the captured data
 *  to the printer.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *     return fn_eSpLPTc( 1 )
 *
 *  $SEEALSO$
 *   fn_sSpLPTC() fn_fSpLPTC() fn_cSpLPTC()
 *  $END$
 */



function fn_eSpLPTc( nLPTNo )
  return _fnlpt( END_SPECIFIC, nLPTNo  )




/*  $DOC$
 *  $FUNCNAME$
 *     fn_cSpLPTc()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Cancel specific LPT capture
 *  $SYNTAX$
 *
 *     fn_cSpLPTc( nLPTno ) -> nil
 *
 *  $ARGUMENTS$
 *
 *     <nLPTno> is the specific LPT capture buffer to cancel.
 *				1 - LPT1, 2 - LPT2, 3 - LPT3
 *
 *  $RETURNS$
 *
 *     Nil
 *
 *  $DESCRIPTION$
 *
 *  This function cancels the capture buffer associated with the specific
 *  printer.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *     return fn_cSpLPTc( 1 )
 *
 *  $SEEALSO$
 *   fn_sSpLPTC() fn_eSpLPTC() fn_fSpLPTc()
 *  $END$
 */


function fn_cSpLPTc( nLPTNo )
  return _fnlpt( CANCEL_SPECIFIC, nLPTNo )


/*  $DOC$
 *  $FUNCNAME$
 *     fn_fSpLPTc()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Flush specific LPT capture
 *  $SYNTAX$
 *
 *     fn_fSpLPTc( nLPTNo ) -> nil
 *
 *  $ARGUMENTS$
 *
 *     <nLPTno> is the specific LPT capture buffer to cancel.
 *				1 - LPT1, 2 - LPT2, 3 - LPT3
 *
 *  $RETURNS$
 *
 *      Nil
 *
 *  $DESCRIPTION$
 *
 *  This function flushes the capture buffer associated with the specified
 *  printer by releasing the buffer to the printer if the capture was
 *  to a network printer. If the capture is to a file, the file is closed.
 *  The connection to the print queue is maintained by this call and
 *  the capture continues. A new capture file is created with the next
 *  charater sent after this call.
 *
 *  This call clears the Capture in Progress and Print Job Valid flags while
 *  maintaining the LPT Capture and Print Queue Capture flags.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *     return fn_fSpLPTc( 1 )
 *
 *  $SEEALSO$
 *   fn_sSpLPTC() fn_eSpLPTC() fn_cSpLPTc()
 *  $END$
 */


function fn_fSpLPTc( nLPTNo )
  return _fnlpt( FLUSH_SPECIFIC, nLPTNo )



/* ----------------------------------------------------------------------- */



static function _fnlpt( nServ, nLpt )
  local aRegs[ INT86_MAX_REGS ]

  default nLpt to 1

  aRegs[ AX ] := makehi( LPTCAPTURE )
  // put in extra parens around makehi() so order of operations is correct.
  aRegs[ DX ] := iif( IS_SPECIFIC( nServ ), makehi( (nLpt - 1) ), 0 ) + nServ

  _fnSetErr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )

  return nil
