/*
 * File......: CREATDIR.PRG
 * Author....: Ted Means
 * CIS ID....: 73067,3332
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.CH"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_MKDIR()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Create directory
 *  $SYNTAX$
 *
 *     fn_MkDir( <nHandle>, <nRights> [, <cPath>]  ) --> <nStatus>
 *
 *  $ARGUMENTS$
 *
 *    <nHandle> is a handle to a directory path, usually obtained with
 *              fn_alTemDH().
 *
 *    <nRights> contains the maximum rights mask.  Since the rights are
 *              specified as a bit pattern, you may wish to use the values
 *              defined in netto.CH (see example below).
 *
 *    <cPath> is the desired pathspec.  If the pathspec is fully defined
 *            by the handle, then pass an empty string or NIL.
 *
 *  $RETURNS$
 *
 *    <nStatus> will be zero if the directory was created.  If an error
 *              occurred then <nStatus> will likely be NO_CREATE_PRIVILEGES
 *              or VOLUME_DOES_NOT_EXIST.
 *
 *  $DESCRIPTION$
 *
 *    This call creates a directory on a file server, given the directory
 *    path and the maximum rights for the directory.
 *
 *  $EXAMPLES$
 *
 *    // Create a directory with read/write privileges only
 *
 *    fn_MkDir(  0, MRM_READ + MRM_WRITE, "SYS:\THISDIR" )
 *
 *    // Create a directory with full priveleges using a handle
 *
 *    aDHInfo := fn_alTemDH( 0, "X", "VOL1:\" )
 * 
 *    fn_MkDir( aDHInfo[ 1 ], 255, "THATDIR" )
 *
 *  $SEEALSO$
 *    fn_RmDir() fn_GetCD() fn_RenDir()
 *  $INCLUDE$
 *    netto.CH (only needed if you want to make use of the #defines for
 *              the Maximum Rights Mask).
 *  $END$
 */

function fn_MkDir( nHandle, nRights, cPath )
  local cReply

  default cPath to ""

  cReply := i2bin( 0 )

  return _fnReq( 226, chr( 10 )           + ;   // Subservice 0Ah
                       chr( nHandle )      + ;   // Convert handle to char
                       chr( nRights )      + ;   // Make bit pattern
                       chr( len( cPath ) ) + ;   // Length of pathspec
                       cPath,                ;   // Pathspec string
                       @cReply )

