/*
 * File......: CHQJPOS.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_CHQJBPO()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Change queue job position 
 *  $SYNTAX$
 *
 *     fn_chQJbPo( nQueueID, nJob, nPos ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJob>     is the job number
 *     <nPos>     is the new job position 
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_chQJbPo( nQueueID, nJob, nPos  ) 
  local cReq, cRep, aJob := {}, lRes

  if pcount() == 3 .and. ;
     valtype( nQueueID ) == "N" .and.;
     valtype( nJob )     == "N" .and.;
     valtype( nPos )     == "N"

     cReq := I2BYTE( 110 )  + L2HILO( nQueueID ) + ;       // 6Eh
             W2HILO( nJob ) + I2BYTE( nPos )
     cRep := ""

     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )
  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
