/*
 * File......: VOLINFH.PRG
 * Author....: David Minter
 * CIS ID....: 
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by [] and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_VOLINFH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get volume information with handle
 *  $SYNTAX$
 *
 *     fn_volinfH( <nHandle> ) -> aInfStruct
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *    aInfStruct, an array as follows:
 *
 *         Subscript            Contents
 *         ---------            -------------------------------------------
 *
 *            1                    Sectors per block (Numeric).  The number
 *                                 of 512-byte sectors in each block.
 *            2                    Total blocks (Numeric)
 *                                 Number of blocks on the volume.
 *            3                    Available blocks (Numeric)
 *                                 Unused blocks on a volume.
 *            4                    Total directory slots (Numeric)
 *            5                    Available directory slots (Numeric)
 *            6                    Volume name (Char, max len 16)
 *            7                    Volume is removable (logical) 
 *
 *    If aInfStruct is empty, an error occurred.  Check fn_error().
 *
 *  $DESCRIPTION$
 *
 *    This call returns information about a volume, given a directory handle
 *    (this is not the same as a DOS file handle).  
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */



#include "netto.ch"


function fn_volinfH( nHandle )
  local cReq, cRep, aRes := {}

  if pcount() == 1 .and. valtype( nHandle ) == "N"

     cReq := I2BYTE( 21 ) + I2BYTE( nHandle )
     cRep := repl( chr(0), 30 )

     if _fnReq( 226, cReq, @cRep ) == ESUCCESS
        aRes :=  {  HILO2W( subs( cRep,  1, 2 ) ),;      // Sectors per block
                    HILO2W( subs( cRep,  3, 2 ) ),;      // Total blocks
                    HILO2W( subs( cRep,  5, 2 ) ),;      // Available blocks
                    HILO2W( subs( cRep,  7, 2 ) ),;      // Total directory slots
                    HILO2W( subs( cRep,  9, 2 ) ),;      // Available directory slots
                    fn_NoNull( subs( cRep, 11, 16 ) ),;  // Volume name (trimmed)
		               subs( cRep, 27, 1 ) # I2BYTE( 0 );   // Is Removable
                 }
     endif

  else
     _fnSetErr( EBADPARM )
  endif

  return aRes
