/*
 * File......: RENAMOBJ.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_renBndO()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Rename Bindery Object
 *  $SYNTAX$
 *
 *     FN_renBndO(cObjectName, cNewName, nObjectType) => lChanged
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Bindery Object that you are
 *		     trying to change the name for. Max length 47.
 *
 *     <cNewName> is the new name of the Bindery Object.  Maximum of
 *		  47 characters is allowed.
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.
 *
 *  $RETURNS$
 *
 *     <lChanged> if name was changed or not.
 *
 *  $DESCRIPTION$
 *
 *     This function renames a bindery object.	It requires supervisor
 *     rights.
 *
 *  $EXAMPLES$
 *
 *     lChanged :=  FN_renBndO("IDENTIFICATION", "FULLNAME", OT_USER_GROUP)
 *
 *  $SEEALSO$
 *
 *     FN_BndONam()
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"


#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN(cObject, cNewName, nType)
    IF FN_renBndO(cObject, cNewName, Val(nType))
      Qout("Object name has been changed.")
    ELSE
      Qout("Object name has not been changed.")
      Qout("Error:")
      QQout(FN_Error())
      Qout()
    ENDIF

  RETURN ( nil )

#endif

FUNCTION FN_renBndO(cOldName, cNewName, nType)

  LOCAL cSend := I2BYTE(52);		// 34h API Function Request Code
	       + W2HILO(nType); 	// nw_int Object type
	       + FN_NameL(cOldName,48); // Current Object Name Length encoded
	       + FN_NameL(cNewName,48)	// Desired Object Name Length encoded

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
