/*
 * File......: ADDR.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define E3h	227

/*  $DOC$
 *  $FUNCNAME$
 *      fn_inetAdd()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetInternetAddress
 *  $SYNTAX$
 *
 *      fn_inetAdd( [ <nConnectionNo> ] ) -> aAddress
 *
 *  $ARGUMENTS$
 *
 *      <nConnectionNo> is the Logical Connection Number that you are
 *      interested in.  If omitted, the requesting workstation's address
 *      is returned.
 *
 *  $RETURNS$
 *
 *      A 3 element array containing the following address information:
 *
 *            Position   Description            Data Type/Length
 *            
 *               1       Network Number         Character/  8
 *               2       Physical Node Address  Character/ 12
 *               3       Socket Number          Character/  4
 *
 *  $DESCRIPTION$
 *
 *      This function returns a connection's internetwork address.  The
 *      values are in hexidecimal, and left padded with "0"s.
 *
 *  $EXAMPLES$
 *
 *      aINet := fn_inetAdd( )						//  GetInternetAddress
 *
 *      ? 'Internet Address is '
 *
 *      ?? aINet[ 1 ]  + ":"							// Network number
 *      ?? aINet[ 2 ]  + ":"							// Physical Node Address
 *      ?? aINet[ 3 ]									// Socket Number
 *
 *
 *  $SEEALSO$
 *      fn_ConnInf() fn_staAddr() fn_connNum()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_inetAdd( nConnNo )
	LOCAL cReqBuffer, cRepBuffer := REPLICATE( I2BYTE( 0 ) , 12 )
	LOCAL aReply := { "", "", "" }, nRetVal := 0

	/* fetch default connection number if not specified */

	DEFAULT nConnNo TO fn_connNum()

	/* construct request packet */

	cReqBuffer := I2BYTE( ft_Hex2Dec( "13" ) ) +;
					  I2BYTE( nConnNo )

	/* call NetWare and build return array */

	IF ( _fnReq( E3h, cReqBuffer, @cRepBuffer ) == 0 )
		aReply[ 1 ] := PADL( fn_bin2hex( SUBSTR( cRepBuffer,  1,  4 ) ),  8, '0' )
		aReply[ 2 ] := PADL( fn_bin2hex( SUBSTR( cRepBuffer,  5,  6 ) ), 12, '0' )
		aReply[ 3 ] := PADL( fn_bin2hex( SUBSTR( cRepBuffer, 11,  2 ) ),  4, '0' )
	ENDIF

RETURN( aReply )


/*  $DOC$
 *  $FUNCNAME$
 *      fn_staAddr()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetStationAddress
 *  $SYNTAX$
 *
 *      fn_staAddr() -> cPhysicalNodeAddress
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      The calling workstation's physical node address, that is the address
 *      of the workstation's NIC, as a 12 digit hexidecimal character string.
 *
 *      If error, an empty string is returned.  Use fn_Error() to determine
 *      the nature of the error.  If the NetWare Shell is not loaded,
 *      fn_Error() will return ENO_SHELL, otherwise, fn_Error() will return
 *      a DOS/NetWare error code.
 *
 *  $DESCRIPTION$
 *
 *      This function returns the calling workstation's physical node
 *      address, which is the address of the workstation's NIC.
 *
 *      Since each station must have a unique physical node address on any
 *      given network, this function could be useful in deriving unique
 *      temporary filenames, among other things.
 *
 *  $EXAMPLES$
 *
 *      ? fn_staAddr()							// "00AB031002F8"
 *
 *  $SEEALSO$
 *      fn_inetadd() fn_connid() fn_conninf()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_staAddr()
	LOCAL aRegs[ INT86_MAX_REGS ], cRetVal := ""

	aRegs[ AX ] := ft_HEX2DEC( "EE00" )   // Netware Service EEh

	IF !ft_int86( INT21, aRegs )          // fetch Conn No.
		_fnSetErr( EINT86 )
	ELSE
	  IF( aRegs[ AX ] < 0, aRegs[ AX ] += 65536, )
	  IF( aRegs[ BX ] < 0, aRegs[ BX ] += 65536, )
	  IF( aRegs[ CX ] < 0, aRegs[ CX ] += 65536, )

	  cRetVal := LEFT( ft_Byt2Hex( CHR( Highbyte( aRegs[ CX ] ) ) ), 2 ) +;
	  				 LEFT( ft_Byt2Hex( CHR( Lowbyte(  aRegs[ CX ] ) ) ), 2 ) +;
					 LEFT( ft_Byt2Hex( CHR( Highbyte( aRegs[ BX ] ) ) ), 2 ) +;
					 LEFT( ft_Byt2Hex( CHR( Lowbyte(  aRegs[ BX ] ) ) ), 2 ) +;
					 LEFT( ft_Byt2Hex( CHR( Highbyte( aRegs[ AX ] ) ) ), 2 ) +;
					 LEFT( ft_Byt2Hex( CHR( Lowbyte(  aRegs[ AX ] ) ) ), 2 )
	ENDIF

RETURN ( cRetVal )
