; File......: FNSHR.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_SHR()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Shift the bits in an integer to the right
; $SYNTAX$
;
;    fn_shr( <nInt> | <cInt>, <nBits> ) -> nResult
;
; $ARGUMENTS$
;
;    <nInt> may either be a numeric integer, or a 16-bit character string
;    that is the binary representation of a numeric integer.
;
;    <nBits> is the number of bits to shift right and must be a numeric.
;
; $RETURNS$
;
;     <nResult>, a numeric
;
; $DESCRIPTION$
;
;      The value returned is obtained by shifting the bits in <nInt> to
;      the right.  <nBits> determines the number of bits to shift.
;      If any parameters are invalid, the function will return zero.
;
; $EXAMPLES$
;
;       ? fn_shr( 12, 2 )       // 3
;
; $SEEALSO$
; 
; $INCLUDE$
;
; $END$
;
;


IDEAL

PUBLIC   FN_SHR

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_SHR       FAR

         MOV       AX,6ED3h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_SHR
ENDS     _FNNET
END

