#include "netto.ch"
#include "ftint86.ch"


function _fnNCPreq( nCode, cReq, cRep )
  local aRegs[ INT86_MAX_REGS ]

  aRegs[ AX ] := makehi( 242 ) + nCode         // F2h
  aRegs[ CX ] := len( cReq )
  aRegs[ DX ] := len( cRep )
  aRegs[ DS ] := cReq
  aRegs[ SI ] := REG_DS
  aRegs[ ES ] := cRep
  aRegs[ DI ] := REG_ES

  ft_int86( INT21, aRegs )

  return UNSIGNED( LOWBYTE( aRegs[ AX ] ) ) 

