*-----------------------------------------------------------------------------
*----- The following network function are submitted by 
*----- Galen A. Grimes
*----- Pittsburgh, PA
*----- (412) 645-7500
*----- Please use as you see fit.



*-----------------------------------------------------------------------------
*----- Syntax: Net_ApBlk(<exp1>)
*-----    <exp1> = Datafile
*-----------------------------------------------------------------------------
Function  Net_ApBlk
Parameters     net_file
Private   net_file, net_scr
net_scr = Space(0)
Do While .T. 
     Append Blank
     If NetErr()
          If Empty(net_scr)
               net_scr = SaveScreen(24, 0, 24, 79 )
          EndIf
          @24,0 Say _Center(Space(3) + "Attempting to 'Append Blank' to " + Upper(net_file) + Space(3), 80)
          InKey(.5)
     Else
          If ! Empty(net_scr)
               RestScreen(24, 0, 24, 79, net_scr)
               net_scr = Space(0)
          EndIf
          Exit
     EndIf
EndDo
Return 0


*-----------------------------------------------------------------------------
*----- Syntax: Net_FLok(<exp1>)
*-----    <exp1> = Datafile
*-----------------------------------------------------------------------------
Function  Net_FLok
Parameters     net_file
Private   net_file, net_scr
net_scr = Space(0)
Do While .T. 
     FLock()
     If NetErr()
          If Empty(net_scr)
               net_scr = SaveScreen(24, 0, 24, 79)
          EndIf
          @24,0 Say _Center(Space(3) + "Attempting to 'FLock()' " + Upper(net_file) + Space(3), 80)
          InKey(.5)
     Else
          If ! Empty(net_scr)
               RestScreen(24, 0, 24, 79, net_scr)
               net_scr = Space(0)
          EndIf
          Exit
     EndIf
EndDo
Return 0


*-----------------------------------------------------------------------------
*----- Syntax: Net_RLok(<exp1>)
*-----    <exp1> = Datafile
*-----------------------------------------------------------------------------
Function  Net_RLok
Parameters     net_file
Private   net_file, net_scr
net_scr = Space(0)
Do While .T. 
     RLock()
     If NetErr()
          If Empty(net_scr)
               net_scr = SaveScreen(24, 0, 24, 79)
          EndIf
          @24,0 Say _Center(Space(3) + "Attempting to 'RLock()' " + Upper(net_file) + Space(3), 80)
          InKey(.5)
     Else
          If ! Empty(net_scr)
               RestScreen(24, 0, 24, 79, net_scr)
               net_scr = Space(0)
          EndIf
          Exit
     EndIf
EndDo
Return 0


*-----------------------------------------------------------------------------
*----- Syntax: Net_Use(<exp1>, <exp2>, <exp3>, <exp4>)
*-----    <exp1> = Datafile
*-----    <exp2> = work area
*-----    <exp3> = mode; 0 = shared, > 1 = exclusive
*-----    <exp4> = Alias
*----- NOTE: All parameters are required!
*-----------------------------------------------------------------------------

Function  Net_Use
Parameters     net_file, net_sel, net_mode, net_al
Private   net_file, net_sel, net_mode, net_al, net_scr
net_scr = Space(0)
Do While .T.
     Select (net_sel)
     If net_mode = 0
          Use (net_file) Alias &net_al
     Else
          Use (net_file) Exclusive Alias &net_al
     EndIf
     If NetErr()
          If Empty(net_scr)
               net_scr = SaveScreen(24, 0, 24, 79)
          EndIf
          @24,0 Say _Center(Space(3) + "Attempting to 'USE' " + Upper(net_file) + Space(3), 80)
          InKey(.5)
     Else
          If ! Empty(net_scr)
               RestScreen(24, 0, 24, 79, net_scr)
               net_scr = Space(0)
          EndIf
          Exit
     EndIf
EndDo
Return 0

*-----------------------------------------------------------------------------
*-----------------------------------------------------------------------------

/*----- Net_Prn.C
     Used to signal end of print stream
     Some networks will wait a period of time to see if print stream
     has ended when printing to a queued network printer.  This function
     will signal the end of the print stream.

     USE:
          ...
          Set Device To Print
          Print_Pull()              && print routine
          NetPrn()
          Set Device To Screen
          ...
     Compile using MS C 5.x or higher as per instructions in Clipper manual

-----*/

#include <nandef.h>
#include <extend.h>
#include <dos.h>

union REGS regs;

CLIPPER NETPRN()
{
     regs.h.ah = 6;
     regs.h.al = 3;
     int86(0x2A, &regs, &regs);

     _ret();
}


*-----------------------------------------------------------------------------
*-----------------------------------------------------------------------------

Function _Center
Parameters string, width
Private Spacing
Spacing = Int(Width / 2) - Int(Len(String) / 2)
If (Int(Width / 2) - Int(Len(String) / 2) % 2 = 1)
    	Return(Space(Spacing+1) + String)
Else
    	Return(Space(Spacing) + String)
Endif


