*
*  FILE......: DEMO.PRG
*  AUTHOR....: Berend M. Tober
*  DATE......: 1994/08/13
*

#include "common.ch"
#include "inkey.ch"

************************************ DEMO() ************************************
*  Usage:
*      DEMO()
*  Parameters:
*     -None-
*  Description:
*     Exercises various routines in my Networks library.
*
PROCEDURE DEMO()
   FIELD Id, LName, FName, YearBeg, Seq IN CHIEF
   CLEAR SCREEN
   ? "Demonstration of NetMode and other network-related functions"
   ?
   IF !FILE( "CHIEF.DBF")         // Create a sample database
      ? "Creating database"
      CreateDbf()
   ENDIF

   // Open database in  SHARED mode
   ? "Opening CHIEF.DBF "
   USE ("CHIEF") NEW SHARED
   NetMode( TRUE )

   USE ("AREACODE") NEW SHARED
   NetMode( TRUE )

   SELECT chief
   IF LASTREC() == 0             // Fill database with sample data
      ? "Adding data to database"
      AddData()
   ENDIF
   ?
   ? "I suggest you step through NetMode() with the debugger and"
   ? "examine the STATIC array aMode() to see what's happening ..."
   Prompt()
   ALTD()   // I suggest that you step (F8) into the next
            // routine and examing the array aMode[] just
            // prior to RETURNing.

   // Indicate mode and list data to console
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   LIST Id, LName, FName, YearBeg, Seq
   ? LASTREC(), " records"
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   Prompt()

   // Demonstrate delete in SHARED mode
   GO TOP
   CLEAR SCREEN
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   ? "Deleting "
   RLOCK()
   DBDELETE()
   UNLOCK
   LIST Id, LName, FName, YearBeg, Seq
   ? LASTREC(), " records"
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   Prompt()

   // Demonstrate PACKing in shared mode.
   CLEAR SCREEN
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   ? "PACKing ..."
   IF NetMode()
      USE chief EXCLUSIVE
      PACK
      USE chief SHARED
   ELSE
      PACK
   ENDIF
   LIST Id, LName, FName, YearBeg, Seq
   ? LASTREC(), " records"
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   Prompt()

   // Demonstrate ZAPing in shared mode.
   CLEAR SCREEN
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   ? "ZAPping ..."
   IF NetMode()
      USE chief EXCLUSIVE
      ZAP
      USE chief SHARED
   ELSE
      ZAP
   ENDIF
   LIST Id, LName, FName, YearBeg, Seq
   ? LASTREC(), " records"
   ? "Open mode is ", IF( NetMode(), "SHARED", "EXCLUSIVE")
   Prompt()

   RETURN
* end of DEMO()

STATIC FUNCTION CreateDbf()
   * Create demo database
   LOCAL aDbf := {}

   * Create structure
   AADD( aDbf, {"Id"       , "C",  9, 0})
   AADD( aDbf, {"Lname"    , "C", 20, 0})
   AADD( aDbf, {"Fname"    , "C", 10, 0})
   AADD( aDbf, {"Yearbeg"  , "C",  4, 0})
   AADD( aDbf, {"SEQ"      , "N",  3, 0})

   DBCREATE( "CHIEF", aDbf )

   RETURN NIL

STATIC FUNCTION AddData()
   * Add some data
   LOCAL aFldVal := {}
   LOCAL bGather  := {|a| AEVAL( a, {|x,i| FIELDPUT(i,x)})}

   AADD( aFldVal, {"001", "Clinton", "Bill   ", "1993", 42 })
   AADD( aFldVal, {"002", "Bush   ", "George ", "1989", 41 })
   AADD( aFldVal, {"003", "Reagan ", "Ronald ", "1981", 40 })
   AADD( aFldVal, {"004", "Carter ", "Jimmy  ", "1977", 39 })
   AADD( aFldVal, {"005", "Ford   ", "Gerald ", "1974", 38 })
   AADD( aFldVal, {"006", "Nixon  ", "Richard", "1969", 37 })
   AADD( aFldVal, {"007", "Johnson", "Lyndon ", "1963", 36 })
   AADD( aFldVal, {"008", "Kennedy", "John   ", "1961", 35 })
   AEVAL( aFldVal, {|x,i| dbAppend(), EVAL( bGather, x )})
   RETURN NIL

STATIC FUNCTION Prompt()
   ?
   ? "Press any key to continue ..."
   INKEY(0)
   RETURN NIL
*  eof: DEMO.PRG

