//͸
//  Program .....: Strtoarr                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
//  Convert A string to an Array 
//

#define CRLF   Chr(13) + Chr(10)

Function StrToArray( cString, cDelimiter, crlf_strip )

    LOCAL pos                        , ;
          tmp_array := {}                            // Define an empty array


    IF cDelimiter == NIL
       cDelimiter := ","
    ENDIF

    IF crlf_strip == NIL
      crlf_strip := .t.
    ENDIF

    WHILE (pos := AT(cDelimiter, cString)) # 0
       IF crlf_strip
         AADD(tmp_array, strip(CRLF,ltrim(trim(subs(cString, 1, pos - 1)))))
       ELSE
         AADD(tmp_array, ltrim(trim(subs(cString, 1, pos - 1))))
       ENDIF
       cString := subs(cString, pos + len(cDelimiter))

    END
    IF crlf_strip
      AADD(tmp_array, strip(CRLF,ltrim(trim(cString))))
    ELSE
      AADD(tmp_array, ltrim(trim(cString)))
    ENDIF

Return( tmp_array )
