//͸
//  Program .....: Nccbar                                
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//                                                       
//  Complie......: Clipper nccbar /n/w/a/m               
//                                                       
//  Needs........: NccBar.prg, NccPrompt.prg,            
//                 NccView.prg and Class(y)              
//                                                       
//  Purpose......: To create a menu object. See          
//                 G_Menu.prg, G_Menu.ch for example     
//                                                       
//;

//Ŀ
//  Class NccBar 
//

#include "class(y).ch"
#include "set.ch"
#include "inkey.ch"


#define D_ALT    5001

    create class NccBar

      instvar      colset
      instvar      screen
      instvar      ActivateKeys
      instvar      quickkeys

      method       sayPrompt

    export:

      instvar      winDelay
      instvar      winExplode
      instvar      promptColumns
      instvar      menusActive
      instvar      MouseActive
      instvar      BarReader
      instvar      Exception
      instvar      ExceptBlock
      instvar      cur
      instvar      promptSpace
      instvar      prompts
      instvar      row
      instvar      StandardColor
      instvar      InverseColor
      instvar      LetterColor
      instvar      GrayedColor

      method       Activate
      method       Terminate
      method       Show                  = Activate
      method       Hide
      method       Left                  = bLeft
      method       Right                 = bRight
      method       Highlight
      method       Display
      method       DehighLight
      method       AddMenuPrompt

      method       BarChoice
      method       BarSelection
      method       MenuChoice
      method       MenuSelection

      method       PromptId
      method       PromptActive
      method       PromptCheck
      method       PromptMessage
      method       PromptSubMenu

      method       isActivateKey
      method       isQuickKey
      method       PromptQuickKey
      method       KeySeek
      method       findkey
      method       BarUpdate

    endclass


    constructor new( nRow )

    local x


    ::colset           := .f.
    ::exception        := .f.
    ::winDelay         := .02
    ::winExplode       := .f.
    ::row              := if( nRow == NIL, 0, nRow )
    ::cur              := NIL
    ::ActivateKeys     := { D_ALT }
    ::promptColumns    := {}
    ::prompts          := {}
    ::quickkeys        := {}
    ::promptspace      := 0
    ::StandardColor    := SetColor()

    x                  := StrToArray( SetColor() )
    ::InverseColor     := x[2] + ','+ x[1] + ',' + x[3] + ',' + x[4]
    ::lettercolor      := subs(x[2],1,at('/',x[2])-1)+'/'+subs(x[1],at('/',x[1])+1)
    ::lettercolor      := if( ::lettercolor == 'N/N', 'N+/N', ::lettercolor )
    ::lettercolor      := if( ::lettercolor == 'W/W', 'W+/W', ::lettercolor )
    ::grayedcolor      := 'N+'+ subs(x[1],at('/',x[1]))
    ::screen           := NIL
    ::menusActive      := .f.
    ::MouseActive      := .f.
    ::barReader        := { |o| StandardReader(o) }
    ::ExceptBlock      := { |o| gx(o, (self) ) }

Return


    //Ŀ
    // Add Menu Prompts 
    //
    method Function AddMenuPrompt(                 ;
                               nId                , ;
                               cTitle             , ;
                               lActive            , ;
                               lChecked           , ;
                               cMessage           , ;
                               oSubMenu             ;
                             )

    local o


    o := NccPrompt():New( nId, cTitle, lActive, lChecked, cMessage, oSubMenu )
    aadd( ::prompts, o )
    aadd( ::promptColumns, NIL )
    aadd( ::ActivateKeys, LetterAsAltKey( o:Hotkey ) )
    if oSubMenu # NIL
      oSubMenu:usestyle   := .t.
    endif

Return( NIL )


    //Ŀ
    //  Activate Bar 
    //
    method Function Activate( nTestKey )

    local cColor        := setColor()                   , ;
          nRow          := Row()                        , ;
          nCol          := Col()                        , ;
          m             := MouseSys()                   , ;
          found                                         , ;
          i                                             , ;
          nTestPos                                      , ;
          nKey


    if ::cur == NIL
      ::cur := 1
    endif

    if ::screen == NIL
      ::screen := savescreen( ::row, 00, ::row, maxcol() )
    endif

    found := ::findkey( nTestKey )

    if ! found .and. ( nTestKey # NIL .or. m:Button # 0 )
      ::MenuChoice(0,.f.)
      Return( 0 )
    endif

    if ! ( ::cur > 0 .and. ::cur <= len( ::prompts ) )
      ::cur := 1
    endif

    if ! ::Prompts[::cur]:active
      for i = 1 to len( ::Prompts )
        if ::prompts[i]:active
          ::cur := i
          exit
        endif
      next
      if i > len(::prompts)
        aeval( ::prompts, { |x| x:SubMenu:MenuChoice(0) } )
        ::cur := 0
        Return( 0 )
      endif
    endif

    if ::screen == NIL
      ::screen := savescreen( ::row, 0, ::row, maxcol() )
    endif
    SetColor( ::StandardColor )


    if nTestKey == NIL .and. m:Button == 0
      ::dehighlight()
      ::highlight()
      if ::MenusActive .and. ::prompts[::cur]:SubMenu # NIL
        ::prompts[::cur]:SubMenu:Show()
      endif
    endif

    if ! ::isQuickKey( nTestKey )

        eval( ::BarReader, (self) )

        if ::cur > 0 .and. ::cur <= len( ::prompts ) .and. ;
           ::prompts[::cur]:SubMenu # NIL
          ::prompts[::cur]:SubMenu:Hide()
        endif

      ::dehighlight()

    endif

    m:Hide()
    SetColor( cColor )

Return( ::MenuSelection() )


    //Ŀ
    //  Test if Key if An Activation Key 
    //
    method Function isActivateKey( nTestKey )

Return( ascan( ::ActivateKeys, { |x| x == nTestKey } ) # 0 )


    //Ŀ
    //  Test if Key if a Quick Key 
    //
    method Function isQuickKey( nTestKey )

Return( ascan( ::quickKeys, { |x| x[2] == nTestKey } ) # 0 )


    //Ŀ
    //  Hide Bar 
    //
    method Function Hide()

    local x


    if ::screen # NIL
      if ::cur # 0
        if ::prompts[::cur]:SubMenu # NIL .and. ;
          ( x := ::prompts[::cur]:SubMenu:promptSubMenu() ) # NIL
          x:Hide()
        endif

        if ::MenusActive .and. ::prompts[::cur]:SubMenu # NIL
          ::prompts[::cur]:SubMenu:Hide()
        endif
      endif

      restscreen( ::row, 00, ::row, maxcol(), ::screen )
      ::screen      := NIL
      ::MenusActive := .f.
      ::colset      := .f.
    endif

Return( NIL )


    //Ŀ
    //  Terminate Bar 
    //
    method Function Terminate()

    ::ActivateKeys   := NIL
    ::promptColumns  := NIL
    ::prompts        := NIL
    ::quickkeys      := NIL
    ::active         := .f.


Return( NIL )


    //Ŀ
    //  Bar Choice 
    //
    method Function BarChoice( nCur, lNoDisplay )

    if nCur # NIL
      if lNoDisplay == NIL .or. lNoDisplay # .F.
        ::dehighlight()
      endif
      ::cur := nCur
      if nCur > 0 .and. nCur <= len( ::prompts ) .and. ;
        ( lNoDisplay == NIL .or. lNoDisplay # .f. )
        ::highlight()
      endif
    endif

Return( ::cur )


    //Ŀ
    //  Bar Id 
    //
    method Function BarSelection()

Return( if( ::cur < 1 .or. ::cur > len( ::prompts ) .or. ;
            ::prompts[::cur]:id == NIL, 0, ;
           ::prompts[::cur]:id ) )


    //Ŀ
    //  Menu Choice 
    //
    method Function MenuChoice( nCur, lNoShow )

Return( if( ::cur < 1 .or. ::cur > len( ::prompts ) , 0, ;
           if( ::prompts[::cur]:SubMenu == NIL, ;
               ::cur := 0, ;
               ::prompts[::cur]:SubMenu:MenuChoice( nCur, lNoShow ) ) ) )


    //Ŀ
    //  Menu Selection 
    //
    method Function MenuSelection()

Return( if( ::cur < 1 .or. ::cur > len( ::prompts ), 0, ;
           if( ::prompts[::cur]:SubMenu == NIL, ;
               ::prompts[::cur]:id, ;
               ::prompts[::cur]:SubMenu:MenuSelection() ) ) )


    //Ŀ
    //  Move Left on Bar 
    //
    method Function bLeft()


    if ::cur < 1
      if Set( _SET_WRAP )
        ::cur := len( ::prompts )
      else
        Return( NIL )
      endif
    elseif ::cur > len( ::prompts )
      ::cur := len( ::prompts ) +1
    else
      ::dehighlight()
    endif

    while .t.
      ::cur--
      if ::cur < 1
        if ! Set( _SET_WRAP )
          Return( NIL )
        else
          ::cur := len( ::prompts )
        endif
      endif
      if ::prompts[::cur]:active
        exit
      endif

    enddo

    ::highlight()

Return( NIL )


    //Ŀ
    //  Move Right on Bar 
    //
    method Function bRight()


    if ::cur < -1
      ::cur := 0
    elseif ::cur > len( ::prompts )
      if Set( _SET_WRAP )
        ::cur := 0
      else
        Return( NIL )
      endif
    else
      ::dehighlight()
    endif

    while .t.
      ::cur++
      if ::cur > len( ::prompts )
        if ! Set( _SET_WRAP )
          Return( NIL )
        else
          ::cur := 1
        endif
      endif
      if ::prompts[::cur]:active
        exit
      endif

    enddo

    ::highlight()

Return( NIL )


    //Ŀ
    // HighLight Bar Choice 
    //
    method Function Highlight()

    local cColor := SetColor()          , ;
          nRow   := Row()               , ;
          nCol   := Col()


    setcolor( ::InverseColor )
    @ ::row, ::promptColumns[ ::cur ] say ::prompts[::cur]:text
    setcolor( cColor )
    setpos( nRow, nCol )

Return( NIL )


    //Ŀ
    // Display Bar 
    //
    method procedure display

    if ::screen == NIL
      ::screen := savescreen( ::row, 00, ::row, maxcol() )
    endif

    ::colset := .f.
    ::dehighlight()

Return


    //Ŀ
    // Dehighlight Bar 
    //
    method Function dehighlight()

    local i                                                     , ;
          cColor := SetColor()                                  , ;
          nRow   := Row()                                       , ;
          nCol   := Col()


    SetColor( ::StandardColor )

    if ! ::colset
      @ ::row,0
      setpos( ::row, 1 )
      for i = 1 to len( ::prompts )
        if ::prompts[i]:SubMenu # NIL
          ::prompts[i]:SubMenu:TopRow     := ::row+2
          ::prompts[i]:SubMenu:LeftColumn := col()
        endif
        ::promptColumns[i]    := col()

        ::SayPrompt( i )
        setpos( ::row,::promptColumns[i] + ::promptspace +len(::prompts[i]:text))
      next
      ::colset := .t.
    else
      ::sayPrompt( ::cur )
    endif

    SetColor( cColor )
    setpos( nRow, nCol )

Return( NIL )


    //Ŀ
    //  Say Prompt 
    //
    method Function SayPrompt( i )

    local sColor := Setcolor()                  , ;
          nRow   := row()                       , ;
          nCol   := col()                       , ;
          z


    if i < 1 .or. i > Len( ::prompts )
      Return( NIL )
    endif

    if ! ::prompts[i]:active
      SetColor( ::grayedcolor )
      @ ::row, ::promptColumns[i] say ::prompts[i]:text
    else
      @ ::row, ::promptColumns[i] say ::prompts[i]:text
      SetColor( ::lettercolor )
      @ ::row, ::promptColumns[i] + ::prompts[i]:keypos -1 say ::prompts[i]:hotkey
    endif
    SetColor( sColor )
    setpos( nRow,nCol )

Return( NIL )


    //Ŀ
    // Seek Key Pressed 
    //
    method Function KeySeek(nKey)

    local cSeekKey                           , ;
          ret_Val  := 0                      , ;
          i        := 1                      , ;
          pr       := ::prompts


    for i = 1 to len( pr )

      if ! ( pr[i]:text == "" )
        cSeekKey := pr[i]:hotkey

        if uppe(chr(nKey)) == uppe(cSeekKey) .and. pr[i]:active
          exit
        endif

      endif

    Next

    if i <= len( ::prompts )
      ret_val := i
    endif

Return( ret_val )


    //Ŀ
    //  Prompt Id 
    //
    method Function PromptId( nOldId, nNewId )

    local i, nPos, nCur


    if nOldId # NIL
      nPos := ascan( ::prompts, { |x| x:Id == nCur } )
      if nPos == 0
        for i = 1 to  len( ::prompts )
          if ::prompts[i]:SubMenu # NIL .and. ::prompts[i]:SubMenu:PromptId( nOldId, nNewId )
            Return( .t. )
          endif
        next
        Return( .f. )
      endif
      nCur := nPos
    else
      if ::cur == NIL
        nCur := len( ::prompts )
      elseif ::Cur < 1 .or. ::Cur > Len( ::prompts )
        Return( .f. )
      else
        nCur := ::Cur
      endif
    endif

Return( if( nNewId == NIL                             , ;
            ::prompts[nCur]:Id                        , ;
            ::prompts[nCur]:Id := nNewId                ;
          )                                             ;
       )


    //Ŀ
    //  Prompt Active 
    //
    method Function PromptActive( nCur, lActive )

    local i, nPos


    if nCur # NIL
      nPos := ascan( ::prompts, { |x| x:Id == nCur } )
      if nPos == 0
        for i = 1 to  len( ::prompts )
          if ::prompts[i]:active .and. ::prompts[i]:SubMenu # NIL .and. ;
             ::prompts[i]:SubMenu:PromptActive( nCur, lActive )
            Return( .t. )
          endif
        next
        Return( .f. )
      endif
      nCur := nPos
    else
      if ::cur == NIL
        nCur := len( ::prompts )
      elseif ::Cur < 1 .or. ::Cur > Len( ::prompts )
        Return( .f. )
      else
        nCur := ::Cur
      endif
    endif

Return( if( lActive == NIL                            , ;
            ::prompts[nCur]:active                    , ;
            ::prompts[nCur]:active := lactive           ;
          )                                             ;
       )


    //Ŀ
    //  Prompt Check 
    //
    method Function PromptCheck( nCur, lCheck )

    local i, nPos


    if nCur # NIL
      nPos := ascan( ::prompts, { |x| x:Id == nCur } )
      if nPos == 0
        for i = 1 to  len( ::prompts )
          if ::prompts[i]:SubMenu # NIL .and. ::prompts[i]:SubMenu:PromptCheck( nCur, lCheck )
            Return( .t. )
          endif
        next
        Return( .f. )
      endif
      nCur := nPos
    else
      if ::cur == NIL
        nCur := len( ::prompts )
      elseif ::Cur < 1 .or. ::Cur > Len( ::prompts )
        Return( .f. )
      else
        nCur := ::Cur
      endif
    endif

Return( if( lCheck == NIL                             , ;
            ::prompts[nCur]:Checked                   , ;
            ::prompts[nCur]:Checked := lCheck           ;
          )                                             ;
       )


    //Ŀ
    //  Prompt Message 
    //
    method Function PromptMessage( nCur, cMessage )

    local i, nPos


    if nCur # NIL
      nPos := ascan( ::prompts, { |x| x:Id == nCur } )
      if nPos == 0
        for i = 1 to  len( ::prompts )
          if ::prompts[i]:SubMenu # NIL .and. ::prompts[i]:SubMenu:PromptMessage( nCur, cMessage )
            Return( .t. )
          endif
        next
        Return( .f. )
      endif
      nCur := nPos
    else
      if ::cur == NIL
        nCur := len( ::prompts )
      elseif ::Cur < 1 .or. ::Cur > Len( ::prompts )
        Return( .f. )
      else
        nCur := ::Cur
      endif
    endif

Return( if( cMessage == NIL                           , ;
            ::prompts[nCur]:Message                   , ;
            ::prompts[nCur]:Message := cMessage         ;
          )                                             ;
       )


    //Ŀ
    //  Prompt SubMenu 
    //
    method Function PromptSubMenu( nCur, o )

    local i, nPos


    if nCur # NIL
      nPos := ascan( ::prompts, { |x| x:Id == nCur } )
      if nPos == 0
        for i = 1 to  len( ::prompts )
          if ::prompts[i]:SubMenu # NIL .and. ::prompts[i]:SubMenu:PromptSubMenu( nCur, o )
            Return( .t. )
          endif
        next
        Return( .f. )
      endif
      nCur := nPos
    else
      if ::cur == NIL
        nCur := len( ::prompts )
      elseif ::Cur < 1 .or. ::Cur > Len( ::prompts )
        Return( .f. )
      else
        nCur := ::Cur
      endif
    endif

Return( if( o == NIL                                  , ;
            ::prompts[nCur]:SubMenu                   , ;
            ::prompts[nCur]:SubMenu := o                ;
          )                                             ;
       )


    //Ŀ
    //  Establish Quick Key 
    //
    method Function PromptQuickKey( nId, nKey )

    aadd( ::quickKeys, { nId, nKey } )

Return( NIL )


method function findkey( nTestKey )

    local nTestPos, nKey, i, ;
          o, bCurrentStack, bFoundStack, ;
          m := MouseSys()


    if m:Button # 0
      if m:Row == ::row
        i := 1
        for i = 1 to len( ::promptColumns )
          if ::promptColumns[i] <= m:Column .and. ;
             ::promptColumns[i]+len( ::prompts[i]:Text )-1 >= m:Column
             exit
          endif
        next

        if i > len( ::promptColumns )
          Return( .f. )
        else
          m:Hide()
          ::dehighlight()
          if ::MenusActive
            if ::cur >= 1 .and. ::cur <= len( ::prompts )
              if ::prompts[::cur]:SubMenu # NIL
                ::prompts[::cur]:SubMenu:Hide()
                ::MenuChoice(0,.f.)
              endif
            endif
            ::MenusActive := .t.
          endif
          ::cur := i
          ::HighLight()
          ::MenusActive := .t.
          if ::prompts[::cur]:SubMenu # NIL
            ::prompts[::cur]:SubMenu:Show()
          endif
          m:Show()
        endif
      else
        Return( .f. )
      endif
    else
      if nTestKey == NIL
        if m:Ascii # 0
          nTestKey := m:Ascii
        endif
      endif

      bCurrentStack := {}
      o := (self)
      While .t.
        if o:cur == NIL .or. o:cur < 1 .or. o:Cur > len( o:prompts )
          exit
        endif
        aadd( bCurrentStack, o:Cur )
        if ( o := o:prompts[o:cur]:SubMenu ) == NIL
          exit
        endif
      enddo

      if len(::quickkeys) # 0
        nTestPos := ascan( ::quickkeys, { |x| x[2] == nTestKey } )
        if nTestPos # 0


          for i = 1 to len( ::prompts )
            if ::prompts[i]:SubMenu == NIL
              loop
            endif
            if ( nKey := ::prompts[i]:SubMenu:FindId( ::quickkeys[nTestPos,1], .t. ) ) # 0

               ::cur := i
               ::prompts[::cur]:SubMenu:cur := nKey

               bFoundStack := {}
               o := (self)
               While .t.
                 if o:cur == NIL .or. o:cur < 1 .or. o:Cur > len( o:prompts )
                   exit
                 endif
                 aadd( bFoundStack, o:Cur )
                 if ( o := o:prompts[o:cur]:SubMenu ) == NIL
                   exit
                 endif
               enddo

              if ! ::PromptActive( ::quickkeys[nTestPos,1] )
                o := (self)
                for i = 1 to len( bCurrentStack )
                  o:Cur := bCurrentStack[i]
                  if i == len( bCurrentStack )
                    exit
                  endif
                  o := o:prompts[o:cur]:SubMenu
                next

                Return( .f. )
              else
                o := (self)
                for i = 1 to len( bCurrentStack )
                  o:Cur := bCurrentStack[i]
                  if i == len( bCurrentStack )
                    exit
                  endif
                  o := o:prompts[o:cur]:SubMenu
                next

                m:Hide()
                if ::menusActive .and. ::prompts[::cur]:SubMenu # NIL
                  ::prompts[::cur]:SubMenu:Hide()
                endif
                ::dehighlight()
                m:Show()

                o := (self)
                for i = 1 to len( bFoundStack )
                  o:Cur := bFoundStack[i]
                  if i == len( bFoundStack )
                    exit
                  endif
                  o := o:prompts[o:cur]:SubMenu
                next
                Return( .t. )
              endif

              exit

            endif
          next
          Return( .f. )
        endif
      endif

      nTestPos := ascan( ::ActivateKeys, { |x| x == nTestKey } )
      if nTestPos == 0
        Return( .f. )
      endif

      nKey := ( nTestPos-1 # 0 )

      if nTestPos-1 == 0
        for i = 1 to len( ::prompts )
          if ::prompts[i]:active
            exit
          endif
        next
        if i > len( ::prompts )
          ::MenuChoice(0,.f.)
          Return( .f. )
        endif
        nTestPos := i+1

      else
        if ! ::prompts[nTestpos-1]:Active
          ::MenuChoice(0,.f.)
          Return( .f. )
        endif
      endif

      m:Hide()
      if ::cur >= 1 .and. ::cur <= len( ::prompts )
        if ::MenusActive .and. ::prompts[::cur]:SubMenu # NIL
          ::prompts[::cur]:SubMenu:Hide()
        endif
      endif

      ::dehighlight()
      ::MenusActive := nKey
      ::cur := nTestPos - 1
      ::Highlight()

      if nKey .and. ::prompts[::cur]:SubMenu # NIL
        ::prompts[::cur]:SubMenu:MenuChoice(1,.f.)
        ::prompts[::cur]:SubMenu:Show()
      endif
      m:Show()

    endif

Return( .t. )


    //Ŀ
    //  Bar Update 
    //
    method Function BarUpdate( Block )


    local i, j

    eval( Block, (self) )
    for i = 1 to len( ::Prompts )
      if ( j := ::prompts[i]:SubMenu ) # NIL
        eval( Block, j )
        SearchMenu( j, Block )
      endif
    next

Return( NIL )


static Function SearchMenu( o, Block )

    local i, s

    for i = 1 to len( o:prompts )
      if ( s := o:prompts[i]:SubMenu ) # NIL
        eval( Block, s )
        SearchMenu( s, Block )
      endif
    next

Return( NIL )


//-----------------------------------------------------------------------------

#define LEFT_BUTTON   1
#define RIGHT_BUTTON  2
#define BOTH_BUTTONS  3


    //Ŀ
    // Default Bar Reader 
    //
static Function StandardReader(b)

    local nKey                                   , ;
          s                                      , ;
          lProcessed                             , ;
          m          := MouseSys()               , ;
          mAccept    := .f.


    m:Activate( b:MouseActive )

    while .t.
      lProcessed := .t.

      if b:MenusActive .and. b:cur > 0 .and. b:cur <= len( b:prompts )
        if b:prompts[b:cur]:Active .and. b:prompts[b:cur]:SubMenu # NIL
          if ! b:prompts[b:cur]:SubMenu:Active
            b:prompts[b:cur]:SubMenu:show()
          endif
          b:prompts[b:cur]:SubMenu:Stabilize()
        endif
      endif

      if m:ButtonHold( LEFT_BUTTON )
        m:show()
        m:update()
        mAccept := .f.

      elseif m:ButtonHold( RIGHT_BUTTON )
        m:show()
        m:update()
        loop

      else
        m:Hide()
        m:MouseRead()
        mAccept := .t.
      endif

      Do Case
        Case m:Ascii == K_UP
          if b:MenusActive .and. b:Cur > 0 .and. b:Cur <= len( b:prompts ) .and. ;
            b:prompts[b:cur]:SubMenu # NIL
            m:Hide()
            b:prompts[b:cur]:SubMenu:up()
          endif

        Case m:Ascii == K_DOWN
          if b:MenusActive .and. b:Cur > 0 .and. b:Cur <= len( b:prompts ) .and. ;
            b:prompts[b:cur]:SubMenu # NIL
            m:Hide()
            b:prompts[b:cur]:SubMenu:down()
          endif

        Case m:Ascii == K_ENTER .and. ;
             b:cur > 0 .and. b:cur <= len( b:prompts )

          if b:prompts[b:cur]:SubMenu # NIL
            if b:MenusActive
              if b:prompts[b:cur]:SubMenu:PromptActive()
                if ( s := b:prompts[b:cur]:SubMenu:PromptSubMenu() ) # NIL
                  s:MouseActive   := b:MouseActive
                  s:Shadow        := b:prompts[b:cur]:SubMenu:Shadow
                  s:usestyle      := b:prompts[b:cur]:SubMenu:usestyle
                  s:TopRow        := b:prompts[b:cur]:SubMenu:CurrentRow + 2
                  s:BottomRow     := NIL
                  s:LeftColumn    := b:prompts[b:cur]:SubMenu:RightColumn - 4
                  s:winExplode    := b:winExplode
                  s:winDelay      := b:winDelay
                  s:ExceptBlock   := { |o| gx(o, b,.t.) }
                  s:Exception     := .f.
                  s:MenuChoice( 1,.f.)
                  s:Activate()
                  if b:isQuickKey( m:ascii )
                    exit
                  elseif s:Exception
                    loop
                  elseif s:MenuSelection() == 0
                    s:Hide()
                    b:prompts[b:cur]:SubMenu:HighLight()
                  else
                    exit
                  endif
                else
                  exit
                endif
              endif
            elseif b:PromptActive()
              m:Hide()
              b:MenusActive := .t.
              if b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:MenuChoice(1,.f.)
                b:prompts[b:cur]:SubMenu:show()
              endif
            endif
         elseif b:PromptActive()
           exit
         endif

        Case m:Ascii == K_ESC .or. m:Button == RIGHT_BUTTON .or. m:Ascii == D_ALT
          if b:cur >= 1 .and. b:cur <= len( b:prompts )
            if b:MenusActive .and. b:prompts[b:cur]:SubMenu # NIL
              m:Hide()
              b:MenusActive := .f.
              if b:cur > 0 .and. b:cur <= len( b:prompts )
                b:prompts[b:cur]:SubMenu:hide()
              endif
            else
              if b:prompts[b:cur]:SubMenu # NIL
                if b:cur > 0 .and. b:cur <= len( b:prompts )
                  b:prompts[b:cur]:SubMenu:MenuChoice(0)
                else
                  aeval( b:prompts, { |x| x:SubMenu:MenuChoice(0) } )
                endif
              endif
              b:BarChoice(0)
              exit
            endif
          else
            exit
          endif

        Case m:Ascii == K_LEFT
          if ( b:cur == 1 .and. Set( _SET_WRAP ) ) .or. b:Cur # 1
            m:Hide()
            if b:MenusActive
              if b:Cur > 0 .and. b:Cur <= len( b:prompts ) .and. ;
                 b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:hide()
              endif
              b:Left()
              if b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:MenuChoice(1,.f.)
                b:prompts[b:cur]:SubMenu:show()
              endif
            else
              b:Left()
            endif
          endif

        Case m:Ascii == K_RIGHT
          if ( b:cur == len(b:prompts) .and. Set( _SET_WRAP ) ) .or. b:Cur # len(b:prompts)
            m:Hide()
            if b:MenusActive 
              if b:Cur > 0 .and. b:Cur <= len( b:prompts ) .and. ;
                 b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:hide()
              endif
              b:Right()
              if b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:MenuChoice(1,.f.)
                b:prompts[b:cur]:SubMenu:show()
              endif
            else
              b:Right()
            endif
          endif

        Case m:Row == b:Row .and. m:Button == LEFT_BUTTON
          for nKey = 1 to len( b:Prompts )
             if m:Column >= b:promptColumns[ nKey ] .and. ;
                m:Column <= b:promptColumns[ nKey ] + ;
                len( b:prompts[nKey]:text )-1 .and. ;
                b:prompts[nKey]:active
               exit
             endif
          next

          if nKey # 0
            if nKey == b:cur
              if b:cur > 0 .and. b:cur <= len( b:prompts )
                if b:prompts[b:cur]:SubMenu == NIL .and. mAccept
                  exit
                endif
                if ! b:MenusActive  .and. mAccept
                  m:Hide()
                  b:MenusActive := .t.
                  if b:prompts[b:cur]:SubMenu # NIL
                    b:prompts[b:cur]:SubMenu:MenuChoice(1,.f.)
                    b:prompts[b:cur]:SubMenu:show()
                  endif
                endif
              endif
            else
              m:Hide()
              if b:MenusActive .and. b:cur > 0 .and. b:cur <= len( b:prompts ) .and. ;
                 b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:hide()
              endif
              b:BarChoice( nKey )
              if b:cur > 0 .and. b:cur <= len( b:prompts ) .and. ;
                 b:prompts[b:cur]:SubMenu == NIL .and. mAccept
                exit
              endif
              if b:MenusActive .and. b:cur > 0 .and. b:cur <= len( b:prompts ) .and. ;
                 b:prompts[b:cur]:SubMenu # NIL
                b:prompts[b:cur]:SubMenu:MenuChoice(1,.f.)
                b:prompts[b:cur]:SubMenu:show()
              endif
            endif
          endif

        Case b:MenusActive .and. m:Button == LEFT_BUTTON .and. ;
             b:cur > 0 .and. b:cur <= len( b:Prompts ) .and. ;
             b:prompts[b:cur]:SubMenu # NIL .and. ;
             m:Row >= b:prompts[b:cur]:SubMenu:TopRow .and. ;
             m:Row <= b:prompts[b:cur]:SubMenu:BottomRow .and. ;
             m:Column >= b:prompts[b:cur]:SubMenu:LeftColumn .and. ;
             m:Column <= b:prompts[b:cur]:SubMenu:RightColumn

          if m:Row # b:prompts[b:cur]:SubMenu:CurrentRow
            m:Hide()
            b:prompts[b:cur]:SubMenu:dehighlight()
            if m:Row > b:prompts[b:cur]:SubMenu:CurrentRow
              b:prompts[b:cur]:SubMenu:cur += m:Row - b:prompts[b:cur]:SubMenu:CurrentRow
              b:prompts[b:cur]:SubMenu:RelativeRow += m:Row - b:prompts[b:cur]:SubMenu:CurrentRow
              if b:prompts[b:cur]:SubMenu:cur > len( b:prompts[b:cur]:SubMenu:prompts )
                b:prompts[b:cur]:SubMenu:cur      := len( b:prompts[b:cur]:SubMenu:prompts )
              endif
              if b:prompts[b:cur]:SubMenu:RelativeRow > b:prompts[b:cur]:SubMenu:BottomRow - b:prompts[b:cur]:SubMenu:TopRow
                b:prompts[b:cur]:SubMenu:RefreshAll(b:prompts[b:cur]:SubMenu:BottomRow - b:prompts[b:cur]:SubMenu:TopRow)
              endif
            elseif m:Row < b:prompts[b:cur]:SubMenu:CurrentRow
              b:prompts[b:cur]:SubMenu:cur -= b:prompts[b:cur]:SubMenu:CurrentRow - m:Row
              b:prompts[b:cur]:SubMenu:RelativeRow -= b:prompts[b:cur]:SubMenu:CurrentRow - m:Row
              if b:prompts[b:cur]:SubMenu:RelativeRow < 0
                b:prompts[b:cur]:SubMenu:RefreshAll(0)
              endif
            endif

            b:prompts[b:cur]:SubMenu:CurrentRow  := b:prompts[b:cur]:SubMenu:TopRow + ;
                                          b:prompts[b:cur]:SubMenu:RelativeRow
            b:prompts[b:cur]:SubMenu:highlight()

          elseif ( m:Button == LEFT_BUTTON .and. mAccept )
            if b:prompts[b:cur]:SubMenu:PromptActive()
              if ( s := b:prompts[b:cur]:SubMenu:PromptSubMenu() ) # NIL
                s:MouseActive   := b:MouseActive
                s:Shadow        := b:prompts[b:cur]:SubMenu:Shadow
                s:usestyle      := b:prompts[b:cur]:SubMenu:usestyle
                s:TopRow        := b:prompts[b:cur]:SubMenu:CurrentRow + 2
                s:BottomRow     := NIL
                s:LeftColumn    := b:prompts[b:cur]:SubMenu:RightColumn - 4
                s:winExplode    := b:winExplode
                s:winDelay      := b:winDelay
                s:ExceptBlock   := { |o| gx(o, b,.t.) }
                s:Exception     := .f.
                s:MenuChoice( 1,.f.)
                s:Activate()
                if b:isQuickKey( m:ascii )
                  exit
                elseif s:Exception
                  loop
                elseif s:MenuSelection() == 0
                  s:Hide()
                  b:prompts[b:cur]:SubMenu:HighLight()
                else
                  exit
                endif
              else
                exit
              endif
            endif
          endif

        Case b:MenusActive .and. m:Button == LEFT_BUTTON .and.   ;
             b:cur > 0 .and. b:cur <= len( b:Prompts ) .and. ;
             b:prompts[b:cur]:SubMenu # NIL .and. ;
             len( b:prompts[b:cur]:SubMenu:prompts ) > ;
                  b:prompts[b:cur]:SubMenu:bottomrow - b:prompts[b:cur]:SubMenu:Toprow .and. ;
             (( m:Row == b:prompts[b:cur]:SubMenu:TopRow .and. ;
               m:Column == b:prompts[b:cur]:SubMenu:RightColumn+1 ) .or. ;
             ( m:Row == b:prompts[b:cur]:SubMenu:BottomRow .and. ;
               m:Column == b:prompts[b:cur]:SubMenu:RightColumn+1 ))

           m:Hide()
           if m:Row == b:prompts[b:cur]:SubMenu:TopRow
             b:prompts[b:cur]:SubMenu:up()
           else
             b:prompts[b:cur]:SubMenu:down()
           endif

        Case ! empty( m:Ascii )
           if b:MenusActive .and. ;
              b:cur > 0 .and. b:cur <= len( b:Prompts ) .and. ;
              b:prompts[b:cur]:SubMenu # NIL
             nKey := b:prompts[b:cur]:SubMenu:KeySeek( m:Ascii )
             if ! ( nKey == 0 )
               m:Hide()
               b:MenuChoice( nKey )
               if ! Set( _SET_CONFIRM )
                 m:ClearButtons()
                 keyboard chr( K_RETURN )
               endif
             else
               lProcessed := .f.
             endif
           else
             nKey := b:KeySeek( m:Ascii )
             if ! ( nKey == 0 )
               m:Hide()
               b:BarChoice( nKey )
               if ! Set( _SET_CONFIRM )
                 b:MenusActive := .t.
                 if b:prompts[b:cur]:SubMenu # NIL
                   b:prompts[b:cur]:SubMenu:MenuChoice(1,.f.)
                   b:prompts[b:cur]:SubMenu:show()
                 endif
               endif
             else
               lProcessed := .f.
             endif
           endif

         Otherwise
           if !(m:Ascii == 0 .and. m:button == 0)
             lProcessed := .f.
           endif

      EndCase

      if ! lProcessed
        if Eval( b:ExceptBlock , b)
          b:exception := .t.
          exit
        endif
      endif

    enddo

    m:ClearButtons()
    m:Hide()

Return( NIL )



static function Gx( o, b, lExit )

    local lRetVal := .f. , ;
          m := MouseSys()


    lExit := if( lExit == NIL, .f., lExit )

    if b:FindKey( m:ascii )
      if b:isQuickKey( m:Ascii )
        lRetVal := .t.
      endif
      if lExit
        lRetVal := .t.
      endif
    endif

Return( lRetVal )




    //Ŀ
    // Convert Letter to Alt key representation 
    //
static Function LetterAsAltKey( cKey )

    local nAltKey, nKey

    // Conversion table
    static saRegAltKeys := { { 65, K_ALT_A }, ;
                             { 66, K_ALT_B }, ;
                             { 67, K_ALT_C }, ;
                             { 68, K_ALT_D }, ;
                             { 69, K_ALT_E }, ;
                             { 70, K_ALT_F }, ;
                             { 71, K_ALT_G }, ;
                             { 72, K_ALT_H }, ;
                             { 73, K_ALT_I }, ;
                             { 74, K_ALT_J }, ;
                             { 75, K_ALT_K }, ;
                             { 76, K_ALT_L }, ;
                             { 77, K_ALT_M }, ;
                             { 78, K_ALT_N }, ;
                             { 79, K_ALT_O }, ;
                             { 80, K_ALT_P }, ;
                             { 81, K_ALT_Q }, ;
                             { 82, K_ALT_R }, ;
                             { 83, K_ALT_S }, ;
                             { 84, K_ALT_T }, ;
                             { 85, K_ALT_U }, ;
                             { 86, K_ALT_V }, ;
                             { 87, K_ALT_W }, ;
                             { 88, K_ALT_X }, ;
                             { 89, K_ALT_Y }, ;
                             { 90, K_ALT_Z } }


    nKey    := asc( uppe( cKey ) )
    nAltKey := ascan( saRegAltKeys, {|x| x[1] == nKey} )

    if nAltKey == 0
      Return( nKey )
    endif

Return( if( nAltKey > 0, saRegAltKeys[nAltKey, 2], 0 ) )
