//͸
//  Program .....: Nccarray                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
// Display Single Dimension array 
//

#include "inkey.ch"

FUNCTION ArrayDsp(  xArray,   ;    //  Array to be viewed
                    xHead,    ;    //  Heading
                    xfoot,    ;    //  Footing
                    tr,       ;    //  TopRow for element display
                    lc,       ;    //  LeftColumn for elements
                    br,       ;    //  BottomRow for element display
                    rc,       ;    //  RightColumn for element display
                    cPos,     ;    //  CurrentPosition
                    rPos,     ;    //  RelativePosition
                    xplode,   ;    //  Explode flag
                    ExitKeys, ;    //  Array of keys to exit on
                    keyReader ;    //  Key reader block
                 )

    LOCAL RetVal, nKey, o, vb, sCursor := SetCursor(0), winHandle


    tr        := if(tr==NIL,8,tr)
    lc        := if(lc==NIL,25,lc)
    br        := if(br==NIL,18,br)
    rc        := if(rc==NIL,52,rc)
    cPos      := if(cPos==NIL,1,cPos)
    rPos      := if(rPos==NIL,0,rPos)
    ExitKeys  := if(ExitKeys==NIL, { NIL }, ExitKeys)
    xplode    := if(xplode==NIL,.f.,xplode)
    keyReader := if(keyReader==NIL, { || Ncc_k_wait(0) }, keyReader)



    if cPos < 1
      cPos := 1
    elseif cPos > len(xArray)
      cPos := Len(xArray)
    endif

    if rPos < 0
      rPos := 0
    elseif rPos > br-tr
      rPos := br-tr
    endif

    if Empty(xHead)
      tr += 2

    endif

    if Empty(xFoot)
      br -= 2

    endif

    if xplode
      winHandle := WinBox(tr-3, lc-2, br+3, rc+3, , 4, .t., xplode)

    else
      @ tr-3, lc-2, br+3, rc+3 Box '͸Գ '

    Endif

    if ! empty(xHead)
      NccMesg(" "+xHead+" ", tr-2, [Center,] + str(lc) + [,] + str(rc) + ['])
      @ tr-1, lc-2 say '' + Replicate("", 5+rc-lc-1) + ''
      @tr-1,rc+1 say ''

    else
      tr -= 2
      @tr-1,rc+1 say ''

    Endif

    if ! Empty(xFoot)
      NccMesg(" "+xfoot+" ", br+2, [Center,] + str(lc) + [,] + str(rc) + ['])
      @ br+1,lc-2 say '' + Replicate("", 5+rc-lc-1) + ''
      @br+1,rc+1 say ''

    else
      br += 2
      @br+1,rc+1 say ''

    Endif

    for nKey = tr to br
      @ nKey,rc+1 say ''

    next


    o := dViewARRAY():New( tr, lc, br, rc, xArray )

    o:StatusBlock := { || "" }
    o:CurrentItem := cPos
    o:RelativeRow := rPos

    vb := NccVBar():New( tr, rc+2, br, rc+2, len(xArray) )

    if len(xArray) == 0
      inkey(0)
      if xplode
        implode( winHandle )
      endif
      Return( 0 )
    endif

    o:Activate() ; vb:Activate()

    While .t.

      o:Stabilize()
      vb:Update( o:CurrentItem )

      nKey := eval( keyReader , o )

      Do Case
        Case nKey == K_ESC
          o:Terminate()
          RetVal := 0
          exit

        Case nKey == K_ENTER
          RetVal := o:CurrentItem
          o:Terminate()
          exit

        Otherwise
          if ! o:StandardKeys( nKey )
            if ascan( ExitKeys, { |x| x == nKey } ) # 0
              o:Terminate()
              RetVal := o:CurrentItem
              exit

            endif

            RetVal := ascan( ;
                             xArray, ;
                             { |x| uppe(subs(ltrim(x),1,1)) == uppe(chr(nKey)) }, ;
                             o:CurrentItem +1  ;
                           )

            if RetVal == 0
              RetVal := ascan( ;
                               xArray, ;
                               { |x| uppe(subs(ltrim(x),1,1)) == uppe(chr(nKey)) }, ;
                               1, ;
                               o:CurrentItem ;
                             )

            endif

            if RetVal # 0
              o:CurrentItem := RetVal
              o:RefreshAll()

            endif

          endif

      EndCase

    End

    if xplode
      implode( winHandle )
    endif
    SetCursor( sCursor )

Retu( RetVal )
