//͸
//  Program .....: G_Window                              
//  CopyRight ...: 1993 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
//  Desktop    
//

#include "inkey.ch"
#include "dbstruct.ch"
#include "g_menu.ch"
#include "mouse.ch"



#define WINDOW_INDEXFILES     1
#define WINDOW_ALIAS          2
#define   WINDOW_FILENAME       1
#define   WINDOW_OBJECT         2
#define   WINDOW_COLOR          3
#define   WINDOW_TROW           4
#define   WINDOW_LCOL           5
#define   WINDOW_BROW           6
#define   WINDOW_RCOL           7
#define WINDOW_VIEWFIELDS     3
#define WINDOW_VIEWSTRUCT     4
#define WINDOW_POSITION       5

STATIC window_active  := .f.

STATIC title_Color       := 'W+/B'                                         , ;
       message_Color     := 'W+/R'                                         , ;
       desktop_Color     := 'W+/N*'                                        , ;
       desktop_char      := ""                                            , ;
       popup_color       := 'W+/RB,W+/B,,W+/RB'                            , ;
       pop_color         := 'GR+/RB,W+/B,,GR+/RB'                          , ;
       bar_color         := 'R/BG,W+/R,,W+/BG,W+/R'                        , ;
       Text_Color        := 'W+/B,W+/R,W+/R,N/G,GR+,G'                     , ;
       letter_color      := 'N+/BG,W+/R,,W+/BG,W+/R'                       , ;
       SaveMode          := NIL                                            , ;
       Current_window    := 1                                              , ;
       v                                                                   , ;
       win_Stack         := {}          // Window sequence


/*                      W I N D O W   S T R U C T U R E
  *************************************************************************************

  Position of Current Row  Ŀ
  Viewing File Structure  Ŀ      
  Viewing Field List     Ŀ           
  RightColumn           Ŀ                
  BottomRow            Ŀ                  
  LeftColumn          Ŀ                    
  TopRow             Ŀ                      
  Window Color      Ŀ                                         
  Assoc. object    Ŀ                                            
  Full File name  Ŀ                                              
  Index Array    Ŀ                                                   
                                                                      
                   v     v  v   v                   v  v  v  v     v     v      v

  *************************************************************************************
*/
STATIC win := {;
                { {""}, {'','','W+/B,GR+/RB,,,W+/B'   ,03,01,14,70}, {""}, NIL, {} } ,;
                { {""}, {'','','N/W,W+/R,,,N/W'       ,04,02,15,71}, {""}, NIL, {} } ,;
                { {""}, {'','','N/BG,W+/R,,,W+/B'     ,05,03,16,72}, {""}, NIL, {} } ,;
                { {""}, {'','','N/GR,W+/RB,,,N/BR'    ,06,04,17,73}, {""}, NIL, {} } ,;
                { {""}, {'','','N/G,R+/RB,,,N/W'      ,07,05,18,74}, {""}, NIL, {} } ,;
                { {""}, {'','','G+/B,W+/R,,,W+/B'     ,08,06,19,75}, {""}, NIL, {} } ,;
                { {""}, {'','','GR/W,GR+/RB,,,N/W'    ,09,07,20,76}, {""}, NIL, {} } ,;
                { {""}, {'','','GR+/B,W+/R,,,W+/B'    ,10,08,21,77}, {""}, NIL, {} } ,;
                { {""}, {'','','R/W,GR+/RB,,,N/W'     ,11,09,22,78}, {""}, NIL, {} } ,;
                { {""}, {'','','G+/B,W+/R,,,W+/B'     ,12,10,23,79}, {""}, NIL, {} }  ;
              }


//
//
//

Function Window_Active(x)
Return( if( x == NIL, window_active, window_active := x ) )

Function Win_Stack( x )
Return(;
        if( x == NIL, ;
            win_stack, ;
            win_Stack := x ;
          );
      )

Function winStackUpdate( x )

   local i

   if (i := ascan( win_stack, x )) # 0
     adel( win_stack, i )
     win_stack[len(win_stack)] := x
   else
     aadd( win_stack, x )
   endif

Return( NIL )


Function Windows()
Return( win )

Function Title_Color( x )
Return( if( x == NIL, Title_Color, Title_Color := x ) )

Function Message_Color( x )
Return( if( x == NIL, Message_Color, Message_Color := x ) )

Function DeskTop_Color( x )
Return( if( x == NIL, DeskTop_Color, DeskTop_Color := x ) )

Function DeskTop_Char( x )
Return( if( x == NIL, DeskTop_Char, DeskTop_Char := x ) )

Function Popup_Color( x )
Return( if( x == NIL, Popup_Color, Popup_Color := x ) )

Function Pop_Color( x )
Return( if( x == NIL, Pop_Color, Pop_Color := x ) )

Function Bar_Color( x )
Return( if( x == NIL, Bar_Color, Bar_Color := x ) )

Function Text_Color( x )
Return( if( x == NIL, Text_Color, Text_Color := x ) )

Func Letter_Color( x )
Return( if( x == NIL, Letter_Color, Letter_Color := x ) )

Function Current_Window( x )
Return( if( x == NIL, Current_Window, Current_Window := x ) )

Function SaveMode( x )
Return( if( x == NIL, SaveMode, SaveMode := x ) )

Function WinIndexFiles( x, y )
    x := if( x == NIL, current_window, x )
Return( ;
        if( y == NIL, ;
            y := Win[x,WINDOW_INDEXFILES], ;
            Win[x,WINDOW_INDEXFILES] := y ;
          );
       )

Function WinFilename( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_FILENAME], ;
            Win[x,2,WINDOW_FILENAME] := y ;
          );
      )

Function WinObj( x, y )
 x := if( x == NIL, Current_Window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_OBJECT], ;
            Win[x,2,WINDOW_OBJECT] := y ;
          );
      )


Function WinVSbar(x)
 x := if( x == NIL, current_window, x )
 v:Update(WinObj( x ):LinePosition)
Return( NIL )

Function WinColor( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_COLOR], ;
            Win[x,2,WINDOW_COLOR] := y ;
          );
      )

Function WinTop( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_TROW], ;
            Win[x,2,WINDOW_TROW] := y ;
          );
      )

Function WinLeft( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_LCOL], ;
            Win[x,2,WINDOW_LCOL] := y ;
          );
      )

Function WinBottom( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_BROW], ;
            Win[x,2,WINDOW_BROW] := y ;
          );
      )

Function WinRight( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,2,WINDOW_RCOL], ;
            Win[x,2,WINDOW_RCOL] := y ;
          );
      )

Function WinViewFields( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,WINDOW_VIEWFIELDS], ;
            Win[x,WINDOW_VIEWFIELDS] := y ;
          );
      )

Function WinViewStru( x, y )
 x := if( x == NIL, current_window, x )
Return(;
        if( y == NIL, ;
            y := Win[x,WINDOW_VIEWSTRUCT], ;
            Win[x,WINDOW_VIEWSTRUCT] := y ;
          );
      )

FUNCTION ColorSetup(x)

    local i

    if '/M' $ uppe(x) .or. ! isColor()
       Title_color   := 'N/W'
       desktop_color := 'N/N,N/W'
       popup_color   := 'N/W,W+/N,,,N/W'
       bar_color     := 'N/W,W/N,,N+/W,W+/N'
       message_color := 'W+/N'

       for i = 1 to 10
         WinColor(i,'W/N,N/W,,,W/N')
       next

    endif

Return( NIL )


//Ŀ
//  Next Window  
//
Function WinNext()

    local nKey, i

    nKey := Current_Window()
    DeHighLightWindow(nKey)
    for i = 1 to len(windows())
      nKey++
      if nKey > Len(windows())
        nKey := 1
      endif
      if ! Empty(WinFilename(nKey))
        exit
      endif
    next
    HighLightWindow( nKey )

Return( NIL )


//Ŀ
// Previous Window 
//
Function WinPrev()

    local nKey, i

    nKey := Current_Window()
    DeHighLightWindow(nKey)
    for i = 1 to len(windows())
      nKey--
      if nKey == 0
        nKey := len(windows())
      endif
      if ! Empty(WinFilename(nKey))
        exit
      endif
    next
    HighLightWindow( nKey )

Return( NIL )

//Ŀ
// Resize Window 
//
Function WinResize()

    ResizeWindow( WinObj() )
    ShowDesktop()

Return( NIL )



Function ZoomIsFull()

    local zoom := .f., o := WinObj()


    if Window_Active()
      if ! ( o:TopRow-4      == WinTop() .and.       ;
             o:LeftColumn-1  == WinLeft() .and.      ;
             o:BottomRow+1   == WinBottom() .and.    ;
             o:RightColumn+1 == WinRight()           ;
           )
         zoom := .t.
      endif
    endif

Return( zoom )

//Ŀ
//  Zoom Window  
//
Function WinZoom()

    local o := WinObj()

    if ! ZoomIsFull()
      o:TopRow       := 6
      o:LeftColumn   := 1
      o:BottomRow    := maxrow() -2
      o:RightColumn  := maxcol() -1
      HighLightWindow()

    else
      o:TopRow       := WinTop()+4
      o:LeftColumn   := WinLeft()+1
      o:BottomRow    := WinBottom()-1
      o:RightColumn  := WinRight()-1
      ShowDeskTop()

    endif

Return( NIL )


//Ŀ
// Highlight Window  
//
Function HighlightWindow( x )

    x := if( x == NIL, current_window, x )
    Sele ( x )
    winStackUpdate( x )
    Current_Window( x )
    WindowFrame(WinObj( x ))
    WinObj( x ):RefreshAll()

Return( NIL )


//Ŀ
// De Highlight Window  
//
Function DeHighlightWindow( x )

    local TopRow, ;
          LeftColumn, ;
          BottomRow, ;
          RightColumn, ;
          StandardColor, ;
          Window


    x := if( x == NIL, current_window, x )
    if empty(alias(x))
      Return( NIL )
    endif

    Window := WinObj(x)

    TopRow        := Window:TopRow -4
    LeftColumn    := Window:LeftColumn -1
    BottomRow     := Window:BottomRow +1
    RightColumn   := Window:RightColumn +1
    StandardColor := Window:StandardColor

    Setcolor( StandardColor )
    WinBox(TopRow,LeftColumn,BottomRow,RightColumn,0,'Ŀ', ;
               if(BottomRow==maxrow()-1,.f.,.t.) ;
            )

    @ TopRow, LeftColumn+1 say " " + eval( Window:UserSlot[1] ) + ;
                                     "  < Win  " + ;
                                     str(select(),1,0)+" > " ;
                               color Window:InverseColor


    Window:ShowStatus()

Return( NIL )


//Ŀ
// Open Desktop
//
Function OpenDesktop()

    local init, i, j


    win_Stack( {} )
    init := .t.
    j := if(empty(alias()),1,select())
    for i = 1 to len(Windows())
      j++
      if j > Len(windows())
        j := 1
      endif
      if ! empty( alias(j) )
        if ! init
          DeHighLightWindow(Current_Window())
        endif
        OpenWindow(j)
        init := .f.
      endif
    next

Return( NIL )


//Ŀ
// Display DeskTop  
//
Function ShowDeskTop()

    local i, j := Current_Window()


    ShowBackGround()
    for i = 1 to len(windows())
      j++
      if j > Len(windows())
        j := 1
      endif
      Current_Window( j )
      if ! empty(WinFilename(j))
        HighLightWindow( j )
        if i # len(windows())
          DeHighLightWindow(j)
        endif
      endif
    next

Return( NIL )

//Ŀ
// Open Window   
//
Function OpenWindow(x)

    local o, y, Window := WinObj()


    if x == NIL
      x := Current_window()
    endif

    if empty(alias(x))
      Return( NIL )
    endif


    if ! empty( Window )
      WinTop( , Window:TopRow -4 )
      WinLeft( , Window:LeftColumn -1 )
      WinBottom( , Window:BottomRow +1 )
      WinRight( , Window:RightColumn +1 )
    endif

    winStackUpdate( x )
    Current_Window( x )
    Sele (x)


    Setcolor(WinColor())
    o := dViewDBF():New( WinTop()    +4, ;
                         WinLeft()   +1, ;
                         WinBottom() -1, ;
                         WinRight()  -1  ;
                       )

    o:Head      := ""
    o:HeadSep   := ""
    o:ColSep    := ""

    o:UserSlot  :=  {                                               ;
                      { || FileBase(WinFilename(),".DBF") }       , ;
                      NIL                                         , ;
                      NIL                                           ;
                    }
    o:Structure :=  WinViewStru()
    y           := {}
    aeval( WinViewStru(), {|a| aadd(y, a[DBS_NAME]) } )
    o:Headings  := y

    WinObj(x, o )
    WindowFrame( o )

    WinObj():Activate()

Return( o )


//Ŀ
// Display Window Frame  
//
Function WindowFrame( x )


    local TopRow        := x:TopRow -4, ;
          LeftColumn    := x:LeftColumn -1, ;
          BottomRow     := x:BottomRow +1, ;
          RightColumn   := x:RightColumn +1, ;
          StandardColor := x:StandardColor


    Setcolor( StandardColor )

    if BottomRow > Maxrow() -1
      TopRow := max( 2, maxrow() - (BottomRow - TopRow) )
      BottomRow := Maxrow() -1
    endif

    if RightColumn > Maxcol()
      RightColumn := Maxcol()
    endif


    x:TopRow      := TopRow +4
    x:LeftColumn  := LeftColumn +1
    x:BottomRow   := BottomRow -1
    x:RightColumn := RightColumn -1

    WinBox(TopRow,LeftColumn,BottomRow,RightColumn,0,4, ;
               if(BottomRow==maxrow()-1,.f.,.t.) ;
            )

    WinSbar( TopRow, RightColumn, BottomRow, LeftColumn )

    @ TopRow, LeftColumn say "[]"

    @ TopRow, LeftColumn + 4 say " " + eval( x:UserSlot[1] ) + ;
                                       "  < Win  " + ;
                                       str(select(),2,0)+" > " ;
                                       color x:InverseColor

    if x:Userslot[3] # NIL
      eval( x:UserSlot[3] )
    endif


Return( NIL )


//Ŀ
// Resize window   
//

#define R_TOP            1
#define R_TOPLEFT        2
#define R_TOPRIGHT       3
#define R_BOTTOMLEFT     4
#define R_BOTTOMRIGHT    5

#define EXT_SHIFT        ( keybd_Stat(0) == 1 .or. keybd_Stat(1) == 1 )

STATIC Function ResizeWindow( x )

    Local CurrentScreen := Savescreen(02,00,maxrow(),maxcol()), ;
          line1         := savescreen(01,00,01,maxcol()), ;
          TopRow        := x:TopRow -4, ;
          LeftColumn    := x:LeftColumn -1, ;
          BottomRow     := x:BottomRow +1, ;
          RightColumn   := x:RightColumn +1, ;
          OriginalColor := Setcolor(), ;
          ResizeColor   := x:InverseColor , ;
          nKey          := 0, ;
          drag          := .f. , ;
          holdT         := -1, ;
          holdL         := -1, ;
          holdB         := -1, ;
          holdR         := -1, ;
          holdButton    := 0 , ;
          Mouse         := MouseSys(), ;
          row, ;
          col, ;
          drag_who , ;
          xwidth, ;
          xheight, ;
          xOffset


    row    := Mouse:Row
    col    := Mouse:Column

    Setcolor( ResizeColor )
    @1,0
    NccMesg( ;
         ' Move:  '+chr(26)+ space(7) + ;
         'Resize:  Shift '+chr(26)+ space(7) + ;
         'Done:  ', ;
         1, ;
         'Center' ;
        )

    WHILE .t.

      if ! (                              ;
             holdT == TopRow        .and. ;
             holdL == LeftColumn    .and. ;
             holdB == BottomRow     .and. ;
             holdR == RightColumn         ;
           )

        Mouse:Hide()
        Restscreen(02,00,maxrow(),maxcol(),CurrentScreen)
        @ TopRow, LeftColumn, BottomRow, RightColumn  Box 'Ŀ'
        Mouse:Show()

        holdT :=  TopRow
        holdL :=  LeftColumn
        holdB :=  BottomRow
        holdR :=  RightColumn

      endif

      xheight := BottomRow - TopRow
      xwidth  := RightColumn - LeftColumn

      if Mouse:Button == 0
        if drag
          exit
        endif
        Mouse:MouseRead()
        row := Mouse:Row
        col := Mouse:Column
      endif

      if Mouse:Ascii # 0
        nKey := Mouse:Ascii
        Do Case
          Case nKey == K_ESC .or. nKey == K_RETURN
            exit

          Case nKey == K_UP .and. ! EXT_SHIFT
             if TopRow > 2
               TopRow--
               BottomRow--
             endif

          Case nKey == K_DOWN .and. ! EXT_SHIFT
             if BottomRow < maxrow() -1
               TopRow++
               BottomRow++
             endif

          Case nKey == K_LEFT .and. ! EXT_SHIFT
             if LeftColumn > 0
               LeftColumn--
               RightColumn--
             endif

          Case nKey == K_RIGHT .and. ! EXT_SHIFT
             if RightColumn < maxcol()
               LeftColumn++
               RightColumn++
             endif

            Case nKey == K_UP .or. ( EXT_SHIFT .and. nKey == 56 )
               if BottomRow - 6 > TopRow
                 BottomRow--
               endif

            Case nKey == K_DOWN .or. ( EXT_SHIFT .and. nKey == 50 )
               if BottomRow < maxrow() -1
                 BottomRow++
               endif

            Case nKey == K_LEFT .or. ( EXT_SHIFT .and. nKey == 52 )
               if RightColumn > LeftColumn + 21
                 RightColumn--
               endif

            Case nKey == K_RIGHT .or. ( EXT_SHIFT .and. nKey == 54 )
               if RightColumn < maxcol()
                 RightColumn++
               endif

        EndCase

      elseif Mouse:Button # LEFT_BUTTON
        nKey := K_RETURN
        exit

      elseif Mouse:Button == LEFT_BUTTON
        if drag
          Mouse:Update()
          row := Mouse:Row
          col := Mouse:Column
          Do Case
            Case drag_who == R_TOPLEFT
              if row <= BottomRow - 6 .and. col <= RightColumn - 30 .and. ;
                 row > 1
                TopRow := max(2,row)
                LeftColumn := col
              endif

            Case drag_who == R_TOPRIGHT
              if row <= BottomRow - 6 .and. col >= LeftColumn + 30 .and. ;
                row > 1
                TopRow := max(2,row)
                RightColumn := col
              endif

            Case drag_who == R_BOTTOMLEFT
              if row >= TopRow + 6 .and. col <= RightColumn - 30 .and. ;
                 row < maxrow()
                BottomRow   := min( row, maxrow()-1 )
                LeftColumn  := col
              endif

            Case drag_who == R_BOTTOMRIGHT
              if row >= TopRow + 6 .and. col >= LeftColumn + 30 .and. ;
                 row < maxrow()
                BottomRow   := min( row, maxrow()-1 )
                RightColumn := col
              endif

            Case drag_who == R_TOP
              if row <= Maxrow()-1 - xHeight .and. col - xOffset >= 0 .and. ;
                 col - xOffset + xWidth <= maxcol() .and. row > 1
                TopRow      := row
                BottomRow   := row + xHeight
                LeftColumn  := col - xOffset
                RightColumn := LeftColumn + xWidth
              endif

          EndCase

        else
          drag := .t.
          if holdButton == 0
            @1,0
            holdButton := LEFT_BUTTON
            if row == TopRow .and. Col # LeftColumn .and. Col # RightColumn
              NccMesg( ;
                   ' Move:  '+chr(26)+ space(7) + ;
                   'Done:  Release Mouse Button', ;
                   1, ;
                   'Center' ;
                  )
            else
              NccMesg( ;
                   ' Resize:  '+chr(26)+ space(7) + ;
                   'Done:  Release Mouse Button', ;
                   1, ;
                   'Center' ;
                  )
            endif
            Mouse:Show()
          endif
          Do Case
            Case row == TopRow .and. col == LeftColumn
              drag_who := R_TOPLEFT

            Case row == TopRow .and. col == RightColumn
              drag_who := R_TOPRIGHT

            Case row == BottomRow .and. col == LeftColumn
              drag_who := R_BOTTOMLEFT

            Case row == BottomRow .and. col == RightColumn
              drag_who := R_BOTTOMRIGHT

            Case row == TopRow .and. col >= LeftColumn .and. col <= RightColumn
              drag_who := R_TOP
              xOffset  := Col - Leftcolumn

            Otherwise
              exit

          endcase
        endif
      elseif Mouse:Button == BOTH_BUTTONS
         exit
      elseif Mouse:Button == RIGHT_BUTTON
         exit
      else
        exit
      endif

    ENDDO

    Mouse:Hide()

    nKey           := Current_Window()
    x:TopRow       := TopRow+4
    x:LeftColumn   := LeftColumn+1
    x:BottomRow    := BottomRow-1
    x:RightColumn  := RightColumn-1

    WinTop(nKey, TopRow)
    WinLeft(nKey, LeftColumn)
    WinBottom(nKey, BottomRow)
    WinRight(nKey, RightColumn)

    Setcolor( OriginalColor )
    restscreen(01,00,01,maxcol(),line1)

Return( NIL )


//Ŀ
//    Window NccSbar       
//

Function WinSbar( TopRow, RightColumn, BottomRow, LeftColumn )

Local bColor := Setcolor()

Setcolor('W+/R')
v :=  NccVBar():New( TopRow+3,RightColumn,BottomRow-1,RightColumn, Lastrec() )
v:Activate()
v:InverseColor := Setcolor('GR+')
v:Update(WinObj():LinePosition)

/*
Setcolor('W+/R')
h :=  NccHBar():New( BottomRow,LeftColumn+1,BottomRow,RightColumn-1, Fcount() )
// mFcount := dbstruct()
h:Activate()
h:InverseColor := Setcolor('GR+')
// aeval( dbstruct(), {|a| aadd(mFcount, a[DBS_NAME]) } )
h:Update( FieldPos() )
*/

Setcolor( bColor )

Return( NIL )

