//͸
//  Program .....: G_Edit                                
//  CopyRight ...: 1993 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "nccview.ch"
#include "set.ch"
#include "inkey.ch"
#include "dbstruct.ch"
#include "directry.ch"


#define BUFFER_SIZE  256

Function g_add()

    local nOrigRec := recno()


    if ! ffadd()
      DBGoTo( nOrigRec )
    else
      WinObj():RefreshAll()
      keyboard Chr( K_ENTER )
    endif

Return( NIL )


Function g_Duplicate()

    LOCAL tmp[fcount()], nOrigRec := recno(), nAddedRec, i


    if ffadd()
      nAddedRec := Recno()
      DBGoTo( nOrigRec )

      for i  = 1 to fcount()
        tmp[i] := fieldget( i )
      next

      DBGoTo( nAddedRec )

      for i  = 1 to fcount()
         fieldput( i, tmp[i] )
      next

      WinObj():Refresh := .t.
    endif

Return( NIL )

Function g_insert()

    LOCAL curr_rec := recno(), tmp[fcount()], i, to_dele

    IF fflock()
      IF ffadd()
        Set order to 0
        WHILE curr_rec < recno()
          WinObj():ShowStatus(DVIEW_REFRESHING)
          skip -1
          for i  = 1 to fcount()
            tmp[i] := fieldget( i )
          next
          to_dele := deleted()
          recall
          skip
          for i  = 1 to fcount()
             fieldput( i, tmp[i] )
          next
          IF to_dele
            dele
          END
          skip -1
        END
        set order to 1
      END
      go bottom
      skip
      for i  = 1 to fcount()
        tmp[i] := fieldget( i )
      next
      go curr_rec
      for i  = 1 to fcount()
         fieldput( i, tmp[i] )
      next
      recall
      ffshare( WinFilename()  )
      AttachIndexfiles( WinIndexFiles() )
      WinObj():Refresh := .t.
    END
    go curr_rec

Return( NIL )


Function g_quickdelete()

    if rrlock()
      if deleted()
        recall
      else
        delete
      endif
      unlock
      WinObj():RefreshCurrent()
    endif

Return( NIL )


Function g_delete()

    STATIC hfor_cond   := "" , ;
           hwhile_cond := "" , ;
           hhow_many   := 0

    LOCAL scrn, ;
          cColor, ;
          func_choice, ;
          GetList    := {}, ;
          CurrentRec := Recno(), ;
          sCursor    := Set( _SET_CURSOR )

    priv for_cond, while_cond, how_many


    for_cond   := subs(hfor_cond+space(BUFFER_SIZE),1,BUFFER_SIZE)
    while_cond := subs(hwhile_cond+space(BUFFER_SIZE),1,BUFFER_SIZE)
    how_many   := hhow_many
    scrn       := savescreen(05,05,19,62)
    cColor     := setcolor()

    setcolor(popup_Color())
    WinBox(5,5,18,60,0,4,.t.)
    NccMesg('[ Delete/unDelete ]',5,'center,5,60')

    WHILE .t.

      FUNC_choice := if(deleted(),2,1)

      @ 08,22       Prompt  ' Delete '
      @ 08,col()+3  Prompt ' unDelete '

      NccMesg('Highlight choice',11,'center,5,60')

      Menu to FUNC_choice

      NccMesg('                ',11,'center,5,60')

      IF Lastkey() == K_ESC
        exit

      END

      @11,06 say 'FOR   ' get for_cond ;
                          pict '@S40'
      @12,06 say 'WHILE ' get while_cond ;
                          pict '@S40'
      @13,06 say 'SCOPE ' get how_many valid how_many >= 0
      @14,06 say '     0=All or Next # of records'

      set key 28 to pop_it
      set cursor on
      read
      set( _SET_CURSOR, sCursor )
      set key 28 to

      IF lastkey() # K_ESC

        DO CASE

           CASE ! EMPTY(for_cond) .AND. TYPE(for_cond) <> "L"
              msg("FOR condition must be a Logical expression")

           CASE ! EMPTY(while_cond) .AND. TYPE(while_cond) <> "L"
              msg("WHILE condition must be a Logical expression")

           OTHERWISE
              IF fflock()
                * ok
                IF FUNC_choice == 1
                  NccMesg("Deleting",17,'center,5,60')

                ELSE
                  NccMesg("Recalling",17,'center,5,60')

                ENDIF


                for_cond   := ltrim(trim(for_cond))
                while_cond := ltrim(trim(while_cond))

                IF EMPTY(for_cond)
                  * literal true is the same as no FOR condition
                  for_cond := ".T."

                ENDIF

                IF EMPTY(while_cond)
                  * literal true is the same as no WHILE condition
                  while_cond := ".T."

                  IF how_many == 0
                    * unless a scope has been entered
                    GO TOP

                  ENDIF

                ENDIF

                IF FUNC_choice == 1
                  IF how_many == 0
                    DELETE WHILE &while_cond .and. inkey() # K_ESC FOR &for_cond

                  ELSE
                    DELETE NEXT how_many WHILE &while_cond .and. inkey() # K_ESC FOR &for_cond

                  ENDIF

                ELSE
                  IF how_many == 0
                    RECALL WHILE &while_cond .and. inkey() # K_ESC FOR &for_cond

                  ELSE
                    RECALL NEXT how_many WHILE &while_cond .and. inkey() # K_ESC FOR &for_cond

                  ENDIF

                ENDIF

                WinObj():Refresh := .t.

              ENDIF

              unlock

              IF eof()
                go top

              END

              EXIT

        ENDCASE
      ELSE
        EXIT

      END

      scroll(11,6,17,59,0)

    END

    hfor_cond   := for_cond
    hwhile_cond := hwhile_cond
    hhow_many   := hhow_many

    setcolor(cColor)
    restscreen(05,05,19,62,scrn)
    Set( _SET_CURSOR, sCursor )


Return( NIL )



Function g_pack()

    LOCAL rec, scrn, cColor, ok := .f.

    rec    := recno()
    scrn   := savescreen(3,15,6,65)
    cColor := SetColor()

    IF ffexcl( WinFilename() )
      AttachIndexfiles( WinIndexFiles() )

      setcolor(popup_color())
      WinBox(3,15,5,63,0,4,.t.)
      NccMesg('Press  to confirm PACK',4,'center,15,63',,0)

      IF Lastkey() == K_RETURN
        NccMesg(' PACKING ',5,'center,15,63')
        pack
        go top
        ok := .t.

      END

      setcolor(cColor)

    END
    IF ffshare( WinFilename() )
      AttachIndexfiles( WinIndexFiles() )

      IF reccount() >= rec
        go rec

      END
    END
    restscreen(3,15,6,65,scrn)
    if ok
      WinObj():RefreshAll(0)
    endif

Return( NIL )


Function g_zap()

    LOCAL rec     := recno() , ;
           scrn   := savescreen(3,15,6,65), ;
           cColor := SetColor(), ;
           ok     := .f.

    IF ffexcl( WinFilename() )
      setcolor(popup_color())
      WinBox(3,15,5,63,0,4,.t.)
      NccMesg('Press  to confirm ZAP',4,'center,15,63',,0)

      IF lastkey() == K_RETURN
        NccMesg(' ZAPING ',5,'center,15,63')
        zap
        go top
        ok := .t.

      END

      setcolor(cColor)
    END

    IF ffshare( WinFilename() )
      AttachIndexfiles( WinIndexFiles() )

      IF reccount() >= rec
        go rec

      END
    END
    restscreen(3,15,6,65,scrn)
    if ok
      WinObj():RefreshAll(0)
    endif

Return( NIL )


Function g_replace()

    STATIC hfield_mvar := ""   , ;
           hwith_what  := ""   , ;
           hfor_cond   := ""   , ;
           hwhile_cond := ""   , ;
           hhow_many   := 0

    LOCAL scrn, ;
          cColor, ;
          x, ;
          GetList    := {}, ;
          xCursor    := Set( _SET_CURSOR ), ;
          CurrentRec := Recno()

    priv field_mvar, with_what, for_cond, while_cond, how_many

    hfor_cond   := if(subs(hfor_cond,1,1) == '.', "", hfor_cond)
    hwhile_cond := if(subs(hwhile_cond,1,1) == '.', "", hwhile_cond)

    field_mvar := subs(hfield_mvar+space(10),1,10)
    with_what  := subs(hwith_what+space(BUFFER_SIZE),1,BUFFER_SIZE)
    for_cond   := subs(hfor_cond+space(BUFFER_SIZE),1,BUFFER_SIZE)
    while_cond := subs(hwhile_cond+space(BUFFER_SIZE),1,BUFFER_SIZE)
    how_many   := hhow_many
    scrn       := savescreen(03,12,17,69)
    cColor     := setcolor()

    setcolor(popup_color())
    WinBox(3,12,16,67,0,4,.t.)
    NccMesg('[ Replace ]',3,'center,12,67')

    WHILE .t.
      @05,13 say 'Field ' get field_mvar when force()
      @06,13 say 'WITH  ' get with_what ;
                          pict '@S20'

      @09,13 say 'FOR   ' get for_cond ;
                          pict '@S20'
      @10,13 say 'WHILE ' get while_cond ;
                          pict '@S20'
      @11,13 say 'SCOPE ' get how_many valid how_many >= 0
      @12,13 say '     0=All or Next # of records'

      set key 28 to pop_it
      Set Cursor On
      read
      Set( _SET_CURSOR, xCursor )
      set key 28 to

      IF lastkey() # K_ESC

        DO CASE

           CASE EMPTY(field_mvar)
              msg("Field not selected")

           CASE EMPTY(with_what)
              msg("Replace expression not entered")

           CASE TYPE(with_what) <> TYPE(field_mvar) .and. ;
                !(TYPE(field_mvar) == "M") .and. ;
                !(TYPE(with_what) == "UI")
              msg("Type mismatch between replace expression and field")

           CASE ! EMPTY(for_cond) .AND. TYPE(for_cond) <> "L"
              msg("FOR condition must be a Logical expression")

           CASE ! EMPTY(while_cond) .AND. TYPE(while_cond) <> "L"
              msg("WHILE condition must be a Logical expression")

           CASE ! Empty(indexkey()) .and. trim(field_mvar) $ uppe(indexkey())
              x := savescreen(14,12,16,67)
              NccMesg("Attempting to replace index key",14,'center,12,67')
              NccMesg("Close index file first then retry", 15,'center,12,67')
              NccMesg(' Press any key ', 16, 'center,12,67')
              keyboard ''
              inkey(0)
              restscreen(14,12,16,67,x)

           OTHERWISE
              IF fflock()
                * ok to replace
                NccMesg("< Replacing >",15,'center,12,67')

                for_cond   := ltrim(trim(for_cond))
                while_cond := ltrim(trim(while_cond))

                IF EMPTY(for_cond)
                  * literal true is the same as no FOR condition
                  for_cond := ".T."

                ENDIF

                IF EMPTY(while_cond)
                  * literal true is the same as no WHILE condition
                  while_cond := ".T."

                  IF how_many == 0
                    * unless a scope has been entered
                    GO TOP

                  ENDIF

                ENDIF

                IF how_many = 0
                  REPLACE &field_mvar WITH &with_what;
                  WHILE &while_cond .and. inkey() # K_ESC FOR &for_cond

                ELSE
                  REPLACE NEXT how_many &field_mvar WITH &with_what;
                  WHILE &while_cond .and. inkey() # K_ESC FOR &for_cond

                ENDIF

                WinObj():Refresh := .t.

              ENDIF

              unlock

              EXIT

        ENDCASE
      ELSE
        EXIT

      END
    END

    hfield_mvar := field_mvar
    hwith_what  := with_what
    hfor_cond   := for_cond
    hwhile_cond := while_cond
    hhow_many   := how_many

    setcolor(cColor)
    Set( _SET_CURSOR, xCursor )
    restscreen(03,12,17,69,scrn)
    Go CurrentRec

Return( NIL )


STATIC Function msg(x)

    local scrn := savescreen(15,12,16,67)


    NccMesg(x,15,'center,12,67')
    NccMesg(' Press any key ', 16, 'center,12,67')
    inkey(0)
    restscreen(15,12,16,67,scrn)

Return( NIL )



STATIC Function force()

    keyboard chr(K_F1)

Return( .t. )


STATIC Function pop_it()

    local stru       := WinViewStru(), ;
          pick_stru  := {}, ;
          counter    := 0, ;
          xsele      := 0, ;
          fc, ;
          scrn, ;
          bottom


    IF readvar() == 'FIELD_MVAR'
      scrn := savescreen(04,49,16,67)
      AEVAL(stru,{ |fi_stru| aadd(pick_stru, ' '+;
                             padr(fi_stru[DBS_NAME],10,' '))+ ' ', ;
                             counter++ })


      fc     := ltrim(str(counter))
      bottom := if(counter > 6,14,6+counter)
      xsele  := arraydsp( ;
                          pick_stru,;
                          '   Field  ',;
                          ,;
                          07,;
                          51,;
                          bottom,;
                          63,;
                          xsele,;
                          IF(xsele>((bottom-6)/2)+1,((bottom-6)/2),xsele-1),;
                          .f., ;
                          { K_LEFT }, ;
                        )

      IF xsele # 0
        if Set( _SET_CONFIRM )
          fc := subs(pick_stru[xsele],2) + ;
                 replicate(chr(K_LEFT),10) + ;
                 chr(K_RETURN)
        else
          fc := subs(pick_stru[xsele],2)
        endif
        keyboard fc

      ELSE
        keyboard chr(K_RETURN)

      END
      restscreen(04,49,16,67,scrn)
    END

Return( nil )



Function g_EditRec()

    if WinObj():UserSlot[2] == NIL
      g_Hedit()
    else
      g_Vedit()
    endif

Return( NIL )


STATIC Function g_Hedit()

    LOCAL init      := .t.                                       , ;
          Window    := WinObj()                                  , ;
          stru                                                   , ;
          head                                                   , ;
          aEditList := { {}, {} }                                , ;
          GetList   := {}                                        , ;
          i         := 1                                         , ;
          cCol                                                   , ;
          ntxVal                                                 , ;
          nLeftPos                                               , ;
          nWorkArea := Select()                                  , ;
          sCursor   := Set(_SET_CURSOR)


    // EditList ... [1]  Codeblock to Get/Set Field Value
    //              [2]  Field Value

    stru      := Window:Structure
    head      := Window:Headings
    nLeftPos  := Window:LeftPosition

    if rrlock()
      Window:DehighLight()

      @ Window:TopRow-3, ;
        Window:RightColumn-6 say '<Edit>'
      setpos( ;
              Window:CurrentRow, ;
              Window:LeftColumn  ;
            )

      if ! Empty( indexkey() )
        NtxVal := &(indexkey())
      endif

      while .t.
        if col() + max(stru[nLeftPos,DBS_LEN],len(head[nLeftPos]))-1 >  ;
           Window:RightColumn .and. ! init
          exit
        endif
        aadd( aEditList[1], fieldwblock(stru[nLeftPos,DBS_NAME], nWorkArea))
        aadd( aEditList[2], eval(aEditList[1,i]) )
        cCol := Col()
        if cCol + stru[nLeftPos,DBS_LEN]-1 > ;
          Window:RightColumn
          @row(),cCol get aEditList[2,i] ;
                       pict '@S' + ;
                       ltrim(str(Window:RightColumn-col()))
        elseif valtype( aEditList[2,i] ) == 'L'
          @row(),cCol+1 get aEditList[2,i]
        else
          @row(),cCol get aEditList[2,i]
        endif
        setpos(  ;
                row() , ;
                cCol+;
                max(stru[nLeftPos,DBS_LEN],len(head[nLeftPos]))+ ;
                len( Window:ColSep ) ;
              )
        init := .f.
        nLeftPos++
        i++
        if nLeftPos > len(stru)
          exit
        endif
      enddo
      set cursor on
      read
      set(_SET_CURSOR,sCursor)


      if ! updated()
        Window:RefreshCurrent()
      else
        i := 1                                     // This is the
        aeval( aEditList[1]                   , ;
                 { |x| eval(x,aEditList[2,i]) , ;
                       i++                      ;
                 }                              ;
             )                                    // REPL STATEMENT
        if ! Empty( indexkey() )
          if ! ( NtxVal == &(indexkey()) )
            Window:Refresh := .t.
          else
            Window:RefreshCurrent()
          endif
        else
          Window:RefreshCurrent()
        endif
      endif
      unlock
    endif

Return( NIL )



STATIC Function g_Vedit()

    LOCAL xfieldblock                                   , ;
          xTemp                                         , ;
          nKey                                          , ;
          xKey                                          , ;
          HoldColor                                     , ;
          vBar                                          , ;
          nStop     := .f.                              , ;
          o         := WinObj()                         , ;
          x         := WinViewStru()                    , ;
          sExit     := ReadExit( .t. )                  , ;
          sCursor   := SET( _SET_CURSOR )               , ;
          GetList   := {}



    vBar := NccVbar():New( o:TopRow, o:RightColumn+1         , ;
                        o:BottomRow, o:RightColumn+1      , ;
                        len(x)                              ;
                      )

    HoldColor      := o:InverseColor
    o:InverseColor := o:StandardColor
    o:deHighLight()

    if ! rrlock()
      Return( NIL )
    endif

    vBar:Activate()

    While .t.

       vBar:UpDate( o:userslot[2] )

       @ o:TopRow-3, ;
         o:RightColumn-6 say '<Edit>'

       setpos( o:CurrentRow, o:LeftColumn+11 )
       xFieldblock := fieldwblock(fieldname(fieldpos(x[o:userslot[2]][1])), Current_Window())
       xTemp := xFieldblock:Eval()

       if valtype( xTemp ) == 'C' .and. len( xTemp ) > o:RightColumn - Col() + 1
         @row(), o:LeftColumn + 11 GET xTemp  PICT '@S' + ;
                          ltrim(str(o:RightColumn - Col() + 1))

       elseif valtype( xTemp ) == 'L'
         @row(), o:LeftColumn + 12 GET xTemp
       else
         @row(), o:LeftColumn + 11 GET xTemp

       endif

       Set Cursor on
       READ
       Set Cursor Off

       xKey := 'N'
       nKey := Lastkey()
       if nkey == K_ESC .and. Updated()
         While .t.
           NccPopUp('\nAbort Changes (Y/N)\n',Popup_Color(),10 )
           nKey := uppe(chr(lastkey()))
           if nKey $ 'YN'
             exit
           endif
         enddo
       endif

       if xKey == 'Y' .or. nKey == K_ESC
         Exit
       endif

       eval( xFieldblock, xTemp )

       Do Case
         Case nKey == K_PGDN        ;   o:PageDown()
         Case nKey == K_PGUP        ;   o:PageUp()

         Case nKey == K_UP          ;   o:Up()
         case nKey == K_SH_TAB      ;   o:Up()

         Case nKey == K_DOWN        ;   o:Down()
         Case nKey == K_TAB         ;   o:Down()
         Case nKey == K_ENTER       ;   o:Down()

       EndCase

       if o:AtBottom .and. ;
         ( nkey == K_ENTER .or. nkey == K_DOWN .or. nKey == K_TAB ) ;
         .or. ;
         o:AtTop .and. ;
         ( nKey == K_UP .or. nKey == K_SH_TAB )
         exit
       endif

     Enddo

     unlock
     o:InverseColor := HoldColor
     o:RefreshCurrent()

     ReadExit( sExit )
     Set( _SET_CURSOR, sCursor )
     vBar:Hide()

Return( NIL )

